/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.pdf.panels;

import esecurity.crypto.gui.pdf.bean.PdfDocument;
import esecurity.crypto.gui.pdf.guielements.CGAppearance;
import esecurity.crypto.gui.pdf.guielements.CGAppearanceBuilder;
import esecurity.crypto.gui.pdf.panels.eakifuto;
import esecurity.crypto.gui.pdf.panels.orybujqe;
import esecurity.crypto.gui.pdf.panels.svillixe;
import esecurity.crypto.gui.pdf.panels.xugfuioj;
import esecurity.crypto.gui.properties.UserProperties;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.crypto.gui.utils.guielements.CGRadioButton;
import esecurity.desktop.FileDialog;
import esecurity.desktop.View;
import esecurity.desktop.dom.Button;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.DivContainer;
import esecurity.desktop.dom.Image;
import esecurity.desktop.dom.Paragraph;
import esecurity.desktop.dom.SpanContainer;
import esecurity.desktop.dom.TextInput;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.vol.utils.Constants;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;

public class PdfViewerOptionsPanel {
    private static final EllipsLogger logger = PdfViewerOptionsPanel.oR("-bsek6q", Constants.CAPI_LOGGER_NAME);
    private static final I18N i18n;
    private static final String ARROW_LEFT;
    private static final String ARROW_RIGHT;
    private final View view;
    private final CGAppearanceBuilder appearanceBuilder;
    private final List<PdfDocument> pdfDocuments;
    private CGRadioButton imageYesRB;
    private CGRadioButton imageNoRB;
    private Image appearanceImage;
    private Button modifyImageBtn;
    private CGRadioButton dateYesRB;
    private CGRadioButton dateNoRB;
    private CGRadioButton locationYesRB;
    private CGRadioButton locationNoRB;
    private TextInput locationTextBox;
    private CGRadioButton reasonYesRB;
    private CGRadioButton reasonNoRB;
    private TextInput reasonTextBox;
    private CGRadioButton preservePDFAYesRB;
    private CGRadioButton preservePDFANoRB;
    private boolean isOptionsVisible = false;
    private BufferedImage bufferedImage = null;

    public PdfViewerOptionsPanel(CGAppearanceBuilder appearanceBuilder, List<PdfDocument> pdfDocuments, DOMElement parent, View view) {
        this.appearanceBuilder = appearanceBuilder;
        this.pdfDocuments = pdfDocuments;
        this.view = view;
        this.draw(parent);
    }

    private void draw(DOMElement parent) {
        char[] cArray = "\u774f\u8181\u5ad5\u5fb7\u510e\ud8fd\u2cb2\uec5f\u3035\ua9c6\u8ca6\uc577\ud248\u990f\uc695\u8137\u72ee\u20e8\u8ed9\u395c\u89a4\u62df\u6edc\u3b5e\u2dc6\u7c04\u0266\u12ee\ud45d\ua556\uf879\uebca\u78c3\u0366\u442f\ucc92\uf35b\u1ee0\u27756\ua2e6\udd43\u85a4\u7669\u6684\u5815".toCharArray();
        cArray[41] = (char)(cArray[41] ^ 0x2D06);
        DivContainer optionsContainer = new DivContainer(orybujqe.X(cArray, (short)28771, true, false), parent, this.view);
        char[] cArray2 = "\u0510\ue83d\u6c82\ud38e\ub25d\u4ff5\u448d\uae79\u0267\u1c1a\u1001\u5759\u4ade\u7967\u4e9f\u959e\u36d4\udb23\u588d\ufe3f\u1ee4\u594c\uc66e\u5381\u4833\uf0ad\u74e8\u473f\ud825\u9248\u8b94\ue6f4\ubb59\ua28c\ubbd7\u0565\u4b0b\uf8e5\u82aa\uca57\u2b4f\u8e44\u1dc6\ue383\ub453\u732f".toCharArray();
        cArray2[5] = (char)(cArray2[5] ^ 0x9DB);
        PdfViewerOptionsPanel.oR("-1ft2jtb", optionsContainer, orybujqe.X(cArray2, (short)10588, true, false));
        char[] cArray3 = "\uee6a\u09dd\ud060\u83f7\u89b7\u9ce6\u64c1\u7dff\ua422\u9c35\u978c\ud812\u5ddc\u9cd8\u5719\u38a3\ue8b6\ufe0b\uf126\u36b5\u76ac\u6a40\ub7d3\ude22\ub1d8\u4399\u5e30\uf7c4\u83a5\u367a\u9148\u9f21\uf70f\u4845\u7f9c\u8bb6\u35ff\ue2ad\u6bcf\u1bc6\ud18d\u9214\ub618\u420a\u3b3e\u0549\u04dc\u4c7b\u29c0".toCharArray();
        cArray3[5] = (char)(cArray3[5] ^ 0x2646);
        DivContainer optionsArea = new DivContainer(orybujqe.X(cArray3, (short)19880, true, false), (DOMElement)optionsContainer, this.view);
        char[] cArray4 = "\u46b4\u49da\u7c0b\u6f60\u8121\u80c8\u1fcc\ufa50\ueef8\uf2e2\ud14f\u1a32\u2be6\u8af5\uf522\ude18\u3da0\uf3f4\u17e4\u93db\ua6dc\u45c4\u25a9\u650f\ua406\ucb2b\u3c4c\u15c3\uea05\ue108\u0db4\u0d33\ud1a0\u3cb5\uc1c6\u2977\uf317\ufee0\u07fa\u13b5\ua579\ub91c\u9ed8\u8488\u40c6\uc746\u1c48\u9942\u7f03".toCharArray();
        cArray4[11] = (char)(cArray4[11] ^ 0xA2A);
        PdfViewerOptionsPanel.oR("-1ft2jtb", optionsArea, orybujqe.X(cArray4, (short)20567, false, false));
        PdfViewerOptionsPanel.oR("1qqlc23", optionsArea, false);
        char[] cArray5 = "\u056b\ubf19\u6811\u17ad\u565e\u27e7\u81a0\u50e6\uf1de\u578d\uc06a\u41d1\ubbaf\uf9c7\u2b1b\u10ea\udf1c\uce1d\uaf0e\u7080\u2756\ud52a\ua46b\ubf12\ubeb2\u00fe\ue435\ue5d6\u89ea\u52e6\uac42\u8b06\u440c\ufa9d\u56f9\uca6e\u7779\u7cc0\ue99e\u8a46\u13e6\u2295\u8ce6\udbef\u89b0\ub7a4\u7ef5\ue5a3\uacd1\u3761\u48d4\uffd7\u5087\u76be\ue3c9\u0bb7".toCharArray();
        cArray5[1] = (char)(cArray5[1] ^ 0xAD6);
        DivContainer optionsAreaContent = new DivContainer(orybujqe.X(cArray5, (short)31891, false, false), (DOMElement)optionsArea, this.view);
        char[] cArray6 = "\uc8e6\ua237\u0f21\u6d0b\ubb75\u90da\ud588\ub288\u1fad\u42a0\ue18d\u0e0e\u4dcf\uc693\u50f2\uc292\u0e4a\udf80\u7bac\u967a\ua22b\u5bb7\uc44f\uf88a\uac08\ubcf4\u940d\u1eec\u7557\uf714\ufe8c\u16a0\u0e88\u170f\u6160\u8880\ub9cd\ud507\u074f\u1341\uafcd\u20a3\u9171\ud851\u4fd9\u83c2\u8a7a\u822d\udf9b\ua297\uc597\ua543\u27a6\uabf9\u1114\u7274".toCharArray();
        cArray6[17] = (char)(cArray6[17] ^ 0x3D17);
        PdfViewerOptionsPanel.oR("-1ft2jtb", optionsAreaContent, orybujqe.X(cArray6, (short)22810, true, true));
        char[] cArray7 = "\ud276\udc7d\u25c0\u2a42\ubeef\u68c9\u3134\u5668\ue016\uc52a\u5cc8\u9ebc\u8315\ub702\u0765\u32f3\ud7ea\u7e3d\u3147\ude3d\uafe9\u8943\uaaf6\ubdc2\u4841\u0fbe\ub2b4\u9e9e\u475c\u9dca\u76d7\uf39b\u14cd\uf793\u3970\ue366\u2ca2\u4da7\ude0e\ue5ca\ue1d5\ub042\uf5d6\uff65\ua4af\u323a\u1008\u5d6b\ub551\ua2e2\u890c\ue070\ucf8d\u1231".toCharArray();
        cArray7[44] = (char)(cArray7[44] ^ 0x2EAA);
        Paragraph optionsInfo = new Paragraph(orybujqe.X(cArray7, (short)26433, true, true), (DOMElement)optionsArea, this.view, () -> {
            char[] cArray = "\uf316\u4945\u41e3\ua75e\uaad7\u7ed9\ud396\ua477\u1fc3\u7552\ua0f4\u3d44\uc19c\udfb0\u2ada\ubc5e\u51cf\uff70\u6873\ufff2\u67c8\u8f90\uc28d\u15da\u1ad0\u1043\u6918\u7701\u0992\uac61\uf3d9\u42cb\uffc9\uf6ca\uffc3\u1696\ua344\ua97d\u47d6".toCharArray();
            cArray[35] = (char)(cArray[35] ^ 0x72CB);
            return PdfViewerOptionsPanel.oR("dt5c2r", i18n, eakifuto.s(cArray, (short)23623, (byte)1, (short)4), (Object[])new Object[0]);
        });
        char[] cArray8 = "\u5aaa\u9d6a\u1a47\u2d75\ubc25\u3a7a\u5c3b\u274a\u40a8\ua986\u79d9\ue091\u96ec\u66f9\u0893\u2da1\u6897\ud569\ud7a9\u6f4c\ub0a3\u7e8d\uc342\ud971\u5170\u6ea6\u8dcc\ue32c\u7334\ud2b8\u370b\u63c9\u5a84\uecd2\u2271\u789a\ua87f\u3e2d\uea72\u7988\u21b6\u4ba3\u8a22\ubca4\uae4a\uf376\uedee\ub4cf\u82f0\ucfda\ua7fe\ue4c6\ufab7\u1c8a".toCharArray();
        cArray8[23] = (char)(cArray8[23] ^ 0x7236);
        PdfViewerOptionsPanel.oR("10v7c26", optionsInfo, orybujqe.X(cArray8, (short)27788, true, true));
        this.drawImageArea((DOMElement)optionsAreaContent);
        this.drawDateArea((DOMElement)optionsAreaContent);
        this.drawLocationArea((DOMElement)optionsAreaContent);
        this.drawReasonArea((DOMElement)optionsAreaContent);
        this.drawPreservePdfAArea((DOMElement)optionsAreaContent);
        this.drawVerticalArea((DOMElement)optionsContainer, (DOMElement)optionsArea);
    }

    private void drawImageArea(DOMElement parent) {
        char[] cArray = "\u2ec0\u87ab\ub933\u8604\ue7f6\ufca7\u1830\u263a\u316c\u6251\u124d\ub83c\u9198\u8ef9\ub3b3\ufcc7\u4d9c\ud3f1\ucde3\ua719\u722e\u0dd6\u38a8\u13d0\ufc9c\u44b8\u4cc8\u89f0\uf1a4\u7acb\uad14\uec13\u7625\u1aa1\uc216\u46e4\u0e2a\u7386\u0819\u53bf\ua808\uf603\ud0f2\u9c87\u964b\u9279\u6dd8\u5575\u4d75\u5170\u03d8\uccc0\ubbcf\u8211\u07ee\u51d6\u176e\u912d\u7728\u09a0".toCharArray();
        cArray[11] = (char)(cArray[11] ^ 0x64FD);
        Paragraph imageTitle = new Paragraph(orybujqe.X(cArray, (short)4618, false, true), parent, this.view, () -> {
            char[] cArray = "\u896c\ue790\u6313\udc4d\u9563\u1850\u2d1e\ubb6f\uc8d6\ufc5d\u4313\u6387\u0615\u363f\u3786\u7783\ua5d5\u51d0\uac44\u32c9\ua3f2\u6589\u9589\u7686\u8dc7\u2604\u1837\u7d7a\u7ad2\u4b39\u0dba\ud453\u2926\u5b22".toCharArray();
            cArray[15] = (char)(cArray[15] ^ 0x2DE8);
            return PdfViewerOptionsPanel.oR("dt5c2r", i18n, orybujqe.X(cArray, (short)5496, false, false), (Object[])new Object[0]);
        });
        char[] cArray2 = "\u9f28\u8b23\u7589\u8405\u40b9\u2881\ua403\u1938\u2aed\uc261\ub1ea\u9e68\ud757\u2d48\ube38\u11fc\ud299\u4741\ubf17\ubb95\u297a\ud915\u055d\u2ae2\ua96f\u7e26\uc8eb\u3608\uc91e\u9c16\u3f7b\u3474\ufcd3\u4113\u4adc\u330c\u204b\u17b7\u7c78\u19ee\u4fa4\u08cf\ue7e2\u0518\ub7fb\ua7cb\u3bc0\u77d0\ufee1\ua413\u664e\u4ffd\u20a6\ufb1b\u5fcf".toCharArray();
        cArray2[19] = (char)(cArray2[19] ^ 0xF3E);
        PdfViewerOptionsPanel.oR("10v7c26", imageTitle, orybujqe.X(cArray2, (short)16178, true, true));
        char[] cArray3 = "\u4c96\ue7d8\ubaea\u5b57\u6f97\u0e50\ub044\u289f\u76d0\uf782\ua848\u493b\ube2d\ube11\u3edb\u30a1\u9a3e\u4856\u5462\u9af4\u3ba5\u1ebb\uc8a2\uf011\u93d8\u1a89\uc13d\uca0e\ude04\ue31c\u82e4\u9d42\ubb76\ubc17\u540c\ud9e9\u67ca\ucce0\u1d9b\u1a38\u28e6\u6a5d\u591e\uf75e\u9e92\uabc8\uc1d3\uf5e7\uef3a\u83a2\uefaf\u8c06\ua9c7\u33cb\uce8b\ufc74\u4116\u9fe0\uf127\u5c75\u16b0\u63c3".toCharArray();
        cArray3[16] = (char)(cArray3[16] ^ 0x35AD);
        DivContainer imageDivisor = new DivContainer(orybujqe.X(cArray3, (short)26928, false, false), parent, this.view);
        char[] cArray4 = "\uf6f5\u451d\uc4d1\u814a\u2173\udc41\u2586\u70b5\ub7c5\u7616\ubc26\u5a84\u9ad4\u8c09\ud8f2\uae67\uab52\u300c\uf2ef\u392a\u465a\ufbee\u0d2c\u8212\ue36b\u6d35\u63f6\uc540\u48a3\ufa37\u41d6\ua082\uef6e\u3fc1\uc229\u74ba\u60c6\u25ff\uac53\u725f\ude6c\u7010\ud293\uf074\u3223\u26d4\u6342\u4f76\u0ae0\uf4e8\ubf2f\u206f\ua3d5\u80eb\u1553\ue587\u3fce".toCharArray();
        cArray4[15] = (char)(cArray4[15] ^ 0x232E);
        PdfViewerOptionsPanel.oR("-1ft2jtb", imageDivisor, orybujqe.X(cArray4, (short)7068, false, false));
        char[] cArray5 = "\u6809\ud00b\uc7cd\u0eb9\uc134\u9c64\uc084\u1935\u5dfb\ub6be\u49bd\uc20c\u9881\u315e\ufa6b\ud288\u791a\u13aa\uba74\uc180\u4307\uabcc\u7472\u3106\u072c\ue9f6\u39a1\u3e80\u891f\u1b33\ub630\u212d\u9060\u078b\ua091\uf3c4\uc4a6\u6446\u9da6\ub078\u09df\uec4c\uba50\u29e8\u17b4\uf14e\u8777\u9cf7\ub870\ud3dc\u30a3\u6cd1\ud395\uc9f5\ud0b3\u9881\u5c41\u6eb5".toCharArray();
        cArray5[11] = (char)(cArray5[11] ^ 0x6CC3);
        char[] cArray6 = "\ucb41\u680f\u12e6\u8708\u1f37\u6764\u9d76\ud444\u812f\udd7b\u056a\u15c2\uace3\ube15\uccca\u9ec1\uaae9\u5e5a\u2078\uab44\u7f9f\u8148\u0f40\u4a5a\u232e\u5e8b\uac40\ubd4d\udfa9\uba2e\u3b91\u6c57".toCharArray();
        cArray6[9] = (char)(cArray6[9] ^ 0x4856);
        char[] cArray7 = "\u32c1\u7d8c\u43a6\u26b9\u43b9\u7f2e\ud1de\u7706\ud551\u1445\uf1af\u0fbb\u32db".toCharArray();
        cArray7[4] = (char)(cArray7[4] ^ 0x56B1);
        this.imageYesRB = new CGRadioButton(orybujqe.X(cArray5, (short)14917, true, true), parent, this.view, (String)PdfViewerOptionsPanel.oR("dt5c2r", i18n, orybujqe.X(cArray6, (short)171, true, true), (Object[])new Object[0]), orybujqe.X(cArray7, (short)17327, true, true));
        char[] cArray8 = "\u5c05\ub190\uc80d\u4e45\u5a7e\u7846\ue7a5\ub944\u5ae9\ue968\u82d6\u1235\u649c\ub8c8\u394c\u2985\u4678\u099c\ua1e9\ue8d9\u5d88\u6f9b\ub71e\u534f\u1225\u9162\u882c\u05b1\u8f4d\u2fcf\u1c35\ua251\u71e8\u036f\ue759\uc7c5\u3151\u66cd\ub288\udc02\uf89f\u043d\u0ba8\u124b\u91b8\ud124\u6645\u8f41\ue66b\u4d53\ued96\u424e\ufaf0\u0ed2\u88f2\u0c49\u74eb".toCharArray();
        cArray8[50] = (char)(cArray8[50] ^ 0x2469);
        char[] cArray9 = "\u07c1\u4d60\u1cff\ua1bb\ue232\u3820\u9ffe\uae7c\u2ac1\ua2ea\u3d35\uf35e\uc267\ude2e\u397f\ue99c\u62e6\u1cdd\ue807\ue830\u9260\u6c68\u0421\uf74c\u29ce\ud5eb\ue3cf\u28f2\u3550\ua60a\u57f0".toCharArray();
        cArray9[18] = (char)(cArray9[18] ^ 0x1249);
        char[] cArray10 = "\u622d\u838c\ua298\uffb6\ubddc\ub9df\u1731\u8557\u12d0\u3315\u0c41\u2946\u39eb".toCharArray();
        cArray10[10] = (char)(cArray10[10] ^ 0x4EC6);
        this.imageNoRB = new CGRadioButton(orybujqe.X(cArray8, (short)26993, false, true), parent, this.view, (String)PdfViewerOptionsPanel.oR("dt5c2r", i18n, orybujqe.X(cArray9, (short)25007, false, false), (Object[])new Object[0]), orybujqe.X(cArray10, (short)24333, false, true));
        char[] cArray11 = "\udb58\uc55f\u024d\ubd3e\u7670\u2887\uf2d0\uc967\ue33b\u0844\u54da\ue934\uf09c\u070a\ub486\u17eb\u9d46\ueeb2\u0f4b\u8e2e\ubec6\u9e9c\u7ae7\u0819\u4dd4\u9f02\ucde0\uf837\ub8d2d\uf215\u9787\u962c\u3219\ue2aa\u0705\u1391\u2f12\u15a0\u825d\u4545\uf509\u7b24\u9bb5\ubcbc\u3e15\u4eda\u7eea\u3b1a\u9c8f\u569a\ucc34\u697c\ubd08\u702e\ue00e\uc81a\uef8c\u47a5\udbad\u3910".toCharArray();
        cArray11[10] = (char)(cArray11[10] ^ 0x34A4);
        PdfViewerOptionsPanel.oR("-kgak6k", this.imageYesRB, orybujqe.X(cArray11, (short)6951, true, false));
        char[] cArray12 = "\u9f82\ufa65\u3fc2\ua617\u49b9\u672c\ue15c\u9f95\udccc\u8403\udb77\u0757\u5c28\u961f\u424f\u36bc\uc775\u2171\u90ee\u0de2\ud763\u42a9\u3821\u4b4e\u163c\ue57e\u77ce\u47c2\ud846\u124c\u4b0d\u1205\u5881\u5f7f\u4f25\u0305\uc93d\ud6d0\ua101\u04d9\u24ae\u4659\u2e24\u35bd\u2da1\u743f\uec9b\u06ec\u4793\u03f1\u49b1\u4277\uc2ff\u4d05\ua7be\uaf69\u3e2c\u4f7b\uc245\u8086\u4039".toCharArray();
        cArray12[37] = (char)(cArray12[37] ^ 0x355F);
        PdfViewerOptionsPanel.oR("-kgak6k", this.imageNoRB, orybujqe.X(cArray12, (short)23829, true, false));
        char[] cArray13 = "\ub7dd\ue4a5\u69ab\u9ad0\u6b22\uca83\u4fba\u67a4\ue9d3\u3be6\u4217\u5044\u18e9\ufa9a\u8e4b\u334e\u5c1a\ub332\uf2f2\ufe6a\ued97\ub5ba\ucbfa\u5e71\u48d3\ue310\u738d\ud862\u4bd9\uf1ab\u2b0c\ubbc7\uad5f\u6a69\ua8f2\u1877\uce66\u6819\ua127\ud749\u537d\ub6cb\ub72a\uabb4\u067c\u9916\uf952\u6815\u4666\u2e60\uf8de\ud96e\u81b4\uf766\u2f5c\u7175\u6064\u47bf\ua430\u691c\u3ca3\ud45a\uf4e0\uc34d\u1206".toCharArray();
        cArray13[6] = (char)(cArray13[6] ^ 0x5851);
        this.appearanceImage = new Image(orybujqe.X(cArray13, (short)20711, true, false), parent, this.view);
        char[] cArray14 = "\u988d\ue99f\u1d55\u2e1e\u30ca\u5cca\uf876\u5ff6\u3044\u27df\udaad\ube99\u47f5\u9ead\u5ab5\u9ba8\u3568\u0e1e\uf399\ub251\ub0d8\uf292\u175f\u78aa\u6806\ud7cf\u74ee\u7661\u1926\u7aab\uc2f4\u271a\u5da2\uf16d\u5e2a\u9e33\u88e1\u7879\u6fdb\uc062\u7b98\u5f7f\uac44\u7638\ue80c\ucfd7\ufb88\udda9\u62bf\ucfd2\uad79\u9bad\ua881\ufd14\ue9a3\u6961\u6777\uba55\ub0ec\u86e7\u4385\uc980\u552e\uc98c\u2d77".toCharArray();
        cArray14[19] = (char)(cArray14[19] ^ 0x18D7);
        PdfViewerOptionsPanel.oR("1g21c24", this.appearanceImage, orybujqe.X(cArray14, (short)12137, true, false));
        if (PdfViewerOptionsPanel.oR("1h0rbof", PdfViewerOptionsPanel.oR("-1bfgk76", PdfViewerOptionsPanel.oR("-1ebkk77"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)"")) == false) {
            PdfViewerOptionsPanel.oR("1vdtbpi", this.appearanceImage, PdfViewerOptionsPanel.oR("-1bfgk76", PdfViewerOptionsPanel.oR("-1ebkk77"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)""));
        } else {
            char[] cArray15 = "\u559f\udad9\u35ea\uebf0\u03eb\u0f4f\ua654\ucd0a\u4638\u0b2f\u0f09\ue582\u4358\u141b\ud3a7\u1656\ua37c\u53f7\ue62b\u5924\ufb1c\u34dc\u15ef\uf25a\u3330\u23da\ud1fa\ue58e\u4922\u00df".toCharArray();
            cArray15[9] = (char)(cArray15[9] ^ 0x29AF);
            PdfViewerOptionsPanel.oR("1vdtbpi", this.appearanceImage, PdfViewerOptionsPanel.oR("-b2ck6f", orybujqe.X(cArray15, (short)1979, true, true)));
        }
        char[] cArray16 = "\uc04f\uc00d\u3e9c\u9203\u920a\ub667\u6891\u6fa8\ua672\uf0e1\u7fcf\u39ca\u805a\u6ca2\ucb82\u55c1\u0d88\ue007\u7f5d\u69d2\uc0d0\ubc63\u7aed\u50f9\u62d5\uc9e6\ud47e\ufae5\u79e4\u1ab7\u18c9\uba3b\u2280\ua6c7\u5627\u6845\ue547\ufe3b\uf8dd\ud291\u27ad\u21c9\ua68f\u19ed\u5a7c\u32b3\u7669\u4f33\u906d\uede7\u309f\u73be\u4338\u28cb\u1343\ub471\uedb8\u364c\u0b8f\u47a6\u7cc8\ud9b8\uf401\u101c".toCharArray();
        cArray16[22] = (char)(cArray16[22] ^ 0x3A65);
        this.modifyImageBtn = new Button(orybujqe.X(cArray16, (short)11730, false, true), parent, this.view, () -> {
            char[] cArray = "\u2cc6\ua16b\u38d7\u2655\u38fd\uf996\u1cc8\uf649\uabf0\ua9d2\u5cd0\uebd7\uf868\u852d\u9e55\uf044\ube1e\ub0f9\ubb71\u31ec\u07a6\uba86\u040e\u0749\ufc3a\u51b0\ue0c7\u657a\u8210\u8922\u545f\uf655\uef33\u36fd\u5820".toCharArray();
            cArray[11] = (char)(cArray[11] ^ 0x73CF);
            return PdfViewerOptionsPanel.oR("dt5c2r", i18n, svillixe.E(cArray, (short)16686, (short)0, (short)2), (Object[])new Object[0]);
        });
        char[] cArray17 = "\u5a9d\u9d78\uccb1\u4928\u92aa\ufa7b\u4f89\u7bac\u2bf4\uecf5\ue6a9\ue824\u51c0\u4dbd\u3a9c\u55f5\u070a\ub1a3\u362d\u670e".toCharArray();
        cArray17[13] = (char)(cArray17[13] ^ 0x4FB6);
        PdfViewerOptionsPanel.oR("1o3pbp1", this.modifyImageBtn, orybujqe.X(cArray17, (short)27989, false, true));
        char[] cArray18 = "\uc833\ufe22\u4f97\u50fa\u6a2d\uee05\u23fc\uc7a7\u864e\u1c15\u65b9\ubf87\uf4da\uc0bd\u673c\u8d81\ucaf3\uf7b5\u3b5e\u05b6\u47da\u01fb\uf5bc\u2609\ua066\udc9f\uf02d\u5e67\uc6f5\u1e1c\u9d6c\ua3cf\ua70e\u5b2f\u87f3\u199e\uaebb\u6b26\u7766\ud843\u20f1\u084a\u6b2e\u83f3\uadb5\uaaea\udde2\u4020\u7108\ue512\u2fe3\uf2de\ud605\uc069\ua8aa\u3d8d\ue16d\uc1b5\uf611\u426a\u6287\u74c3\u2472\u045b".toCharArray();
        cArray18[38] = (char)(cArray18[38] ^ 0x73FD);
        PdfViewerOptionsPanel.oR("1o3pbp1", this.modifyImageBtn, orybujqe.X(cArray18, (short)6888, false, false));
        PdfViewerOptionsPanel.oR("8j3bog", this.imageYesRB, () -> {
            if (PdfViewerOptionsPanel.oR("-himk8i", this.imageYesRB) != false) {
                this.onImageYesSelected();
            }
        });
        PdfViewerOptionsPanel.oR("8j3bog", this.imageNoRB, () -> {
            if (PdfViewerOptionsPanel.oR("-himk8i", this.imageNoRB) != false) {
                this.onImageNoSelected();
            }
        });
        char[] cArray19 = "\u0ccf\u7657\u348f\u7a7f\u1d04".toCharArray();
        cArray19[3] = (char)(cArray19[3] ^ 0xB02);
        char[] cArray20 = "\uea33\u9318\u2314\u629e\u43c5".toCharArray();
        cArray20[1] = (char)(cArray20[1] ^ 0x1E21);
        if (PdfViewerOptionsPanel.oR("1sffbod", orybujqe.X(cArray19, (short)15694, false, false), PdfViewerOptionsPanel.oR("-1bfgk76", PdfViewerOptionsPanel.oR("-1ebkk77"), UserProperties.GRAPHICSIGNATURE_IMAGE, (Object)orybujqe.X(cArray20, (short)22454, true, false))) == false) {
            PdfViewerOptionsPanel.oR("-1ht6k7i", this.imageNoRB, false);
            this.onImageNoSelected();
        } else {
            PdfViewerOptionsPanel.oR("-1ht6k7i", this.imageYesRB, false);
            this.onImageYesSelected();
        }
        PdfViewerOptionsPanel.oR("-1mek6u", this.modifyImageBtn, evt -> this.onModifyImage());
    }

    private void onImageYesSelected() {
        if (this.bufferedImage == null) {
            Object src = null;
            File srcFile = null;
            if (PdfViewerOptionsPanel.oR("1h0rbof", PdfViewerOptionsPanel.oR("-1bfgk76", PdfViewerOptionsPanel.oR("-1ebkk77"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)"")) == false) {
                srcFile = new File((String)PdfViewerOptionsPanel.oR("-1bfgk76", PdfViewerOptionsPanel.oR("-1ebkk77"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)""));
                src = PdfViewerOptionsPanel.oR("-1p94k7d", srcFile);
            }
            if (src != null) {
                PdfViewerOptionsPanel.oR("1vdtbpi", this.appearanceImage, src);
                try {
                    this.bufferedImage = PdfViewerOptionsPanel.oR("pppbok", srcFile);
                }
                catch (IOException ex) {
                    PdfViewerOptionsPanel.oR("s9hbpd", logger, PdfViewerOptionsPanel.oR("1u9lbpg", ex), (Object)ex);
                }
            } else {
                this.loadDefaultImage();
            }
        }
        char[] cArray = "\ud194\ud770\u67ad\ue521\u00a3\u87dc\u8a4d\u3de8\uec6c\uff07\u9460\u23ff\uf74b\u1c15\u0c78".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x277E);
        PdfViewerOptionsPanel.oR("-1a42k7v", this.appearanceImage, orybujqe.X(cArray, (short)898, true, false));
        PdfViewerOptionsPanel.oR("-od0k7u", this.modifyImageBtn, false);
        PdfViewerOptionsPanel.oR("-1msuk79", this.appearanceBuilder, true);
        PdfViewerOptionsPanel.oR("-1f6ok78", this.appearanceBuilder, this.bufferedImage);
        this.updateAllImages(this.bufferedImage, true);
    }

    private void loadDefaultImage() {
        char[] cArray = "\u1ad3\ubbc8\ub1c3\u5a24\u8d68\ufaac\u5473\u9acf\ubc15\u2867\u68a9\udccf\u3000\u0dc6\u34ad\u3b53\u1e8d\u0537\ud687\u37ff\u182f\u5bc7\u9956\u778e\u64ef\uc262\ue726\u7ca6\uc77f\u7d1b".toCharArray();
        cArray[19] = (char)(cArray[19] ^ 0x3FFF);
        PdfViewerOptionsPanel.oR("1vdtbpi", this.appearanceImage, PdfViewerOptionsPanel.oR("-b2ck6f", eakifuto.s(cArray, (short)19655, (byte)4, (short)0)));
        try {
            char[] cArray2 = "\uaf01\u3303\u034f\u1073\u38f6\ua6c6\u82af\u8f0a\u5654\u4604\uf934\u0ea7\ue738\ueb45\u2d7a\ud4cd\ua6d7\u8be4\ua776\u73a8\ub8de\u5b79\uedf0\u3e31\u7beb\u768f\u080b\u114d\ude17\u3da4\u4f69\ub07a\u5220\ueb73\u42e7\ue2c7\u3800\u176f\uca4b\uc937\ud0b9\u7c2c\u4d96\u89fd\u605d\uf8b2\u0d01\u7124\ub13d\u1bf7\u255c\u4ca4\u7b47\u1779\ue29c\u2e4c".toCharArray();
            cArray2[17] = (char)(cArray2[17] ^ 0x5F2D);
            this.bufferedImage = PdfViewerOptionsPanel.oR("5upbom", PdfViewerOptionsPanel.oR("9udbol", PdfViewerOptionsPanel.class, eakifuto.s(cArray2, (short)1214, (byte)4, (short)1)));
        }
        catch (IOException ex) {
            PdfViewerOptionsPanel.oR("s9hbpd", logger, PdfViewerOptionsPanel.oR("1u9lbpg", ex), (Object)ex);
        }
    }

    private void onImageNoSelected() {
        char[] cArray = "\ud5e3\u5fc0\u2c60\udddf\ud6bc\uc92c\ub284\u3f52\uaf46\ub7cc\uc7a9\u880b\u5a9b\u68e2\u0abb".toCharArray();
        cArray[10] = (char)(cArray[10] ^ 0x2689);
        PdfViewerOptionsPanel.oR("1g21c24", this.appearanceImage, eakifuto.s(cArray, (short)26702, (byte)1, (short)5));
        PdfViewerOptionsPanel.oR("-od0k7u", this.modifyImageBtn, true);
        PdfViewerOptionsPanel.oR("-1msuk79", this.appearanceBuilder, false);
        PdfViewerOptionsPanel.oR("-1f6ok78", this.appearanceBuilder, null);
        this.updateAllImages(null, false);
    }

    private void onModifyImage() {
        char[] cArray = "\u9342\u05eb\ubedd\ue232\u83c9\u5dcf\u7d88\u090a\ue21c\u6f1e\u4b8f\u5eb5\u8f9c\uc33b\u04a5\u6857\ua15c\u2cf9\u0e2c\ub27a\ue121\ue631\u7282\u3617\ue4c2\uac30\u6ef2\u7810\ue7ce\ueb38\u4341\u58f2\u1786\u1a8b\u400e\ua6c2\uf58e\u2a8c\u71a4\u7a71\u5b54\u0c53".toCharArray();
        cArray[12] = (char)(cArray[12] ^ 0x3E77);
        FileDialog dialog = new FileDialog(this.view, (String)PdfViewerOptionsPanel.oR("dt5c2r", i18n, svillixe.E(cArray, (short)21949, (short)1, (short)2), (Object[])new Object[0]), esecurity.crypto.gui.utils.Constants.APPEARANCE_IMAGE_FORMATS);
        Object file = PdfViewerOptionsPanel.oR("-oj4k75", dialog, false);
        if (file != null && !file.isEmpty()) {
            try {
                File imageFile = new File((String)file.get(0));
                PdfViewerOptionsPanel.oR("1vdtbpi", this.appearanceImage, PdfViewerOptionsPanel.oR("-1p94k7d", imageFile));
                PdfViewerOptionsPanel.oR("-1msuk79", this.appearanceBuilder, true);
                this.bufferedImage = PdfViewerOptionsPanel.oR("pppbok", imageFile);
                PdfViewerOptionsPanel.oR("-1f6ok78", this.appearanceBuilder, this.bufferedImage);
                this.updateAllImages(this.bufferedImage, true);
            }
            catch (IOException ex) {
                PdfViewerOptionsPanel.oR("s9hbpd", logger, PdfViewerOptionsPanel.oR("1u9lbpg", ex), (Object)ex);
            }
        }
    }

    private void updateAllImages(BufferedImage image, boolean useImage) {
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.oR("1h3fbo9", PdfViewerOptionsPanel.oR("16d9bos", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.oR("javboa", app, useImage);
                PdfViewerOptionsPanel.oR("-seuk81", app, image);
                PdfViewerOptionsPanel.oR("1eupbo0", app);
            }
        }
    }

    private void drawDateArea(DOMElement parent) {
        char[] cArray = "\u9a78\ub33e\u377d\u1fc9\ue3f0\ud08f\u82f1\u6a00\u5e06\uc221\ua7a9\u65e0\u566f\u25d1\u5647\u7fff\ua41a\u6f7f\u1696\u4bc7\u9cd2\u360a\u0fad\udb6d\uf3ae\ude55\u0a68\ud230\ub99b\u96c5\u7208\u2780\u261f\u2d8a\ue33e\u52df\uf7d5\u8223\ua3d0\ue5ed\u9e41\u00ab\u4c5b\u9b35\u34c9\u86f4\uc2ae\u1613\u5cc0\u8b85\u02b7\uf55e\uc1ab\u32b2\u60ba\u3032\ue209\ua362\u09c0".toCharArray();
        cArray[41] = (char)(cArray[41] ^ 0x172A);
        Paragraph dateTitle = new Paragraph(orybujqe.X(cArray, (short)2009, true, true), parent, this.view, () -> {
            char[] cArray = "\u0b5e\u3834\u3ffa\uc709\uc4fe\u364b\u9f94\uffb3\u0883\u4e04\u2f90\u19de\u7088\u19f0\ufde0\ue890\uee4c\u329c\ua5a9\u196f\uec9b\ub97b\ufc5e\u459f\u5e41\ub21c\udf99\ua6f2\u2b1f\u55a3\u0ffc\u4bfa\u3b29".toCharArray();
            cArray[3] = (char)(cArray[3] ^ 0x1DFD);
            return PdfViewerOptionsPanel.oR("dt5c2r", i18n, orybujqe.X(cArray, (short)17353, true, false), (Object[])new Object[0]);
        });
        char[] cArray2 = "\u5d8d\u1999\ucff3\ufaf1\u12dd\uf9a4\u053c\u7d48\uc71c\u8d9e\ua36a\u5588\ua682\ue220\u3f33\u841f\ue07f\uf20c\u5619\u3796\uf977\u60da\u0183\ud8b3\u7875\uc475\ue0f2\ude92\u254b\u752b\ud228\uc9e1\u51f1\u8680\u492d\ua643\u37ea\u7d7e\u7807\u2c09\ubb26\u1f6b\u223e\u9758\ud22f\u8dee\u56a8\ua6de\ub296\u23e1\uc487\u6f3d\ufba1\u48fe\u5ee1".toCharArray();
        cArray2[28] = (char)(cArray2[28] ^ 0x7580);
        PdfViewerOptionsPanel.oR("10v7c26", dateTitle, orybujqe.X(cArray2, (short)28269, true, false));
        char[] cArray3 = "\u4b2c\u7eca\u3f67\u6a7b\u16bc\ufdb1\u1e82\u5e7a\u09a0\u8863\ud21d\u15d4\u53dd\u6d1c\u4630\uf6f9\uc814\ua390\uf8cf\u6132\uaadf\u9c79\u9aae\uaab2\u1d91\u3e68\ue750\uc348\uea0f\u9214\u3b9e\u2c53\ua316\u7601\u7600\ueb5b\u6f18\uacca\u8cbe\u124f\u22e7\udd88\ucb8d\ub212\uf8fb\u7bf9\u9e59\u7ce6\u2ff4\uc137\u3340\u6491\u60a5\u6d68\uc7d6\u0ee6\u52b2\ucd68\ub67d\uad56\u4930".toCharArray();
        cArray3[52] = (char)(cArray3[52] ^ 0x3AB);
        DivContainer dateDivisor = new DivContainer(orybujqe.X(cArray3, (short)12102, true, false), parent, this.view);
        char[] cArray4 = "\ub278\u5943\u1905\u4ee6\ub604\uda16\u02ac\u6ec9\ucfe2\u322f\u35dd\u58e4\u11d7\ua7bb\uf263\u9841\u22eb\u9b20\u07d7\uc8eb\u5e9c\u9009\u438e\u4daf\u4a65\u01af\u5514\u0445\u77e7\u94ec\u81e0\u8a63\ueb54\u187f\u0fcf\ufda7\u17f2\ue700\ud635\u2530\u89c0\u5dda\u1f9a\u72b3\u3cdc\udfc5\u121c\u27de\u7f8f\u787c\u92d6\u7cac\u5ef0\u008b\uf69e?\u4089".toCharArray();
        cArray4[53] = (char)(cArray4[53] ^ 0x584C);
        PdfViewerOptionsPanel.oR("-1ft2jtb", dateDivisor, orybujqe.X(cArray4, (short)26035, true, true));
        char[] cArray5 = "\u1733\uad4d\u6157\uc41a\ue54e\ub628\uccce\u8dc9\uf6bc\u549b\u8249\u7679\ue233\ucb1b\uc15c\uba03\ude0d\u91fd\u5a44\u812b\uee3e\u172d\u11e3\ud117\u86a1\ue5bd\uce6b\u33b4\u38db\uee85\ua7b0\ud823\u28e7\u4740\ue94f\u54ef\u3873\ufabc\udf9c\u357e\u98bd\ucd97\u798d\u8b41\u4005\u1071\u38ae\u6701\ubb9a\udf70\ub35f\u3bba\uad9e\u38ae\u0df3\u96eb\u3d75".toCharArray();
        cArray5[31] = (char)(cArray5[31] ^ 0x5A);
        char[] cArray6 = "\uef5b\u69f2\u20f2\u3095\u5ffa\ub159\u4081\u3b74\u4139\uaa33\u535a\u0771\u3474\u3706\ub96e\udcb2\u7c31\uc262\u2b87\uc52c\ub10d\u437e\u09be\uac5f\u6e61\u92f7\u08ea\uedfb\ud55e\u4426\u626a\u5581".toCharArray();
        cArray6[11] = (char)(cArray6[11] ^ 0x2074);
        char[] cArray7 = "\u10d8\u086b\u7c53\ud0b9\u9222\ucae6\u613c\u6e13\uddcd\u2920\uabe2\u4d0d".toCharArray();
        cArray7[2] = (char)(cArray7[2] ^ 0x5B75);
        this.dateYesRB = new CGRadioButton(orybujqe.X(cArray5, (short)19470, true, true), parent, this.view, (String)PdfViewerOptionsPanel.oR("dt5c2r", i18n, orybujqe.X(cArray6, (short)13004, true, false), (Object[])new Object[0]), orybujqe.X(cArray7, (short)20474, true, true));
        char[] cArray8 = "\uf127\ucd8e\u8482\uaf2a\u97f9\uf7fd\u2b72\u069f\u71ed\u2371\u1a39\udf2c\u4ed5\ue5fe\u3a4c\u93d8\u6298\u9066\ua057\u34bd\ua557\ueee5\u072f\u6227\u158e\u557a\uac65\u7d2c\u477e\u191a\u7854\ua32a\u8b0b\uf592\uadb3\ua59f\u5f46\uf0d8\u93d6\u2037\ud2fe\u87d0\ua7b0\u9e01\u8987\u9cba\u78eb\u4dc1\u92f6\uec8b\ub56a\uf2ec\u7323\u6df8\ube97\u1a2e".toCharArray();
        cArray8[48] = (char)(cArray8[48] ^ 0x3578);
        char[] cArray9 = "\ucdf5\u761a\uaa08\u80da\u43c7\u53ee\ube87\uf358\u61e5\u9356\ue7d8\uc426\u4a69\u07bc\ud453\u5b5c\u21e3\u8025\u8a2b\u3400\u872f\u6342\uff52\u72ce\ub6b3\ue23d\u6971\u4359\ud2c7\u7904\u3859".toCharArray();
        cArray9[9] = (char)(cArray9[9] ^ 0x7EB4);
        char[] cArray10 = "\u3b70\u4aa6\ub809\u6cda\u3b1c\u8234\ucb5f\ub04b\u1e10\u1a02\u4d86\u1c82".toCharArray();
        cArray10[5] = (char)(cArray10[5] ^ 0x19E4);
        this.dateNoRB = new CGRadioButton(orybujqe.X(cArray8, (short)2380, true, false), parent, this.view, (String)PdfViewerOptionsPanel.oR("dt5c2r", i18n, orybujqe.X(cArray9, (short)10581, false, false), (Object[])new Object[0]), orybujqe.X(cArray10, (short)23348, true, false));
        char[] cArray11 = "\u65dd\u6a12\ub6e9\u392d\u02a2\u3f7f\u99a9\uff62\udf38\u6622\uaaf7\u717c\u3b61\u15ce\u6812\u171c\uf789\u9170\ue105\u324f\ucfdd\ue69c\u2627\u97ca\ue56d\u0b23\uf518\uc001\u7ff2\udf5a\u4c5f\u5ada\ub4c3\ueffa\u6b9f\ueb18\ua146\u3062\u8481\u86d7\ub365\u7669\u53ff\ua02e\uf236\u9d99\u71dc\u1790\uf983\u8032\u93e2\u9882\u9989\u5980\u03a1\u30efV\u5988\u1f6f\u9b8c\u3253".toCharArray();
        cArray11[15] = (char)(cArray11[15] ^ 0x384B);
        PdfViewerOptionsPanel.oR("-kgak6k", this.dateYesRB, orybujqe.X(cArray11, (short)26750, true, false));
        char[] cArray12 = "\u2fdf\u261c\u27d6\u7b22\uc92b\u2af5\u752c\ua513\u7a59\u9ee3\u01d3\u6f6e\uc197\uc81d\u9354\u4723\u00a5\ubb33\ue731\ucdae\u6835\u964e\u8cd2\u793f\u81a0\u60fa\uc2ef\u7cc3\u7545\u8890\u7343\u0a9a\u1a6e\uf758\u9e25\u0915\u80f2\ueb56\ud221\u2802\uc57e\u6c0e\u7705\u4e24\u69f9\u4b99\u976b\u19f1\uf0f8\u90ce\u1605\u12c8\ufde1\u273f\u1ca1\uef76\u4ac5\ucbff\u0c35\uc267\u1aee".toCharArray();
        cArray12[45] = (char)(cArray12[45] ^ 0x59A7);
        PdfViewerOptionsPanel.oR("-kgak6k", this.dateNoRB, orybujqe.X(cArray12, (short)522, true, false));
        PdfViewerOptionsPanel.oR("8j3bog", this.dateYesRB, () -> {
            if (PdfViewerOptionsPanel.oR("-himk8i", this.dateYesRB) != false) {
                this.updateAllDates(true);
            }
        });
        PdfViewerOptionsPanel.oR("8j3bog", this.dateNoRB, () -> {
            if (PdfViewerOptionsPanel.oR("-himk8i", this.dateNoRB) != false) {
                this.updateAllDates(false);
            }
        });
        char[] cArray13 = "\uc8f3\u60a0\u9e1c\ucf10\u77ab".toCharArray();
        cArray13[0] = (char)(cArray13[0] ^ 0x1F78);
        char[] cArray14 = "\u1d51\uffe9\ubc0f\u0265\u550a".toCharArray();
        cArray14[3] = (char)(cArray14[3] ^ 0x2C34);
        if (PdfViewerOptionsPanel.oR("1sffbod", orybujqe.X(cArray13, (short)13026, false, false), PdfViewerOptionsPanel.oR("-1bfgk76", PdfViewerOptionsPanel.oR("-1ebkk77"), UserProperties.GRAPHICSIGNATURE_DATE, (Object)orybujqe.X(cArray14, (short)28668, false, false))) == false) {
            PdfViewerOptionsPanel.oR("-1ht6k7i", this.dateNoRB, false);
            this.updateAllDates(false);
        } else {
            PdfViewerOptionsPanel.oR("-1ht6k7i", this.dateYesRB, false);
            this.updateAllDates(true);
        }
    }

    private void updateAllDates(boolean showDate) {
        PdfViewerOptionsPanel.oR("-dh4k83", this.appearanceBuilder, showDate);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.oR("1h3fbo9", PdfViewerOptionsPanel.oR("16d9bos", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.oR("22hbnu", app, showDate);
                PdfViewerOptionsPanel.oR("1eupbo0", app);
            }
        }
    }

    private void drawLocationArea(DOMElement parent) {
        char[] cArray = "\uc5a1\ub663\u8c4e\u9fb5\u297d\u2fcb\u469b\ud78d\ub881\uc0f9\u8eb1\u752e\u04d9\u5d75\u8896\u118d\uf1ef\ub99a\uba51\ua738\uec26\u3a14\uc7f0\uc71c\u219a\u204b\u3eec\u0fa7\u65a5\u0987\uc5df\u3f3d\u6f24\u0fe0\u4702\u31bb\uacb1\u953f\u1495\u723a\u01fe\u370a\u3598\ufad4\u83fc\u78c1\ud6e6\u9533\ubf7f\u69cd\u94cf\ufe1f\ua6e7\u5b7a\u249e\u8c99\uc60b\u1dcc\uc132\u5090\u9cc3\u1a0a\u1290".toCharArray();
        cArray[55] = (char)(cArray[55] ^ 0x236);
        Paragraph locationTitle = new Paragraph(orybujqe.X(cArray, (short)29128, false, false), parent, this.view, () -> {
            char[] cArray = "\ua2e2\ud638\u6dc3\u09b8\u38ee\u4e8e\u6149\u66d0\u0e12\uff1a\u31cd\u8d37\ub4a0\u7ed6\u4188\ud052\u3ea8\u23ce\u6563\ud373\ueb15\ubdfc\ucfb6\u55b7\u6dd8\u6cf6\u9f0e\u0ee5\ue7d9\u4b26\u2309\u938a\ueaf0\u5ad4\u128e\uc707\u5309".toCharArray();
            cArray[13] = (char)(cArray[13] ^ 0xD38);
            return PdfViewerOptionsPanel.oR("dt5c2r", i18n, orybujqe.X(cArray, (short)10548, false, true), (Object[])new Object[0]);
        });
        char[] cArray2 = "\ub893\u601c\u559f\ue932\u3386\u90d7\u908f\u819a\ucbf1\u80af\ua716\uc1ce\ua4a0\u25d1\ud75f\uf774\u2e95\ue702\ue640\u865e\ua762\ufa4f\u5ad9\u3346\ud7ed\u9ebd\ua4ef\u48ad\u07b4\u6e7a\u0db8\ub2ec\u864c\u1de5\u82d0\u358d\u634d\u9ddf\ud215\ufa26\u3e16\u9ddf\uf4a6\u58fd\u29ae\u8d7e\u5180\u8ba0\uc7d2\uc2e1\ue28c\u420d\u3adb\u3c7e\u1ed7".toCharArray();
        cArray2[2] = (char)(cArray2[2] ^ 0x1633);
        PdfViewerOptionsPanel.oR("10v7c26", locationTitle, orybujqe.X(cArray2, (short)2970, false, false));
        char[] cArray3 = "\ubb43\ud6e8\u201b\u0a7a\u89f1\ue00b\u0a96\u1427\uff39\u1105\ud9fd\u2a2d\u7e1e\u780d\u42ab\u930e\u1df0\uc346\ubec0\ue42a\u104a\uf6b6\uc496\uc526\uf1f2\u6ae8\u5d68\u18e8\ub6e9\u15d3\u9fe2\u8fb4\u12a3\u9aaf\u5133\uecdd\u9bc6\u1fc8\u960c\u626d\u72b2\ud3f7\u54fe\u3c06\u2bb7\u0878\u1f4f\udfed\uc46b\uecbf\u5a39\udec6\u1dd6\u2ea6\u7d4d\u5fa9\ua1e9\ub3c7\uaa6d\u5cf5\u3c9a\u1cf5\ucb95\u4f49\u5e43".toCharArray();
        cArray3[54] = (char)(cArray3[54] ^ 0x3B86);
        DivContainer locationDivisor = new DivContainer(orybujqe.X(cArray3, (short)7709, true, false), parent, this.view);
        char[] cArray4 = "\u2210\ubf1a\u7c48\u8eca\ub724\u97ee\ud915\u0095\u626e\u12fe\ub63b\uc3ed\ub6c5\u333a\ucf7e\u6d25\u8e45\u6628\uba5d\u1fca\ud912\ud813\ua24d\uc7a6\uf822\u3457\ue3bb\u356d\u0bf6\u1990\uda0a\ubfef\uea4b\u86ca\u09a6\u8db5\u6671\ua5fc\uc3b5\ud914\uc9ec\uba26\u52d1\uc776\ued45\u7842\u2492\u9551\ub72c\ue317\u40aa\u5337\u6991\u587f\u262b\u8d76\u4e61".toCharArray();
        cArray4[52] = (char)(cArray4[52] ^ 0x775A);
        PdfViewerOptionsPanel.oR("-1ft2jtb", locationDivisor, orybujqe.X(cArray4, (short)24262, false, false));
        char[] cArray5 = "\u2d61\u70b2\u0999\u0846\u2ff2\u8cce\u711c\udfbd\u22d6\u6664\ub287\ud92a\ude86\uc9f4\u6043\ubdd8\uc56c\u8385\uc3b4\u1fe7\u7624\u6feb\ucb64\u253f\udc8d\u9eff\uc6e2\ue644\ue3ab\u2fd6\u71bd\u9cda\uf1c0\ua558\u2f58\ubff8\u9814\u99d6\u05ea\u44f9\u5c27\u1ef6\udf85\ua80a\u768f\u9fde\u18fa\ufeb3\ueda5\u75d9\u9a4a\u3c0c\u074a\u9997\u8495\u6227\ue7d1\u8c93\u7d8d\u94ca\u656b".toCharArray();
        cArray5[37] = (char)(cArray5[37] ^ 0x628D);
        char[] cArray6 = "\u3e85\u50e5\u2dd6\ufe88\ube65\ud4e8\uf274\ua099\u98e9\uca0f\ufa52\u51ba\u695b\u226c\u9b39\u075a\ue8b6\ua556\uffd8\u48d4\u3395\uc5e3\uf896\ua98e\u401f\u19e5\u6ac6\ue33f\u62b2\ud943\uc48f\u5b72".toCharArray();
        cArray6[23] = (char)(cArray6[23] ^ 0x109E);
        char[] cArray7 = "\u8077\udbfa\uae31\u4558\u139f\u00a4\u31bd\u44d7\ue503\u7e0c\u2422\uf451\ub372\u235b\u1724\u1afb".toCharArray();
        cArray7[11] = (char)(cArray7[11] ^ 0x2861);
        this.locationYesRB = new CGRadioButton(orybujqe.X(cArray5, (short)7329, false, true), parent, this.view, (String)PdfViewerOptionsPanel.oR("dt5c2r", i18n, orybujqe.X(cArray6, (short)25211, true, true), (Object[])new Object[0]), orybujqe.X(cArray7, (short)24826, false, true));
        char[] cArray8 = "\u98a2\u181b\ud24d\u6280\u0c69\u8626\u3a50\ua31c\u5f8a\u865b\u9080\u2a6a\u33b4\u9ad3\u2db8\ud111\ub191\ub24f\u52f5\u391b\u4f7f\ud399\u0467\u0a45\u0b47\u6872\ub36f\u962e\u6819\u9354\u1f86\u8a20\u9ea9\uf50f\u187c\u5c62\u4542\ua834\uef4f\u2139\ue9ea\u6796\u9504\u9460\uca67\u55e1\u255a\u882f\u9750\ucb0c\u5770\ude6f\u58cf\u5aab\u1d59\u0f7a\u5e45\u8d69\u56ea\u648e".toCharArray();
        cArray8[45] = (char)(cArray8[45] ^ 0x2F30);
        char[] cArray9 = "\u3cb8\ue365\u6f04\u2de1\u9599\u6454\u1581\u63d3\ub9d8\u1a42\uba5b\u6f0c\ua299\u254d\u49d9\u12b1\u1cba\u8ebf\ua098\ua175\u59ac\u392e\u5b12\u2d84\u49e4\u054c\ud114\ua7f9\u7918\u48ba\u39a8".toCharArray();
        cArray9[3] = (char)(cArray9[3] ^ 0x6F86);
        char[] cArray10 = "\uc4d2\ub3c2\u45e9\u5dd4\u2c59\uff2d\uc165\u416c\ud37e\u1bc7\uf515\ua39d\ua1d5\ue45a\u9a6c\u1500".toCharArray();
        cArray10[6] = (char)(cArray10[6] ^ 0x105C);
        this.locationNoRB = new CGRadioButton(orybujqe.X(cArray8, (short)15640, false, false), parent, this.view, (String)PdfViewerOptionsPanel.oR("dt5c2r", i18n, orybujqe.X(cArray9, (short)28859, false, true), (Object[])new Object[0]), orybujqe.X(cArray10, (short)32138, false, true));
        char[] cArray11 = "\u229a\u20f2\u1ef4\ucb69\u611d\u83a8\u3360\u018b\u4afc\ud544\uf4c2\u833b\u3ff7\u7154\u4e4a\u4352\u01ea\u8466\u03ab\u6b3e\ub87c\ud897\u37f3\u4f5d\uaa08\udf38\u329e\uc09b\ua50b\ua2f8\ua6f3\u81d7\udc74\u9820\u9d69\u0497\uf891\u3cda\u0694\u3196\u1e9a\ucaf1\u9182\u3a6f\u791c\u3be6\u86c0\u5511\ucf29\uc207\u6183\u07c4\ub961\u83d5\u5135\u12aa\u54c2\u95b7\u1f5e\ub46e\u20a1".toCharArray();
        cArray11[31] = (char)(cArray11[31] ^ 0xFD);
        PdfViewerOptionsPanel.oR("-kgak6k", this.locationYesRB, orybujqe.X(cArray11, (short)32518, false, true));
        char[] cArray12 = "\ube9f\udb8d\u041b\ud60b\u860a\ude9a\u05fb\u5933\u12f1\uf352\ue4b0\u0837\ufa26\ue423\u57c7\u35f7\u951b\u24ea\u9039\ud1bf\u45c4\u1600\u64d2\u9f58\u2676\ud6a9\u474b\u0f18\u77c8\ubc57\ucb0a\u4bf4\u9f00\ud75f\udc41\u409a\u61d3\uf09e\uffa2\ua660\u61a1\ufe93\u9567\ucd92\ucd16\u3ad5\ua0a7\u2b31\uef8b\ub2f5\u62f4\ucf5f\u4d4c\ub1f5\ud9d2\u802a\ue192\ub48d\u9ef0\u3fb2\u54f9".toCharArray();
        cArray12[12] = (char)(cArray12[12] ^ 0x5209);
        PdfViewerOptionsPanel.oR("-kgak6k", this.locationNoRB, orybujqe.X(cArray12, (short)15588, true, false));
        char[] cArray13 = "\u38d2\uee8e\u125a\u7f5a\uf2e3\u6275\u2f7e\u5982\u2f9d\u4db6\u2247\ua125\u1d4b\u2ce5\uf2c8\u910d\uda1d\ud58c\ua526\ue118\u0528\u9679\ua2c5\ub63b\uee0d\ud8b4\u4a5e\u510c\u5d7b\ua0fd\ua2fd\ua896\u081c\u134d\ud5f0\u7350\uc229\u1668\ude52\u9df2\uf80d\uc89b\ub8c4\u246d\u64ab\ua362\u9c01\u8d77\u958d\u6aee\uccbb\u689d\u6e65\u1fc1\u5a4e\ufc6e\u4f5f\u423b\ub363\u79b4\u37bf\u5320\u2acf\u2d2a\u1dd9".toCharArray();
        cArray13[14] = (char)(cArray13[14] ^ 0x5F08);
        this.locationTextBox = new TextInput(orybujqe.X(cArray13, (short)24545, true, true), parent, this.view);
        char[] cArray14 = "\uab77\udaf8\u20a4\ua975\uc94f\u579a\udc98\u3d5a\u82cb\u592d\u0207\u6ae9\u124f\u444c\u74a8\u118b".toCharArray();
        cArray14[6] = (char)(cArray14[6] ^ 0x55FB);
        PdfViewerOptionsPanel.oR("tadbo3", this.locationTextBox, orybujqe.X(cArray14, (short)25633, false, false));
        char[] cArray15 = "\ubb4e\u3dfa\u3630\u32c2\u420f\u55c5\u2958\u9636\u2184\ub4d5\ud4b8\u0f76\u5077".toCharArray();
        cArray15[4] = (char)(cArray15[4] ^ 0x4489);
        PdfViewerOptionsPanel.oR("tadbo3", this.locationTextBox, orybujqe.X(cArray15, (short)27991, true, false));
        PdfViewerOptionsPanel.oR("menbo4", this.locationTextBox, obj -> this.updateAllLocations());
        PdfViewerOptionsPanel.oR("8j3bog", this.locationYesRB, () -> {
            if (PdfViewerOptionsPanel.oR("-himk8i", this.locationYesRB) != false) {
                PdfViewerOptionsPanel.oR("-1nmsk8f", this.locationTextBox, true);
            }
        });
        PdfViewerOptionsPanel.oR("8j3bog", this.locationNoRB, () -> {
            if (PdfViewerOptionsPanel.oR("-himk8i", this.locationNoRB) != false) {
                PdfViewerOptionsPanel.oR("-1nmsk8f", this.locationTextBox, false);
                PdfViewerOptionsPanel.oR("-dhqk8e", this.locationTextBox, "");
                PdfViewerOptionsPanel.oR("-o24k7p", this.appearanceBuilder, "");
            }
        });
        char[] cArray16 = "\u5c38\u0b39\ub8e3\ubb90\ud590\u41a4".toCharArray();
        cArray16[4] = (char)(cArray16[4] ^ 0x586F);
        char[] cArray17 = "\u2602\ud35b\u4ff5\uf06b\u05de".toCharArray();
        cArray17[1] = (char)(cArray17[1] ^ 0x526);
        if (PdfViewerOptionsPanel.oR("1sffbod", orybujqe.X(cArray16, (short)6838, true, false), PdfViewerOptionsPanel.oR("-1bfgk76", PdfViewerOptionsPanel.oR("-1ebkk77"), UserProperties.GRAPHICSIGNATURE_LOCALITA, (Object)orybujqe.X(cArray17, (short)30029, false, false))) == false) {
            PdfViewerOptionsPanel.oR("-1ht6k7i", this.locationYesRB, false);
            PdfViewerOptionsPanel.oR("-1nmsk8f", this.locationTextBox, true);
        } else {
            PdfViewerOptionsPanel.oR("-1ht6k7i", this.locationNoRB, false);
            PdfViewerOptionsPanel.oR("-1nmsk8f", this.locationTextBox, false);
            PdfViewerOptionsPanel.oR("-dhqk8e", this.locationTextBox, "");
            PdfViewerOptionsPanel.oR("-o24k7p", this.appearanceBuilder, "");
        }
    }

    private void updateAllLocations() {
        Object location = PdfViewerOptionsPanel.oR("-ssik7o", this.locationTextBox);
        PdfViewerOptionsPanel.oR("-o24k7p", this.appearanceBuilder, location);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.oR("1h3fbo9", PdfViewerOptionsPanel.oR("16d9bos", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.oR("1vlbo5", app, location);
            }
        }
    }

    private void drawReasonArea(DOMElement parent) {
        char[] cArray = "\ub60c\u1e3a\u68ab\u286b\u9814\uded2\u308d\u75e0\u0915\uc6a2\u58f9\uf6d9\u6428\ufa98\u1b49\u332c\u1759\ud471\u2698\u94de\u5a5f\u1b51\u2945\u0873\ufd64\u2298\uf1e2\ud995\u393f\u65cd\ue445\ub5da\u725e\ua993\u4915\u326a\u194d\u8049\u3395\u7f21\u2efe\ua322\u93e5\u2cc0\u0536\u6962\u6259\u6265\u8819\uedab\ufcfc\u2c8c\uf8a1\u7823\ufd47\ub1a8\ucb11\u88c8\u8b25\u2395\u6c86".toCharArray();
        cArray[57] = (char)(cArray[57] ^ 0x2846);
        Paragraph reasonTitle = new Paragraph(orybujqe.X(cArray, (short)11561, true, false), parent, this.view, () -> {
            char[] cArray = "\uca26\u7373\u1fad\u1a80\u8b74\u84ca\u5779\u0e0b\u63d6\u3d9a\ubd23\u5882\uc642\uaa81\u1588\uc63e\u2e57\uf34d\uc7a3\ue4dd\udebd\u0abf\u1018\u553e\u05f7\ufc72\u1582\uf810\u5f58\u2939\uadcb\ub1a0\u6572\u09a5\u38bc".toCharArray();
            cArray[16] = (char)(cArray[16] ^ 0x741E);
            return PdfViewerOptionsPanel.oR("dt5c2r", i18n, svillixe.E(cArray, (short)28445, (short)3, (short)0), (Object[])new Object[0]);
        });
        char[] cArray2 = "\u635b\u0e37\u3ec6\u33b7\u89ca\u02c0\u543f\uf959\uf1cc\u2e1b\ubf7c\u999d\u0701\ufe4e\u2cab\u8c87\ubb70\ubb7a\ue6a8\uc62b\u47b0\u9934\u52ca\ua45d\uc5f1\u5a0f\u6aa5\u4dce\u94f3\u6cfd\u8f28\u7aba\u0825\u6379\u453b\u12b2\u6642\u0f7d\u0b83\u4f5c\u9b25\ue2be\u25b4\ue58a\uf0aa\u7d13\u5f36\u96c4\ufde5\u9df4\ub5a7\uefb9\u6d82\u2168\u587e".toCharArray();
        cArray2[43] = (char)(cArray2[43] ^ 0x4F6D);
        PdfViewerOptionsPanel.oR("10v7c26", reasonTitle, orybujqe.X(cArray2, (short)9865, true, true));
        char[] cArray3 = "\ub586\ufd1e\ud9f9\ub504\ub120\u01b8\uc34e\u60dd\u56a2\u1942\udf25\u5578\u4838\uc80b\uca54\u20c9\ude78\u95f7\u035f\ud306\ue87f\u31ea\u96a4\u5b9d\u0539\ue123\ubc57\u01ec\u6852\uef9b\u12d3\ucba5\u5c0e\ucd23\ucc96\ub277\u4c71\ue34b\uda95\u921e\u71ca\uf834\u35dd\u59eb\ued66\u8a35\uc2f6\u3857\uc417\u8f23\ud3e7\uece7\u8312\u4ce0\ufa5b\u55f9\u5d07\u49fc\uc3ae\u0a25\u4c1b\u6e9b\u7b0d".toCharArray();
        cArray3[39] = (char)(cArray3[39] ^ 0x34B9);
        DivContainer reasonDivisor = new DivContainer(orybujqe.X(cArray3, (short)23702, true, true), parent, this.view);
        char[] cArray4 = "\ubede\u47a5\u29c7\u8009\u6a74\uacfb\u36ea\ue140\u0743\u354f\ud6e1\u7740\ue3f5\u35e3\ufc53\ucb1d\u91ab\u444f\u58e1\ud852\u43f1\ub795\u8baf\u529c\u1bee\uea7e\u1975\u1774\u6af9\ude8b\u3d3a\u0fd8\ued88\ucf16\ub134\uf3d2\u2a27\u89f9\uff46\ueee5\u4e53\u33a0\ue6ad\u32e4\uef22\u53a4\ub3f8\uf9cb\ud8f6\u8dc3\uab7f\ufcc8\ufa0c\u7eda\u5fe9\u2423\u7d78".toCharArray();
        cArray4[44] = (char)(cArray4[44] ^ 0x2B36);
        PdfViewerOptionsPanel.oR("-1ft2jtb", reasonDivisor, orybujqe.X(cArray4, (short)90, false, false));
        char[] cArray5 = "\u1871\u99d3\u7e12\u5426\u22bf\ue59e\u1b72\u582d\u8bb8\u4da6\u3fb1\u9513\u323c\u35ba\u9dec\uf75e\u378b\u8ead\u587c\u1de3\u282b\ue11a\uaa6d\uc526\u71be\u784e\u0d74\u5b33\ub218\u9027\u9960\u120f\uf398\uf1e9\u0bd2\u2d68\ud586\u1d62\u8fe0\u5f01\ueff3\udf85\u2099\u93fa\u7b04\uc89c\uc1ea\ub340\u682d\u9050\u609a\u8301\u5b65\ubf42\u7051\ue15e\ud0e5\uf180\u228a".toCharArray();
        cArray5[24] = (char)(cArray5[24] ^ 0x3E57);
        char[] cArray6 = "\u64c1\u15d9\u0e04\ud9ba\uf049\uad95\ucb5a\u64fe\u3b3e\ue466\uba31\u60e9\u9148\uae3d\u90fe\uc7fa\uc345\uc154\u8b2f\uea91\ubde3\u39ce\u0ac7\u663e\u4825\u33b7\u4543\u0418\u51a2\u0122\uebeb\u1edf".toCharArray();
        cArray6[0] = (char)(cArray6[0] ^ 0x544C);
        char[] cArray7 = "\ue038\u9a06\u29c6\ue4a7\ud9a5\u242c\u05b2\u0118\u4bc5\u377f\u5849\u1e08\uda9e\u53b9".toCharArray();
        cArray7[7] = (char)(cArray7[7] ^ 0x7283);
        this.reasonYesRB = new CGRadioButton(orybujqe.X(cArray5, (short)20295, false, false), parent, this.view, (String)PdfViewerOptionsPanel.oR("dt5c2r", i18n, orybujqe.X(cArray6, (short)8768, true, false), (Object[])new Object[0]), orybujqe.X(cArray7, (short)30645, true, false));
        char[] cArray8 = "\u0c3e\ud950\ud045\ud7db\u7420\u0350\uda2f\ua0dc\u6daa\u2f57\uf360\ube81\u83a1\ufd59\ude2d\u6042\u29c5\ue3a3\ue695\u5d73\u7544\u878f\u320b\u858b\ue643\uff88\u5810\ua45a\ueadf\u1534\u0260\u1862\uba41\u039f\u47a2\ubba1\udc36\u59d2\u6a7a\u4133\u9386\u19fc\uc918\u0838\u2f51\ue128\u7aa5\u1fe7\ucf81\u7cf1\u4d50\u3978\ua7f2\ucfed\ufc39\ubd77\u5c4e\u14d2\u6281".toCharArray();
        cArray8[1] = (char)(cArray8[1] ^ 0x590A);
        char[] cArray9 = "\uc70c\u116a\u2e30\uba10\u2b25\ua268\u0230\u35b7\u65f4\u2c87\uc47a\ucd90\u54bc\u436c\u8c02\ue857\u48a8\uc105\u9b93\u5afd\ua1c3\u96ff\u71bd\ueadc\u7a37\u5573\u67e5\u59ac\u367d\u6aff\u51b8".toCharArray();
        cArray9[22] = (char)(cArray9[22] ^ 0xB8C);
        char[] cArray10 = "\u5621\udc8b\u1c79\u3c30\ub3bb\u2232\u9681\u66c2\u0b52\ub876\uac85\ue022\uf8f1\u0ee2".toCharArray();
        cArray10[2] = (char)(cArray10[2] ^ 0x3EB4);
        this.reasonNoRB = new CGRadioButton(orybujqe.X(cArray8, (short)23090, true, true), parent, this.view, (String)PdfViewerOptionsPanel.oR("dt5c2r", i18n, orybujqe.X(cArray9, (short)24155, false, true), (Object[])new Object[0]), orybujqe.X(cArray10, (short)3240, true, true));
        char[] cArray11 = "\u1c5f\u4265\ufa86\ubd2b\uba91\u39e4\u299d\u9be1\ub979\ubce3\uaff6\u3add\uebb8\ub778\u4284\u5989\u4b81\udfe9\u7f34\u0fe2\u408c\u5f56\u72ea\ub1c8\u03aa\u3fa6\u92c3\u84c4\u1e4a\u1142\uc0bb\u9c90\u6ea6\u3a79\uc560\ua65b\u48cd\u9fe3\ue473\u9f65\ubf51\ud5cd\u3369\ua0df\u4348\uc695\u3672\u6698\uc09e\u1ee5\u200a\uf00d\u0fa6\ud7af\udbbb\u2c00\u9d26\u6d96\u023a\u26bd\u54ba".toCharArray();
        cArray11[48] = (char)(cArray11[48] ^ 0x63C3);
        PdfViewerOptionsPanel.oR("-kgak6k", this.reasonYesRB, orybujqe.X(cArray11, (short)27147, false, true));
        char[] cArray12 = "\uf676\u7f60\u4a6a\u313c\ub171\u7ed2\u0c31\ud8ea\ubea1\ud1df\u4766\u06fc\udb60\u08aa\u988f\u6e9e\uc239\u2e05\u9451\u5feb\ud65a\ufcb3\ua06c\ubd7e\u4bee\ub40d\u8a42\uc980\u65ec\udedc\u868f\u62a3\ub13f\udf05\u3d10\u85bf\u7c53\u59e3\uf8d0\u0b8b\u5e97\u115a\u770d\u80a0\u87c7\uc147\u790d\udf93\u395e\u576a\ua2e0\u0f62\uedb3\u02b5\ub150\u6e22\u49dc\u6cba\u9b8d\u2840\u5508".toCharArray();
        cArray12[5] = (char)(cArray12[5] ^ 0x732A);
        PdfViewerOptionsPanel.oR("-kgak6k", this.reasonNoRB, orybujqe.X(cArray12, (short)32163, true, false));
        char[] cArray13 = "\udccc\u7dfc\uc7e5\u92cf\uacef\ud234\uc7e8\ub57b\u5dba\uef72\u51e4\u917e\ued7e\u12bc\u893a\u0ae3\u9536\u26ce\uff30\u7592\u2c85\u9c3e\u4d5f\u20ff\ud9b6\ub75b\ubcc1\u04bb\uc857\u9c76\ufb41\ua9cf\ud1ae\u5f7e\uc808\u4845\u8870\u3210\ud61b\u264b\ua1e6\u9513\u5aaf\uaf3c\ud5bf\u5de6\ud3a5\u736c\u5a4c\u574a\ude87\uba43\ub6e1\ua243\u841e\u9c1a\ue58a\ud592\u5a27\u9443\uc465\u7f0f\u68bb".toCharArray();
        cArray13[57] = (char)(cArray13[57] ^ 0x14E);
        this.reasonTextBox = new TextInput(orybujqe.X(cArray13, (short)24696, true, true), parent, this.view);
        char[] cArray14 = "\ucccf\ubdfc\ue97e\ufad5\u72f7\u3883\ue0f2\ud513\u1a62\ue102\u301c\u1456\u8206\ude01\u55cf\u6ff2".toCharArray();
        cArray14[5] = (char)(cArray14[5] ^ 0x58A9);
        PdfViewerOptionsPanel.oR("tadbo3", this.reasonTextBox, orybujqe.X(cArray14, (short)14509, false, true));
        char[] cArray15 = "\ue4c7\u1860\ud3ef\ua62c\uc8ec\u7f62\u657e\u632c\uf03d\ua756\uc05f\uc5f4\u44e9".toCharArray();
        cArray15[4] = (char)(cArray15[4] ^ 0x2868);
        PdfViewerOptionsPanel.oR("tadbo3", this.reasonTextBox, orybujqe.X(cArray15, (short)8194, false, true));
        PdfViewerOptionsPanel.oR("menbo4", this.reasonTextBox, obj -> this.updateAllReasons());
        PdfViewerOptionsPanel.oR("8j3bog", this.reasonYesRB, () -> {
            if (PdfViewerOptionsPanel.oR("-himk8i", this.reasonYesRB) != false) {
                PdfViewerOptionsPanel.oR("-1nmsk8f", this.reasonTextBox, true);
            }
        });
        PdfViewerOptionsPanel.oR("8j3bog", this.reasonNoRB, () -> {
            if (PdfViewerOptionsPanel.oR("-himk8i", this.reasonNoRB) != false) {
                PdfViewerOptionsPanel.oR("-1nmsk8f", this.reasonTextBox, false);
                PdfViewerOptionsPanel.oR("-dhqk8e", this.reasonTextBox, "");
                PdfViewerOptionsPanel.oR("14s7bo6", this.appearanceBuilder, "");
            }
        });
        char[] cArray16 = "\ueb49\u6939\uc679\u9a8b\uc898d".toCharArray();
        cArray16[2] = (char)(cArray16[2] ^ 0x6A);
        char[] cArray17 = "\ua3b3\ua799\ua2b9\ud687\u0201".toCharArray();
        cArray17[1] = (char)(cArray17[1] ^ 0x50E);
        if (PdfViewerOptionsPanel.oR("1sffbod", orybujqe.X(cArray16, (short)17655, true, false), PdfViewerOptionsPanel.oR("-1bfgk76", PdfViewerOptionsPanel.oR("-1ebkk77"), UserProperties.GRAPHICSIGNATURE_MOTIVO, (Object)orybujqe.X(cArray17, (short)12454, true, false))) == false) {
            PdfViewerOptionsPanel.oR("-1ht6k7i", this.reasonYesRB, false);
            PdfViewerOptionsPanel.oR("-1nmsk8f", this.reasonTextBox, true);
        } else {
            PdfViewerOptionsPanel.oR("-1ht6k7i", this.reasonNoRB, false);
            PdfViewerOptionsPanel.oR("-1nmsk8f", this.reasonTextBox, false);
            PdfViewerOptionsPanel.oR("-dhqk8e", this.reasonTextBox, "");
            PdfViewerOptionsPanel.oR("14s7bo6", this.appearanceBuilder, "");
        }
    }

    private void updateAllReasons() {
        Object reason = PdfViewerOptionsPanel.oR("-ssik7o", this.reasonTextBox);
        PdfViewerOptionsPanel.oR("14s7bo6", this.appearanceBuilder, reason);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.oR("1h3fbo9", PdfViewerOptionsPanel.oR("16d9bos", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.oR("-me8k7l", app, reason);
            }
        }
    }

    private void drawPreservePdfAArea(DOMElement parent) {
        char[] cArray = "\ub34f\u6100\u9ba5\uf56c\uce1b\ub09a\u30fc\u8fec\u1970\u24f2\ue337\uefd4\u28aa\u5366\ue05e\u4dc4\u9ed3\u204a\u5c72\uea02\u9d9d\u3c81\ue269\ucef2\u6c16\u84f4\u7b40\u992b\u928e\u8293\udc54\ub06f\u75d3\u6a00\u19d9\ud63f\u6079\udbb5\u34cb\u5f19\u632b\ufeee\u6d64\uee8c\u5d78\u98f9\u5cb2\ufbb0\u54ea\u133a\u7544\udd2d\u35c4\uf495\uaefe\u41ee\ubab1\u1e32\u251f\uc4b9\u1a27\ue9d6\u2ba6\ubae8\uc45e\u48f5\u2c68".toCharArray();
        cArray[26] = (char)(cArray[26] ^ 0x3580);
        Paragraph preservePDFATitle = new Paragraph(svillixe.E(cArray, (short)11754, (short)0, (short)0), parent, this.view, () -> {
            char[] cArray = "\uf811\uc46b\u7bb5\u3dc1\ub894\u06cb\uecfe\u7afa\u5d45\u259c\u23d7\u1e07\u0f1a\u1c70\u79ef\u30f1\udcfa\u16c5\uf099\ua5d9\u9a7e\u4a93\uff9e\u03f9\u708e\u06d0\ua0b1\uae57\u4b9f\ue784\u9c9c\u894d\u8358\uac23\ue6bd\u5941\u2864\u2c7b\u96ea\ubc32\u985f\u5d17".toCharArray();
            cArray[35] = (char)(cArray[35] ^ 0x584F);
            return PdfViewerOptionsPanel.oR("dt5c2r", i18n, eakifuto.s(cArray, (short)7942, (byte)0, (short)5), (Object[])new Object[0]);
        });
        char[] cArray2 = "\u0ab4\u8265\u5e2e\uc250\u5c2b\ub5e0\u1181\u36d2\u9b70\u0bd6\u0976\ua4e9\uc64c\u670c\ue1ff\u3839\u4276\u5d3b\u0fbe\u302a\ufe44\u6861\u7bf7\ufc45\uc4e8\uaf25\u8347\u3efe\uf9e4\u89ad\ub3a6\u15a2\u8c89\uef64\ubeb5\uff33\u1ce3\uc2f7\ufcab\u7f3e\u9f99\u7d1e\ua462\u41e4\u6a40\u385c\uaf3f\u2aae\u43c9\uba0d\u81d7\u3bc9\u45c7\uc102\u4a6b".toCharArray();
        cArray2[14] = (char)(cArray2[14] ^ 0x6ECD);
        PdfViewerOptionsPanel.oR("10v7c26", preservePDFATitle, svillixe.E(cArray2, (short)23372, (short)0, (short)1));
        char[] cArray3 = "\u6954\u6282\u65fe\u4709\uf493\u9362\uedd7\u5f4c\u2feb\u9d55\ufdbf\u55ec\ub54b\ue239\u239a\uf443\uee23\u58c2\u07ec\ufee0\ub361\u4196\u0b5c\uf0bc\u831d\uac0f\u315a\ua746\u4218\u737c\u7e30\uf426\ub4cd\ufbd8\uedaa3\u1baa\ubc2b\u7770\u231f\u6035\u51bb\u844b\uddc6\u040f\u39a1\u87d5\u057a\u3cb3\ub074\u38c7\ud7f7\u8efd\u2b75\u7301\u8092\u3567\u029b\u6de4\u72bb\uabfb\u56a1\uac8c\u1668\u089d\u060c\uce84\u8876\u2bc7".toCharArray();
        cArray3[32] = (char)(cArray3[32] ^ 0x4C4);
        DivContainer preservePDFADivisor = new DivContainer(svillixe.E(cArray3, (short)9444, (short)1, (short)2), parent, this.view);
        char[] cArray4 = "\u3f85\u7ec1\u2cdf\u5800\u0502\u3a22\ucbc6\u9029\u7283\u920e\u8059\ud523\ufef4\u915a\u4201\u6bcd\u8a3d\u9ad9\u242e\uda4a\u7d7b\u0fd9\uc81b\u6355\ucf54\ud4f5\u44be\ud5ff\u2889\u439b\uc5cd\u423a\ua6eb\u8595\u6280\u07c8\u0a6d\u2093\u0019\u1774\u788e\udc7b\u6345\u7a2b\ud203\u1904\u8484\uc9e4\u74f4\u0097\u1f47\u7218\uac9c\u13dd\u741b\u97e2\u2528".toCharArray();
        cArray4[36] = (char)(cArray4[36] ^ 0x3677);
        PdfViewerOptionsPanel.oR("-1ft2jtb", preservePDFADivisor, svillixe.E(cArray4, (short)29419, (short)2, (short)1));
        char[] cArray5 = "\uba57\u33b8\ue0a1\u7500\u53f4\u87e9\u44e2\uba98\u9ff1\u9486\ub289\ua68c\u6f0a\ua080\u9019\u9c1d\u0a8b\uee3d\u5182\u32b4\u80d1\u4855\u5b01\uf24a\ud0cc\u6c0a\uf405\uefa0\u990f\u5974\ufe81\uf414\u19d5\uceff\u7a96\uaf71\u4b9a\uc6f7\u7e64\ufe15\ucb29\u8ab0\ub59e\u4b86\ue7f4\u31ce\u07f0\u92ff\uabe0\u8ddc\u020d\u43e8\u939e\uab4e\ue82c\ucb83\uc66e\u0331\u126f\udfb6\u086a\u0c53\u8082\ud153\u4e6a".toCharArray();
        cArray5[22] = (char)(cArray5[22] ^ 0x756D);
        char[] cArray6 = "\u3b90\uc989\ua228\uc7c5\u6cea\ue225\u92e5\u9cf4\ue13b\u9c72\ub4ef\ua216\u1998\u46fe\ue5d9\u7449\u9a2b\uf4a0\u8e17\uea3e\u2c82\u5f8d\u4e86\ubf4b\u3724\u5b8c\u1fba\u10b9\u9b02\ubd31\u26ab\u5560".toCharArray();
        cArray6[4] = (char)(cArray6[4] ^ 0xDBB);
        char[] cArray7 = "\uf82e\u0765\u684f\u4736\u8267\u7799\ub842\ua1bf\uf479\u9732\u16f6\u4f41\uab65\u07d2\ud67b\u777d\u9c0e\u0ad5\uce71\u1ebc".toCharArray();
        cArray7[16] = (char)(cArray7[16] ^ 0x6AD3);
        this.preservePDFAYesRB = new CGRadioButton(svillixe.E(cArray5, (short)9737, (short)2, (short)2), parent, this.view, (String)PdfViewerOptionsPanel.oR("dt5c2r", i18n, svillixe.E(cArray6, (short)3935, (short)0, (short)3), (Object[])new Object[0]), svillixe.E(cArray7, (short)3641, (short)2, (short)0));
        char[] cArray8 = "\u68da\ue985\ub081\u5e22\u08dd\u28a7\u67cf\u2f24\u20a7\u4295\u0b53\ube78\u9b36\ud793\uabee\u9d56\u40d6\u81a4\u47eb\u074f\u9e5e\u7425\u6803\uf0cc\ud1ed\u21b1\uf7df\u106d\ucf63\u5ab0\u1470\u4b40\ud0c3\uc193\u26c3\u14b2\u50f8\u0def\ufc81\uc390\u3587\u4182\u5601\ucb93\u96ef\u0cec\u6984\uc77a\u2b23\u239a\u776c\u8828\u2f1c\u6415\u3799\u3032\u857b\ub87e\ua275\u81b4\u9599\u1d8a\u4fa2\u7883".toCharArray();
        cArray8[1] = (char)(cArray8[1] ^ 0x1EF7);
        char[] cArray9 = "\ue92f\u1f73\u8002\u1f80\ufc8c\u93f9\ubf90\ud1a4\u1424\u5524\u3b3b\u4428\ue284\u5667\ue6bb\u2f84\u2f73\u4667\u4ff7\u3840\u377e\u9dcd\u6977\u9e70\u7936\ub2c8\ueb5e\ud6b9\u794d\u983a\u7ae3".toCharArray();
        cArray9[15] = (char)(cArray9[15] ^ 0x681F);
        char[] cArray10 = "\u7f07\u2c15\u8341\u76eb\udfd8\uf51f\u2e11\ua941\u8a98\ue976\udd9f\u2f8a\u8db1\u2487\u5fa0\ud68d\u0edb\uca4d\ub500\u1b58".toCharArray();
        cArray10[17] = (char)(cArray10[17] ^ 0x4CF);
        this.preservePDFANoRB = new CGRadioButton(svillixe.E(cArray8, (short)6472, (short)2, (short)4), parent, this.view, (String)PdfViewerOptionsPanel.oR("dt5c2r", i18n, svillixe.E(cArray9, (short)9028, (short)1, (short)5), (Object[])new Object[0]), svillixe.E(cArray10, (short)30916, (short)2, (short)3));
        char[] cArray11 = "\u5662\udf7b\uef34\uef7a\uedf0\u2350\u2257\ue106\u3da0\ucfe1\ua1e4\u0650\u3c50\u8594\uc0cb\u9eae\uaf90\u6c5d\uc00d\u184b\u80e2\ud97d\u0ef1\u48ee\ua76f\u740e\u6265\u1b46\uef5c\u95b2\u7a67\uc5ad\u83e9\u1a25\uceb1\ud4e3\u0d78\u29e5\u1353\ua249\u3b33\u1558\u5fd7\u72c5\ud6c8\ucd12\u47ec\u1220\u57c3\u2ea8\u5335\u14c4\ue315\u8dcc\u282e\u8da5\u2f5b\u88d0\ue32d\u5af0\u16c0".toCharArray();
        cArray11[14] = (char)(cArray11[14] ^ 0x1BC4);
        PdfViewerOptionsPanel.oR("-kgak6k", this.preservePDFAYesRB, svillixe.E(cArray11, (short)23451, (short)0, (short)1));
        char[] cArray12 = "\ue5a2\u7113\uf4db\u4fbd\u906d\uce02\ua14d\u75ff\ucf5e\uaf16\ua05c\u0e8a\ueb92\ud407\u2a7e\u983f\u5824\ue8a4\uf255\u5524\u9872\u254c\uf72d\uad5a\u0d8a\uef36\u6aac\u7650\u1957\udd94\u0db9\u638a\ucf84\u0210\ua29a\ua834\u6dc2\u076e\u60a9\u8405\u3952\u5f7b\ucd40\u6a76\u1810\uc03c\u637f\u9535\u58e5\uad27\u41bf\u398a\ue82c\ua7e6\ufd66\u1293\uec6c\u8620\ua126\u57ef\u55e6".toCharArray();
        cArray12[52] = (char)(cArray12[52] ^ 0x2030);
        PdfViewerOptionsPanel.oR("-kgak6k", this.preservePDFANoRB, svillixe.E(cArray12, (short)17944, (short)0, (short)3));
        PdfViewerOptionsPanel.oR("8j3bog", this.preservePDFAYesRB, () -> {
            if (PdfViewerOptionsPanel.oR("-himk8i", this.preservePDFAYesRB) != false) {
                this.updateAllPreservePdfA(true);
            }
        });
        PdfViewerOptionsPanel.oR("8j3bog", this.preservePDFANoRB, () -> {
            if (PdfViewerOptionsPanel.oR("-himk8i", this.preservePDFANoRB) != false) {
                this.updateAllPreservePdfA(false);
            }
        });
        char[] cArray13 = "\u9a62\u19b1\u7aa0\u3f55\u4a4b".toCharArray();
        cArray13[2] = (char)(cArray13[2] ^ 0x4833);
        char[] cArray14 = "\u51f0\u37e9\u63cd\uf806\u4ae8".toCharArray();
        cArray14[3] = (char)(cArray14[3] ^ 0x3480);
        if (PdfViewerOptionsPanel.oR("1sffbod", svillixe.E(cArray13, (short)3087, (short)3, (short)0), PdfViewerOptionsPanel.oR("-1bfgk76", PdfViewerOptionsPanel.oR("-1ebkk77"), UserProperties.GRAPHICSIGNATURE_PRESERVEPDFA, (Object)svillixe.E(cArray14, (short)5994, (short)4, (short)0))) == false) {
            PdfViewerOptionsPanel.oR("-1ht6k7i", this.preservePDFANoRB, false);
            PdfViewerOptionsPanel.oR("1ejpboc", this.appearanceBuilder, false);
        } else {
            PdfViewerOptionsPanel.oR("-1ht6k7i", this.preservePDFAYesRB, false);
            PdfViewerOptionsPanel.oR("1ejpboc", this.appearanceBuilder, true);
        }
    }

    private void updateAllPreservePdfA(boolean preserve) {
        PdfViewerOptionsPanel.oR("1ejpboc", this.appearanceBuilder, preserve);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.oR("1h3fbo9", PdfViewerOptionsPanel.oR("16d9bos", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.oR("132rbnp", app, preserve);
                PdfViewerOptionsPanel.oR("1eupbo0", app);
            }
        }
    }

    private void drawVerticalArea(DOMElement optionsContainer, DOMElement optionsArea) {
        char[] cArray = "\uee03\ufdbb\u173a\u7030\u77aa\u9633\uaf69\u64f1\ue7df\u377d\u397f\u96b8\u47f9\u21dd\u7a67\uc5d2\u9d99\u992c\ue830\ud185\u1a9f\u95b2\uecc0\u2042\u6ec3\uccaa\u31c8\u20d0\uae60\u9394\ue6ff\uba89\u579e\u9e29\uc4f0\uce07\ue670\u2a33\u66b0\u6264\u1ad7\u66a3\uad9a\uec96\uf672\uabac\u4e0e\u20b1\u8985\u118e".toCharArray();
        cArray[23] = (char)(cArray[23] ^ 0x2221);
        DivContainer verticalArea = new DivContainer(orybujqe.X(cArray, (short)15097, true, true), optionsContainer, this.view);
        char[] cArray2 = "~\u243f\uf936\u98c5\ua9a3\u2fe4\udba4\u3ce8\u2b8a\u9c12\u3a25\u4980\uc59d\ud352\u2df0\u17b3\ud44f\u0d18\u9e40\uf80d\u7a64\ub695\u1328\uaaf1\ua50c\u3f66\u37d8\ub4ff\u7f61\ua513\u76b8\u09cf\u4d58\u24ec\u5a9d\uc962\u5602\u6050\ub870\u10e6\ud062\u25eb\ucba6\uee04\u04d1\u4e20\u2176\u5ca7\u8432\u566e".toCharArray();
        cArray2[20] = (char)(cArray2[20] ^ 0x23CE);
        PdfViewerOptionsPanel.oR("-1ft2jtb", verticalArea, orybujqe.X(cArray2, (short)25387, true, true));
        char[] cArray3 = "\ud3af\u0535\u6b0b\u480d\uda91\ud0b2\u139d\ubd27\u478d\ub9ff\u0279\ue1f1\ud4f2\uad23\ua3b0\u438a\u70be\ub9fa\u61fe\u43ca\u00a8\ua757\u013b\u331a\u4201\u161a\ue3d9\ud37d\uf37f\u1575\ub575\uc095\u1a28\u582e\uf3f4\u41a2\u34eb\u6a41\u767c\u587b\u9815\u270d\ue0d0\u0d58\uf7ac\u633a\u8a45\uca63\ufbc6\u4f1c".toCharArray();
        cArray3[19] = (char)(cArray3[19] ^ 0x673D);
        Paragraph optionsLabel = new Paragraph(orybujqe.X(cArray3, (short)24714, true, true), (DOMElement)verticalArea, this.view, () -> {
            char[] cArray = "\ua8d0\ue8e7\uf6cd\u24ab\u61ee\u572f\uf398\ucf10\u38f1\u5eed\u20bf\u495a\u178c\u3310\uac48\u1a89\ub766\u7e33\u46ca\ufed2\ufe8e\ud72a\ufba9\ud3e5\u50be\u42a5\u6f44".toCharArray();
            cArray[7] = (char)(cArray[7] ^ 0x6B57);
            return PdfViewerOptionsPanel.oR("dt5c2r", i18n, orybujqe.X(cArray, (short)31741, false, true), (Object[])new Object[0]);
        });
        char[] cArray4 = "\u0d53\uaf77\u933e\u2380\u0707\u6a8c\uc7cd\u93be\u2f02\uca3b\u751f\u5c76\u634e\ube1f\ub0bd\u382b\u89ab\u0a94\ue55c\ubd85\uf130\ua270\ua0ec\u7003\u846d\u725f\u6fcc\uae0f\ue18a\u38ef\u83d2\uef53\u5df3\u8e00\ud496\u25cc\u72b4\u2948\ua8a2\ud536\u21db\uef69\u2d96\uc6f5\u25c9\u6cad\ubb39\ude2b\ub9c0\u3d5d".toCharArray();
        cArray4[29] = (char)(cArray4[29] ^ 0x490C);
        PdfViewerOptionsPanel.oR("10v7c26", optionsLabel, orybujqe.X(cArray4, (short)18650, false, false));
        char[] cArray5 = "\uf509\u1355\u804c\u2b0b\u9df3\u5f76\ueff3\uf4b0\u0824\ud6b8\u1a5b\u4cc9\udf06\ueee8\u85b4\ua29e\uf0f6\ufb15\u2057\ua553\uae55\ud3ad\ub66b\ubadb\u9be4\u015d\u63d4\u17d8\ue2b6\u5f40\u5ac3\ua0b6\ue573\u88c8\u50ad\u22b3\u0172\ub43b\u55a5\u1396\u8cf9\ud2bf\uf943\u23fe\ua94b\uf1d9\u0858\u93d2\ue12f\u3908\uee9b\u69bf\u5425".toCharArray();
        cArray5[2] = (char)(cArray5[2] ^ 0x2AAB);
        SpanContainer verticalAligner = new SpanContainer(orybujqe.X(cArray5, (short)6576, true, true), (DOMElement)verticalArea, this.view);
        char[] cArray6 = "\uaa15\ufd4b\uf14c\u1762\udd52\u1302\u79aa\ue955\u73d7\ub721\ubd40\u1c3d\u3205\u2618\u3889\ue632\u088e\u2b7d\u645c\ufbdc\u2f90\u0b60\u33cb\u59f7\u0973\ub8cd\u0d62\u668f\u2318\udee8\u3528\ue254\uc6c1\u197a\u84a2\u69be\u3603\u58c4\u9a46\ubc8c\u1fe1\ucc45\uaee1\udb64\u1f5d\u4a2a\u54a8\u4e2a\u439b\u6604\uf72b\ua340\u08ed".toCharArray();
        cArray6[42] = (char)(cArray6[42] ^ 0x5199);
        PdfViewerOptionsPanel.oR("-1oeuk86", verticalAligner, orybujqe.X(cArray6, (short)23941, true, false));
        char[] cArray7 = "\uebcb\u81df\u179b\ud109\u5ee5\u1b88\u5b8a\ue0cd\ufa2a\ub6f6\u2d90\uebf6\uf01e\u4ed8\uab0a\u9b33\ub696\u0f18\u6938\ueb5a\u6d5d\u33ea\uf22c\ubb0b\u3508\u1999\u1b4d\uc8e5\u2811\u0d37\u231a\u3921\u2a43\ude1c\u9892\u0822\u395f\ufdad\ub383\u0873\u303b\ua2a9\uec3a\u8142\ucade\uf30f\u6cc1\u1c0a\u6519".toCharArray();
        cArray7[9] = (char)(cArray7[9] ^ 0x33CF);
        Image toggleOptions = new Image(orybujqe.X(cArray7, (short)8600, true, false), (DOMElement)verticalArea, this.view);
        char[] cArray8 = "\u2d38\u4fb9\uc7ba\u3e5a\u675a\u23d3\u654f\uc447\uaaf4\uafc0\u90ff\u4326\uaf12\u5856\u65e4\u9366\u37db\ubad5\uaac8\u741b\ucd51\u7afd\ub5ea\u37da\ufc49\u2e97\u49ec\u34a0\ud65c\u0bdf\u5813\u5c27\u6d3d\u169e\u6e9c\u240f\u37b5\u8fea\u6e82\ua404\u49cd\ud42a\u4532\u468e\u97a0\u1e76\ucc3b\u9bc1\u711d".toCharArray();
        cArray8[41] = (char)(cArray8[41] ^ 0x4EA5);
        PdfViewerOptionsPanel.oR("1g21c24", toggleOptions, orybujqe.X(cArray8, (short)6400, false, true));
        PdfViewerOptionsPanel.oR("1vdtbpi", toggleOptions, ARROW_LEFT);
        PdfViewerOptionsPanel.oR("1389bnf", verticalArea, evt -> {
            this.isOptionsVisible = !this.isOptionsVisible;
            PdfViewerOptionsPanel.oR("-1gjek8j", optionsArea, this.isOptionsVisible);
            if (this.isOptionsVisible) {
                PdfViewerOptionsPanel.oR("1vdtbpi", toggleOptions, ARROW_RIGHT);
            } else {
                PdfViewerOptionsPanel.oR("1vdtbpi", toggleOptions, ARROW_LEFT);
            }
        });
    }

    public void remove() {
        if (this.imageYesRB != null) {
            PdfViewerOptionsPanel.oR("4kdbng", this.imageYesRB);
        }
        if (this.imageNoRB != null) {
            PdfViewerOptionsPanel.oR("4kdbng", this.imageNoRB);
        }
        if (this.dateYesRB != null) {
            PdfViewerOptionsPanel.oR("4kdbng", this.dateYesRB);
        }
        if (this.dateNoRB != null) {
            PdfViewerOptionsPanel.oR("4kdbng", this.dateNoRB);
        }
        if (this.locationYesRB != null) {
            PdfViewerOptionsPanel.oR("4kdbng", this.locationYesRB);
        }
        if (this.locationNoRB != null) {
            PdfViewerOptionsPanel.oR("4kdbng", this.locationNoRB);
        }
        if (this.reasonYesRB != null) {
            PdfViewerOptionsPanel.oR("4kdbng", this.reasonYesRB);
        }
        if (this.reasonNoRB != null) {
            PdfViewerOptionsPanel.oR("4kdbng", this.reasonNoRB);
        }
        if (this.preservePDFAYesRB != null) {
            PdfViewerOptionsPanel.oR("4kdbng", this.preservePDFAYesRB);
        }
        if (this.preservePDFANoRB != null) {
            PdfViewerOptionsPanel.oR("4kdbng", this.preservePDFANoRB);
        }
    }

    static {
        char[] cArray = "\u01c9\uda56\u5821\uea48\u70f0\uca43\uae69\u2b1c\u6435\u1803\u07bf\u229a\u7284\u1502\u07db\ua5ba\u4fea\ufac7\ua5e4\u8c34\u9d0e\u0a43\u8e5d\u550f\u6c13\u2ddaw\u21ef\u24fd\u03a0\ufb8e\u4b00\u3e00\ub806\u639e".toCharArray();
        cArray[8] = (char)(cArray[8] ^ 0x1853);
        i18n = PdfViewerOptionsPanel.oR("6qnbpb", eakifuto.s(cArray, (short)30917, (byte)0, (short)2));
        char[] cArray2 = "\u0446\u7e4e\ub201\u7951\uaf26\u0e8d\u467e\uec8d\uc1f0\ub21e\u6845\u4ce4".toCharArray();
        cArray2[9] = (char)(cArray2[9] ^ 0x5C6E);
        ARROW_LEFT = PdfViewerOptionsPanel.oR("-b2ck6f", eakifuto.s(cArray2, (short)721, (byte)0, (short)3));
        char[] cArray3 = "\u924d\u94ce\u40ed\udade\u0111\ubb3a\uc9e6\u63b7\uddef\ud8d8\ufc9b\u05a8".toCharArray();
        cArray3[7] = (char)(cArray3[7] ^ 0x52CA);
        ARROW_RIGHT = PdfViewerOptionsPanel.oR("-b2ck6f", eakifuto.s(cArray3, (short)15714, (byte)5, (short)0));
    }

    private static Object oR(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(xugfuioj.S(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

