/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.ldap;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import esecurity.crypto.gui.ldap.LdapEndPoint;
import esecurity.crypto.gui.ldap.tqthcysq;
import esecurity.crypto.gui.ldap.ucptjpud;
import esecurity.crypto.gui.properties.AppProperties;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LdapEndPointLoader {
    private static final EllipsLogger logger = LdapEndPointLoader.Fz("-t7n1gs", Constants.CAPI_LOGGER_NAME);
    private static final File LDAP_DATA_FILE;
    private static final File DEFAULT_LDAP_DATA_FILE;
    private static List<LdapEndPoint> ldapDataLoader;

    public static void load() {
        ldapDataLoader = LdapEndPointLoader.loadFromFile();
    }

    public static List<LdapEndPoint> getEndPoints() {
        if (ldapDataLoader == null) {
            LdapEndPointLoader.load();
        }
        return ldapDataLoader;
    }

    public static void addEndPoint(LdapEndPoint endPoint) {
        LdapEndPointLoader.getEndPoints().add(endPoint);
    }

    public static void removeEndPoint(LdapEndPoint endPoint) {
        if (endPoint == null) {
            return;
        }
        LdapEndPointLoader.getEndPoints().remove(endPoint);
    }

    public static void removeEndPoint(String name) {
        if (name == null || LdapEndPointLoader.Fz("19g2ufj", name) != false) {
            return;
        }
        List<LdapEndPoint> endPoints = LdapEndPointLoader.getEndPoints();
        boolean found = false;
        for (int i = 0; !found && i < endPoints.size(); ++i) {
            if (LdapEndPointLoader.Fz("tucufb", name, LdapEndPointLoader.Fz("5rcuf3", endPoints.get(i))) == false) continue;
            endPoints.remove(i);
            found = true;
        }
    }

    public static void saveToFile() {
        ObjectMapper om = new ObjectMapper();
        LdapEndPointLoader.Fz("-j4b1h2", om, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, (boolean)false);
        try {
            LdapEndPointLoader.Fz("-30l1h3", om, LDAP_DATA_FILE, LdapEndPointLoader.getEndPoints());
        }
        catch (IOException ex) {
            LdapEndPointLoader.Fz("-1mal1gv", logger, LdapEndPointLoader.Fz("-ecn1gg", ex), (Object)ex);
        }
    }

    private static List<LdapEndPoint> loadFromFile() {
        ArrayList<LdapEndPoint> endpoints = new ArrayList<LdapEndPoint>();
        ObjectMapper om = new ObjectMapper();
        LdapEndPointLoader.Fz("-j4b1h2", om, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, (boolean)false);
        if (LdapEndPointLoader.Fz("-1j1j1gh", DEFAULT_LDAP_DATA_FILE) != false) {
            try {
                LdapEndPointLoader.Fz("1254uep", endpoints, (Collection)LdapEndPointLoader.Fz("1b1mueq", om, DEFAULT_LDAP_DATA_FILE, (Object)new TypeReference<List<LdapEndPoint>>(){}));
            }
            catch (IOException ex) {
                LdapEndPointLoader.Fz("-1mal1gv", logger, LdapEndPointLoader.Fz("-ecn1gg", ex), (Object)ex);
            }
        }
        if (LdapEndPointLoader.Fz("-1j1j1gh", LDAP_DATA_FILE) != false) {
            try {
                LdapEndPointLoader.Fz("1254uep", endpoints, (Collection)LdapEndPointLoader.Fz("1b1mueq", om, LDAP_DATA_FILE, (Object)new TypeReference<List<LdapEndPoint>>(){}));
            }
            catch (IOException ex) {
                LdapEndPointLoader.Fz("-1mal1gv", logger, LdapEndPointLoader.Fz("-ecn1gg", ex), (Object)ex);
            }
        }
        return endpoints;
    }

    static {
        char[] cArray = "\u1f19\u0a3c\u827e\u16e7\uf11f\ufdda\u681e\u3204\uff32\u4d4c".toCharArray();
        cArray[4] = (char)(cArray[4] ^ 0x76E6);
        LDAP_DATA_FILE = new File((String)LdapEndPointLoader.Fz("-16sj1gr", LdapEndPointLoader.Fz("-10rb1gq", LdapEndPointLoader.Fz("-10rb1gq", LdapEndPointLoader.Fz("-10rb1gq", new StringBuilder(), LdapEndPointLoader.Fz("gokues", LdapEndPointLoader.Fz("-1p4t1o1"), AppProperties.WORK_FOLDER, (Object)"")), File.separator), tqthcysq.v(cArray, (short)14980, 3, (short)1))));
        char[] cArray2 = "\u7858\ub809\ua892\u98ae\u1ec4\ua010\u90be\uae89\u6716\u6d99\u7a00\ude65\u95b0\u45ae".toCharArray();
        cArray2[10] = (char)(cArray2[10] ^ 0x1708);
        DEFAULT_LDAP_DATA_FILE = new File((String)LdapEndPointLoader.Fz("-16sj1gr", LdapEndPointLoader.Fz("-10rb1gq", LdapEndPointLoader.Fz("-10rb1gq", LdapEndPointLoader.Fz("-10rb1gq", new StringBuilder(), LdapEndPointLoader.Fz("gokues", LdapEndPointLoader.Fz("-1p4t1o1"), AppProperties.BASE_FOLDER, (Object)"")), File.separator), tqthcysq.v(cArray2, (short)25209, 0, (short)2))));
    }

    private static Object Fz(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(ucptjpud.m(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

