/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.https;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class LocalSSLRootBuilder {
    public static KeyPair createKeyPair(int n) throws CapiException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(n);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CapiException(noSuchAlgorithmException.getMessage(), 1003, noSuchAlgorithmException);
        }
    }

    public static KeyPair createKeyPair() throws CapiException {
        return LocalSSLRootBuilder.createKeyPair(2048);
    }

    public static X509Certificate generateRootSelfSignedCertificate(PrivateKey privateKey, PublicKey publicKey, Date date, Date date2, String string) throws CapiException {
        try {
            privateKey = new JcaContentSignerBuilder("SHA512withRSA").build(privateKey);
            X500NameBuilder x500NameBuilder = new X500NameBuilder();
            x500NameBuilder.addRDN(BCStyle.CN, "localhost");
            x500NameBuilder.addRDN(BCStyle.O, string);
            x500NameBuilder.addRDN(BCStyle.C, "IT");
            string = x500NameBuilder.build();
            publicKey = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            publicKey = new X509v3CertificateBuilder((X500Name)string, new BigInteger(48, Util.secureRandom), date, date2, (X500Name)string, (SubjectPublicKeyInfo)publicKey);
            date = new KeyUsage(6);
            publicKey.addExtension(Extension.keyUsage, true, (ASN1Encodable)date);
            publicKey.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(1));
            privateKey = publicKey.build((ContentSigner)privateKey);
            return LocalSSLRootBuilder.a((X509CertificateHolder)privateKey);
        }
        catch (Exception exception) {
            throw new CapiException(exception.getMessage(), 1003, exception);
        }
    }

    public static X509Certificate generateCertificateForWebServer(PrivateKey privateKey, X509Certificate x509Certificate, PrivateKey dERSequence, PublicKey publicKey, Date date, Date date2, String string) throws CapiException {
        try {
            privateKey = new JcaContentSignerBuilder("SHA512withRSA").build(privateKey);
            x509Certificate = new JcaX509CertificateHolder(x509Certificate).getSubject();
            dERSequence = string;
            string = new X500NameBuilder();
            string.addRDN(BCStyle.CN, "localhost");
            string.addRDN(BCStyle.O, (String)dERSequence);
            string.addRDN(BCStyle.OU, "webserver");
            string.addRDN(BCStyle.C, "IT");
            dERSequence = string.build();
            publicKey = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            x509Certificate = new X509v3CertificateBuilder((X500Name)x509Certificate, new BigInteger(48, Util.secureRandom), date, date2, (X500Name)dERSequence, (SubjectPublicKeyInfo)publicKey);
            dERSequence = new KeyUsage(160);
            x509Certificate.addExtension(Extension.keyUsage, true, (ASN1Encodable)dERSequence);
            dERSequence = new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_serverAuth});
            x509Certificate.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)dERSequence);
            dERSequence = new ArrayList();
            dERSequence.add(new GeneralName(2, "localhost"));
            dERSequence.add(new GeneralName(7, "127.0.0.1"));
            dERSequence = new DERSequence((ASN1Encodable[])dERSequence.toArray(new GeneralName[0]));
            x509Certificate.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)dERSequence);
            x509Certificate.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            privateKey = x509Certificate.build((ContentSigner)privateKey);
            return LocalSSLRootBuilder.a((X509CertificateHolder)privateKey);
        }
        catch (Exception exception) {
            throw new CapiException(exception.getMessage(), 1003, exception);
        }
    }

    public static X509Certificate generateCertificateForUser(PrivateKey privateKey, X509Certificate x509Certificate, byte[] object, Date date, Date date2, String string) throws CapiException {
        try {
            object = new PKCS10CertificationRequest(object);
            return LocalSSLRootBuilder.generateCertificateForUser(privateKey, x509Certificate, (PKCS10CertificationRequest)object, date, date2, string);
        }
        catch (IOException iOException) {
            throw new CapiException(iOException.getMessage(), 1003, iOException);
        }
    }

    public static X509Certificate generateCertificateForUser(PrivateKey privateKey, X509Certificate x509Certificate, PKCS10CertificationRequest object, Date date, Date date2, String string) throws CapiException {
        try {
            privateKey = new JcaContentSignerBuilder("SHA512withRSA").build(privateKey);
            x509Certificate = new JcaX509CertificateHolder(x509Certificate).getSubject();
            X500NameBuilder x500NameBuilder = new X500NameBuilder();
            x500NameBuilder.addRDN(BCStyle.CN, "localhost");
            x500NameBuilder.addRDN(BCStyle.O, string);
            x500NameBuilder.addRDN(BCStyle.OU, "webserver");
            x500NameBuilder.addRDN(BCStyle.C, "IT");
            string = x500NameBuilder.build();
            object = object.getSubjectPublicKeyInfo();
            x509Certificate = new X509v3CertificateBuilder((X500Name)x509Certificate, new BigInteger(48, Util.secureRandom), date, date2, (X500Name)string, (SubjectPublicKeyInfo)object);
            object = new KeyUsage(160);
            x509Certificate.addExtension(Extension.keyUsage, true, (ASN1Encodable)object);
            object = new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_serverAuth});
            x509Certificate.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)object);
            object = new ArrayList<GeneralName>();
            ((ArrayList)object).add(new GeneralName(2, "localhost"));
            ((ArrayList)object).add(new GeneralName(7, "127.0.0.1"));
            object = new DERSequence((ASN1Encodable[])((ArrayList)object).toArray(new GeneralName[0]));
            x509Certificate.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)object);
            x509Certificate.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            privateKey = x509Certificate.build((ContentSigner)privateKey);
            return (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(privateKey.getEncoded()));
        }
        catch (Exception exception) {
            throw new CapiException(exception.getMessage(), 1003, exception);
        }
    }

    private static X509Certificate a(X509CertificateHolder x509CertificateHolder) throws CertificateException, IOException {
        return (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(x509CertificateHolder.getEncoded()));
    }
}

