/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.crl;

import esecurity.validator.DateSource;
import esecurity.validator.ValidationDate;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.CrlBean;
import esecurity.validator.x509status.RevocationBean;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.I;
import it.actalis.vol.utils.Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.slf4j.Logger;

public class CRLUtils {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final int CRL_BEHAVE_HTTPFIRST = 0;
    public static final int CRL_BEHAVE_LDAPFIRST = 1;
    public static final int CRL_BEHAVE_HTTPONLY = 2;
    public static final int CRL_BEHAVE_LDAPONLY = 3;

    public static CRL getCrlForCertificate(UrlClient urlClient, ValidatorConfig validatorConfig, Certificate certificate, Date date, CertDB certDB) {
        a.debug(I.d() + "Chiamata la getCrlForCertificate ");
        String string = validatorConfig.getElement("crl.behavior", "HTTPFIRST");
        int n = string.equals("HTTPONLY") ? 2 : (string.equals("LDAPFIRST") ? 1 : (string.equals("LDAPONLY") ? 3 : 0));
        ArrayList<CertDBItem> arrayList = new ArrayList<CertDBItem>();
        try {
            certDB.onLineVerify(urlClient.getConf(), certificate.getInternalCert().getEncoded(), arrayList);
        }
        catch (CapiException capiException) {
            a.debug(I.d() + "Non trovata: " + capiException.getMessage());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            a.debug(I.d() + "Non trovata: " + certificateEncodingException.getMessage());
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        ArrayList<CertDBItem> arrayList2 = arrayList;
        return CRLUtils.a(urlClient, validatorConfig, certificate.getIssuerDN(), CRLUtils.a(certificate), arrayList2.toArray(new CertDBItem[arrayList2.size()]), date, n);
    }

    private static String[] a(Certificate stringArray) {
        a.debug(I.d() + "Chiamata la downloadCRL(Certificate)");
        try {
            stringArray = stringArray.getCdpURLs();
            if (stringArray.length == 0) {
                a.debug(I.d() + "Errore cdp non presente nel certificato.");
            }
        }
        catch (CapiException capiException) {
            a.error(I.d() + "Errore " + capiException.getMessage());
            return null;
        }
        return stringArray;
    }

    private static CRL a(UrlClient object, ValidatorConfig validatorConfig, String string, String[] stringArray, CertDBItem[] object2, Date date, int n) {
        if (object2 == null || ((CertDBItem[])object2).length == 0) {
            a.error(I.d() + "Root non trovata verifica impossibile.");
            return null;
        }
        a.debug(I.d() + "Chiamata la getCrlForCertificate ");
        if (stringArray == null) {
            return null;
        }
        if ((object = CRLUtils.a((UrlClient)object, validatorConfig, stringArray, n)) != null) {
            try {
                ((CRL)object).verify(object2[0].getCertificate().getInternalCert().getEncoded());
            }
            catch (CapiException capiException) {
                for (int i = 0; i < stringArray.length; ++i) {
                    a.info("crl non valida: " + stringArray[i]);
                }
                a.error(capiException.getMessage(), (Throwable)capiException);
                object = null;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                for (int i = 0; i < stringArray.length; ++i) {
                    a.info("crl non valida: " + stringArray[i]);
                }
                a.error(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
                object = null;
            }
        }
        boolean bl = false;
        try {
            bl = CRLUtils.b((CRL)object, date);
        }
        catch (CapiException capiException) {
            a.warn(capiException.getMessage());
        }
        if (object == null || !bl) {
            a.debug(I.d() + "Crl non valida");
            object = null;
        }
        try {
            if (object != null) {
                String string2;
                object2 = Utils.retrieveCommonName(((CRL)object).getIssuerDN());
                if (!((String)object2).equalsIgnoreCase(string2 = Utils.retrieveCommonName(string))) {
                    a.warn(I.d() + "CRL non valida per il certificato");
                    a.warn(I.d() + "Crl issuer " + ((CRL)object).getIssuerDN());
                    a.warn(I.d() + "Certificate issuer " + string);
                }
                if ((string2 = CRLUtils.a((CRL)object)) != null) {
                    int n2;
                    boolean bl2 = false;
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        if (!string2.equalsIgnoreCase(stringArray[n2])) continue;
                        bl2 = true;
                    }
                    if (!bl2) {
                        a.warn(I.d() + "CRL non valida per il certificato");
                        a.warn(I.d() + "idp " + string2);
                        for (n2 = 0; n2 < stringArray.length; ++n2) {
                            a.warn(I.d() + "cdp " + stringArray[n2]);
                        }
                    }
                }
            }
        }
        catch (CapiException capiException) {
            a.error("Errore " + capiException.getMessage());
        }
        a.debug(I.d() + "Fine getCrlForCertificate");
        return object;
    }

    private static String a(CRL cRL) {
        String string = null;
        try {
            for (String string2 : cRL.getInternalCRL().getCriticalExtensionOIDs()) {
                byte[] byArray;
                IssuingDistributionPoint issuingDistributionPoint;
                DistributionPointName distributionPointName;
                if (!string2.equalsIgnoreCase("2.5.29.28") || (distributionPointName = (issuingDistributionPoint = IssuingDistributionPoint.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])(byArray = cRL.getInternalCRL().getExtensionValue(string2))))).getDistributionPoint()).getType() != 0) continue;
                GeneralNames generalNames = (GeneralNames)distributionPointName.getName();
                GeneralName[] generalNameArray = generalNames.getNames();
                for (int i = 0; i < generalNameArray.length; ++i) {
                    GeneralName generalName = generalNameArray[i];
                    string = generalName.getName().toString();
                }
            }
        }
        catch (Exception exception) {
            a.error("get distribution point: " + exception.getMessage());
        }
        return string;
    }

    private static boolean b(CRL object, Date date) throws CapiException {
        if (date == null) {
            date = new Date();
        }
        if (object == null) {
            return false;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            simpleDateFormat.setTimeZone(Constants.DEFAULT_TIMEZONE);
            Date date2 = new Date();
            Date date3 = simpleDateFormat.parse(((CRL)object).getThisUpdate("dd/MM/yyyy HH:mm:ss zzz"));
            object = simpleDateFormat.parse(((CRL)object).getNextUpdate("dd/MM/yyyy HH:mm:ss zzz"));
            if (date2.before(date3)) {
                throw new CapiException("crl is not valid because thisUpdate is after current time", 31006);
            }
            if (date.after((Date)object)) {
                throw new CapiException("crl is not valid because nextUpdate is prior to validation time", 31006);
            }
            return true;
        }
        catch (ParseException parseException) {
            throw new CapiException("Error parsing crl date", 31006);
        }
    }

    static RevocationBean a(CRL cRL, BigInteger object, ValidationDate object2) {
        RevocationBean revocationBean = new RevocationBean();
        try {
            Object object3 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            ((DateFormat)object3).setTimeZone(Constants.DEFAULT_TIMEZONE);
            if (object2 == null) {
                object2 = new ValidationDate(new Date(), DateSource.SYSTEM);
            }
            object3 = CRLUtils.a(cRL, ((ValidationDate)object2).getDate());
            revocationBean.setCrlBean((CrlBean)object3);
            revocationBean.setCrlStatus(((CrlBean)object3).getCrlStatusExplained());
            if (((CrlBean)object3).isCrlValid()) {
                if (cRL.isRevoked((BigInteger)object)) {
                    object3 = cRL.getRevocationDate((BigInteger)object);
                    object3 = Util.parseDate((String)object3, "yyyyMMddHHmmss");
                    if (((Date)(object2 = ((ValidationDate)object2).getDate())).compareTo((Date)object3) >= 0) {
                        int n = cRL.getReasonCode((BigInteger)object);
                        object = CRLUtils.a(n);
                        revocationBean.setCertRevoked(true);
                        revocationBean.setRevocationDate((Date)object3);
                        revocationBean.setRevocationReason(Integer.toString(n));
                        if (!revocationBean.getInvalidityReason().equalsIgnoreCase("")) {
                            object = revocationBean.getInvalidityReason() + " - " + (String)object;
                        }
                        revocationBean.setInvalidityReason((String)object);
                    }
                } else {
                    revocationBean.setCertRevoked(false);
                }
            } else {
                revocationBean.setCertRevoked(false);
                if (!revocationBean.getInvalidityReason().equalsIgnoreCase("")) {
                    revocationBean.setInvalidityReason(revocationBean.getInvalidityReason() + " crl not found or expired");
                } else {
                    revocationBean.setInvalidityReason("Crl not found or expired");
                }
                revocationBean.setCrlStatus("NOT FOUND OR EXPIRED");
            }
        }
        catch (CapiException capiException) {
            revocationBean.setCertRevoked(false);
            revocationBean.setInvalidityReason(revocationBean.getInvalidityReason() + capiException.getMessage());
            revocationBean.setCrlStatus("NO_CHECK");
        }
        return revocationBean;
    }

    static String a(int n) {
        String string;
        switch (n) {
            case 3: {
                string = "AffiliationChanged";
                break;
            }
            case 2: {
                string = "CACompromise";
                break;
            }
            case 6: {
                string = "CertificateHold";
                break;
            }
            case 5: {
                string = "CessationOfOperation";
                break;
            }
            case 1: {
                string = "KeyCompromise";
                break;
            }
            case 8: {
                string = "RemoveFromCRL";
                break;
            }
            case 4: {
                string = "Superseded";
                break;
            }
            case 0: {
                string = "Unspecified";
                break;
            }
            case 9: {
                string = "PrivilegeWithdrawn";
                break;
            }
            case 10: {
                string = "AACompromise";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    static CrlBean a(CRL cRL, Date date) throws CapiException {
        CrlBean crlBean = new CrlBean();
        Cloneable cloneable = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        cloneable.setTimeZone(Constants.DEFAULT_TIMEZONE);
        try {
            Object object;
            X509CRL x509CRL;
            crlBean.setIssuerDN(cRL.getIssuerDN());
            crlBean.setThisUpdate(cRL.getThisUpdate("dd/MM/yyyy HH:mm:ss zzz"));
            crlBean.setNextUpdate(cRL.getNextUpdate("dd/MM/yyyy HH:mm:ss zzz"));
            crlBean.setDownloadedUrl(cRL.getDownloadedUrl());
            if (cRL.getExpiredCertsOnCRL() != null) {
                crlBean.setExpiredCertsOnCRL(cloneable.format(cRL.getExpiredCertsOnCRL()));
            }
            if ((x509CRL = cRL.getInternalCRL()) != null) {
                byte[] byArray = x509CRL.getExtensionValue("2.5.29.20");
                object = byArray;
                if (byArray != null) {
                    object = (ASN1Integer)CRLUtils.a(((ASN1OctetString)CRLUtils.a((byte[])object)).getOctets());
                    crlBean.setSerial(object.getValue().toString(16));
                }
                crlBean.setVersion(String.valueOf(x509CRL.getVersion()));
                crlBean.setSigAlgName(x509CRL.getSigAlgName());
            }
            if ((object = CRLUtils.a(cRL)) != null) {
                crlBean.setIssuingDistributionPointName((String)object);
            }
            object = new Date();
            boolean bl = true;
            try {
                Date date2 = cloneable.parse(cRL.getThisUpdate("dd/MM/yyyy HH:mm:ss zzz"));
                cloneable = cloneable.parse(cRL.getNextUpdate("dd/MM/yyyy HH:mm:ss zzz"));
                cRL.getInternalCRL().getNextUpdate();
                crlBean.setCrlStatusExplained("VALID");
                if (((Date)object).before(date2)) {
                    crlBean.setCrlStatusExplained("NOT YET");
                    bl = false;
                }
                if (date.after((Date)cloneable)) {
                    crlBean.setCrlStatusExplained("EXPIRED");
                    bl = false;
                }
            }
            catch (Exception exception) {
                crlBean.setCrlStatusExplained("UNKNOWN");
            }
            crlBean.setCrlValid(bl);
        }
        catch (CapiException capiException) {
            CapiException capiException2 = capiException;
            throw capiException;
        }
        catch (IOException iOException) {
            throw new CapiException("Internal Errore", 1003, iOException);
        }
        return crlBean;
    }

    private static ASN1Primitive a(byte[] object) throws IOException {
        object = new ByteArrayInputStream((byte[])object);
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)object);
        object = aSN1InputStream;
        return aSN1InputStream.readObject();
    }

    private static CRL a(UrlClient urlClient, ValidatorConfig validatorConfig, String[] stringArray, int n) {
        a.debug(I.d() + "Chiamata la downloadCRL(urls[])");
        String[] stringArray2 = new String[stringArray.length];
        Object object = validatorConfig.getElement("sogei.proxy", "");
        ((String)object).isEmpty();
        if (stringArray != null) {
            stringArray = CRLUtils.a(validatorConfig, stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("http://")) {
                    stringArray[i].startsWith("https://");
                }
                stringArray[i].startsWith("ldap://");
            }
        }
        if (n == 0) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (!stringArray[n2].toLowerCase().startsWith("http")) continue;
                stringArray2[n3] = stringArray[n2];
                ++n3;
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (!stringArray[n2].toLowerCase().startsWith("ldap")) continue;
                stringArray2[n3] = stringArray[n2];
                ++n3;
            }
        }
        if (n == 1) {
            int n4;
            int n5 = 0;
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                if (!stringArray[n4].toLowerCase().startsWith("ldap")) continue;
                stringArray2[n5] = stringArray[n4];
                ++n5;
            }
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                if (!stringArray[n4].toLowerCase().startsWith("http")) continue;
                stringArray2[n5] = stringArray[n4];
                ++n5;
            }
        }
        boolean bl = false;
        object = null;
        for (int i = 0; i < stringArray2.length && !bl; ++i) {
            if (n == 2 && !stringArray2[i].toLowerCase().startsWith("http") || n == 3 && !stringArray2[i].toLowerCase().startsWith("ldap")) continue;
            InputStream inputStream = null;
            try {
                a.debug(I.d() + "Url " + stringArray2[i]);
                if (stringArray2[i].startsWith("ldap")) {
                    UrlReturn urlReturn = urlClient.downloadUrl(stringArray2[i], null, null);
                    if (urlReturn == null || urlReturn.getStatus() == null || !urlReturn.getStatus().equals("OK")) {
                        Util.closeQuietly(null);
                        continue;
                    }
                    inputStream = new ByteArrayInputStream(urlReturn.getData());
                } else {
                    inputStream = urlClient.getInputStream(new URL(stringArray2[i]), null);
                }
                a.debug(I.d() + "Fine download");
                object = new CRL(new BufferedInputStream(inputStream));
                ((CRL)object).setDownloadedUrl(stringArray2[i]);
                bl = true;
                Util.closeQuietly(inputStream);
            }
            catch (Exception exception) {
                a.error(I.d() + "Errore: " + exception.getMessage());
            }
            finally {
                Util.closeQuietly(inputStream);
            }
            continue;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        try {
            a.debug(I.d() + "CRL recuperata " + ((CRL)object).getIssuerDN());
            a.debug(I.d() + "This update    " + simpleDateFormat.format(((CRL)object).getInternalCRL().getThisUpdate()));
            a.debug(I.d() + "Next update    " + simpleDateFormat.format(((CRL)object).getInternalCRL().getNextUpdate()));
        }
        catch (Exception exception) {
            a.error(I.d() + "Errore recupero info CRL: " + exception.getMessage());
        }
        a.debug(I.d() + "Fine downloadCRL");
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] a(ValidatorConfig validatorConfig, String[] stringArray) {
        if (validatorConfig.getElement("sogei.proxy") == null) return stringArray;
        if (validatorConfig.getElement("sogei.proxy").equals("")) return stringArray;
        Socket socket = null;
        int n = 0;
        while (n < stringArray.length) {
            try {
                Object object = stringArray[n];
                String string = validatorConfig.getElement("sogei.proxy");
                int n2 = 80;
                if (validatorConfig.getElement("sogei.proxy.port") != null && !validatorConfig.getElement("sogei.proxy.port").equals("")) {
                    try {
                        n2 = Integer.parseInt(validatorConfig.getElement("sogei.proxy.port"));
                    }
                    catch (Exception exception) {
                        n2 = 80;
                    }
                }
                socket = new Socket(string, n2);
                System.out.println(socket.getLocalAddress().getHostAddress());
                object = URLDecoder.decode((String)object, "UTF-8");
                object = URLEncoder.encode((String)object, "UTF-8");
                String string2 = URLEncoder.encode(socket.getLocalAddress().getHostAddress(), "UTF-8");
                object = new URI("http://" + string + ":" + n2 + "/crlproxy/crlproxy?hostname=" + string2 + "&uri=" + (String)object);
                object = ((URI)object).toString();
                a.debug("Url Proxy Sogei:" + (String)object);
                stringArray[n] = object;
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    a.error(iOException.getMessage());
                }
            }
            catch (Exception exception) {
                a.error(exception.getMessage());
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        a.error(iOException.getMessage());
                    }
                }
            }
            ++n;
        }
        return stringArray;
    }

    public static String generateCrlId(String[] objectArray) {
        Object object = "";
        String string = "";
        for (int i = 0; i < objectArray.length; ++i) {
            object = (String)object + objectArray[i];
        }
        SHA256Digest sHA256Digest = new SHA256Digest();
        objectArray = new byte[sHA256Digest.getDigestSize()];
        object = ((String)object).getBytes();
        sHA256Digest.update((byte[])object, 0, ((Object)object).length);
        sHA256Digest.doFinal((byte[])objectArray, 0);
        for (int i = 0; i < objectArray.length; ++i) {
            string = Hex.toHexString((byte[])objectArray);
        }
        return string.toUpperCase();
    }

    public static String generateCrlId(Certificate certificate) {
        return CRLUtils.generateCrlId(CRLUtils.a(certificate));
    }
}

