/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status;

import esecurity.validator.DateSource;
import esecurity.validator.ValidationDate;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.constants.RevocationVerifyMode;
import esecurity.validator.x509status.CertificateStatus;
import esecurity.validator.x509status.X509StatusValidator;
import esecurity.validator.x509status.crl.CRLCacheManager;
import esecurity.validator.x509status.crl.CRLX509StatusValidator;
import esecurity.validator.x509status.crl.DefaultCrlCacheManager;
import esecurity.validator.x509status.ocsp.DefaultOCSPCacheManager;
import esecurity.validator.x509status.ocsp.OCSPCacheManager;
import esecurity.validator.x509status.ocsp.OCSPX509StatusValidator;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import org.slf4j.Logger;

public class X509StatusService {
    private static Logger a = null;
    private X509StatusValidator[] b = null;

    private X509StatusService(X509StatusValidator[] x509StatusValidatorArray, Logger logger) {
        if (logger != null) {
            a = logger;
        }
        this.b = x509StatusValidatorArray;
    }

    public static X509StatusService getInstance(ValidatorConfig validatorConfig, CRLCacheManager object, OCSPCacheManager x509StatusValidatorArray, Logger logger) throws CapiException {
        Object object2 = logger;
        a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        if (object2 != null) {
            a = object2;
        }
        if (validatorConfig == null) {
            validatorConfig = new ValidatorConfig();
        }
        object2 = object != null ? object : new DefaultCrlCacheManager(validatorConfig, a);
        object = object != null ? x509StatusValidatorArray : new DefaultOCSPCacheManager(validatorConfig, a);
        x509StatusValidatorArray = validatorConfig.getElement("verify.mode", RevocationVerifyMode.OCSPFIRST.name());
        if (RevocationVerifyMode.OCSPFIRST.name().equals(x509StatusValidatorArray)) {
            X509StatusValidator[] x509StatusValidatorArray2 = new X509StatusValidator[2];
            x509StatusValidatorArray = x509StatusValidatorArray2;
            x509StatusValidatorArray2[0] = new OCSPX509StatusValidator(validatorConfig, (OCSPCacheManager)object, a);
            x509StatusValidatorArray[1] = new CRLX509StatusValidator(validatorConfig, (CRLCacheManager)object2, a);
        } else if (RevocationVerifyMode.CRLFIRST.name().equals(x509StatusValidatorArray)) {
            X509StatusValidator[] x509StatusValidatorArray3 = new X509StatusValidator[2];
            x509StatusValidatorArray = x509StatusValidatorArray3;
            x509StatusValidatorArray3[1] = new OCSPX509StatusValidator(validatorConfig, (OCSPCacheManager)object, a);
            x509StatusValidatorArray[0] = new CRLX509StatusValidator(validatorConfig, (CRLCacheManager)object2, a);
        } else if (RevocationVerifyMode.OCSPONLY.name().equals(x509StatusValidatorArray)) {
            X509StatusValidator[] x509StatusValidatorArray4 = new X509StatusValidator[1];
            x509StatusValidatorArray = x509StatusValidatorArray4;
            x509StatusValidatorArray4[0] = new OCSPX509StatusValidator(validatorConfig, (OCSPCacheManager)object, a);
        } else if (RevocationVerifyMode.CRLONLY.name().equals(x509StatusValidatorArray)) {
            X509StatusValidator[] x509StatusValidatorArray5 = new X509StatusValidator[1];
            x509StatusValidatorArray = x509StatusValidatorArray5;
            x509StatusValidatorArray5[0] = new CRLX509StatusValidator(validatorConfig, (CRLCacheManager)object2, a);
        } else {
            throw new CapiException("Invalid verify.mode", 1003);
        }
        return new X509StatusService(x509StatusValidatorArray, logger);
    }

    public static X509StatusService getInstance(ValidatorConfig validatorConfig, Logger logger) throws CapiException {
        return X509StatusService.getInstance(validatorConfig, null, null, logger);
    }

    public static X509StatusService getInstance(ValidatorConfig validatorConfig) throws CapiException {
        return X509StatusService.getInstance(validatorConfig, null);
    }

    public static X509StatusService getInstance() throws CapiException {
        return X509StatusService.getInstance(null);
    }

    public void setX509StatusHelper(X509StatusValidator[] x509StatusValidatorArray) {
        this.b = x509StatusValidatorArray;
    }

    public CertificateStatus checkStatus(Certificate certificate, ValidationDate validationDate) throws CapiException {
        Object object = new CertificateStatus();
        if (this.b == null) {
            ((CertificateStatus)object).setCertValid(false);
            ((CertificateStatus)object).setInvalidityReason("MISSING CONFIGURATION");
            ((CertificateStatus)object).setCrlStatus("NO_CHECK");
            return object;
        }
        if (validationDate == null) {
            validationDate = new ValidationDate(new Date(), DateSource.SYSTEM);
        }
        X509StatusValidator[] x509StatusValidatorArray = this.b;
        int n = this.b.length;
        for (int i = 0; i < n; ++i) {
            object = x509StatusValidatorArray[i];
            if ((object = object.checkStatus(certificate, validationDate)) != null && !((CertificateStatus)object).getCrlStatus().equals("OFFLINE") && !((CertificateStatus)object).getCrlStatus().equals("NOT FOUND")) break;
        }
        return object;
    }
}

