/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.ValidationDate;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.x509status.CertificateStatus;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.tsl.TSLStatus;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;

public class StepX509Status
extends MultipleValidationSubStepImpl {
    private final DateFormat a = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");

    public StepX509Status() {
        super(ValidationType.CERTIFICATE);
    }

    protected LinkedList<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        linkedList = new LinkedList();
        if (validationContextParameters == null || validationContextParameters.getConfig() == null) {
            linkedList.add(new ValidatorMessage(null, MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
            return linkedList;
        }
        if (validationContextParameters.getSignerCertificate() == null) {
            linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
            return linkedList;
        }
        try {
            if (validationContextParameters.getLevelValidation() == null || validationContextParameters.getLevelValidation().getLevel() != SignatureLevel.LT && validationContextParameters.getLevelValidation().getLevel() != SignatureLevel.LTA) {
                Object object = validationContextParameters.getSignerCertificate();
                Object object2 = validationContextParameters.getCalculatedValidationDate();
                object2 = validationContextParameters.getValidator().getStatusService().checkStatus(((ValidatedCertificate)object).getCert(), (ValidationDate)object2);
                ((CertificateStatus)object2).applyToValidate((ValidatedCertificate)object);
                if (!"NOT FOUND".equals(((ValidatedCertificate)object).getCrlStatus())) {
                    if (((ValidatedCertificate)object).getCrlBean() == null) {
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0017_OCSP_USED_FOR_CERT_VALIDATION, new Object[0]));
                    } else {
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0018_CRL_USED_FOR_CERT_VALIDATION, new Object[0]));
                    }
                }
                this.a.setTimeZone(validationContextParameters.getTimeZone());
                if (((ValidatedCertificate)object).isCertRevoked()) {
                    object2 = this.a.format(((ValidatedCertificate)object).getRevocationDate());
                    if (((ValidatedCertificate)object).getRevocationReason().equalsIgnoreCase("6")) {
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0006_CERT_SUSPENDED, object2));
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0014_CERT_VALIDATION_TO_DATE, new Object[0]));
                    } else {
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0007_CERT_REVOKED, object2));
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0014_CERT_VALIDATION_TO_DATE, new Object[0]));
                    }
                }
                if (!(((ValidatedCertificate)object).getCertIssuer() == null || ((ValidatedCertificate)object).isCertValid() || ((ValidatedCertificate)object).isCertRevoked() || ((ValidatedCertificate)object).getCrlStatus().equalsIgnoreCase("VALID") || ((ValidatedCertificate)object).getCrlStatus().equalsIgnoreCase("VERIFIED SIGNATURE") || (object = ((CertDB)(object2 = validationContextParameters.getCertDB())).contains(((ValidatedCertificate)object).getCert().getEncoded().getBytes())) != null && ((CertDBItem)object).getSource() == 1 && !TSLStatus.isStatusIn(TSLStatus.StatusGroup.UNTRUSTED, ((CertDBItem)object).getStatus()) && !TSLStatus.isStatusIn(TSLStatus.StatusGroup.REMOVED, ((CertDBItem)object).getStatus()))) {
                    if (validationContextParameters.getSignature() != null && validationContextParameters.getSignature().getFormat() != null && validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0004_TSACERT_STATUS_UNKNOWN, new Object[0]));
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0005_TSACERT_STATUS_TEMP_UNAVAIABLE, new Object[0]));
                    } else {
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0001_STATUS_UNKNOWN, new Object[0]));
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0002_STATUS_TEMP_UNAVAIABLE, new Object[0]));
                    }
                }
            }
            if (validationContextParameters.getSignerCertificate().getCert().isRsVerified()) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0015_CERT_VERIFIED, new Object[0]));
            }
        }
        catch (Exception exception) {
            linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
        }
        return linkedList;
    }
}

