/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cipherservice;

import esecurity.internal.asb.gw.GwClient;
import esecurity.internal.asb.gw.GwClientI;
import it.actalis.ellips.capi.http.ArubaTrustStore;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.arubapec.signservice.CredentialListQuery;
import it.arubapec.signservice.CredentialListReturn;
import org.slf4j.Logger;

public class CSUtils {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static CredentialListReturn credentials_query(CredentialListQuery request, String strUrl1, String strUrl2, URLCredentials creds, boolean enforceMode) {
        CredentialListReturn objReturn = new CredentialListReturn();
        UrlClient objClient = new UrlClient(HTTP.defaultConfig, logger);
        GwClientI client = GwClient.getInstance(objClient, logger, creds, ArubaTrustStore.getTSRS((String)request.getDomain()), false, enforceMode, null);
        CredentialListReturn response = null;
        boolean retry = false;
        try {
            response = client.credentials_query(strUrl1, request);
            if (response == null) {
                retry = true;
            }
        }
        catch (Exception ex) {
            objReturn.setStatus("KO");
            objReturn.setDescription("Errore server");
            logger.error("Errore Primario");
            logger.error(ex.getMessage(), (Throwable)ex);
            retry = true;
        }
        if (retry) {
            try {
                response = client.credentials_query(strUrl2, request);
            }
            catch (Exception ex1) {
                objReturn.setStatus("KO");
                objReturn.setDescription("Errore server");
                logger.error("Errore Secondario");
                logger.error(ex1.getMessage(), (Throwable)ex1);
            }
        }
        if (response != null) {
            objReturn = response;
        }
        return objReturn;
    }
}

