/*
 * Decompiled with CFR 0.152.
 */
package esecurity.internal.asb.gw;

import esecurity.arubacipherservice.DecryptReq;
import esecurity.arubacipherservice.DecryptRet;
import esecurity.internal.asb.gw.GwClientI;
import esecurity.internal.asb.gw.bean.InfoErrorReturn;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.arubapec.signservice.ArssAudit;
import it.arubapec.signservice.Auth;
import it.arubapec.signservice.AutomaticSignatureControl;
import it.arubapec.signservice.AutomaticSignatureControlReturn;
import it.arubapec.signservice.CertListResponse;
import it.arubapec.signservice.Certificato;
import it.arubapec.signservice.CertsListRequest;
import it.arubapec.signservice.CertsListRequestAuth;
import it.arubapec.signservice.ChangePassword;
import it.arubapec.signservice.CloseSessionRequest;
import it.arubapec.signservice.CreateSessionReturn;
import it.arubapec.signservice.CredentialListQuery;
import it.arubapec.signservice.CredentialListReturn;
import it.arubapec.signservice.GWReturn;
import it.arubapec.signservice.RetriveCredential;
import it.arubapec.signservice.RetriveCredentialReturn;
import it.arubapec.signservice.SendCredential;
import it.arubapec.signservice.SessionSignRequest;
import it.arubapec.signservice.SignRequest;
import it.arubapec.signservice.SignResponse;
import it.arubapec.signservice.StrongCredential;
import it.arubapec.signservice.TempPwdRequest;
import it.arubapec.signservice.TempPwdRequestEx;
import it.arubapec.signservice.TempPwdResponse;
import it.arubapec.signservice.TempPwdResponseEx;
import it.arubapec.signservice.TestCredential;
import it.arubapec.signservice.UserAuthenticationInfoRequest;
import it.arubapec.signservice.UserAuthenticationInfoResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GwClientInfo
extends GwClientI {
    private static Logger logger = null;
    UrlClient client;
    private static String infomiddleware_url = System.getProperty("esecurity.asb.infomiddleware.url");
    private static DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
    boolean debug = false;
    URLCredentials cred;
    boolean enforcemode;

    public GwClientInfo(UrlClient client) throws CertDBException {
        this(client, null, null, null, false, true);
    }

    public GwClientInfo(UrlClient client, Logger logger, URLCredentials cred, KeyStore store, boolean ignorecert, boolean enforcemode) {
        this.client = client;
        if (ignorecert) {
            this.client.setSSLTrustAllRoot(ignorecert);
            this.client.setSSLHallHostVerified(ignorecert);
        }
        GwClientInfo.logger = logger != null ? logger : EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        this.cred = cred;
        this.enforcemode = enforcemode;
        if (System.getProperties().getProperty("esecurity.asb.gw.debug") != null) {
            this.debug = System.getProperties().getProperty("esecurity.asb.gw.debug").equals("true");
        }
    }

    @Override
    public void setEnforceMode(boolean enforce) {
        this.enforcemode = enforce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignResponse signop(String baseurl, SignRequest request) throws IOException {
        SignResponse response = new SignResponse();
        response.setStatus("KO");
        response.setDescription("Errore generico");
        response.setReturn_code("0001");
        String identificativo = "[" + request.getIdentity().getDomain() + "]_" + request.getIdentity().getUser();
        String numeroOtp = request.getIdentity().getOtpPwd();
        String pinFirma = request.getIdentity().getUserPWD();
        ArrayList<byte[]> hashs = new ArrayList<byte[]>();
        if (request.getDataToSign() == null) {
            response.setStatus("KO");
            response.setDescription("Errore generico");
            response.setReturn_code("0001");
            return response;
        }
        byte[] hash = request.getDataToSign();
        hashs.add(hash);
        String strXml = "";
        InputStream xmlres = null;
        try {
            strXml = this.signopXml(identificativo, numeroOtp, pinFirma, hashs);
            RequestData rdata = new RequestData();
            rdata.setSoapAction("");
            rdata.setType("SOAP");
            rdata.setPostdata(strXml.getBytes("UTF-8"));
            UrlReturn ret = this.client.downloadUrl(infomiddleware_url, rdata, this.cred);
            if (ret.getStatus().equals("OK") || ret.getStatus().equals("KO") && ret.getErrordata() != null) {
                String strXmlRes = "";
                strXmlRes = ret.getData() != null ? new String(ret.getData(), "UTF-8") : new String(ret.getErrordata(), "UTF-8");
                xmlres = new ByteArrayInputStream(strXmlRes.getBytes(Charset.forName("UTF-8")));
                DocumentBuilder db = df.newDocumentBuilder();
                Document doc = db.parse(xmlres);
                if (doc.getElementsByTagName("env:Fault").getLength() > 0) {
                    InfoErrorReturn inforeturn = this.getErrorReturn(doc);
                    response.setStatus(inforeturn.getStatus());
                    response.setReturn_code(inforeturn.getReturn_code());
                    response.setDescription(inforeturn.getDescription());
                } else if (doc.getElementsByTagName("resultSignedHash").getLength() > 0) {
                    response.setStatus("OK");
                    response.setDescription("OK");
                    response.setReturn_code("0000");
                    response.setSignData(Base64.decode((String)doc.getElementsByTagName("resultSignedHash").item(0).getTextContent()));
                } else {
                    response.setStatus("KO");
                    response.setDescription("Generic error");
                    response.setReturn_code("0001");
                }
            } else {
                logger.error("Chiamato metodo sighHash esito negativo status: " + ret.getStatus() + " status code: " + ret.getStatus_code() + " status message: " + ret.getStatusMessage());
                response.setStatus("KO");
                response.setDescription("Errore generico");
                response.setReturn_code("0001");
            }
        }
        catch (Exception ex) {
            response.setStatus("KO");
            response.setDescription("Errore generico");
            response.setReturn_code("0001");
            logger.error("Eccezione: " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            if (xmlres != null) {
                try {
                    xmlres.close();
                }
                catch (Exception exception) {}
            }
        }
        return response;
    }

    @Override
    public SignResponse signop2(String baseurl, SessionSignRequest request) throws IOException {
        request.getRequest().getIdentity().setOtpPwd(request.getSession());
        return this.signop(baseurl, request.getRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CertListResponse certlistop(String baseurl, CertsListRequest request) throws IOException {
        CertListResponse response = new CertListResponse();
        response.setStatus("KO");
        response.setDescription("Errore generico");
        response.setReturn_code("0001");
        String identificativo = "[" + request.getIdentity().getDomain() + "]_" + request.getIdentity().getUser();
        String strXml = "";
        InputStream xmlres = null;
        try {
            strXml = this.certlistopXml(identificativo);
            RequestData rdata = new RequestData();
            rdata.setSoapAction("");
            rdata.setType("SOAP");
            rdata.setPostdata(strXml.getBytes("UTF-8"));
            UrlReturn ret = this.client.downloadUrl(infomiddleware_url, rdata, this.cred);
            if (ret.getStatus().equals("OK") || ret.getStatus().equals("KO") && ret.getErrordata() != null) {
                String strXmlRes = "";
                strXmlRes = ret.getData() != null ? new String(ret.getData(), "UTF-8") : new String(ret.getErrordata(), "UTF-8");
                xmlres = new ByteArrayInputStream(strXmlRes.getBytes(Charset.forName("UTF-8")));
                DocumentBuilder db = df.newDocumentBuilder();
                Document doc = db.parse(xmlres);
                if (doc.getElementsByTagName("env:Fault").getLength() > 0) {
                    InfoErrorReturn inforeturn = this.getErrorReturn(doc);
                    response.setStatus(inforeturn.getStatus());
                    response.setReturn_code(inforeturn.getReturn_code());
                    response.setDescription(inforeturn.getDescription());
                } else if (doc.getElementsByTagName("resultCertificate").getLength() > 0) {
                    response.setStatus("OK");
                    response.setDescription("OK");
                    response.setReturn_code("0000");
                    Certificate cer = new Certificate(doc.getElementsByTagName("resultCertificate").item(0).getTextContent().getBytes());
                    Certificato[] certs = new Certificato[]{new Certificato()};
                    certs[0].setContent(cer.getInternalCert().getEncoded());
                    certs[0].setId("AS0INFO");
                    response.setCertlist(certs);
                } else {
                    response.setStatus("KO");
                    response.setDescription("Generic error");
                    response.setReturn_code("0001");
                }
            } else {
                logger.error("Chiamato metodo getCertificate esito negativo status: " + ret.getStatus() + " status code: " + ret.getStatus_code() + " status message: " + ret.getStatusMessage());
                response.setStatus("KO");
                response.setDescription("Errore generico");
                response.setReturn_code("0001");
            }
        }
        catch (Exception ex) {
            response.setStatus("KO");
            response.setDescription("Errore generico");
            response.setReturn_code("0001");
            logger.error("Eccezione: " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            if (xmlres != null) {
                try {
                    xmlres.close();
                }
                catch (Exception exception) {}
            }
        }
        return response;
    }

    @Override
    public CertListResponse certlistopauth(String baseurl, CertsListRequestAuth request) throws IOException {
        CertListResponse response = new CertListResponse();
        response.setStatus("KO");
        response.setDescription("Not implemented");
        response.setReturn_code("0001");
        return response;
    }

    @Override
    public GWReturn close_session(String baseurl, CloseSessionRequest request) throws IOException {
        GWReturn ret = new GWReturn();
        ret.setReturn_code("0000");
        ret.setDescription("Success");
        ret.setStatus("OK");
        return ret;
    }

    @Override
    public CreateSessionReturn create_session(String baseurl, TempPwdRequestEx identity) throws IOException {
        CreateSessionReturn objReturn = new CreateSessionReturn();
        objReturn.setReturn_code("0001");
        objReturn.setDescription("Generic Error");
        objReturn.setStatus("KO");
        TempPwdRequest req = new TempPwdRequest();
        req.setIdentity(identity.getIdentity());
        req.getIdentity().setOtpPwd(identity.getValue());
        TempPwdResponse resp = this.temppwd(baseurl, req);
        if (resp != null) {
            if (resp.getStatus().equals("OK")) {
                objReturn.setStatus("OK");
                objReturn.setDescription("Success");
                objReturn.setReturn_code("0000");
                objReturn.setSessionId(resp.getTmppwd());
            } else if (resp.getStatus().equals("KO-3")) {
                objReturn.setStatus("KO");
                objReturn.setDescription("Invalid Otp");
                objReturn.setReturn_code("0003");
            }
        }
        return objReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TempPwdResponse temppwd(String baseurl, TempPwdRequest request) throws IOException {
        TempPwdResponse response = new TempPwdResponse();
        response.setStatus("KO");
        response.setDescription("Errore generico");
        String identificativo = "[" + request.getIdentity().getDomain() + "]_" + request.getIdentity().getUser();
        String numeroOtp = request.getIdentity().getOtpPwd();
        String pinFirma = request.getIdentity().getUserPWD();
        String strXml = "";
        InputStream xmlres = null;
        try {
            strXml = this.temppwdXml(identificativo, numeroOtp, pinFirma);
            RequestData rdata = new RequestData();
            rdata.setSoapAction("");
            rdata.setType("SOAP");
            rdata.setPostdata(strXml.getBytes("UTF-8"));
            UrlReturn ret = this.client.downloadUrl(infomiddleware_url, rdata, this.cred);
            if (ret.getStatus().equals("OK") || ret.getStatus().equals("KO") && ret.getErrordata() != null) {
                String strXmlRes = "";
                strXmlRes = ret.getData() != null ? new String(ret.getData(), "UTF-8") : new String(ret.getErrordata(), "UTF-8");
                xmlres = new ByteArrayInputStream(strXmlRes.getBytes(Charset.forName("UTF-8")));
                DocumentBuilder db = df.newDocumentBuilder();
                Document doc = db.parse(xmlres);
                if (doc.getElementsByTagName("env:Fault").getLength() > 0) {
                    InfoErrorReturn inforeturn = this.getErrorReturn(doc);
                    response.setStatus("KO-3");
                    response.setDescription("Invalid Otp");
                } else if (doc.getElementsByTagName("startTransactionSignResult").getLength() > 0) {
                    response.setStatus("OK");
                    response.setDescription("OK");
                    response.setTmppwd(doc.getElementsByTagName("startTransactionSignResult").item(0).getTextContent());
                } else {
                    response.setStatus("KO-3");
                    response.setDescription("Invalid Otp");
                }
            } else {
                logger.error("Chiamato metodo startTransactionSign esito negativo status: " + ret.getStatus() + " status code: " + ret.getStatus_code() + " status message: " + ret.getStatusMessage());
                response.setStatus("KO-3");
                response.setDescription("Invalid Otp");
            }
        }
        catch (Exception ex) {
            response.setStatus("KO-3");
            response.setDescription("Invalid Otp");
            logger.error("Eccezione: " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            if (xmlres != null) {
                try {
                    xmlres.close();
                }
                catch (Exception exception) {}
            }
        }
        return response;
    }

    @Override
    public String arssaudit(String baseurl, ArssAudit request) throws IOException {
        String response = "KO-NOT IMPLEMENTED";
        return response;
    }

    @Override
    public TempPwdResponseEx temppwd_ext(String baseurl, TempPwdRequestEx request) throws IOException {
        TempPwdResponseEx response = new TempPwdResponseEx();
        response.setStatus("KO");
        response.setDescription("NOT IMPLEMENTED");
        return response;
    }

    @Override
    public String send_credential(String baseurl, SendCredential request) throws IOException {
        String response = "KO-NOT IMPLEMENTED";
        return response;
    }

    @Override
    public String verify_credential(String baseurl, StrongCredential request) throws IOException {
        String response = "KO-NOT IMPLEMENTED";
        return response;
    }

    @Override
    public String verify_otp(String baseurl, StrongCredential request) throws IOException {
        String response = "KO-NOT IMPLEMENTED";
        return response;
    }

    @Override
    public AutomaticSignatureControlReturn enable_automatic_signature(String baseurl, AutomaticSignatureControl request) throws IOException {
        AutomaticSignatureControlReturn response = new AutomaticSignatureControlReturn();
        response.setReturn_code("0001");
        response.setStatus("KO");
        response.setDescription("NOT IMPLEMENTED");
        return response;
    }

    @Override
    public RetriveCredentialReturn retrieve_credential(String baseurl, RetriveCredential retrive_request) throws IOException {
        RetriveCredentialReturn response = new RetriveCredentialReturn();
        response.setReturn_code("0001");
        response.setStatus("KO");
        response.setDescription("NOT IMPLEMENTED");
        return response;
    }

    @Override
    public String[] auth_methods(String baseurl, Auth identity) throws IOException {
        String[] response = new String[]{new String("OTP")};
        return response;
    }

    private String signopXml(String identificativo, String numeroOtp, String pinFirma, List<byte[]> hashs) {
        String hashstr = "";
        if (hashs.size() > 0) {
            hashstr = new String(Base64.encode((byte[])hashs.get(0)));
        }
        StringBuilder strXml = new StringBuilder();
        strXml.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:sig=\"http://signhash.webservice.ncfr.infocert.it/\">\n");
        strXml.append("<soapenv:Header/>\n");
        strXml.append("<soapenv:Body>\n");
        strXml.append("<sig:sighHash>\n");
        strXml.append("<identificativo>" + identificativo + "</identificativo>\n");
        strXml.append("<numeroOtp>" + numeroOtp + "</numeroOtp>\n");
        strXml.append("<pinFirma>" + pinFirma + "</pinFirma>\n");
        strXml.append("<hashs>" + hashstr + "</hashs>\n");
        strXml.append("</sig:sighHash>\n");
        strXml.append("</soapenv:Body>\n");
        strXml.append("</soapenv:Envelope>");
        return strXml.toString();
    }

    private String signop2Xml(String identificativo, String numeroOtp, String pinFirma, List<byte[]> hashs) {
        String hashstr = new String(Base64.encode((byte[])hashs.get(0)));
        StringBuilder strXml = new StringBuilder();
        strXml.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:sig=\"http://signhash.webservice.ncfr.infocert.it/\">\n");
        strXml.append("<soapenv:Header/>\n");
        strXml.append("<soapenv:Body>\n");
        strXml.append("<sig:sighHash>\n");
        strXml.append("<identificativo>" + identificativo + "</identificativo>\n");
        strXml.append("<numeroOtp>" + numeroOtp + "</numeroOtp>\n");
        strXml.append("<pinFirma>" + pinFirma + "</pinFirma>\n");
        strXml.append("<hashs>" + hashstr + "</hashs>\n");
        strXml.append("</sig:sighHash>\n");
        strXml.append("</soapenv:Body>\n");
        strXml.append("</soapenv:Envelope>");
        return strXml.toString();
    }

    private String certlistopXml(String identificativo) {
        StringBuilder strXml = new StringBuilder();
        strXml.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:sig=\"http://signhash.webservice.ncfr.infocert.it/\">\n");
        strXml.append("<soapenv:Header/>\n");
        strXml.append("<soapenv:Body>\n");
        strXml.append("<sig:getCertificate>\n");
        strXml.append("<identificativo>" + identificativo + "</identificativo>\n");
        strXml.append("</sig:getCertificate>\n");
        strXml.append("</soapenv:Body>\n");
        strXml.append("</soapenv:Envelope>");
        return strXml.toString();
    }

    private String temppwdXml(String identificativo, String numeroOtp, String pinFirma) {
        StringBuilder strXml = new StringBuilder();
        strXml.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:sig=\"http://signhash.webservice.ncfr.infocert.it/\">\n");
        strXml.append("<soapenv:Header/>\n");
        strXml.append("<soapenv:Body>\n");
        strXml.append("<sig:startTransactionSign>\n");
        strXml.append("<identificativo>" + identificativo + "</identificativo>\n");
        strXml.append("<numeroOtp>" + numeroOtp + "</numeroOtp>\n");
        strXml.append("<pinFirma>" + pinFirma + "</pinFirma>\n");
        strXml.append("</sig:startTransactionSign>\n");
        strXml.append("</soapenv:Body>\n");
        strXml.append("</soapenv:Envelope>");
        return strXml.toString();
    }

    private String faultGetCode(Document doc) {
        String retval = "";
        NodeList nlstfault = doc.getElementsByTagName("env:Fault");
        block0: for (int i = 0; i < nlstfault.getLength(); ++i) {
            NodeList nlstfaultchild = nlstfault.item(i).getChildNodes();
            for (int f = 0; f < nlstfaultchild.getLength(); ++f) {
                if (!nlstfaultchild.item(f).getNodeName().equals("faultcode")) continue;
                retval = nlstfaultchild.item(f).getTextContent();
                continue block0;
            }
        }
        return retval;
    }

    private InfoErrorReturn getErrorReturn(Document doc) {
        InfoErrorReturn errret = new InfoErrorReturn();
        errret.setReturn_code("0001");
        errret.setStatus("KO");
        errret.setDescription("Generic error");
        String faultcodeinfo = "";
        NodeList faultcode = doc.getElementsByTagName("code");
        if (faultcode.getLength() > 0) {
            faultcodeinfo = faultcode.item(0).getTextContent();
        }
        String faultmessageinfo = "";
        NodeList faultmsg = doc.getElementsByTagName("message");
        if (faultmsg.getLength() > 0) {
            faultmessageinfo = faultmsg.item(0).getTextContent().toUpperCase();
        }
        if (faultcodeinfo.equals("GENE-0001")) {
            if (faultmessageinfo.contains("IL PIN DI FIRMA")) {
                errret.setReturn_code("0002");
                errret.setStatus("KO");
                errret.setDescription("KO-INVALID PASSWORD");
            } else if (faultmessageinfo.contains("PKBOX GENERIC ERROR")) {
                errret.setReturn_code("0002");
                errret.setStatus("KO-INFOSESSION");
                errret.setDescription("KO-INVALID USER");
            }
        } else if (faultcodeinfo.equals("GENE-0201")) {
            if (faultmessageinfo.contains("ACCESSDENIED")) {
                errret.setReturn_code("0002");
                errret.setStatus("KO");
                errret.setDescription("KO-INVALID USER");
            } else if (faultmessageinfo.contains("INVALID PIN")) {
                errret.setReturn_code("0002");
                errret.setStatus("KO");
                errret.setDescription("KO-INVALID PASSWORD");
            } else if (faultmessageinfo.contains("INVALID OTP")) {
                errret.setReturn_code("0003");
                errret.setStatus("KO");
                errret.setDescription("Otp Credential Invalido Or Blocked");
            }
        } else if (faultcodeinfo.equals("GENE-0102")) {
            if (faultmessageinfo.contains("NESSUN CERTIFICATO TROVATO")) {
                errret.setReturn_code("0002");
                errret.setStatus("KO");
                errret.setDescription("KO-INVALID USER");
            }
        } else {
            errret.setReturn_code("0001");
            errret.setStatus("KO");
            errret.setDescription("Generic error");
        }
        return errret;
    }

    @Override
    public String getInfoMiddlewareUrl() {
        return infomiddleware_url;
    }

    @Override
    public CredentialListReturn credentials_query(String baseurl, CredentialListQuery credential_query) throws IOException {
        CredentialListReturn retval = new CredentialListReturn();
        retval.setReturn_code("0001");
        retval.setStatus("KO");
        retval.setDescription("NOT IMPLEMENTED");
        return retval;
    }

    @Override
    public GWReturn test_otp(String baseurl, TestCredential test_credential) throws IOException {
        GWReturn retval = new GWReturn();
        retval.setReturn_code("0001");
        retval.setStatus("KO");
        retval.setDescription("NOT IMPLEMENTED");
        return retval;
    }

    @Override
    public DecryptRet decrypt(String baseurl, DecryptReq request) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GWReturn changePassword(String baseurl, ChangePassword request) throws IOException {
        return null;
    }

    private String genID(String user, String pin) {
        String strReturn = "";
        SHA1Digest d = new SHA1Digest();
        d.update((user + pin).getBytes(), 0, (user + pin).getBytes().length);
        byte[] ret = new byte[d.getDigestSize()];
        d.doFinal(ret, 0);
        String strHash = Hex.toHexString((byte[])ret);
        strReturn = user + "-" + strHash;
        return strReturn;
    }

    @Override
    public UserAuthenticationInfoResponse userAuthenticationInfo(String baseurl, UserAuthenticationInfoRequest request) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

