/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.asic.utils.xml;

import com.sun.org.apache.xerces.internal.dom.DOMInputImpl;
import it.actalis.ellips.capi.asic.ASiCSignatureType;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.util.XMLCommonUtils;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class ASiCXMLUtils {
    private static Schema schema = null;
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    private static Schema getSchemaInitializingIfNecessary() {
        if (schema != null) {
            return schema;
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream schemaStream = ASiCXMLUtils.class.getResourceAsStream("/it/actalis/ellips/capi/asic/ts_102918v010301.xsd");
        try {
            factory.setResourceResolver(new LSResourceResolver(){

                @Override
                public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                    logger.debug("type " + type);
                    logger.debug("namespaceURI " + namespaceURI);
                    logger.debug("publicId " + publicId);
                    logger.debug("systemId " + systemId);
                    logger.debug("baseURI " + baseURI);
                    InputStream schemaStream = null;
                    if (systemId.equals("http://www.w3.org/TR/2002/REC-xmldsig-core-20020212/xmldsig-core-schema.xsd")) {
                        schemaStream = ASiCXMLUtils.class.getResourceAsStream("/it/actalis/ellips/capi/asic/xmldsig-core-schema.xsd_");
                    } else if (systemId.equals("https://www.w3.org/2001/XMLSchema.dtd")) {
                        logger.info("XMLSchema.dtd loaded from local resource instead of https");
                        try {
                            schemaStream = ASiCXMLUtils.class.getResourceAsStream("/it/actalis/ellips/capi/asic/XMLSchema.dtd");
                        }
                        catch (Exception ex) {
                            logger.debug(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    if (schemaStream != null) {
                        DOMInputImpl input = new DOMInputImpl();
                        input.setPublicId(publicId);
                        input.setSystemId(systemId);
                        input.setBaseURI(baseURI);
                        input.setCharacterStream(new InputStreamReader(schemaStream));
                        return input;
                    }
                    return null;
                }
            });
            schema = factory.newSchema(new StreamSource(schemaStream));
        }
        catch (SAXException ex) {
            logger.error(ex.getMessage());
        }
        return schema;
    }

    private static boolean isSchemaConformant(InputStream xml) {
        Schema schema = ASiCXMLUtils.getSchemaInitializingIfNecessary();
        if (schema == null) {
            return false;
        }
        Validator validator = schema.newValidator();
        try {
            validator.validate(new StreamSource(xml));
            return true;
        }
        catch (SAXException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            try {
                int i;
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                dbFactory.setNamespaceAware(true);
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                xml.reset();
                Document doc = dBuilder.parse(xml);
                NodeList signatures = doc.getElementsByTagName("ds:Signature");
                if (signatures.getLength() == 0) {
                    signatures = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
                }
                if ((i = 0) < signatures.getLength()) {
                    Node node = signatures.item(i);
                    DOMSource source = new DOMSource(node);
                    StringWriter stringWriter = new StringWriter();
                    StreamResult result = new StreamResult(stringWriter);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.transform(source, result);
                    validator.validate(new StreamSource(new StringReader(stringWriter.getBuffer().toString())));
                    return true;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    public static boolean isValidManifest(InputStream xml) {
        return ASiCXMLUtils.isSchemaConformant(xml);
    }

    public static boolean isValidASiCXADESSignature(InputStream xml) {
        return ASiCXMLUtils.isSchemaConformant(xml);
    }

    public static void startManifest(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartDocument("UTF-8", "1.0");
        xsw.writeStartElement("asic", "ASiCManifest", "http://uri.etsi.org/02918/v1.2.1#");
        xsw.writeNamespace("asic", "http://uri.etsi.org/02918/v1.2.1#");
    }

    public static void endManifest(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeEndElement();
    }

    public static void startSigRef(XMLStreamWriter xsw, String filepath, ASiCSignatureType signType) throws XMLStreamException {
        String mimetype = "";
        switch (signType) {
            case CADES: {
                mimetype = "application/pkcs7-signature";
                break;
            }
            case TIMESTAMP: {
                mimetype = "application/vnd.etsi.timestamp-token";
                break;
            }
            case XADES: {
                mimetype = "";
            }
        }
        xsw.writeStartElement("http://uri.etsi.org/02918/v1.2.1#", "SigReference");
        xsw.writeAttribute("MimeType", mimetype);
        xsw.writeAttribute("URI", filepath);
    }

    public static void endSigRef(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeEndElement();
    }

    public static void completeSigRef(XMLStreamWriter xsw, String filepath, ASiCSignatureType signType) throws XMLStreamException {
        ASiCXMLUtils.startSigRef(xsw, filepath, signType);
        ASiCXMLUtils.endSigRef(xsw);
    }

    public static void startDataObjRef(XMLStreamWriter xsw, String filepath) throws XMLStreamException {
        xsw.writeStartElement("http://uri.etsi.org/02918/v1.2.1#", "DataObjectReference");
        xsw.writeAttribute("URI", filepath);
    }

    public static void endDataObjRef(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeEndElement();
    }

    public static void completeDataObjRef(XMLStreamWriter xsw, String filepath, DigestAlgorithm digestMethod, String digestValue) throws XMLStreamException {
        ASiCXMLUtils.startDataObjRef(xsw, filepath);
        XMLCommonUtils.completeXMLDigestCouple((XMLStreamWriter)xsw, (DigestAlgorithm)digestMethod, (String)digestValue);
        ASiCXMLUtils.endDataObjRef(xsw);
    }

    public static ByteArrayOutputStream augmentXadesSignature(ByteArrayOutputStream xadesOutputStream) throws XMLStreamException, CapiException, IOException, ParserConfigurationException, SAXException, TransformerConfigurationException, TransformerException {
        byte[] xades = xadesOutputStream.toByteArray();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document oldDoc = builder.parse(new ByteArrayInputStream(xades));
        Element oldRoot = oldDoc.getDocumentElement();
        Document newDoc = builder.newDocument();
        Element newRoot = newDoc.createElementNS("http://uri.etsi.org/02918/v1.2.1#", "asic:XAdESSignatures");
        newDoc.appendChild(newRoot);
        newRoot.appendChild(newDoc.importNode(oldRoot, true));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DOMSource domSource = new DOMSource(newDoc);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        ((Writer)writer).flush();
        return out;
    }
}

