/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7;

import esecurity.dts.Client;
import esecurity.dts.DTSClient;
import esecurity.dts.TimeStampToken;
import esecurity.dts.util.IllegalParamException;
import esecurity.validator.parser.utils.DerParserUtils;
import it.actalis.ellips.capi.cms.CadesSignedDataProxy;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.HttpsClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.net.HTTP_URLConnection;
import it.actalis.ellips.capi.pkcs7.CapiSignerInformation;
import it.actalis.ellips.capi.pkcs7.CounterSignedEnvelope;
import it.actalis.ellips.capi.pkcs7.RFC5652.CheckSignerInformation;
import it.actalis.ellips.capi.pkcs7.RFC5652.VerificationResult;
import it.actalis.ellips.capi.pkcs7.VerRsContentSignerBuilder;
import it.actalis.ellips.capi.pkcs7.VerifyInfo;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.bouncycastle.cms.bc.BcRSASignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;

public class SignedEnvelope {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;
    public static final int TYPEDATA = 1;
    public static final int TYPEDIGEST = 2;
    public static final String SHA1 = CMSSignedDataGenerator.DIGEST_SHA1;
    public static final String SHA256 = CMSSignedDataGenerator.DIGEST_SHA256;
    protected CMSSignedData pkcs7SignedData = null;
    private MessageDigest msgDigest = null;
    private MessageDigest msgDigest256 = null;
    private String msgDigestToBeUsed = SHA256;
    private byte[] data = null;
    private int type = 0;
    private List<String> signerDnVector = new LinkedList<String>();
    private List<Certificate> signerCertVector = new LinkedList<Certificate>();
    private List<VerifyInfo> signerVerifyVector = new LinkedList<VerifyInfo>();
    protected List<X509Certificate> certsVector = new LinkedList<X509Certificate>();
    private int status = -1;
    private static final int ST_CREATE = 0;
    private static final int ST_CREATE_DATA = 1;
    private static final int ST_SIGN = 2;
    private static final int ST_PARSE = 3;
    private int mode = 1;
    protected boolean isCounterSignedEnv = false;
    private String TSA = null;
    private String TSAhashAlgorithm = null;
    private String TSApolicy = null;
    private boolean TSAcertReq = true;
    private HttpsClient TSAhttps = null;
    private String TSABasicAuthUser = null;
    private String TSABasicAuthPassword = null;
    private DTSClient TSAClient = null;
    private boolean includeSigningTime = true;
    private static boolean useAlternativeVerifier = false;

    public SignedEnvelope(byte[] encoded) throws CapiException {
        this.mode = 1;
        this.status = 3;
        if (encoded == null) {
            throw new CapiException("Null data", 1001);
        }
        this.instanceDigest();
        try {
            this.pkcs7SignedData = new CMSSignedData((InputStream)new ByteArrayInputStream(encoded));
            logger.debug("DER format");
        }
        catch (CMSException cmse) {
            this.loadB64orPEMEnvelope(encoded);
        }
        if (this.pkcs7SignedData == null) {
            logger.debug("null pkcs7SignedData");
            throw new CapiException("Internal error", 50050);
        }
        logger.debug("signed data ok");
        this.parseEnvelope(null);
    }

    public SignedEnvelope(byte[] encoded, boolean useAlternVerifier) throws CapiException {
        this.mode = 1;
        this.status = 3;
        useAlternativeVerifier = useAlternVerifier;
        try {
            if (encoded == null) {
                throw new CapiException("Null data", 1001);
            }
            this.instanceDigest();
            try {
                this.pkcs7SignedData = new CMSSignedData((InputStream)new ByteArrayInputStream(encoded));
                logger.debug("DER format");
            }
            catch (CMSException cmse) {
                this.loadB64orPEMEnvelope(encoded);
            }
            if (this.pkcs7SignedData == null) {
                logger.debug("null pkcs7SignedData");
                throw new CapiException("Internal error", 50050);
            }
            logger.debug("signed data ok");
            this.parseEnvelope(null);
        }
        catch (CapiException ex) {
            throw ex;
        }
        finally {
            useAlternativeVerifier = false;
        }
    }

    private void instanceDigest() throws CapiException {
        try {
            this.msgDigest = MessageDigest.getInstance(Constants.SHA1, ProvUtils.bcProvider);
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("SHA1 Digest Algorithm not available", 50050);
        }
        try {
            this.msgDigest256 = MessageDigest.getInstance(Constants.SHA256, ProvUtils.bcProvider);
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("SHA256 Digest Algorithm not available", 50050);
        }
    }

    private void loadB64orPEMEnvelope(byte[] encoded) throws CapiException {
        try {
            logger.debug("trying Base64 decode ... ");
            byte[] derByte = Util.base64Decode((byte[])encoded);
            this.pkcs7SignedData = new CMSSignedData((InputStream)new ByteArrayInputStream(derByte));
        }
        catch (Exception e) {
            PEMParser pemReader = new PEMParser((Reader)new StringReader(new String(encoded)));
            try {
                logger.debug("not Base64, trying PEM Tagged format  ... ");
                ContentInfo cInfo = (ContentInfo)pemReader.readObject();
                if (cInfo == null) {
                    throw new CapiException("Envelope format unknown or not implemented", 50021);
                }
                if (!cInfo.getContentType().equals((ASN1Primitive)PKCSObjectIdentifiers.signedData)) {
                    throw new CapiException("Not a valid PKCS#7 signed-data object - wrong header " + cInfo.getContentType().getId(), 50021);
                }
                this.pkcs7SignedData = new CMSSignedData(cInfo);
            }
            catch (Exception e1) {
                logger.debug(e.getMessage(), (Throwable)e1);
                throw new CapiException("Envelope format unknown or not implemented", 50021);
            }
        }
    }

    private void loadB64orPEMEnvelope(byte[] encoded, byte[] message) throws CapiException {
        try {
            logger.debug("trying Base64 decode ... ");
            byte[] derByte = Util.base64Decode((byte[])encoded);
            this.pkcs7SignedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(message), (InputStream)new ByteArrayInputStream(derByte));
        }
        catch (Exception e) {
            PEMParser pemReader = new PEMParser((Reader)new StringReader(new String(encoded)));
            try {
                logger.debug("not Base64, trying PEM Tagged format  ... ");
                ContentInfo cInfo = (ContentInfo)pemReader.readObject();
                if (cInfo == null) {
                    throw new CapiException("Envelope format unknown or not implemented", 50021);
                }
                if (!cInfo.getContentType().equals((ASN1Primitive)PKCSObjectIdentifiers.signedData)) {
                    throw new CapiException("Not a valid PKCS#7 signed-data object - wrong header " + cInfo.getContentType().getId(), 50021);
                }
                this.pkcs7SignedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(message), cInfo);
            }
            catch (Exception e1) {
                logger.debug(e.getMessage(), (Throwable)e1);
                throw new CapiException("Envelope format unknown or not implemented", 50021);
            }
        }
    }

    protected static void verifySigners(Store certs, List<SignerInformation> signerInformVector, List<String> sDnVector, List<Certificate> sCertVector, List<VerifyInfo> sVerifyVector) throws CapiException {
        SignedEnvelope.verifySigners(certs, signerInformVector, sDnVector, sCertVector, sVerifyVector, null);
    }

    protected static void verifySigners(Store certs, List<SignerInformation> signerInformVector, List<String> sDnVector, List<Certificate> sCertVector, List<VerifyInfo> sVerifyVector, CadesSignedDataProxy dataProxy) throws CapiException {
        for (int i = 0; i < signerInformVector.size(); ++i) {
            try {
                SignerInformation si = signerInformVector.get(i);
                SignedEnvelope.verifySigner(si, certs, sDnVector, sCertVector, sVerifyVector, dataProxy);
                continue;
            }
            catch (Exception e1) {
                throw new CapiException(e1.getMessage(), 50050);
            }
        }
    }

    protected static void verifySigner(SignerInformation sigInf, Store certs, List<String> sDnVector, List<Certificate> sCertVector, List<VerifyInfo> sVerifyVector, CadesSignedDataProxy dataProxy) throws Exception {
        block28: {
            SignerId id = null;
            try {
                id = sigInf.getSID();
                byte[] ski = id.getSubjectKeyIdentifier();
                if (ski != null) {
                    logger.debug("signerInfo has SubjectKeyIdentifier");
                } else {
                    logger.debug("signerInfo has IssuerAndSerialNumber");
                }
            }
            catch (Exception e) {
                logger.debug("Cannot validate signature: Exception " + e.getMessage());
                logger.debug(e.getMessage(), (Throwable)e);
                sVerifyVector.add(new VerifyInfo(false, VerifyInfo.FailureReason.MISSING_SIGNER_CERT));
            }
            Collection certCollection = certs.getMatches((Selector)id);
            if (certCollection.size() > 0) {
                try {
                    X509CertificateHolder X509Cert = (X509CertificateHolder)certCollection.iterator().next();
                    Certificate capiCert = new Certificate(X509Cert.getEncoded());
                    String dn = capiCert.getSubjectDN();
                    sDnVector.add(dn);
                    sCertVector.add(capiCert);
                    logger.debug("Found signer certificate: " + dn);
                    boolean hasSigningCert = false;
                    boolean hasSigningCertV2 = false;
                    AttributeTable signedAttTable = sigInf.getSignedAttributes();
                    if (signedAttTable != null) {
                        Attribute attr = sigInf.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificate);
                        if (attr != null) {
                            logger.debug("Found signing certificate attribute V1");
                            SigningCertificate signCert = SigningCertificate.getInstance((Object)attr.getAttrValues().getObjectAt(0));
                            ESSCertID certID = ESSCertID.getInstance((Object)signCert.getCerts()[0]);
                            logger.debug("Validating the first ESSCertID ...");
                            try {
                                DerParserUtils.validateESSCertID((ESSCertID)certID, (X509Certificate)capiCert.getInternalCert());
                            }
                            catch (Exception e) {
                                sVerifyVector.add(new VerifyInfo(false, VerifyInfo.FailureReason.INVALID_SIGNING_CERTIFICATE_AUTH_ATTRIBUTE));
                                return;
                            }
                            hasSigningCert = true;
                            logger.debug("ESSCertID V1 successfully validated.");
                        } else {
                            try {
                                hasSigningCertV2 = SignedEnvelope.hasSigningCertificateV2(sigInf, capiCert.getInternalCert());
                            }
                            catch (Exception e) {
                                sVerifyVector.add(new VerifyInfo(false, VerifyInfo.FailureReason.INVALID_SIGNING_CERTIFICATE_AUTH_ATTRIBUTE));
                                return;
                            }
                        }
                        SignerInformationVerifier verifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider(ProvUtils.bcProvider).build(X509Cert);
                        VerificationResult vResult = null;
                        try {
                            vResult = CheckSignerInformation.customVerify(verifier, sigInf, dataProxy);
                        }
                        catch (CMSException cmse) {
                            logger.error(cmse.getMessage(), (Throwable)cmse);
                        }
                        VerifyInfo vi = null;
                        if (vResult.isRelaxedValid()) {
                            logger.debug("Valid signature");
                            vi = new VerifyInfo(true);
                        } else {
                            logger.debug("Invalid signature");
                            vi = new VerifyInfo(false, VerifyInfo.FailureReason.WRONG_SIGNATURE);
                        }
                        if (hasSigningCertV2) {
                            vi.setSigningCertificateV2(hasSigningCertV2);
                        } else if (hasSigningCert) {
                            vi.setSigningCertificate(hasSigningCert);
                        }
                        if (!vResult.isDerEncodedSignedAttributes()) {
                            logger.warn("Valid signature, but signed attributes not DER encoded");
                            vi.setRFC5652_SignedAttrDER(false);
                        }
                        if (!vResult.isValidSigningTime()) {
                            logger.warn("Valid signature, but signing time is not included in the certificate validity period");
                            vi.setValidSigningTime(false);
                        }
                        vi.setVerificationResult(vResult);
                        sVerifyVector.add(vi);
                        break block28;
                    }
                    logger.debug("No signed attribute table found.");
                    if (useAlternativeVerifier) {
                        logger.debug("No signed attribute table found. Using BcRSASignerInfoVerifierBuilder ...");
                        BcRSASignerInfoVerifierBuilder bcv = new BcRSASignerInfoVerifierBuilder((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), (DigestAlgorithmIdentifierFinder)new DefaultDigestAlgorithmIdentifierFinder(), (DigestCalculatorProvider)new BcDigestCalculatorProvider());
                        SignerInformationVerifier siv = bcv.build(X509Cert);
                        if (sigInf.verify(siv)) {
                            sVerifyVector.add(new VerifyInfo(true));
                            logger.debug("Valid signature");
                        } else {
                            sVerifyVector.add(new VerifyInfo(false, VerifyInfo.FailureReason.WRONG_SIGNATURE));
                            logger.debug("Invalid signature");
                        }
                        break block28;
                    }
                    if (sigInf.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(ProvUtils.bcProvider).build(X509Cert))) {
                        sVerifyVector.add(new VerifyInfo(true));
                        logger.debug("Valid signature");
                        break block28;
                    }
                    sVerifyVector.add(new VerifyInfo(false, VerifyInfo.FailureReason.WRONG_SIGNATURE));
                    logger.debug("Invalid signature");
                }
                catch (Exception e) {
                    logger.debug("Cannot validate signature: Exception " + e.getMessage());
                    logger.debug(e.getMessage(), (Throwable)e);
                    sVerifyVector.add(new VerifyInfo(false, VerifyInfo.FailureReason.MISSING_SIGNER_CERT));
                }
            } else {
                logger.debug("Signer certificate not found. Cannot validate signature");
                sDnVector.add(null);
                sCertVector.add(null);
                sVerifyVector.add(new VerifyInfo(false, VerifyInfo.FailureReason.MISSING_SIGNER_CERT));
            }
        }
    }

    private void parseEnvelope(byte[] detachedContent) throws CapiException {
        if (detachedContent == null) {
            logger.debug("setting encapsulated content data...");
            try {
                this.data = (byte[])this.pkcs7SignedData.getSignedContent().getContent();
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("No data found into encrypted envelope", 50000);
            }
        } else {
            logger.debug("setting detached content data...");
            this.data = detachedContent;
        }
        logger.debug("getting certificates...");
        Store certsStore = null;
        try {
            certsStore = this.pkcs7SignedData.getCertificates();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Exception " + e.getMessage(), 50050);
        }
        try {
            if (certsStore == null) {
                logger.debug("no certificates found!");
            }
            X509Certificate[] certsArray = Certificate.getX509CertificatesFromStore((Store)certsStore);
            this.certsVector = new Vector<X509Certificate>(Arrays.asList(certsArray));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("StoreException", 50050);
        }
        logger.debug(this.certsVector.size() + " certificates found");
        logger.debug("getting signers DN...");
        this.signerDnVector = new Vector<String>();
        this.signerCertVector = new LinkedList<Certificate>();
        this.signerVerifyVector = new LinkedList<VerifyInfo>();
        SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
        ArrayList<CapiSignerInformation> signerColl = new ArrayList<CapiSignerInformation>();
        for (SignerInformation signerInfo : sig_infos.getSigners()) {
            signerColl.add(new CapiSignerInformation(signerInfo, this.pkcs7SignedData.getSignedContent()));
        }
        Vector<SignerInformation> signerInformVector = new Vector<SignerInformation>(signerColl);
        logger.debug("signerInformVector size = " + signerInformVector.size());
        SignedEnvelope.verifySigners(certsStore, signerInformVector, this.signerDnVector, this.signerCertVector, this.signerVerifyVector);
        logger.debug("getting signers DN OK");
    }

    protected static boolean hasSigningCertificate(SignerInformation sinf, X509Certificate c) throws CapiException {
        AttributeTable signedAttTable = sinf.getSignedAttributes();
        if (signedAttTable == null) {
            logger.debug("No signed attribute table found.");
            return false;
        }
        Attribute attr = signedAttTable.get(PKCSObjectIdentifiers.id_aa_signingCertificate);
        if (attr == null) {
            logger.debug("No signing certificate attribute found.");
            return false;
        }
        try {
            logger.debug("Found signing certificate attribute V1");
            SigningCertificate signCert = SigningCertificate.getInstance((Object)attr.getAttrValues().getObjectAt(0));
            ESSCertID certID = ESSCertID.getInstance((Object)signCert.getCerts()[0]);
            logger.debug("Validating the first ESSCertID ...");
            DerParserUtils.validateESSCertID((ESSCertID)certID, (X509Certificate)c);
        }
        catch (Exception e) {
            throw new CapiException("Cannot parse ESSCertID", 3010);
        }
        logger.debug("ESSCertID V1 successfully validated.");
        return true;
    }

    public static boolean hasNoSignedAttribute(SignerInformation sinf) throws Exception {
        AttributeTable signedAttTable = sinf.getSignedAttributes();
        if (signedAttTable == null) {
            logger.debug("No signed attribute table found.");
            return true;
        }
        return false;
    }

    protected static boolean hasSigningCertificateV2(SignerInformation sinf, X509Certificate cert) throws CapiException {
        return SignedEnvelope.getSigningCertificateV2HashAlg(sinf, cert) != null;
    }

    protected static String getSigningCertificateV2HashAlg(SignerInformation sinf, X509Certificate cert) throws CapiException {
        AttributeTable signedAttTable = sinf.getSignedAttributes();
        if (signedAttTable == null) {
            logger.debug("No signed attribute table found.");
            return null;
        }
        Attribute attr = signedAttTable.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
        if (attr == null) {
            logger.debug("No signing certificate attribute V2 found.");
            return null;
        }
        logger.debug("Found signing certificate attribute V2.");
        ASN1Sequence seq = (ASN1Sequence)attr.getAttrValues().getObjectAt(0);
        SigningCertificateV2 signCertV2 = SigningCertificateV2.getInstance((Object)seq);
        ESSCertIDv2[] certIDarray = null;
        ESSCertIDv2 certID = null;
        try {
            certIDarray = signCertV2.getCerts();
            certID = certIDarray[0];
        }
        catch (Exception e) {
            logger.debug("Cannot instantiate ESSCertIDv2: Exception " + e.getMessage() + ". Retrying...");
            ASN1Sequence certIDseq = ASN1Sequence.getInstance((Object)seq.getObjectAt(0));
            if (certIDseq.size() <= 0) {
                throw new CapiException("Cannot parse ESSCertIDv2", 3010);
            }
            ASN1Sequence ESSv2 = ASN1Sequence.getInstance((Object)certIDseq.getObjectAt(0));
            if (ESSv2.size() == 1) {
                logger.debug("ESSCertIDv2 contains only SHA256 Hash");
                byte[] certHash = ASN1OctetString.getInstance((Object)ESSv2.getObjectAt(0).toASN1Primitive()).getOctets();
                certID = new ESSCertIDv2(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256), certHash);
            }
            certID = ESSCertIDv2.getInstance((Object)ESSv2);
        }
        if (certID != null) {
            logger.debug("Validating the first ESSCertID ...");
            DerParserUtils.validateESSCertID((ESSCertIDv2)certID, (X509Certificate)cert);
            logger.debug("ESSCertID V2 successfully validated.");
            return certID.getHashAlgorithm().getAlgorithm().getId();
        }
        throw new CapiException("Cannot parse ESSCertIDv2", 3010);
    }

    public SignedEnvelope(String encoded) throws CapiException {
        this.mode = 1;
        this.status = 3;
        if (encoded == null) {
            throw new CapiException("Null data", 1001);
        }
        this.instanceDigest();
        this.loadB64orPEMEnvelope(encoded.getBytes());
        if (this.pkcs7SignedData == null) {
            logger.debug("null pkcs7SignedData");
            throw new CapiException("Internal error", 50050);
        }
        logger.debug("signed data ok");
        this.parseEnvelope(null);
    }

    public SignedEnvelope(String encoded, byte[] message) throws CapiException {
        this.mode = 2;
        this.status = 3;
        if (encoded == null || message == null) {
            throw new CapiException("Null data", 1001);
        }
        this.instanceDigest();
        this.loadB64orPEMEnvelope(encoded.getBytes(), message);
        if (this.pkcs7SignedData == null) {
            logger.debug("null pkcs7SignedData");
            throw new CapiException("Internal error", 50050);
        }
        logger.debug("signed data ok");
        this.parseEnvelope(message);
    }

    public String[] listSigners() {
        String[] res = new String[this.signerDnVector.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.signerDnVector.get(i);
        }
        return res;
    }

    public byte[] getData() {
        byte[] data2 = new byte[this.data.length];
        System.arraycopy(this.data, 0, data2, 0, this.data.length);
        return data2;
    }

    public int getDataType() {
        return this.type == 0 ? 1 : this.type;
    }

    public List<Certificate> listCertificates() throws CapiException {
        try {
            LinkedList<Certificate> res = new LinkedList<Certificate>();
            for (int i = 0; i < this.certsVector.size(); ++i) {
                X509Certificate cert = this.certsVector.get(i);
                Certificate capicert = new Certificate(cert);
                res.add(capicert);
            }
            return res;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
    }

    public Certificate verify(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerCertVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        Boolean v = this.signerVerifyVector.get(signerInfoIndex).isValid();
        if (v.booleanValue()) {
            return this.signerCertVector.get(signerInfoIndex);
        }
        throw new CapiException("Invalid signature", 3010, this.signerVerifyVector.get(signerInfoIndex).getReason().value());
    }

    public Certificate getSignerCertificate(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerCertVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.signerCertVector.get(signerInfoIndex);
    }

    public String getSignerDigestAlg(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            logger.debug("[getSignerDigestAlg] " + sigInfo.getDigestAlgOID());
            if (sigInfo.getDigestAlgOID().equalsIgnoreCase(SHA256)) {
                return Constants.SHA256;
            }
            if (sigInfo.getDigestAlgOID().equalsIgnoreCase(SHA1)) {
                return Constants.SHA1;
            }
            return sigInfo.getDigestAlgOID();
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Cannot get signer digest algorithm oid " + e.getMessage(), 50023);
        }
    }

    public String getSignerDigestAlgOid(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            logger.debug("[getSignerDigestAlg] " + sigInfo.getDigestAlgOID());
            return sigInfo.getDigestAlgOID();
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Cannot get signer digest algorithm oid " + e.getMessage(), 50023);
        }
    }

    public boolean hasSigningCertificateV2(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerCertVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        VerifyInfo vi = this.signerVerifyVector.get(signerInfoIndex);
        return vi.hasSigningCertificateV2();
    }

    public boolean hasRFC5652_SignedAttrDER(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        VerifyInfo vi = this.signerVerifyVector.get(signerInfoIndex);
        return vi.hasRFC5652_SignedAttrDER();
    }

    public String getSigningCertificateV2HashAlg(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (!this.hasSigningCertificateV2(signerInfoIndex)) {
            return null;
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerCertVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        Certificate signerCert = this.signerCertVector.get(signerInfoIndex);
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            X509Certificate X509Cert = signerCert.getInternalCert();
            String oid = SignedEnvelope.getSigningCertificateV2HashAlg(sigInfo, X509Cert);
            return oid;
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean hasSigningCertificate(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerCertVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        VerifyInfo vi = this.signerVerifyVector.get(signerInfoIndex);
        return vi.hasSigningCertificate();
    }

    public boolean hasNoSignerAttribute(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerCertVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerVerifyVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            boolean has = SignedEnvelope.hasNoSignedAttribute(sigInfo);
            return has;
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String getSignerEncryptionAlg(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            if (sigInfo.getEncryptionAlgOID().equalsIgnoreCase(CMSSignedDataGenerator.ENCRYPTION_RSA)) {
                logger.debug("[getEncryptionAlgOID] is ENCRYPTION_RSA");
                return "RSA";
            }
            logger.debug("[getEncryptionAlgOID] " + sigInfo.getEncryptionAlgOID());
            return sigInfo.getEncryptionAlgOID();
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Cannot get signer encryption algorithm oid " + e.getMessage(), 50023);
        }
    }

    public byte[] getSignature(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            return sigInfo.getSignature();
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Cannot get signature value", 50023);
        }
    }

    public String getSigningTime(int signerInfoIndex, String format) throws CapiException {
        return this.getSigningTime(signerInfoIndex, format, null);
    }

    public String getSigningTime(int signerInfoIndex, String format, String TimeZone2) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            Date signTime = this.getSignatureTime(sigInfo);
            if (signTime == null) {
                return null;
            }
            return Util.formatDate((Date)signTime, (String)format);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Wrong signingTime format", 50023);
        }
    }

    public byte[] getMessageDigest(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            return this.getMessageDigest(sigInfo);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Wrong digest format", 50023);
        }
    }

    private byte[] getMessageDigest(SignerInformation signer) {
        Attribute attr;
        AttributeTable atab = signer.getSignedAttributes();
        byte[] result = null;
        if (atab != null && (attr = atab.get(CMSAttributes.messageDigest)) != null) {
            ASN1OctetString t = (ASN1OctetString)attr.getAttrValues().getObjectAt(0).toASN1Primitive();
            result = t.getOctets();
        }
        return result;
    }

    private Date getSignatureTime(SignerInformation signer) {
        Attribute attr;
        AttributeTable atab = signer.getSignedAttributes();
        Date result = null;
        if (atab != null && (attr = atab.get(CMSAttributes.signingTime)) != null) {
            Time t = Time.getInstance((Object)attr.getAttrValues().getObjectAt(0).toASN1Primitive());
            result = t.getDate();
        }
        return result;
    }

    public SignedEnvelope() throws CapiException {
        this(1);
    }

    public SignedEnvelope(int mode) throws CapiException {
        this.checkRange("mode", mode, 1, 2);
        this.status = 0;
        this.mode = mode;
        this.instanceDigest();
    }

    public void setData(byte[] data) throws CapiException {
        this.setData(data, 1);
    }

    public void setData(byte[] data, int type) throws CapiException {
        if (type == 2 && this.mode == 1) {
            throw new CapiException("DIGEST type only for explicit mode", 50021);
        }
        if (this.status > 1) {
            throw new CapiException("Not allowed if already signed", 50002);
        }
        if (data == null) {
            throw new CapiException("Null data", 1001);
        }
        this.type = type;
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
        if (type == 2) {
            if (this.data.length == 20) {
                this.msgDigestToBeUsed = SHA1;
            }
            if (this.data.length == 32) {
                this.msgDigestToBeUsed = SHA256;
            }
        }
        this.status = 1;
    }

    public void addSigner(TokenSpi tk, String alias) throws CapiException {
        this.addSigner(tk, alias, null);
    }

    @Deprecated
    public void addSigner(TokenSpi tk, String alias, boolean withSigningTime) throws CapiException {
        this.addSigner(tk, alias);
    }

    private String stringHeader(String type) throws IOException {
        return "-----BEGIN " + type + "-----" + System.getProperty("line.separator");
    }

    private String stringFooter(String type) throws IOException {
        return System.getProperty("line.separator") + "-----END " + type + "-----";
    }

    public void addSigner(TokenSpi tk, String alias, Date signingTime) throws CapiException {
        X509Certificate cert = null;
        PrivateKey privKey = null;
        try {
            logger.debug("[addSigner] getting credential from token...");
            String base64Cert = tk.getCert(alias);
            byte[] c = base64Cert.getBytes("ISO8859_1");
            ByteArrayInputStream bais = new ByteArrayInputStream(c);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            try {
                cert = (X509Certificate)certificateFactory.generateCertificate(bais);
            }
            catch (CertificateException ce) {
                String pemCert = this.stringHeader("CERTIFICATE") + base64Cert + this.stringFooter("CERTIFICATE");
                c = pemCert.getBytes("ISO8859_1");
                bais = new ByteArrayInputStream(c);
                certificateFactory = CertificateFactory.getInstance("X.509");
                cert = (X509Certificate)certificateFactory.generateCertificate(bais);
                logger.debug("alias cert Subject: " + cert.getSubjectDN().getName());
            }
            logger.debug("...cert ok");
            privKey = tk.getPrivateKey(alias);
            logger.debug("[addSigner] getting credential from token ok");
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
        this.addSigner(cert, privKey, signingTime);
        try {
            this.signerDnVector.add(new Certificate(cert.getEncoded()).getSubjectDN());
            Certificate capicert = new Certificate(cert);
            this.signerCertVector.add(capicert);
            this.signerVerifyVector.add(new VerifyInfo(true));
        }
        catch (CertificateEncodingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
        if (!this.certsVector.contains(cert)) {
            this.certsVector.add(cert);
        }
        logger.debug("Signer added.");
        this.status = 2;
    }

    @Deprecated
    public void addSignerAS(String alias, String PIN, boolean withSigningTime) throws CapiException {
        throw new CapiException("unsupported token type", 1003);
    }

    public void addCertificate(byte[] certificate) throws CapiException {
        if (this.status < 1) {
            throw new CapiException("Data must be set before", 50000);
        }
        X509Certificate cert = new Certificate(certificate).getInternalCert();
        if (!this.certsVector.contains(cert)) {
            this.certsVector.add(cert);
            if (this.status == 3) {
                this.status = 2;
            }
        }
    }

    public void setSignatureTimeStampParams(String TSAserver, String hashAlgorithm, String policy, boolean certReq, HttpsClient https) throws CapiException {
        if (TSAserver == null || hashAlgorithm == null || https == null) {
            throw new CapiException("Null data", 1001);
        }
        if (hashAlgorithm.compareToIgnoreCase("SHA-1") != 0 && hashAlgorithm.compareToIgnoreCase("SHA-256") != 0 && hashAlgorithm.compareToIgnoreCase("MD5") != 0) {
            throw new CapiException("Invalid hash Algorithm", 1002);
        }
        this.TSA = TSAserver;
        this.TSAhashAlgorithm = hashAlgorithm;
        this.TSApolicy = policy;
        this.TSAcertReq = certReq;
        this.TSAhttps = https;
        logger.debug("[setSignatureTimeStampParams] done.");
    }

    public void setSignatureTimeStampParams(String TSAserver, String hashAlgorithm, String policy, boolean certReq, String basicAuthUser, String basicAuthPassword) throws CapiException {
        if (TSAserver == null || hashAlgorithm == null) {
            throw new CapiException("Null data", 1001);
        }
        if (hashAlgorithm.compareToIgnoreCase("SHA-1") != 0 && hashAlgorithm.compareToIgnoreCase("SHA-256") != 0 && hashAlgorithm.compareToIgnoreCase("MD5") != 0) {
            throw new CapiException("Invalid hash Algorithm", 1002);
        }
        this.TSA = TSAserver;
        this.TSAhashAlgorithm = hashAlgorithm;
        this.TSApolicy = policy;
        this.TSAcertReq = certReq;
        this.TSABasicAuthUser = basicAuthUser;
        this.TSABasicAuthPassword = basicAuthPassword;
        this.TSAhttps = null;
        logger.debug("[setSignatureTimeStampParams] done.");
    }

    public void setSignatureTimeStampParams(String hashAlgorithm, String policy, boolean certReq, DTSClient client) throws CapiException {
        if (client == null) {
            throw new CapiException("Null DTSClient", 1001);
        }
        this.TSAhashAlgorithm = hashAlgorithm;
        this.TSApolicy = policy;
        this.TSAcertReq = certReq;
        this.TSAClient = client;
        this.TSA = "TSCLIENT";
        logger.debug("[setSignatureTimeStampParams DTSClient] done.");
    }

    public String getEncoded() throws CapiException {
        if (this.status < 2) {
            throw new CapiException("Data must be signed before", 50001);
        }
        try {
            StringWriter strWr = new StringWriter();
            PEMWriter pemWr = new PEMWriter((Writer)strWr);
            pemWr.writeObject((Object)this.pkcs7SignedData.toASN1Structure());
            pemWr.close();
            return Util.fromPemString((String)strWr.getBuffer().toString(), (boolean)false);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Error encoding signed envelope", 50022);
        }
    }

    public void setDigestAlg(String digestAlg) throws CapiException {
        logger.debug("Setting digest algorithm ...");
        if (digestAlg == null) {
            throw new CapiException("Null data", 1001);
        }
        if (digestAlg.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA1) == 0) {
            logger.debug("set SHA1 digest");
            this.msgDigestToBeUsed = CMSSignedDataGenerator.DIGEST_SHA1;
        } else if (digestAlg.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA256) == 0) {
            logger.debug("set SHA256 digest ");
            this.msgDigestToBeUsed = CMSSignedDataGenerator.DIGEST_SHA256;
        } else {
            throw new CapiException("Invalid digest algorithm", 1002);
        }
    }

    public void includeSigningTime(boolean include) {
        if (logger.isDebugEnabled()) {
            logger.debug("includeSigningTime called ... omit is " + include);
        }
        this.includeSigningTime = include;
    }

    private byte[] getTimeStamp(byte[] message) throws CapiException {
        String tsr = null;
        BigInteger nonce = new BigInteger(64, Util.secureRandom);
        ByteArrayInputStream TSReq = null;
        try {
            if (this.TSAClient != null) {
                return this.TSAClient.timeStamp(this.TSApolicy, this.TSAhashAlgorithm, message, nonce, this.TSAcertReq).toByteArray(false, true);
            }
            Client cli = new Client();
            tsr = cli.getRequest(this.TSApolicy, this.TSAhashAlgorithm, message, false, nonce, this.TSAcertReq);
            logger.debug("[getTimeStamp] generated TSReq");
            TSReq = new ByteArrayInputStream(Util.base64DecodeStr((String)tsr));
        }
        catch (IllegalParamException e) {
            throw new CapiException("Error generating TSReq", 50040);
        }
        catch (CapiException e) {
            logger.debug("[getTimeStamp] Error generating TSReq");
            throw e;
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                throw new CapiException("Error sending TSReq: " + e.getMessage(), 50040);
            }
            throw new CapiException("Error sending TSReq", 50040);
        }
        byte[] signatureTS = null;
        logger.debug("[getTimeStamp] trying send TSA Request ...");
        try {
            if (this.TSAhttps != null) {
                signatureTS = this.TSAhttps.doPost(this.TSA, "application/timestamp-query", (InputStream)TSReq, null);
            } else {
                HTTP_URLConnection u = new HTTP_URLConnection();
                signatureTS = u.doPost(this.TSA, "application/timestamp-query", Util.base64DecodeStr((String)tsr), this.TSABasicAuthUser, this.TSABasicAuthPassword);
            }
        }
        catch (CapiException c) {
            logger.debug("[getTimeStamp] Error sending TSReq");
            throw c;
        }
        catch (Exception c) {
            c.printStackTrace();
            logger.debug("[getTimeStamp] Error sending TSReq");
            throw new CapiException("Exception posting TSReq using HTTP_URLConnection: " + c.getMessage(), 91007);
        }
        if (signatureTS == null || signatureTS.length == 0) {
            throw new CapiException("Null response from TSA", 50040);
        }
        logger.debug("[getTimeStamp] received Time Stamp Token form TSA.");
        return signatureTS;
    }

    private Attribute getTSUnsignedAttribute(byte[] tstByteArray) throws CapiException {
        try {
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(tstByteArray));
            ContentInfo ci = ContentInfo.getInstance((Object)extIn.readObject());
            Attribute attr = new Attribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Set)new DERSet((ASN1Encodable)ci));
            return attr;
        }
        catch (Exception x) {
            logger.debug(x.getMessage(), (Throwable)x);
            throw new CapiException("Error adding signature Time Stamp Token", 50040);
        }
    }

    private SignerInformation setSignatuteTS(Attribute attr, SignerInformation currSI) {
        ASN1EncodableVector hashTabAtt;
        AttributeTable unsignedAttr = currSI.getUnsignedAttributes();
        if (unsignedAttr != null) {
            logger.debug("removing existing TimeStampToken unsignedAttributes ... ");
            Hashtable ht = unsignedAttr.toHashtable();
            ht.remove(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            logger.debug("adding TS attribute to existing unsignedAttributes ... ");
            hashTabAtt = new AttributeTable(ht).toASN1EncodableVector();
        } else {
            hashTabAtt = new ASN1EncodableVector();
        }
        hashTabAtt.add((ASN1Encodable)attr);
        SignerInformation tmpSI = SignerInformation.replaceUnsignedAttributes((SignerInformation)currSI, (AttributeTable)new AttributeTable(hashTabAtt));
        return tmpSI;
    }

    private void addSigner(X509Certificate x509Cert, PrivateKey privateKey, Date signTime) throws CapiException {
        MessageDigest selectedMessageDigest = this.msgDigest;
        Attribute attr = null;
        ASN1EncodableVector hashTabAtt = new ASN1EncodableVector();
        logger.debug("Adding signer ...");
        IssuerSerial issSerial = null;
        try {
            issSerial = new IssuerSerial(new GeneralNames(new GeneralName(JcaX500NameUtil.getIssuer((X509Certificate)x509Cert))), new ASN1Integer(x509Cert.getSerialNumber()));
        }
        catch (Exception e1) {
            throw new CapiException("Exception creating IssuerSerial", 50040);
        }
        if (this.msgDigestToBeUsed.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA1) == 0) {
            logger.debug("using SHA1 digest ...");
            try {
                this.msgDigest.reset();
                ESSCertID essCertid = new ESSCertID(this.msgDigest.digest(x509Cert.getEncoded()), issSerial);
                attr = new Attribute(SignedData.id_aa_signingCertificate, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificate(essCertid)));
                hashTabAtt.add((ASN1Encodable)attr);
            }
            catch (Exception e) {
                throw new CapiException("Exception creating id_aa_signingCertificate.", 50040);
            }
        } else if (this.msgDigestToBeUsed.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA256) == 0) {
            logger.debug("using SHA256 digest ...");
            selectedMessageDigest = this.msgDigest256;
            try {
                this.msgDigest256.reset();
                ESSCertIDv2 essCertidv2 = new ESSCertIDv2(new AlgorithmIdentifier(new ASN1ObjectIdentifier(CMSSignedDataGenerator.DIGEST_SHA256)), this.msgDigest256.digest(x509Cert.getEncoded()), issSerial);
                ESSCertIDv2[] essCertArray = new ESSCertIDv2[]{essCertidv2};
                attr = new Attribute(SignedData.id_aa_signingCertificateV2, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificateV2(essCertArray)));
                hashTabAtt.add((ASN1Encodable)attr);
            }
            catch (Exception e) {
                throw new CapiException("Exception creating id_aa_signingCertificate.", 50040);
            }
        } else {
            throw new CapiException("Invalid digest algorithm", 1002);
        }
        CMSSignedDataGenerator pkcs7SignedDataGen = null;
        try {
            pkcs7SignedDataGen = new CMSSignedDataGenerator();
            if (!this.isCounterSignedEnv) {
                logger.debug("this is a signature->Content type in signed attribute");
                attr = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.7.1")));
                hashTabAtt.add((ASN1Encodable)attr);
            } else {
                logger.debug("this is a countersignature->No content type in signed attribute");
            }
            if (this.includeSigningTime) {
                if (signTime != null) {
                    attr = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(signTime)));
                    hashTabAtt.add((ASN1Encodable)attr);
                } else {
                    attr = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(new Date())));
                    hashTabAtt.add((ASN1Encodable)attr);
                }
            }
            if (this.type == 2) {
                byte[] digest = this.data;
                attr = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(digest)));
                hashTabAtt.add((ASN1Encodable)attr);
            } else {
                attr = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(selectedMessageDigest.digest(this.data))));
                hashTabAtt.add((ASN1Encodable)attr);
            }
            logger.debug("pkcs7SignedDataGen.addSigner ...");
            String sigAlg = "SHA256WithRSAEncryption";
            if (this.msgDigestToBeUsed.compareToIgnoreCase(SHA256) != 0) {
                sigAlg = "SHA1WithRSAEncryption";
            }
            Certificate cert = new Certificate(x509Cert);
            ContentSigner contentSigner = null;
            contentSigner = cert.isRsVerified() ? new VerRsContentSignerBuilder(sigAlg).setProvider(ProvUtils.retrieveBestProviderForKey((PrivateKey)privateKey)).build(privateKey) : new JcaContentSignerBuilder(sigAlg).setProvider(ProvUtils.retrieveBestProviderForKey((PrivateKey)privateKey)).build(privateKey);
            DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            JcaSignerInfoGeneratorBuilder jtemp = new JcaSignerInfoGeneratorBuilder(dcp);
            AttributeTable signedAttributesTable = new AttributeTable(hashTabAtt);
            signedAttributesTable.toASN1EncodableVector();
            SimpleAttributeTableGenerator signedAttributeGenerator = new SimpleAttributeTableGenerator(signedAttributesTable);
            SignerInfoGeneratorBuilder signerInfoBuilder = new SignerInfoGeneratorBuilder(dcp);
            signerInfoBuilder.setSignedAttributeGenerator((CMSAttributeTableGenerator)signedAttributeGenerator);
            SignerInfoGenerator sigenerator = signerInfoBuilder.build(contentSigner, (X509CertificateHolder)new JcaX509CertificateHolder(x509Cert));
            pkcs7SignedDataGen.addSignerInfoGenerator(sigenerator);
            logger.debug("pkcs7SignedDataGen.addSigner done.");
            Vector<X509Certificate> v = new Vector<X509Certificate>();
            v.addElement(x509Cert);
            JcaCertStore cStore = new JcaCertStore(v);
            pkcs7SignedDataGen.addCertificates((Store)cStore);
            logger.debug("pkcs7SignedDataGen.generate ...");
            CMSSignedData signedData = null;
            if (this.type == 2) {
                signedData = pkcs7SignedDataGen.generate((CMSTypedData)new CMSAbsentContent(), false);
            } else if (this.mode == 2) {
                signedData = pkcs7SignedDataGen.generate((CMSTypedData)new CMSAbsentContent(), false);
            } else {
                CMSProcessableByteArray content = new CMSProcessableByteArray(this.data);
                signedData = this.isCounterSignedEnv ? pkcs7SignedDataGen.generate((CMSTypedData)new CMSAbsentContent(), false) : pkcs7SignedDataGen.generate((CMSTypedData)content, true);
            }
            logger.debug("pkcs7SignedDataGen.generate done.");
            SignerInformationStore sig_infos = signedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector<SignerInformation> signerInformVector = new Vector<SignerInformation>(signerColl);
            SignerInformation newSigner = (SignerInformation)signerInformVector.elementAt(0);
            if (this.TSA != null) {
                logger.debug("Signature TimeStampToken adding..");
                byte[] ts = this.getTimeStamp(newSigner.getSignature());
                TimeStampToken tsk = new TimeStampToken(ts);
                byte[] tstByteArray = tsk.toByteArray(false, true);
                attr = this.getTSUnsignedAttribute(tstByteArray);
                newSigner = this.setSignatuteTS(attr, newSigner);
                signerInformVector.set(0, newSigner);
                signedData = CMSSignedData.replaceSigners((CMSSignedData)signedData, (SignerInformationStore)new SignerInformationStore(signerInformVector));
            }
            if (this.pkcs7SignedData != null && this.pkcs7SignedData.getSignerInfos().size() > 0) {
                signerColl = this.pkcs7SignedData.getSignerInfos().getSigners();
                newSigner = (SignerInformation)signedData.getSignerInfos().getSigners().toArray()[0];
                signerColl.add(newSigner);
                this.pkcs7SignedData = CMSSignedData.replaceSigners((CMSSignedData)this.pkcs7SignedData, (SignerInformationStore)new SignerInformationStore(signerColl));
                Store oldCertColl = this.pkcs7SignedData.getCertificates();
                Collection oldCollection = oldCertColl.getMatches((Selector)newSigner.getSID());
                if (oldCollection.isEmpty()) {
                    Collection newCertificates = signedData.getCertificates().getMatches(null);
                    Collection oldCertificates = oldCertColl.getMatches(null);
                    oldCertificates.addAll(newCertificates);
                    JcaCertStore newStore = new JcaCertStore(oldCertificates);
                    this.pkcs7SignedData = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)this.pkcs7SignedData, (Store)newStore, null, null);
                }
            } else {
                this.pkcs7SignedData = signedData;
            }
            logger.debug("Signer added.");
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new CapiException("Internal error: " + ex.getMessage(), 1003, (Throwable)ex);
        }
    }

    private void checkRange(String param_name, int val, int fromval, int toval) throws CapiException {
        if (val < fromval || val > toval) {
            throw new CapiException("Parameter " + param_name + " value ( " + val + " ) is out of the range allowed [" + fromval + " : " + toval + "]", 1002);
        }
    }

    public SignedEnvelope(byte[] env1, byte[] env2) throws CapiException {
        this(env2);
        SignedEnvelope se1 = new SignedEnvelope(env1);
        byte[] dataor1 = se1.getData();
        byte[] dataor2 = this.getData();
        String[] signers1 = se1.listSigners();
        String[] signers2 = this.listSigners();
        if (dataor1 != null && dataor2 != null) {
            String s1 = new String(dataor1);
            String s2 = new String(dataor2);
            if (s1.compareTo(s2) != 0) {
                System.out.println("-- contenuti non uguali --");
                throw new CapiException("Parameter is wrong", 1002);
            }
            try {
                System.out.println("-- contenuti uguali --");
                System.out.println("-- creare un ogetto pkcs7 uguale ad env 1 --");
                Collection s2Coll = this.pkcs7SignedData.getSignerInfos().getSigners();
                Collection s1Coll = se1.pkcs7SignedData.getSignerInfos().getSigners();
                s2Coll.addAll(s1Coll);
                this.pkcs7SignedData = CMSSignedData.replaceSigners((CMSSignedData)this.pkcs7SignedData, (SignerInformationStore)new SignerInformationStore(s2Coll));
                Store cc = this.pkcs7SignedData.getCertificates();
                Collection c2Coll = cc.getMatches(null);
                Store se1Certs = se1.pkcs7SignedData.getCertificates();
                Collection c1Coll = se1Certs.getMatches(null);
                c2Coll.addAll(c1Coll);
                JcaCertStore newStore = new JcaCertStore(c2Coll);
                this.pkcs7SignedData = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)this.pkcs7SignedData, (Store)newStore, null, null);
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Internal error", 50050);
            }
        } else {
            System.out.println("-- contenuti non uguali --");
            throw new CapiException("Parameter is wrong", 1002);
        }
        logger.debug("signer info and certificates added...");
    }

    public SignedEnvelope(String env1, String env2, byte[] message) throws CapiException {
        this(env2, message);
        SignedEnvelope se1 = new SignedEnvelope(env1, message);
        byte[] dataor1 = se1.getData();
        byte[] dataor2 = this.getData();
        String[] signers1 = se1.listSigners();
        String[] signers2 = this.listSigners();
        if (dataor1 != null && dataor2 != null) {
            String s1 = new String(dataor1);
            String s2 = new String(dataor2);
            if (s1.compareTo(s2) != 0) {
                System.out.println("-- contenuti non uguali --");
                throw new CapiException("Parameter is wrong", 1002);
            }
            try {
                System.out.println("-- contenuti uguali --");
                System.out.println("-- creare un ogetto pkcs7 uguale ad env 1 --");
                Collection sc2 = this.pkcs7SignedData.getSignerInfos().getSigners();
                Collection sc1 = se1.pkcs7SignedData.getSignerInfos().getSigners();
                sc2.addAll(sc1);
                this.pkcs7SignedData = CMSSignedData.replaceSigners((CMSSignedData)this.pkcs7SignedData, (SignerInformationStore)new SignerInformationStore(sc2));
                Store cc = this.pkcs7SignedData.getCertificates();
                Collection cc2Coll = cc.getMatches(null);
                Store se1Certs = se1.pkcs7SignedData.getCertificates();
                Collection cc1Coll = se1Certs.getMatches(null);
                cc2Coll.addAll(cc1Coll);
                JcaCertStore newStore = new JcaCertStore(cc2Coll);
                this.pkcs7SignedData = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)this.pkcs7SignedData, (Store)newStore, null, null);
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Internal error", 50050);
            }
        } else {
            System.out.println("-- contenuti non uguali --");
            throw new CapiException("Parameter is wrong", 1002);
        }
        logger.debug("signer info and certificates added...");
    }

    protected SignerInformationStore getSignersInfos() throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        try {
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            return sig_infos;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
    }

    public CounterSignedEnvelope getCounterSignature(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
        Collection signerColl = sig_infos.getSigners();
        Vector signerInformVector = new Vector(signerColl);
        if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            SignerInformation sInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            SignerInformationStore csStore = sInfo.getCounterSignatures();
            CounterSignedEnvelope ret = new CounterSignedEnvelope();
            ret.certsVector = this.certsVector;
            ret.setData(sInfo.getSignature());
            ret.parseCounterSigners(csStore, signerInfoIndex);
            return ret;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Internal error", 50050);
        }
    }

    void parseCounterSigners(SignerInformationStore csStore, int signerInfoIndex) throws CapiException {
        if (this.status < 1) {
            throw new CapiException("Data must be set before", 50000);
        }
        CMSSignedDataGenerator pkcs7SignedDataGen = new CMSSignedDataGenerator();
        CMSProcessableByteArray content = new CMSProcessableByteArray(this.data);
        if (!this.signerDnVector.isEmpty()) {
            this.signerDnVector.clear();
        }
        if (!this.signerVerifyVector.isEmpty()) {
            this.signerVerifyVector.clear();
        }
        try {
            if (csStore == null || csStore.size() == 0) {
                logger.debug("No CounterSignatures already present for signer " + signerInfoIndex);
                this.pkcs7SignedData = pkcs7SignedDataGen.generate((CMSTypedData)content, false);
            } else {
                logger.debug("Found " + csStore.size() + " CounterSignatures for signer " + signerInfoIndex);
                Collection csignerColl = csStore.getSigners();
                Vector csignerInformVector = new Vector(csignerColl);
                JcaCertStore certStore = new JcaCertStore(this.certsVector);
                pkcs7SignedDataGen.addCertificates((Store)certStore);
                this.pkcs7SignedData = pkcs7SignedDataGen.generate((CMSTypedData)content, false);
                this.pkcs7SignedData = CMSSignedData.replaceSigners((CMSSignedData)this.pkcs7SignedData, (SignerInformationStore)csStore);
                ArrayList<CapiSignerInformation> tmpcsignerColl = new ArrayList<CapiSignerInformation>();
                for (SignerInformation information : this.pkcs7SignedData.getSignerInfos().getSigners()) {
                    tmpcsignerColl.add(new CapiSignerInformation(information, this.pkcs7SignedData.getSignedContent()));
                }
                Vector tmpcsignerInformVector = new Vector(tmpcsignerColl);
                for (int i = 0; i < tmpcsignerInformVector.size(); ++i) {
                    CapiSignerInformation cs = (CapiSignerInformation)((Object)tmpcsignerInformVector.elementAt(i));
                    SignedEnvelope.verifySigner(cs, (Store)certStore, this.signerDnVector, this.signerCertVector, this.signerVerifyVector, null);
                }
            }
            this.status = 3;
        }
        catch (NoSuchAlgorithmException x) {
            logger.debug(x.getMessage(), (Throwable)x);
            throw new CapiException("No implementation for signature algorithm:", 50050);
        }
        catch (Exception e1) {
            logger.debug(e1.getMessage(), (Throwable)e1);
            throw new CapiException(e1.getMessage(), 50050);
        }
    }

    private boolean contentTypeIsInSignedAttribute(SignerInformation cs) {
        if (cs.getSignedAttributes() != null && cs.getSignedAttributes().get(CMSAttributes.contentType) != null) {
            logger.debug("counterSigner Signed Attribute Table has contentType ...");
            return true;
        }
        return false;
    }

    public void setCounterSignature(int signerInfoIndex, CounterSignedEnvelope counterSig) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (counterSig == null) {
            throw new CapiException("CounterSignedEnvelope must be valid and signed", 1001);
        }
        SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
        Collection signerColl = sig_infos.getSigners();
        if (signerInfoIndex < 0 || signerInfoIndex >= signerColl.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            Collection signedCertColl = this.pkcs7SignedData.getCertificates().getMatches(null);
            Collection countersignedCertColl = counterSig.pkcs7SignedData.getCertificates().getMatches(null);
            Vector cscertVector = new Vector(countersignedCertColl);
            for (int i = 0; i < cscertVector.size(); ++i) {
                if (signedCertColl.contains(cscertVector.elementAt(i))) continue;
                signedCertColl.add(cscertVector.elementAt(i));
            }
            JcaCertStore cStore = new JcaCertStore(signedCertColl);
            this.pkcs7SignedData = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)this.pkcs7SignedData, (Store)cStore, null, null);
            SignerInformationStore cSigners = counterSig.getSignersInfos();
            logger.debug("adding " + cSigners.size() + " countersignatures to signer " + signerInfoIndex);
            Vector<SignerInformation> signerInformVector = new Vector<SignerInformation>(signerColl);
            SignerInformation currSI = (SignerInformation)signerInformVector.get(signerInfoIndex);
            AttributeTable unsignedAttr = currSI.getUnsignedAttributes();
            if (unsignedAttr != null) {
                SignerInformation tmpSI;
                logger.debug("replacing CS attribute ... ");
                Hashtable ht = unsignedAttr.toHashtable();
                ht.remove(CMSAttributes.counterSignature);
                AttributeTable newUA = new AttributeTable(ht);
                currSI = tmpSI = SignerInformation.replaceUnsignedAttributes((SignerInformation)currSI, (AttributeTable)newUA);
            }
            SignerInformation newSI = SignerInformation.addCounterSigners((SignerInformation)currSI, (SignerInformationStore)cSigners);
            signerInformVector.set(signerInfoIndex, newSI);
            this.pkcs7SignedData = CMSSignedData.replaceSigners((CMSSignedData)this.pkcs7SignedData, (SignerInformationStore)new SignerInformationStore(signerInformVector));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CounterSignature internal error", 50050);
        }
    }

    public boolean hasCounterSignature(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        Collection coll = this.pkcs7SignedData.getSignerInfos().getSigners();
        Vector v = new Vector(coll);
        SignerInformation sInfo = (SignerInformation)v.elementAt(signerInfoIndex);
        SignerInformationStore sStore = sInfo.getCounterSignatures();
        return sStore != null && sStore.size() > 0;
    }

    public void setSignatureTimeStampToken(int signerInfoIndex, TimeStampToken tst) throws CapiException, IOException {
        if (tst == null) {
            throw new CapiException("Time Stamp Token is null", 1001);
        }
        byte[] tstByteArray = tst.toByteArray(false, true);
        this.setSignatureTimeStampToken(signerInfoIndex, tstByteArray);
    }

    public void setSignatureTimeStampToken(int signerInfoIndex, byte[] tst) throws CapiException {
        if (tst == null) {
            throw new CapiException("Time Stamp Token is null", 1001);
        }
        Attribute attr = this.getTSUnsignedAttribute(tst);
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (signerInfoIndex < 0 || signerInfoIndex >= this.signerDnVector.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
        Collection signerColl = sig_infos.getSigners();
        if (signerInfoIndex < 0 || signerInfoIndex >= signerColl.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            Vector<SignerInformation> signerInformVector = new Vector<SignerInformation>(signerColl);
            SignerInformation currSI = (SignerInformation)signerInformVector.get(signerInfoIndex);
            currSI = this.setSignatuteTS(attr, currSI);
            signerInformVector.set(signerInfoIndex, currSI);
            this.pkcs7SignedData = CMSSignedData.replaceSigners((CMSSignedData)this.pkcs7SignedData, (SignerInformationStore)new SignerInformationStore(signerInformVector));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("CounterSignature internal error", 50050);
        }
    }

    public byte[] getSignatureTimeStampToken(int signerInfoIndex) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Attribute attr;
            SignerInformationStore sig_infos = this.pkcs7SignedData.getSignerInfos();
            Collection signerColl = sig_infos.getSigners();
            Vector signerInformVector = new Vector(signerColl);
            if (signerInfoIndex < 0 || signerInfoIndex >= signerInformVector.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation sigInfo = (SignerInformation)signerInformVector.elementAt(signerInfoIndex);
            AttributeTable atab = sigInfo.getUnsignedAttributes();
            byte[] result = null;
            if (atab != null && (attr = atab.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) != null) {
                ContentInfo t = ContentInfo.getInstance((Object)attr.getAttrValues().getObjectAt(0).toASN1Primitive());
                result = t.getEncoded("DER");
            }
            return result;
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Wrong timeStampToken format", 50023);
        }
    }

    public CadesSignedDataProxy getSignedDataProxy() {
        return new CadesSignedDataProxy(this.pkcs7SignedData);
    }
}

