/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms.utils;

import it.actalis.ellips.capi.cms.encrypt.EncryptEnvelopeGenerator;
import it.actalis.ellips.capi.cms.encrypt.EncryptEnvelopeOptions;
import it.actalis.ellips.capi.cms.encrypt.EncryptionAlgorithm;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.TokenHelper;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pkcs7.StreamEncryptedEnvelope;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;

public class EncryptionUtils {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static void encryptSafeEnvelop(InputHandler in, OutputHandler out, X509Certificate[] certificates, EncryptionAlgorithm encryptionAlgorithm) throws CapiException, Throwable {
        try {
            EncryptEnvelopeOptions options = new EncryptEnvelopeOptions();
            if (certificates.length == 0) {
                throw new Throwable("No encryption certificates found");
            }
            options.setRecipients(Arrays.asList(certificates));
            if (encryptionAlgorithm == null) {
                encryptionAlgorithm = EncryptionAlgorithm.DES_EDE3_CBC;
            }
            options.setAlgorithm(encryptionAlgorithm);
            options.setInput(in);
            options.setOutput(out);
            EncryptEnvelopeGenerator generator = new EncryptEnvelopeGenerator();
            generator.encrypt(options);
        }
        catch (CapiException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decryptSafeEnvelop(InputHandler in, OutputHandler out, TokenSpi token) throws CapiException, IOException {
        boolean bDecrypted = false;
        ArrayList<String> enumAlias = new ArrayList<String>(Arrays.asList(TokenHelper.listObjects((TokenSpi)token, null, (byte)4)));
        InputStream is = null;
        OutputStream os = null;
        try {
            is = in.getInputAsNewStream();
            os = out.getAsOutputStream();
            StreamEncryptedEnvelope see = new StreamEncryptedEnvelope(is);
            Map<String, X500Name> recipients = see.listRecipients();
            for (String alias : enumAlias) {
                try {
                    String certificateId = new Certificate(token.getCert(alias).getBytes()).getSerialNumber().toString();
                    if (!recipients.containsKey(certificateId)) continue;
                    bDecrypted = see.decrypt(token, alias, os);
                    break;
                }
                catch (CapiException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                throw new IOException(ex.getMessage());
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ex) {
                throw new IOException(ex.getMessage());
            }
        }
        return bDecrypted;
    }
}

