/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms.utils;

import it.actalis.ellips.capi.core.Base64OutputStream;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.Streams;

public class CAdESUtils {
    public static void bundleP7Signature(InputStream detachedSignature, InputStream unsignedStreamData, OutputStream bundledStreamData, boolean binary) throws CapiException {
        OutputStream dataOut = null;
        CMSSignedData sd = null;
        try {
            if (binary) {
                sd = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray("qualsiasi".getBytes()), detachedSignature);
            } else {
                byte[] p7ByteArr = null;
                try {
                    p7ByteArr = Streams.readAll((InputStream)detachedSignature);
                    byte[] derp7ByteArr = Base64.decode((byte[])p7ByteArr);
                    sd = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray("qualsiasi".getBytes()), derp7ByteArr);
                }
                catch (Exception ex) {
                    PEMParser pemReader = new PEMParser((Reader)new StringReader(new String(p7ByteArr)));
                    try {
                        ContentInfo cInfo = (ContentInfo)pemReader.readObject();
                        if (cInfo == null) {
                            throw new CapiException("Envelope format unknown or not implemented", 50021, (Throwable)ex);
                        }
                        if (!cInfo.getContentType().equals((ASN1Primitive)PKCSObjectIdentifiers.signedData)) {
                            throw new CapiException("Not a valid PKCS#7 signed-data object - wrong header " + cInfo.getContentType().getId(), 50021, (Throwable)ex);
                        }
                        sd = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray("qualsiasi".getBytes()), cInfo);
                    }
                    catch (Exception ex2) {
                        throw new CapiException("Envelope format unknown or not implemented", 50021, (Throwable)ex2);
                    }
                }
            }
            if (sd == null) {
                throw new CapiException("Envelope format unknown or not implemented", 50021);
            }
            CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator();
            gen.addSigners(sd.getSignerInfos());
            gen.addCertificates(sd.getCertificates());
            dataOut = gen.open(bundledStreamData, true);
            Streams.pipeAll((InputStream)unsignedStreamData, (OutputStream)dataOut);
        }
        catch (Exception ex) {
            throw new CapiException(ex.getMessage(), 1003, (Throwable)ex);
        }
        finally {
            if (dataOut != null) {
                try {
                    dataOut.close();
                }
                catch (IOException iOException) {}
            }
            try {
                detachedSignature.close();
            }
            catch (IOException iOException) {}
            try {
                unsignedStreamData.close();
            }
            catch (IOException iOException) {}
            try {
                bundledStreamData.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void unbundleP7Signature(InputStream bundledStreamData, OutputStream detachedSignature, OutputStream unsignedStreamData, boolean binary) throws CapiException {
        CMSSignedData sd = null;
        try {
            byte[] p7ByteArr = Streams.readAll((InputStream)bundledStreamData);
            if (binary) {
                sd = new CMSSignedData(p7ByteArr);
            } else {
                try {
                    byte[] derp7ByteArr = Base64.decode((byte[])p7ByteArr);
                    sd = new CMSSignedData(derp7ByteArr);
                }
                catch (Exception ex) {
                    PEMParser pemReader = new PEMParser((Reader)new StringReader(new String(p7ByteArr)));
                    try {
                        ContentInfo cInfo = (ContentInfo)pemReader.readObject();
                        if (cInfo == null) {
                            throw new CapiException("Envelope format unknown or not implemented", 50021, (Throwable)ex);
                        }
                        if (!cInfo.getContentType().equals((ASN1Primitive)PKCSObjectIdentifiers.signedData)) {
                            throw new CapiException("Not a valid PKCS#7 signed-data object - wrong header " + cInfo.getContentType().getId(), 50021, (Throwable)ex);
                        }
                        sd = new CMSSignedData(cInfo);
                    }
                    catch (Exception ex2) {
                        throw new CapiException("Envelope format unknown or not implemented", 50021, (Throwable)ex2);
                    }
                }
            }
            if (sd == null) {
                throw new CapiException("Envelope format unknown or not implemented", 50021);
            }
            CMSTypedData cp = sd.getSignedContent();
            cp.write(unsignedStreamData);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            gen.addSigners(sd.getSignerInfos());
            gen.addCertificates(sd.getCertificates());
            CMSSignedData signedDetached = gen.generate(cp, false);
            detachedSignature.write(signedDetached.getEncoded());
        }
        catch (Exception ex) {
            throw new CapiException(ex.getMessage(), 1003, (Throwable)ex);
        }
        finally {
            try {
                detachedSignature.close();
            }
            catch (IOException iOException) {}
            try {
                unsignedStreamData.close();
            }
            catch (IOException iOException) {}
            try {
                bundledStreamData.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void unbundleStreamP7Signature(InputStream bundledStreamData, OutputStream detachedSignature, OutputStream unsignedStreamData, boolean binary) throws CapiException {
        EllipsLogger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        try {
            if (bundledStreamData == null) {
                throw new CapiException("Null data", 1001);
            }
            try {
                DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
                CMSSignedDataParser pkcs7SignedData = new CMSSignedDataParser(dcp, bundledStreamData);
                logger.debug("parsed implicit signed data ok");
                CMSTypedStream cmsTypedS = pkcs7SignedData.getSignedContent();
                if (cmsTypedS == null) {
                    logger.debug("no content found into envelope... is detached...");
                    throw new CapiException("Envelope is detached", 50000);
                }
                InputStream is = cmsTypedS.getContentStream();
                if (is == null) {
                    logger.debug("no content found into envelope... is detached...");
                    throw new CapiException("Envelope is detached", 50000);
                }
                if (unsignedStreamData != null) {
                    logger.debug("parsed implicit: copying data...");
                    Streams.pipeAll((InputStream)is, (OutputStream)unsignedStreamData);
                } else {
                    cmsTypedS.drain();
                    logger.debug("parsed implicit: skipping data...");
                }
                logger.debug("parsed implicit: data ok");
                logger.debug("saving envelope ...");
                CMSSignedDataStreamGenerator pkcs7SignedDataGen = null;
                OutputStream b64Stream = null;
                try {
                    pkcs7SignedDataGen = new CMSSignedDataStreamGenerator();
                    if (pkcs7SignedData == null || pkcs7SignedData.getSignerInfos().size() <= 0) {
                        throw new CapiException("Error parsing envelope: no signers", 50022);
                    }
                    pkcs7SignedDataGen.addSigners(pkcs7SignedData.getSignerInfos());
                    pkcs7SignedDataGen.addCertificates(pkcs7SignedData.getCertificates());
                }
                catch (Exception x) {
                    logger.debug(x.getMessage(), (Throwable)x);
                    throw new CapiException("Error parsing signed envelope", 50040);
                }
                try {
                    OutputStream copyData = null;
                    if (!binary) {
                        b64Stream = new Base64OutputStream(detachedSignature, true);
                    }
                    copyData = pkcs7SignedDataGen.open(!binary ? b64Stream : detachedSignature, false);
                    copyData.close();
                    logger.debug("Envelope saved.");
                }
                catch (Exception x) {
                    logger.debug(x.getMessage(), (Throwable)x);
                    throw new CapiException("Error encoding signed envelope", 50040);
                }
                finally {
                    try {
                        if (b64Stream != null) {
                            b64Stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        detachedSignature.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (CapiException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (CMSException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Envelope format unknown or not implemented", 50023);
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Error writing envelope content", 50025);
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new CapiException("Internal error", 50050);
            }
        }
        catch (CapiException e) {
            throw e;
        }
        finally {
            try {
                bundledStreamData.close();
            }
            catch (Exception exception) {}
            try {
                if (unsignedStreamData != null) {
                    unsignedStreamData.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

