/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms.parser;

import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.ParserUtils;
import esecurity.validator.parser.utils.TSTUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.TempFileOutputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsa.TimeStampAndCRL;
import it.actalis.ellips.capi.tsa.TimeStampedData;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.slf4j.Logger;

public class TSDParser
extends SignatureParser {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private DateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");

    public TSDParser(SignatureParserBuilder builder) {
        super(builder);
        this.df.setTimeZone(Constants.DEFAULT_TIMEZONE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ParsedTransientDocument parse(InputHandler source, EventHandlerSelector fileSelector, NetworkConfig config, TimeZone timeZone, File tmpFolder) throws ParsingException {
        OutputHandler oh;
        InputHandler ih;
        ParsedTransientDocument doc;
        block13: {
            doc = new ParsedTransientDocument(source);
            ih = null;
            oh = null;
            if (timeZone != null) {
                this.df.setTimeZone(timeZone);
            }
            TimeStampedData timeStampedData = null;
            try {
                timeStampedData = new TimeStampedData(source.getInputAsNewStream(), source.getName());
                if (timeStampedData.getContent() == null) {
                    throw new IOException("Empty Content");
                }
                byte[] timeStampedData_MetaData = null;
                try {
                    timeStampedData_MetaData = timeStampedData.getMetaData();
                }
                catch (Exception e1) {
                    logger.error(e1.getMessage(), (Throwable)e1);
                }
                boolean isTsdMetadHashProtected = false;
                try {
                    isTsdMetadHashProtected = timeStampedData.getHashProtected();
                }
                catch (Exception e1) {
                    logger.error(e1.getMessage(), (Throwable)e1);
                }
                oh = DataHandlerBuilder.get().setTemp((File)TmpFileUtils.createTempFile((String)"sub_", (String)".data", (File)tmpFolder)).buildOutput();
                OutputStream os = oh.getAsOutputStream();
                if (isTsdMetadHashProtected) {
                    os.write(timeStampedData_MetaData);
                }
                InputHandler originalDocumentBytes = null;
                String id_sub_doc = this.calculateSubDoc(doc.getShortName());
                originalDocumentBytes = timeStampedData.getDataURI() != null ? DataHandlerBuilder.get().setUrl(new URL(timeStampedData.getDataURI())).setUrlNetConf(config).setName(id_sub_doc).buildInput() : DataHandlerBuilder.get().setInputStream(timeStampedData.getContent()).setName(id_sub_doc).buildInput();
                Util.copyStream((InputStream)originalDocumentBytes.getInputAsNewStream(), (OutputStream)os);
                TransientDocument subDoc = ParserUtils.parseDoc((InputHandler)originalDocumentBytes, (EventHandlerSelector)fileSelector, (NetworkConfig)config, (TimeZone)this.df.getTimeZone(), (File)tmpFolder);
                doc.addRefDoc(subDoc);
                os.flush();
                ih = DataHandlerBuilder.get().setTemp(((TempFileOutputHandler)oh).getFile()).buildInput();
                TimeStampAndCRL[] tstEvidences = timeStampedData.getTstEvidence();
                for (int i = 0; i < tstEvidences.length; ++i) {
                    doc.setSigned(true);
                    TimeStampAndCRL tstEvidence = tstEvidences[i];
                    SignatureInformation sig = TSTUtils.tstToVol((TransientDocument)doc, (byte[])tstEvidence.getTimeStampToken(), (InputHandler)ih, (String)subDoc.getId(), (DateFormat)this.df);
                    doc.addSignerInfo(sig);
                }
                if (timeStampedData == null) break block13;
            }
            catch (Exception ex) {
                try {
                    throw new ParsingException("Unable to parse file", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    if (timeStampedData != null) {
                        timeStampedData.free();
                    }
                    Util.closeQuietly(ih);
                    Util.closeQuietly(oh);
                    throw throwable;
                }
            }
            timeStampedData.free();
        }
        Util.closeQuietly((Closeable)ih);
        Util.closeQuietly((Closeable)oh);
        return doc;
    }

    private String calculateSubDoc(String doc) {
        if (doc.lastIndexOf(".") != -1) {
            return doc.substring(0, doc.lastIndexOf("."));
        }
        return doc;
    }
}

