/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms.parser;

import esecurity.validator.bean.RefCertificate;
import esecurity.validator.bean.RefOcsp;
import esecurity.validator.bean.ReferenceDoc;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.parser.utils.CRLUtils;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.TSTUtils;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.pkcs7.CounterSignedEnvelope;
import it.actalis.ellips.capi.pkcs7.StreamSignedEnvelope;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.LinkedList;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.util.Arrays;

public class CadesParserHelper {
    public static void parseCadesEnvelope(TransientDocument doc, TransientDocument subDoc, StreamSignedEnvelope env, EventHandlerSelector fileSelector, DateFormat df, boolean checkDuplicated) throws Exception {
        LinkedList<X509Certificate> certs = env.getSignedDataProxy().getCertificates();
        for (X509Certificate cert : certs) {
            String id = Utils.calculateDigest((InputStream)new ByteArrayInputStream(cert.getEncoded()), (String)Constants.SHA256);
            RefCertificate refCert = new RefCertificate();
            refCert.setId(id);
            refCert.setContent(cert.getEncoded());
            refCert.setCapiCertificate(new Certificate(cert));
            doc.addCert(refCert);
        }
        String[] signers = env.listSigners();
        if (signers != null && signers.length > 0) {
            doc.setSigned(true);
            for (int iSigner = 0; iSigner < signers.length; ++iSigner) {
                SignatureInformation info = null;
                if (checkDuplicated) {
                    info = CadesParserHelper.checkDuplicateSigner(doc, env.getSignedDataProxy().getRawSignature(iSigner));
                }
                boolean hashValid = true;
                if (info == null) {
                    Certificate signerCert;
                    info = new SignatureInformation();
                    info.setSignatureInfo(env.getSignedDataProxy().getRawSignature(iSigner));
                    info.setFormat(SignatureFormat.CADES);
                    info.setContainerFormat(ContainerFormat.SELF);
                    info.setContainsGraphometricInfo(false);
                    if (env.getSignedDataProxy().getSigningTime(iSigner) != null) {
                        info.setSignatureDate(df.format(env.getSignedDataProxy().getSigningTime(iSigner)));
                    }
                    if ((signerCert = env.getSignerCertificate(iSigner)) != null) {
                        byte[] signerCertDecoded = signerCert.getInternalCert().getEncoded();
                        info.setSignerName(signerCert.getName());
                        String refsCertId = Utils.calculateDigest((InputStream)new ByteArrayInputStream(signerCertDecoded), (String)Constants.SHA256);
                        info.setRefsCertId(refsCertId);
                        try {
                            env.verify(iSigner);
                            info.setCorrupted(false);
                        }
                        catch (Exception e) {
                            info.setCorrupted(true);
                            hashValid = env.getSignatureVerificationResult(iSigner).isMessageDigestMatchCalculatedValue();
                        }
                    } else {
                        info.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
                    }
                    CounterSignedEnvelope csenv = env.getCounterSignature(iSigner);
                    if (csenv != null && csenv.listSigners() != null && csenv.listSigners().length > 0) {
                        CadesParserHelper.parseCounterSigner(doc, csenv, info, df);
                    }
                    byte[] tstByte = env.getSignatureTimeStampToken(iSigner);
                    byte[] signByte = env.getSignature(iSigner);
                    if (tstByte != null) {
                        InputHandler signatureInputHandler = DataHandlerBuilder.get().setBytes(signByte).buildInput();
                        info.addTimeStampToken(TSTUtils.tstToVol((TransientDocument)doc, (byte[])tstByte, (InputHandler)signatureInputHandler, (String)"", (DateFormat)df));
                    }
                } else if (env.getSignerCertificate(iSigner) != null) {
                    try {
                        env.verify(iSigner);
                    }
                    catch (Exception e) {
                        info.setCorrupted(true);
                        hashValid = env.getSignatureVerificationResult(iSigner).isMessageDigestMatchCalculatedValue();
                    }
                }
                info.addRefDoc(new ReferenceDoc(subDoc.getId(), hashValid));
                doc.addSignerInfo(info);
            }
        }
        for (RefCertificate rcert : doc.getCerts()) {
            if (certs.contains(rcert.getCapiCertificate().getInternalCert())) continue;
            certs.add(rcert.getCapiCertificate().getInternalCert());
        }
        for (CRL crl : env.getSignedDataProxy().getCRLS()) {
            CRLUtils.addRefCrl((LinkedList)doc.getCrls(), (CRL)crl, certs);
        }
        for (BasicOCSPResp ocsp : env.getSignedDataProxy().getBasicOCSPResponses()) {
            String id = Utils.calculateDigest((InputStream)new ByteArrayInputStream(ocsp.getEncoded()), (String)Constants.SHA256);
            RefOcsp refOcsp = new RefOcsp();
            refOcsp.setId(id);
            refOcsp.setContent(ocsp.getEncoded());
            doc.addOcspresp(refOcsp);
        }
    }

    private static SignatureInformation checkDuplicateSigner(TransientDocument doc, byte[] signerInfo) {
        for (SignatureInformation info : doc.getSignerInfo()) {
            if (!Arrays.areEqual((byte[])info.getSignatureInfo(), (byte[])signerInfo)) continue;
            return info;
        }
        return null;
    }

    private static void parseCounterSigner(TransientDocument doc, CounterSignedEnvelope csEnv, SignatureInformation parentInfo, DateFormat df) throws CapiException, CMSException, IOException, NoSuchAlgorithmException, FileNotFoundException, MalformedURLException, KeyStoreException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        String[] signers = csEnv.listSigners();
        if (signers == null) {
            return;
        }
        for (int iSigner = 0; iSigner < signers.length; ++iSigner) {
            Certificate signerCert;
            SignatureInformation csInfo = new SignatureInformation();
            csInfo.setSignatureInfo(csEnv.getSignedDataProxy().getRawSignature(iSigner));
            csInfo.setCounterSignature(true);
            csInfo.setFormat(SignatureFormat.CADES);
            csInfo.setContainerFormat(ContainerFormat.SELF);
            csInfo.setContainsGraphometricInfo(false);
            if (csEnv.getSignedDataProxy().getSigningTime(iSigner) != null) {
                csInfo.setSignatureDate(df.format(csEnv.getSignedDataProxy().getSigningTime(iSigner)));
            }
            if ((signerCert = csEnv.getSignerCertificate(iSigner)) != null) {
                byte[] signerCertDecoded = signerCert.getDerEncoded();
                csInfo.setSignerName(signerCert.getName());
                String refsCertId = Utils.calculateDigest((InputStream)new ByteArrayInputStream(signerCertDecoded), (String)Constants.SHA256);
                csInfo.setRefsCertId(refsCertId);
                try {
                    csEnv.verify(iSigner);
                    csInfo.setCorrupted(false);
                }
                catch (Exception e) {
                    csInfo.setCorrupted(true);
                }
            } else {
                csInfo.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
            }
            parentInfo.addCounterSignaturesInformation(csInfo);
            CounterSignedEnvelope csenv = csEnv.getCounterSignature(iSigner);
            if (csenv != null && csenv.listSigners().length > 0) {
                CadesParserHelper.parseCounterSigner(doc, csenv, csInfo, df);
            }
            byte[] tstByte = csEnv.getSignatureTimeStampToken(iSigner);
            byte[] signByte = csEnv.getSignature(iSigner);
            if (tstByte == null) continue;
            InputHandler signatureInputHandler = DataHandlerBuilder.get().setBytes(signByte).buildInput();
            csInfo.addTimeStampToken(TSTUtils.tstToVol((TransientDocument)doc, (byte[])tstByte, (InputHandler)signatureInputHandler, (String)"", (DateFormat)df));
        }
    }
}

