/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms;

import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.cms.CadesSignedDataProxy;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.util.CacheOutputStream;
import it.actalis.ellips.capi.signature.SignatureMode;
import it.actalis.ellips.capi.util.ClonerInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;

class CadesSignedDataGeneratorProxy {
    private CMSSignedDataStreamGenerator stream_generator;
    private CMSSignedDataGenerator generator;
    private LinkedList<X509Certificate> certsList = null;
    private LinkedList<X509Certificate> certsListAdditional = null;
    private LinkedList<CRL> crlsList = null;
    private LinkedList<CRL> crlsListAdditional = null;
    private LinkedList<BasicOCSPResp> basicOcspResp = null;
    private LinkedList<BasicOCSPResp> basicOcspRespAdditional = null;
    private LinkedList<OCSPResp> ocspResp = null;
    private CadesSignatureOptions options = null;

    public CadesSignedDataGeneratorProxy(CadesSignatureOptions options, boolean forceder, CadesSignedDataProxy previousSignature, boolean noRebuidSigner) throws Exception {
        this.options = options;
        boolean derEncoding = options.isDerEncoded();
        if (derEncoding || forceder) {
            this.generator = new CMSSignedDataGenerator();
        } else {
            this.stream_generator = new CMSSignedDataStreamGenerator();
        }
        this.certsList = new LinkedList();
        this.certsListAdditional = new LinkedList();
        this.crlsList = new LinkedList();
        this.crlsListAdditional = new LinkedList();
        this.basicOcspResp = new LinkedList();
        this.basicOcspRespAdditional = new LinkedList();
        this.ocspResp = new LinkedList();
        if (previousSignature != null) {
            this.rebuildCades(previousSignature, noRebuidSigner);
        }
    }

    private void rebuildCades(CadesSignedDataProxy previousSignature, boolean noRebuidSigner) throws Exception {
        if (previousSignature != null && previousSignature.getCertificates() != null) {
            for (X509Certificate cert : previousSignature.getCertificates()) {
                this.addCert(cert);
            }
            for (CRL crl : previousSignature.getCRLS()) {
                this.addCRL(crl);
            }
            for (BasicOCSPResp ocsp : previousSignature.getBasicOCSPResponses()) {
                this.addBasicOCSP(ocsp);
            }
            this.ocspResp = previousSignature.getOCSPResponses();
        }
        if (previousSignature != null && previousSignature.getSignerInfos() != null && previousSignature.getSignerInfos().size() > 0 && !noRebuidSigner) {
            this.addSigners(previousSignature.getSignerInfos());
        }
    }

    void addSigners(SignerInformationStore signers) {
        if (this.stream_generator != null) {
            this.stream_generator.addSigners(signers);
        } else {
            this.generator.addSigners(signers);
        }
    }

    void addSignerInfoGenerator(SignerInfoGenerator signerInfoGenerator) {
        if (this.stream_generator != null) {
            this.stream_generator.addSignerInfoGenerator(signerInfoGenerator);
        } else {
            this.generator.addSignerInfoGenerator(signerInfoGenerator);
        }
    }

    void addCert(X509Certificate cert) throws CertificateEncodingException, IOException, CMSException {
        if (!this.certsList.contains(cert)) {
            this.certsList.add(cert);
            if (this.stream_generator != null) {
                this.stream_generator.addCertificate(new X509CertificateHolder(cert.getEncoded()));
            } else {
                this.generator.addCertificate(new X509CertificateHolder(cert.getEncoded()));
            }
        }
    }

    void addCertByAttribute(X509Certificate cert) throws CertificateEncodingException, IOException, CMSException {
        this.addCert(cert);
        if (!this.certsListAdditional.contains(cert)) {
            this.certsListAdditional.add(cert);
        }
    }

    void addCRL(CRL crl) throws CRLException, IOException {
        if (!this.crlsList.contains(crl)) {
            this.crlsList.add(crl);
            if (this.stream_generator != null) {
                this.stream_generator.addCRL(new X509CRLHolder(crl.getInternalCRL().getEncoded()));
            } else {
                this.generator.addCRL(new X509CRLHolder(crl.getInternalCRL().getEncoded()));
            }
        }
    }

    void addCRLByAttribute(CRL crl) throws CRLException, IOException {
        this.addCRL(crl);
        if (!this.crlsListAdditional.contains(crl)) {
            this.crlsListAdditional.add(crl);
        }
    }

    void addBasicOCSP(BasicOCSPResp ocsp) throws IOException, CertificateException, CertificateEncodingException, CMSException {
        if (!this.basicOcspResp.contains(ocsp)) {
            this.basicOcspResp.add(ocsp);
            if (this.stream_generator != null) {
                this.stream_generator.addOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic, (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])ocsp.getEncoded()));
            } else {
                this.generator.addOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic, (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])ocsp.getEncoded()));
            }
        }
        this.addCert(new JcaX509CertificateConverter().setProvider(ProvUtils.bcProvider).getCertificate(ocsp.getCerts()[0]));
    }

    void addBasicOCSPByAttribute(BasicOCSPResp ocsp) throws IOException, CertificateException, CertificateEncodingException, CMSException {
        this.addBasicOCSP(ocsp);
        if (!this.basicOcspRespAdditional.contains(ocsp)) {
            this.basicOcspRespAdditional.add(ocsp);
        }
        this.addCertByAttribute(new JcaX509CertificateConverter().setProvider(ProvUtils.bcProvider).getCertificate(ocsp.getCerts()[0]));
    }

    void addOCSP(OCSPResp ocsp) throws IOException, CertificateException, CertificateEncodingException, CMSException {
        if (!this.ocspResp.contains(ocsp)) {
            this.ocspResp.add(ocsp);
            if (this.stream_generator != null) {
                this.stream_generator.addOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response, (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])ocsp.getEncoded()));
            } else {
                this.generator.addOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response, (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])ocsp.getEncoded()));
            }
        }
    }

    void addCertificates(JcaCertStore jcaCertStore) throws CMSException {
        if (this.stream_generator != null) {
            this.stream_generator.addCertificates((Store)jcaCertStore);
        } else {
            this.generator.addCertificates((Store)jcaCertStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CMSSignedData saveToStream(InputStream detachedInputStream, OutputStream signatureOutputStream, boolean forceder) throws IOException, CMSException, CertificateException, OperatorCreationException, Exception {
        CMSSignedData cMSSignedData;
        Object finalSignedData;
        ClonerInputStream istc;
        CacheOutputStream cache_busta;
        CacheOutputStream cache;
        ASN1InputStream is;
        boolean detached;
        block31: {
            boolean derEncoding = this.options.isDerEncoded();
            detached = this.options.getSignatureMode() == SignatureMode.DETACHED;
            is = null;
            cache = null;
            cache_busta = null;
            istc = null;
            for (OCSPResp resp : this.ocspResp) {
                this.addOCSP(resp);
            }
            if (this.generator == null) break block31;
            CMSProcessableByteArray msg = new CMSProcessableByteArray(Util.getBytesFromInputStream((InputStream)detachedInputStream));
            finalSignedData = this.generator.generate((CMSTypedData)msg, !detached);
            if (derEncoding || forceder) {
                is = new ASN1InputStream(finalSignedData.getEncoded());
                signatureOutputStream.write(is.readObject().getEncoded("DER"));
            } else {
                signatureOutputStream.write(finalSignedData.getEncoded());
            }
            signatureOutputStream.flush();
            CMSSignedData cMSSignedData2 = finalSignedData;
            Util.closeQuietly((Closeable)cache_busta);
            Util.closeQuietly((Closeable)istc);
            Util.closeQuietly((Closeable)cache);
            if (is != null) {
                Util.closeQuietly((Closeable)is);
            }
            return cMSSignedData2;
        }
        try {
            try {
                cache = new CacheOutputStream(64000);
                cache_busta = new CacheOutputStream(64000);
                istc = new ClonerInputStream(detachedInputStream, (OutputStream)cache);
                OutputStream os = this.stream_generator.open((OutputStream)cache_busta, !detached);
                finalSignedData = null;
                try {
                    Util.copyStream((InputStream)istc, (OutputStream)os);
                    os.flush();
                    cache_busta.flush();
                }
                catch (Throwable x2) {
                    finalSignedData = x2;
                    throw x2;
                }
                finally {
                    if (os != null) {
                        if (finalSignedData != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)finalSignedData).addSuppressed(x2);
                            }
                        } else {
                            os.close();
                        }
                    }
                }
                if (!(this.certsListAdditional.isEmpty() && this.crlsListAdditional.isEmpty() && this.basicOcspRespAdditional.isEmpty())) {
                    DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
                    CMSSignedDataParser parser = new CMSSignedDataParser(dcp, cache_busta.getCache());
                    CMSTypedStream cmsTypedS = parser.getSignedContent();
                    cmsTypedS.drain();
                    CadesSignedDataGeneratorProxy internal_proxy = new CadesSignedDataGeneratorProxy(this.options, forceder, new CadesSignedDataProxy(parser), false);
                    for (X509Certificate cert : this.certsListAdditional) {
                        internal_proxy.addCert(cert);
                    }
                    for (CRL crl : this.crlsListAdditional) {
                        internal_proxy.addCRL(crl);
                    }
                    for (BasicOCSPResp ocsp : this.basicOcspRespAdditional) {
                        internal_proxy.addBasicOCSP(ocsp);
                    }
                    internal_proxy.saveToStream(cache.getCache(), signatureOutputStream, !detached);
                } else {
                    Util.copyStream((InputStream)cache_busta.getCache(), (OutputStream)signatureOutputStream);
                    signatureOutputStream.flush();
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
                throw ex;
            }
            catch (CapiException ex) {
                System.err.println(ex.getMessage());
                throw ex;
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
                throw ex;
            }
            catch (Error er) {
                System.err.println(er.getMessage());
                throw er;
            }
            cMSSignedData = null;
        }
        catch (Throwable throwable) {
            Util.closeQuietly(cache_busta);
            Util.closeQuietly(istc);
            Util.closeQuietly(cache);
            if (is != null) {
                Util.closeQuietly(is);
            }
            throw throwable;
        }
        Util.closeQuietly((Closeable)cache_busta);
        Util.closeQuietly((Closeable)istc);
        Util.closeQuietly((Closeable)cache);
        if (is != null) {
            Util.closeQuietly((Closeable)is);
        }
        return cMSSignedData;
    }
}

