/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.cades;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.core.StepSignatureDPCM45DigestAlgoCheck;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;

public class CadesStepSignatureDPCM45Compliance
extends SingleValidationSubStepImpl {
    public CadesStepSignatureDPCM45Compliance() {
        super(ValidationType.SIGNATURE);
        this.subSteps.add(new StepSignatureDPCM45DigestAlgoCheck());
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        format.setTimeZone(param.getTimeZone());
        Date validationDate = param.getCalculatedValidationDate().getDate();
        if ((param.getProfile() == ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE || param.getProfile() == ValidationProfile.GRAPHOMETRIC_SIGNATURE_PROFILE) && validationDate.after(Constants.DPCM_CNIPA_45_2009) && validationDate.before(Constants.DPCM_AGID_121_2019)) {
            MessageLevel level = StepsUtils.retrieveWorstLevel(subMessage);
            if (level == MessageLevel.ERROR) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.ES0005_NOCNIPA45, new Object[0]);
            }
            if (level == MessageLevel.WARNING) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.WS0001_NOCNIPA45VALID, new Object[0]);
            }
        }
        return null;
    }
}

