/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils;

import com.sun.jna.Platform;
import it.actalis.ellips.capi.http.arubautils.HttpStatusException;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.http.arubautils.provider.DownloadProgressNotifier;
import it.actalis.ellips.capi.http.arubautils.provider.HTTPProvider;
import it.actalis.ellips.capi.http.arubautils.provider.HTTPUrlConnectionProvider;
import it.actalis.ellips.capi.http.arubautils.provider.MultipartWrapper;
import it.actalis.ellips.capi.net.CapiSocketFactory;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlClient {
    private static final Logger logger2 = LoggerFactory.getLogger(UrlClient.class);
    private Logger logger = null;
    private static int loop = 0;
    NetworkConfig conf = null;
    TrustManager[] tm = null;
    HTTPProvider provider = null;

    public UrlClient() {
        this(null, logger2);
    }

    public UrlClient(NetworkConfig conf) {
        this(conf, logger2);
    }

    public UrlClient(NetworkConfig netConf, Logger logger) {
        this.logger = logger == null ? logger2 : logger;
        this.conf = netConf == null ? new NetworkConfig() : netConf;
        this.logger.debug("Inizializzazione provider HTTP");
        if (this.conf.getProvidername() == null || this.conf.getProvidername().endsWith("HTTPUrlConnectionProvider")) {
            this.logger.debug("set oracle provider");
            this.provider = new HTTPUrlConnectionProvider(this.conf, this.logger);
        } else if (this.conf.getProvidername().endsWith("ApacheHttpClientProvider")) {
            this.logger.debug("set apache provider");
            try {
                Class<?> apacheProv = this.getClass().getClassLoader().loadClass("it.actalis.ellips.capi.http.arubautils.provider.apache.ApacheHttpClientProvider");
                Constructor<?> apacheProvInit = apacheProv.getConstructors()[0];
                this.provider = (HTTPProvider)apacheProvInit.newInstance(this.conf, this.logger);
            }
            catch (InstantiationException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (this.provider == null) {
            throw new IllegalStateException("No Such Provider");
        }
    }

    public boolean isSSLTrustAllRoot() {
        return this.provider.isSslTrustAllRoot();
    }

    public void setSSLTrustAllRoot(boolean sslTrustAllRoot) {
        this.provider.setSslTrustAllRoot(sslTrustAllRoot);
    }

    public boolean isSSLHallHostVerified() {
        return this.provider.isSslHallHostVerified();
    }

    public void setSSLHallHostVerified(boolean sslHallHostVerified) {
        this.provider.setSslHallHostVerified(sslHallHostVerified);
    }

    private UrlReturn _downloadUrlInt(String url, RequestData rdate, URLCredentials credentials) {
        UrlReturn objReturn = new UrlReturn();
        objReturn.setStatus("KO");
        try {
            objReturn = this.downloadUrl(new URL(url), rdate, credentials);
        }
        catch (Throwable ex) {
            if (url != null && url.toLowerCase().startsWith("ldap")) {
                objReturn = this.downloadLdap(url);
            }
            objReturn.setStatus("KO");
            objReturn.setStatus(ex.getMessage());
            this.logger.error(ex.getMessage(), ex);
        }
        return objReturn;
    }

    private UrlReturn _downloadUrlInt(String url, RequestData rdate, URLCredentials credentials, String method) {
        UrlReturn objReturn = new UrlReturn();
        objReturn.setStatus("KO");
        try {
            objReturn = this.downloadUrl(new URL(url), rdate, credentials, method);
        }
        catch (Throwable ex) {
            if (url != null && url.toLowerCase().startsWith("ldap")) {
                objReturn = this.downloadLdap(url);
            }
            objReturn.setStatus("KO");
            objReturn.setStatus(ex.getMessage());
            this.logger.error(ex.getMessage(), ex);
        }
        return objReturn;
    }

    public UrlReturn downloadUrl(String url, RequestData rdate, URLCredentials credentials) {
        if (this.conf != null) {
            UrlReturn objReturn;
            if (this.conf.isProxyselectorinprogress() && (objReturn = this._downloadUrlInt(url, rdate, credentials)).getStatus().equals("OK")) {
                return objReturn;
            }
            while (this.conf.isProxyselectorinprogress()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return this._downloadUrlInt(url, rdate, credentials);
    }

    public UrlReturn downloadUrl(String url, RequestData rdate, URLCredentials credentials, String method) {
        if (this.conf != null) {
            UrlReturn objReturn;
            if (this.conf.isProxyselectorinprogress() && (objReturn = this._downloadUrlInt(url, rdate, credentials, method)).getStatus().equals("OK")) {
                return objReturn;
            }
            while (this.conf.isProxyselectorinprogress()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return this._downloadUrlInt(url, rdate, credentials, method);
    }

    public UrlReturn downloadHttpUrl(String url, RequestData rdate, URLCredentials credentials, OutputStream os, DownloadProgressNotifier notifier) {
        UrlReturn objReturn = new UrlReturn();
        objReturn.setStatus("KO");
        try {
            assert (this.provider != null) : "http provider must not be null";
            return this.provider.downloadHttp(new URL(url), rdate, credentials, os, notifier);
        }
        catch (Throwable ex) {
            this.manageException(ex, objReturn, url);
            return objReturn;
        }
    }

    public UrlReturn urlRequest(String url, String method, RequestData rdate, URLCredentials credentials) {
        if (this.conf.isFollowRedirect()) {
            try {
                url = this.getFinalURL(new URL(url)).toString();
            }
            catch (MalformedURLException ex) {
                this.logger.warn(ex.getMessage(), (Throwable)ex);
            }
        }
        UrlReturn objReturn = new UrlReturn();
        objReturn.setStatus("KO");
        try {
            assert (this.provider != null) : "http provider must not be null";
            return this.provider.urlRequest(new URL(url), method, rdate, credentials);
        }
        catch (Throwable ex) {
            this.manageException(ex, objReturn, url);
            return objReturn;
        }
    }

    public UrlReturn urlRequest(String url, String method, RequestData rdate, URLCredentials credentials, OutputStream os, DownloadProgressNotifier notifier) {
        if (this.conf.isFollowRedirect()) {
            try {
                url = this.getFinalURL(new URL(url)).toString();
            }
            catch (MalformedURLException ex) {
                this.logger.warn(ex.getMessage(), (Throwable)ex);
            }
        }
        UrlReturn objReturn = new UrlReturn();
        objReturn.setStatus("KO");
        try {
            assert (this.provider != null) : "http provider must not be null";
            return this.provider.urlRequest(new URL(url), method, rdate, credentials, os, notifier);
        }
        catch (Throwable ex) {
            this.manageException(ex, objReturn, url);
            return objReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getFinalURL(URL url) {
        HttpURLConnection connection = null;
        try {
            String redirectUrl;
            boolean originInSSL = url.toString().toLowerCase().startsWith("https");
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setInstanceFollowRedirects(false);
            connection.connect();
            connection.getInputStream();
            int responseCode = connection.getResponseCode();
            if (responseCode > 300 && responseCode <= 309 && (redirectUrl = connection.getHeaderField("Location")) != null) {
                if (originInSSL && !redirectUrl.toLowerCase().startsWith("https")) {
                    URL uRL = url;
                    return uRL;
                }
                URL uRL = this.getFinalURL(new URL(redirectUrl));
                return uRL;
            }
        }
        catch (Exception ex) {
            this.logger.warn(ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return url;
    }

    private UrlReturn downloadUrl(URL url, RequestData rdate, URLCredentials credentials) {
        UrlReturn objReturn = new UrlReturn();
        objReturn.setStatus("KO");
        try {
            String protocol = url.getProtocol();
            objReturn = protocol.toLowerCase().startsWith("http") ? this.downloadHttp(url, rdate, credentials) : this._downloadUrl(url);
        }
        catch (Throwable ex) {
            this.manageException(ex, objReturn, url.toString());
        }
        return objReturn;
    }

    private UrlReturn downloadUrl(URL url, RequestData rdate, URLCredentials credentials, String method) {
        UrlReturn objReturn = new UrlReturn();
        objReturn.setStatus("KO");
        try {
            String protocol = url.getProtocol();
            objReturn = protocol.toLowerCase().startsWith("http") ? this.downloadHttp(url, rdate, credentials, method) : this._downloadUrl(url);
        }
        catch (Throwable ex) {
            this.manageException(ex, objReturn, url.toString());
        }
        return objReturn;
    }

    private UrlReturn downloadHttp(URL url, RequestData rdate, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        if (this.conf.isFollowRedirect()) {
            url = this.getFinalURL(url);
        }
        return this.provider.downloadHttp(url, rdate, credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UrlReturn downloadHttp(URL url, RequestData rdate, URLCredentials credentials, String method) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        if (this.conf.isFollowRedirect()) {
            url = this.getFinalURL(url);
        }
        ByteArrayOutputStream objOut = null;
        UrlReturn objReturn = new UrlReturn();
        objReturn.setStatus("KO");
        try {
            objOut = new ByteArrayOutputStream();
            objReturn = this.provider.urlRequest(url, method, rdate, credentials, objOut, null);
            objOut.close();
            objReturn.setData(objOut.toByteArray());
        }
        finally {
            objOut.close();
        }
        return objReturn;
    }

    private UrlReturn _downloadUrl(URL url) throws MalformedURLException, IOException {
        if (this.conf.isFollowRedirect()) {
            url = this.getFinalURL(url);
        }
        UrlReturn ret = new UrlReturn();
        ret.setStatus("KO");
        byte[] arrReturn = null;
        Proxy proxy = null;
        NetworkConfig objConfig = this.getConf();
        if (objConfig.getProxy() != null && !objConfig.getProxy().equals("")) {
            proxy = objConfig.getProxyPort() != null && !objConfig.getProxyPort().equals("") ? (this.conf.getProxyType().equals("socks") ? new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(objConfig.getProxy(), Integer.parseInt(objConfig.getProxyPort()))) : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(objConfig.getProxy(), Integer.parseInt(objConfig.getProxyPort())))) : (this.conf.getProxyType().equals("socks") ? new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(objConfig.getProxy(), 1080)) : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(objConfig.getProxy(), 8080)));
        }
        InputStream objIn = null;
        URL objDownload = url;
        String fileUrl = URLDecoder.decode(objDownload.getFile(), "UTF-8");
        if (Platform.isWindows()) {
            fileUrl = fileUrl.substring(1);
        }
        if (url.getProtocol().toLowerCase().startsWith("file")) {
            objIn = new FileInputStream(fileUrl);
        } else {
            URLConnection objConn = null;
            objConn = proxy == null ? objDownload.openConnection() : objDownload.openConnection(proxy);
            objIn = objConn.getInputStream();
            if (objIn != null) {
                ArrayList<String> cookieList = new ArrayList<String>();
                Map<String, List<String>> headerFields = objConn.getHeaderFields();
                for (Map.Entry<String, List<String>> headerFieldEntry : headerFields.entrySet()) {
                    if (!"Set-Cookie".equalsIgnoreCase(headerFieldEntry.getKey())) continue;
                    for (String headerValue : headerFieldEntry.getValue()) {
                        this.logger.debug("Cookie found: " + headerValue);
                        cookieList.add(headerValue);
                    }
                }
                ret.setCookieList(cookieList);
            }
        }
        if (objIn != null) {
            byte[] buffer = new byte[512];
            int letti = objIn.read(buffer);
            ByteArrayOutputStream objOut = new ByteArrayOutputStream();
            while (letti != -1) {
                objOut.write(buffer, 0, letti);
                letti = objIn.read(buffer);
            }
            objIn.close();
            arrReturn = objOut.toByteArray();
            ret.setStatus("OK");
            ret.setStatusMessage("OK");
            ret.setData(arrReturn);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UrlReturn downloadLdap(String strUrl) {
        byte[] arrReturn = null;
        UrlReturn ret = new UrlReturn();
        Context ctx = null;
        try {
            ret.setStatus("KO");
            NetworkConfig objConfig = this.getConf();
            if (this.conf != null && this.conf.isAutomaticProxyDiscovery()) {
                ProxySelector sel = this.conf.getDefaultproxyselector();
                Proxy proxy2 = null;
                if (sel != null) {
                    URI uri = new URI(strUrl);
                    for (Proxy proxy2 : sel.select(uri)) {
                        if (proxy2.type() != Proxy.Type.SOCKS) continue;
                        String ip = ((InetSocketAddress)proxy2.address()).getAddress().getHostAddress();
                        String port = ((InetSocketAddress)proxy2.address()).getPort() + "";
                        System.setProperty("socksProxyHost", ip);
                        System.setProperty("socksProxyPort", port);
                        break;
                    }
                }
            }
            if (objConfig.getLdapProxy() != null && !objConfig.getLdapProxy().equals("")) {
                System.setProperty("socksProxyHost", objConfig.getLdapProxy());
            }
            if (objConfig.getLdapProxyPort() != null && !objConfig.getLdapProxyPort().equals("")) {
                System.setProperty("socksProxyPort", objConfig.getLdapProxyPort());
            }
            Properties env = new Properties();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", strUrl);
            env.put("java.naming.security.authentication", "none");
            env.put("com.sun.jndi.ldap.connect.pool", "false");
            env.put("com.sun.jndi.ldap.connect.pool.maxsize", "20");
            env.put("com.sun.jndi.ldap.connect.pool.timeout", "5000");
            env.put("com.sun.jndi.ldap.connect.timeout", "5000");
            env.put("com.sun.jndi.ldap.connect.pool.debug", "fine");
            env.put("java.naming.ldap.attributes.binary", "userCertificate");
            env.put("java.naming.ldap.factory.socket", "it.actalis.ellips.capi.net.CapiSocketFactory");
            CapiSocketFactory.getThreadNetworkConfig().put("" + Thread.currentThread().getId(), this.conf);
            ctx = new InitialDirContext(env);
            NamingEnumeration<SearchResult> results = ctx.search(strUrl, "(certificateRevocationList;binary=*)", null);
            while (results.hasMore()) {
                SearchResult searchResult = results.next();
                Attributes attributes = searchResult.getAttributes();
                Attribute attr = attributes.get("certificateRevocationList;binary");
                if (attr == null) {
                    attr = attributes.get("certificateRevocationList");
                }
                if (attr == null) continue;
                this.logger.debug(" CRL = {}", (Object)((byte[])attr.get()).length);
                arrReturn = (byte[])attr.get();
            }
            ctx.close();
            ctx = null;
            if (arrReturn != null) {
                ret.setStatus("OK");
                ret.setStatusMessage("OK");
                ret.setData(arrReturn);
            }
        }
        catch (Exception ex) {
            ret.setStatus("KO");
            ret.setStatusMessage(ex.getMessage());
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
            this.getLogger().error("impossible contattare l''url :{}", (Object)strUrl);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {
                    this.logger.error(null, (Throwable)ex);
                }
            }
        }
        return ret;
    }

    public NetworkConfig getConf() {
        return this.conf;
    }

    public void setConf(NetworkConfig conf) {
        this.conf = conf;
        if (this.conf != null) {
            this.logger = this.conf.getLogger();
        }
    }

    public void setTrustStore(KeyStore store) {
        if (store != null && this.provider != null) {
            this.provider.setTrustStore(store);
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            return logger2;
        }
        return this.logger;
    }

    private Date getLastModifiedDate(URL url, URLCredentials credentials) throws IOException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        return this.provider.getLastModifiedDate(url, credentials);
    }

    public Date getLastModifiedDate(String url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        return this.provider.getLastModifiedDate(url, credentials);
    }

    public Long getContentLengthLong(URL url, URLCredentials credentials) throws IOException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        return this.provider.getContentLengthLong(url, credentials);
    }

    public Long getContentLengthLong(String url, URLCredentials credentials) throws IOException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        return this.provider.getContentLengthLong(url, credentials);
    }

    public Proxy fech_proxy(URL url) {
        return this.provider.fech_proxy(url);
    }

    public InputStream getInputStream(URL url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        return this.provider.getInputStream(url, credentials);
    }

    public MultipartWrapper getMultipartWrapper(URL url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        return this.provider.getMultipartWrapper(url, credentials);
    }

    public HttpURLConnection getHttpURLConnection(URL url, URLCredentials credentials) throws IOException, KeyManagementException, KeyStoreException, NoSuchAlgorithmException, URISyntaxException, UnrecoverableKeyException {
        return this.provider.getHttpURLConnection(url, credentials);
    }

    public void setSslTrustAllRoot(boolean trust) {
        this.provider.setSslTrustAllRoot(trust);
    }

    private void manageException(Throwable ex, UrlReturn objReturn, String url) {
        objReturn.setStatus("KO");
        objReturn.setStatusMessage(ex.getMessage());
        objReturn.setStatus_code(-1);
        if (ex instanceof HttpStatusException) {
            objReturn.setStatus_code(((HttpStatusException)ex).getStatus_code());
            objReturn.setErrordata(((HttpStatusException)ex).getErrodata());
            this.getLogger().debug("Error Status Code {}", (Object)((HttpStatusException)ex).getStatus_code());
            if (ex.getCause() == null) {
                this.getLogger().error(ex.getMessage(), ex);
            } else {
                this.getLogger().error(ex.getMessage(), ex.getCause());
            }
        } else {
            this.getLogger().error(ex.getMessage(), ex);
        }
        this.getLogger().error("impossible contattare l''url :{}", (Object)url);
    }
}

