/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils.rest;

import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.http.arubautils.rest.RestClientRequest;
import it.actalis.ellips.capi.http.arubautils.rest.RestResponse;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient {
    private static final Logger logger2 = LoggerFactory.getLogger(UrlClient.class);
    private static Logger logger = null;
    private static UrlClient client = null;
    boolean debug = false;

    public RestClient(UrlClient client, KeyStore cdb, boolean ignorecert) {
        this(client, cdb, ignorecert, null);
    }

    public RestClient(UrlClient client, KeyStore store, boolean ignorecert, Logger logger) {
        RestClient.logger = logger == null ? logger2 : logger;
        RestClient.client = client;
        if (ignorecert) {
            client.setSSLTrustAllRoot(ignorecert);
            client.setSSLHallHostVerified(ignorecert);
        } else if (store != null) {
            client.setTrustStore(store);
        }
        if (System.getProperties().getProperty("esecurity.asb.gw.debug") != null) {
            this.debug = System.getProperties().getProperty("esecurity.asb.gw.debug").equals("true");
        }
    }

    @Deprecated
    public String sendJson(String url, String value, URLCredentials cred) {
        String strReturn = "";
        try {
            UrlReturn ret;
            RequestData rdata = new RequestData();
            rdata.setPostdata(value.getBytes("UTF8"));
            rdata.setType("JSON");
            if (this.debug) {
                logger.debug(value);
            }
            if ((ret = client.downloadUrl(url, rdata, cred)).getStatus().startsWith("OK")) {
                strReturn = new String(ret.getData());
            } else {
                logger.error(ret.getStatusMessage());
            }
        }
        catch (Exception ex) {
            logger.info(ex.getMessage());
        }
        return strReturn;
    }

    @Deprecated
    public byte[] sendJsonByte(String url, byte[] value, URLCredentials cred) {
        byte[] arrReturn = null;
        try {
            UrlReturn ret;
            RequestData rdata = new RequestData();
            rdata.setPostdata(value);
            rdata.setType("JSON");
            if (this.debug) {
                logger.debug(new String(value, "UTF-8"));
            }
            if ((ret = client.downloadUrl(url, rdata, cred)).getStatus().startsWith("OK")) {
                arrReturn = ret.getData();
            } else {
                logger.error(ret.getStatusMessage());
            }
        }
        catch (Exception ex) {
            logger.info(ex.getMessage());
        }
        return arrReturn;
    }

    @Deprecated
    public RestResponse sendRawJson(String url, byte[] value, URLCredentials cred) {
        RestResponse response = new RestResponse();
        try {
            RequestData rdata = new RequestData();
            rdata.setPostdata(value);
            rdata.setType("JSON");
            if (this.debug) {
                logger.debug(new String(value, "UTF-8"));
            }
            UrlReturn ret = client.downloadUrl(url, rdata, cred);
            response.setStatus(ret.getStatus());
            response.setMessage(ret.getStatusMessage());
            if (ret.getStatus().startsWith("OK")) {
                response.setResponseData(ret.getData());
            } else {
                logger.error(ret.getStatusMessage());
                if (ret.getErrordata() != null) {
                    response.setErrorData(ret.getErrordata());
                }
            }
        }
        catch (Exception ex) {
            logger.info(ex.getMessage());
            response.setStatus("KO");
            response.setMessage(ex.getMessage());
        }
        return response;
    }

    public RestResponse sendRequest(String url, RestClientRequest request, URLCredentials cred) {
        RestResponse response = new RestResponse();
        RequestData data = new RequestData();
        data.setParam(request.getParameters());
        String method = request.getMethod();
        if ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) {
            data.setType(request.getType());
            if (request.getBody() != null) {
                data.setPostStream(request.getBody());
            }
        }
        UrlReturn ret = client.downloadUrl(url, data, cred, method);
        response.setStatus(ret.getStatus());
        response.setMessage(ret.getStatusMessage());
        response.setResponseData(ret.getData());
        response.setErrorData(ret.getErrordata());
        return response;
    }
}

