/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.xades;

import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.xades.bean.XadesSignatureReference;
import esecurity.validator.xades.bean.XadesSignerInfoData;
import esecurity.validator.xades.bean.XadesSigningCertificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.util.RFC4519Utils;
import java.security.MessageDigest;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.util.encoders.Base64;

public class XadesStepSignatureReferenceCheck
extends MultipleValidationSubStepImpl {
    public XadesStepSignatureReferenceCheck() {
        super(ValidationType.SIGNATURE);
    }

    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        LinkedList<ValidatorMessage> msgs = new LinkedList<ValidatorMessage>();
        if (param != null && param.getSignature() != null && param.getSignature().getSignerInfoData() != null) {
            XadesSignerInfoData data = (XadesSignerInfoData)param.getSignature().getSignerInfoData();
            if (data == null || data.getReferences() == null || data.getReferences().size() < 1) {
                msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0020_NO_REFERENCES_FOUND, new Object[]{((Object)((Object)this)).getClass().getName()}));
            } else {
                boolean hasReferenceToKeyInfo = false;
                boolean hasReferenceToSignedProps = false;
                boolean hasSigningCertificatePropForKeyInfoCert = false;
                if (!data.hasSignedProperties()) {
                    hasReferenceToSignedProps = true;
                }
                for (XadesSignatureReference ref : data.getReferences()) {
                    if (ref.getType() != null && ref.getType().equals("http://uri.etsi.org/01903#SignedProperties") && ref.getURI() != null && data.getSignedPropsId() != null && ref.getURI().equals("#" + data.getSignedPropsId())) {
                        hasReferenceToSignedProps = true;
                        continue;
                    }
                    if (data.getKeyInfoId() == null || ref.getURI() == null || !ref.getURI().equals("#" + data.getKeyInfoId())) continue;
                    hasReferenceToKeyInfo = true;
                }
                if (data.getSigningCertificates() != null && data.getSigningCertificates().size() > 0) {
                    boolean allSigningCertsMatch = true;
                    boolean allIssuerNamePresent = true;
                    for (XadesSigningCertificate signCert : data.getSigningCertificates()) {
                        boolean signingCertMatch;
                        block28: {
                            signingCertMatch = false;
                            if (param.getSignerCertificate() != null) {
                                ValidatedCertificate validatedCert = param.getSignerCertificate();
                                try {
                                    switch (signCert.getVersion()) {
                                        case 1: {
                                            byte[] digestedData;
                                            MessageDigest md;
                                            if (signCert.getIssuerName() == null) {
                                                allIssuerNamePresent = false;
                                                break;
                                            }
                                            if (RFC4519Utils.compareDN((String)validatedCert.getCertIssuer(), (String)signCert.getIssuerName()) && validatedCert.getCert().getSerialNumber().equals(signCert.getSerialNumber())) {
                                                md = MessageDigest.getInstance(DigestAlgorithm.valueFromXadesId((String)signCert.getDigestMethod()).getId(), ProvUtils.bcProvider);
                                                digestedData = md.digest(Base64.decode((String)validatedCert.getCert().getEncoded()));
                                                if (signCert.getDigestValue().equals(new String(Base64.encode((byte[])digestedData)))) {
                                                    hasSigningCertificatePropForKeyInfoCert = true;
                                                    signingCertMatch = true;
                                                }
                                            }
                                            while (validatedCert.getIssuer() != null && !signingCertMatch) {
                                                if (!RFC4519Utils.compareDN((String)(validatedCert = validatedCert.getIssuer()).getCertIssuer(), (String)signCert.getIssuerName()) || !validatedCert.getCert().getSerialNumber().equals(signCert.getSerialNumber())) continue;
                                                try {
                                                    md = MessageDigest.getInstance(DigestAlgorithm.valueFromXadesId((String)signCert.getDigestMethod()).getId(), ProvUtils.bcProvider);
                                                    digestedData = md.digest(Base64.decode((String)validatedCert.getCert().getEncoded()));
                                                    if (!signCert.getDigestValue().equals(new String(Base64.encode((byte[])digestedData)))) continue;
                                                    hasSigningCertificatePropForKeyInfoCert = true;
                                                    signingCertMatch = true;
                                                }
                                                catch (Throwable md2) {}
                                            }
                                            break block28;
                                        }
                                        case 2: {
                                            MessageDigest digest = MessageDigest.getInstance(DigestAlgorithm.valueFromXadesId((String)signCert.getDigestMethod()).getId(), ProvUtils.bcProvider);
                                            byte[] certDigest = digest.digest(validatedCert.getCert().getInternalCert().getEncoded());
                                            if (signCert.getDigestValue().equals(Base64.toBase64String((byte[])certDigest))) {
                                                hasSigningCertificatePropForKeyInfoCert = true;
                                                signingCertMatch = true;
                                            }
                                            break block28;
                                        }
                                        default: {
                                            allIssuerNamePresent = false;
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                        if (signingCertMatch) continue;
                        allSigningCertsMatch = false;
                        break;
                    }
                    if (!allSigningCertsMatch) {
                        msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0023_XADES_ALL_SIGNING_CERTS_NOT_MATCH, new Object[]{((Object)((Object)this)).getClass().getName()}));
                    }
                    if (!allIssuerNamePresent) {
                        msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0015_NO_ISSUER_NAME, new Object[]{((Object)((Object)this)).getClass().getName()}));
                    }
                }
                if (data.hasKeyInfo() && !hasReferenceToKeyInfo && !hasSigningCertificatePropForKeyInfoCert) {
                    msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0021_NO_REFERENCE_FOR_KEYINFO_FOUND, new Object[]{((Object)((Object)this)).getClass().getName()}));
                } else if (!data.hasKeyInfo() && !hasSigningCertificatePropForKeyInfoCert) {
                    msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0021_NO_REFERENCE_FOR_KEYINFO_FOUND, new Object[]{((Object)((Object)this)).getClass().getName()}));
                }
                if (!hasReferenceToSignedProps) {
                    msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0022_NO_REFERENCE_FOR_SIGNEDPROPS_FOUND, new Object[]{((Object)((Object)this)).getClass().getName()}));
                }
            }
        }
        return msgs;
    }
}

