/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.xades;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.xades.bean.XadesSignatureReference;
import esecurity.validator.xades.bean.XadesSignerInfoData;
import esecurity.validator.xades.bean.XadesSigningCertificate;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public class XadesStepSignatureDPCM45HashAlgoCheck
extends SingleValidationSubStepImpl {
    public XadesStepSignatureDPCM45HashAlgoCheck() {
        super(ValidationType.SIGNATURE);
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        if (param.getSignature() == null || param.getSignature().getSignatureInfo() == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        XadesSignerInfoData data = (XadesSignerInfoData)param.getSignature().getSignerInfoData();
        if (data != null && data.getReferences() != null && data.getReferences().size() > 0) {
            for (XadesSignatureReference ref : data.getReferences()) {
                if (ref != null && ref.getDigestMethodAlgorithm() != null && ref.getDigestMethodAlgorithm().equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#sha256")) continue;
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0006_NOSHA256, new Object[]{((Object)((Object)this)).getClass().getName()});
            }
        }
        if (data != null && (data.getSignatureMethod() == null || !data.getSignatureMethod().equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256") && !data.getSignatureMethod().equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"))) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0006_NOSHA256, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        if (data != null && data.getSigningCertificates() != null && data.getSigningCertificates().size() > 0) {
            for (XadesSigningCertificate cert : data.getSigningCertificates()) {
                if (cert != null && cert.getDigestMethod() != null && cert.getDigestMethod().equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#sha256")) continue;
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0006_NOSHA256, new Object[]{((Object)((Object)this)).getClass().getName()});
            }
        }
        return null;
    }
}

