/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import it.actalis.ellips.capi.core.Util;
import it.arubapec.ca.pkcs11.card.Atr;
import it.arubapec.ca.pkcs11.card.AtrType;
import it.arubapec.ca.pkcs11.card.CardFamily;
import it.arubapec.ca.pkcs11.card.CardLibrary;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CardStore {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private List<CardLibrary> cardLibraries;
    private List<CardFamily> cardFamilies;
    private List<Atr> atrs;
    private final transient List<Atr> completeAtr = new ArrayList<Atr>();
    private final transient List<Atr> regexAtr = new ArrayList<Atr>();
    private transient List<Atr> historicalAtr = new ArrayList<Atr>();

    private CardStore() {
        this.atrs = new ArrayList<Atr>();
        this.cardFamilies = new ArrayList<CardFamily>();
        this.cardLibraries = new ArrayList<CardLibrary>();
    }

    public List<CardLibrary> getCardLibraries() {
        return this.cardLibraries;
    }

    public void setCardLibraries(List<CardLibrary> cardLibraries) {
        this.cardLibraries = cardLibraries;
    }

    public List<CardFamily> getCardFamilies() {
        return this.cardFamilies;
    }

    public void setCardFamilies(List<CardFamily> cardFamilies) {
        this.cardFamilies = cardFamilies;
    }

    public void addAtr(Atr atr) throws IOException {
        atr.rebuild(this);
        if (!this.atrs.contains(atr)) {
            this.atrs.add(atr);
        }
        if (atr.getType() == AtrType.COMPLETE) {
            this.completeAtr.add(atr);
        } else if (atr.getType() == AtrType.REGEX) {
            this.regexAtr.add(atr);
        } else if (atr.getType() == AtrType.HISTORICAL) {
            this.historicalAtr.add(atr);
        }
    }

    public void setAtrs(List<Atr> atrs) {
        this.atrs = atrs;
    }

    public void save(OutputStream os) throws IOException {
        JsonWriter writer = gson.newJsonWriter((Writer)new OutputStreamWriter(os, "UTF-8"));
        gson.toJson((Object)this, CardStore.class, writer);
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File jsonFile) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(jsonFile);
            this.save(fos);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(fos);
            throw throwable;
        }
        Util.closeQuietly((Closeable)fos);
    }

    private void rebuild() throws IOException {
        for (Atr atr : this.atrs) {
            this.addAtr(atr);
        }
        for (CardFamily family : this.getCardFamilies()) {
            family.rebuild(this);
        }
    }

    public static CardStore getInstance() throws IOException {
        InputStream is = CardStore.class.getResourceAsStream("/esecurity/card/store.json");
        return CardStore.getInstance(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CardStore getInstance(File jsonStore) throws IOException {
        FileInputStream fis;
        block4: {
            fis = null;
            if (jsonStore == null || !jsonStore.exists()) break block4;
            fis = new FileInputStream(jsonStore);
            CardStore cardStore = CardStore.getInstance(fis);
            Util.closeQuietly((Closeable)fis);
            return cardStore;
        }
        try {
            CardStore cardStore = CardStore.getInstance();
            return cardStore;
        }
        finally {
            Util.closeQuietly(fis);
        }
    }

    public static CardStore getInstance(InputStream is) throws IOException {
        CardStore store = null;
        JsonReader reader = gson.newJsonReader((Reader)new InputStreamReader(is, "UTF-8"));
        store = (CardStore)gson.fromJson(reader, CardStore.class);
        reader.close();
        store.rebuild();
        return store;
    }

    public List<Atr> getCompleteAtr() {
        return this.completeAtr;
    }

    public List<Atr> getRegexAtr() {
        return this.regexAtr;
    }

    public List<Atr> getHistoricalAtr() {
        return this.historicalAtr;
    }

    public boolean equals(CardStore store) {
        boolean found = false;
        for (CardLibrary lib : store.getCardLibraries()) {
            found = false;
            for (CardLibrary lib2 : this.getCardLibraries()) {
                if (!lib2.equals(lib)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        for (CardFamily family : store.getCardFamilies()) {
            found = false;
            for (CardFamily family2 : this.getCardFamilies()) {
                if (!family2.equals(family)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        for (Atr atr : store.getCompleteAtr()) {
            found = false;
            for (Atr atr2 : this.getCompleteAtr()) {
                if (!atr2.equals(atr)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        for (Atr atr : store.getRegexAtr()) {
            found = false;
            for (Atr atr2 : this.getRegexAtr()) {
                if (!atr2.equals(atr)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        for (Atr atr : store.getHistoricalAtr()) {
            found = false;
            for (Atr atr2 : this.getHistoricalAtr()) {
                if (!atr2.equals(atr)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

