/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card;

import it.arubapec.ca.pkcs11.card.AtrType;
import it.arubapec.ca.pkcs11.card.CardFamily;
import it.arubapec.ca.pkcs11.card.CardStore;
import java.io.IOException;

public class Atr {
    private AtrType type = AtrType.COMPLETE;
    private String value;
    private String cardFamilyName;
    private transient CardFamily cardFamily = null;

    public Atr(AtrType type, String value, CardFamily cardFamily) {
        this.type = type;
        this.value = value;
        this.cardFamily = cardFamily;
        this.cardFamilyName = cardFamily.getName();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public AtrType getType() {
        return this.type;
    }

    public void setType(AtrType type) {
        this.type = type;
    }

    public CardFamily getCardFamily() {
        return this.cardFamily;
    }

    public void setCardFamily(CardFamily cardFamily) {
        this.cardFamily = cardFamily;
        this.cardFamilyName = cardFamily.getName();
    }

    void rebuild(CardStore store) throws IOException {
        if (this.cardFamily == null) {
            for (CardFamily family : store.getCardFamilies()) {
                if (this.cardFamilyName == null || !this.cardFamilyName.equals(family.getName())) continue;
                this.cardFamily = family;
                break;
            }
        }
        if (this.cardFamily == null) {
            throw new IOException("No family found for this ATR --> " + this.cardFamilyName);
        }
    }

    public boolean equals(Atr atr) {
        if (!atr.getCardFamily().equals(this.cardFamily)) {
            return false;
        }
        if (!atr.getType().equals((Object)this.type)) {
            return false;
        }
        return atr.getValue().equals(this.value);
    }
}

