/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pcsc;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.util.ATR;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.Hex;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.slf4j.Logger;

public class SCardUtils {
    private static int recursion = 1;
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ATR> retrieveATR() {
        logger.info("SCardUtils16.retrieveATR() start");
        LinkedList<ATR> atrList = new LinkedList();
        try {
            TerminalFactory factory = TerminalFactory.getDefault();
            List<CardTerminal> terminals = factory.terminals().list();
            logger.info("Numero di terminali trovati: {}", (Object)terminals.size());
            for (CardTerminal terminal : terminals) {
                logger.info("  Terminal [{}]:", (Object)terminal.getName());
                Card card = null;
                try {
                    card = terminal.connect("*");
                    logger.info("    connected", (Object)terminal.getName());
                    String atr = Hex.getHex((byte[])card.getATR().getBytes());
                    logger.info("    returns ATR = {}", (Object)atr);
                    atrList.add(new ATR(terminal.getName(), atr.toLowerCase()));
                }
                catch (CardNotPresentException ex) {
                    logger.error("    no card is present");
                }
                catch (CardException ex) {
                    logger.error("    not connected", (Throwable)ex);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    if (card == null) continue;
                    card.disconnect(false);
                }
            }
        }
        catch (CardException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            try {
                SCardUtils.clearTerminalsList();
                if (recursion-- >= 0) {
                    atrList = SCardUtils.retrieveATR();
                }
            }
            catch (Exception e) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                recursion = 1;
            }
        }
        logger.info("SCardUtils16.retrieveATR() end");
        return atrList;
    }

    public static void clearTerminalsList() throws Exception {
        logger.debug("clear the terminals in cache");
        logger.info("clearTerminalsList() start");
        Class<?> pcscterminal = Class.forName("sun.security.smartcardio.PCSCTerminals");
        Field contextId = pcscterminal.getDeclaredField("contextId");
        contextId.setAccessible(true);
        if (contextId.getLong(pcscterminal) != 0L) {
            Class<?> pcsc = Class.forName("sun.security.smartcardio.PCSC");
            Method SCardEstablishContext = pcsc.getDeclaredMethod("SCardEstablishContext", Integer.TYPE);
            SCardEstablishContext.setAccessible(true);
            Field SCARD_SCOPE_USER = pcsc.getDeclaredField("SCARD_SCOPE_USER");
            SCARD_SCOPE_USER.setAccessible(true);
            long newId = (Long)SCardEstablishContext.invoke(pcsc, SCARD_SCOPE_USER.getInt(pcsc));
            contextId.setLong(pcscterminal, newId);
            TerminalFactory factory = TerminalFactory.getDefault();
            CardTerminals terminals = factory.terminals();
            Field fieldTerminals = pcscterminal.getDeclaredField("terminals");
            fieldTerminals.setAccessible(true);
            Class<?> classMap = Class.forName("java.util.Map");
            Method clearMap = classMap.getDeclaredMethod("clear", new Class[0]);
            clearMap.invoke(fieldTerminals.get(terminals), new Object[0]);
        }
        logger.info("clearTerminalsList() end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ATR retrieveATR(String lettore) {
        ATR objAtr = new ATR("", "");
        try {
            TerminalFactory factory = TerminalFactory.getDefault();
            List<CardTerminal> terminals = factory.terminals().list();
            logger.info("Numero di terminali trovati: {}", (Object)terminals.size());
            for (CardTerminal terminal : terminals) {
                logger.info("Lettura terminale [{}]", (Object)terminal.getName());
                Card card = null;
                try {
                    if (!terminal.getName().toUpperCase().contains(lettore.trim().toUpperCase())) continue;
                    card = terminal.connect("*");
                    logger.info("Terminale [{}] connesso", (Object)terminal.getName());
                    String atr = Hex.getHex((byte[])card.getATR().getBytes());
                    logger.info("Trovato ATR = {}", (Object)atr);
                    objAtr = new ATR(terminal.getName(), atr.toLowerCase());
                }
                catch (CardNotPresentException ex) {
                    logger.error("Nessuna carta presente");
                }
                catch (CardException ex) {
                    logger.error("Terminale [" + terminal.getName() + "] non connesso", (Throwable)ex);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    if (card == null) continue;
                    card.disconnect(false);
                }
            }
        }
        catch (CardException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return objAtr;
    }
}

