/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.utils;

import com.sun.jna.Platform;
import esecurity.validator.constants.RevocationVerifyMode;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.vol.utils.ConfigFile;
import it.arubapec.ca.utils.RemoteSignatureSession;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.util.Locale;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.ini4j.Profile;
import org.slf4j.Logger;
import secretstoreutils.SecretStore;

public class ConfigParameter
implements KeyStore.LoadStoreParameter {
    public static final int CONFIG_RUNTIMETYPE_APPLET = 0;
    public static final int CONFIG_RUNTIMETYPE_APP = 1;
    public static final int CONFIG_RUNTIMETYPE_SRV = 2;
    public static final String USER_NAME = System.getProperty("user.name");
    public static final String CRYPT_SALT = "asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58";
    public static final int LOG_STATUS_OFF = 0;
    public static final int LOG_STATUS_STANDARD = 1;
    public static final int LOG_STATUS_DEBUG = 2;
    private int runtimeType;
    private String arubaProxyUrl;
    private TSAData tsaData;
    private String serverAS;
    private String serverAS2;
    private String userNameAS;
    private String passwordAS;
    private String userDomainAS;
    private String asUseCNS;
    private String asMustUrl;
    private String asDelegatedUser;
    private String asDelegatedPassword;
    private String asDelegatedDomain;
    private String p11On;
    private String session;
    private String cacheCRL;
    private String preferOCSP;
    private String p11Override;
    private String ignoreAtr;
    private String preferPdfCades;
    private String feaActivated;
    private String version;
    private String crlOnMemory;
    private String disableVerCertStatus;
    private String crlProxy;
    private String crlProxyPort;
    private String pptUrl;
    private NetworkConfig netConf;
    private RemoteSignatureSession cnsSession;
    private String lang;
    private String scriptStatus;
    private String ntlmSupport;
    private String updaterBasicAuthUser;
    private String updaterBasicAuthPassword;
    private File arubaSignHome;
    private String userHome;
    private String userDir;
    private String applicationUsername;
    private String applicationPassword;
    private int loggerLevelStatus;
    private String timeZone;
    private boolean useTimeZoneUTC;
    private String requestTsaUrl;
    private String remoteSignatureBasicAuthUser;
    private String remoteSignatureBasicAuthPassword;
    private String configFilePath;
    private String tslMode;
    private boolean useDSD;
    private String dsdUrl1;
    private String dsdUrl2;
    private String dsdUser;
    private String dsdToken;
    private static Logger logger = null;

    public ConfigParameter(int RuntimeType) {
        this(RuntimeType, null);
    }

    public ConfigParameter(int RuntimeType, Logger log) {
        this(RuntimeType, log, null);
    }

    public ConfigParameter(int RuntimeType, Logger log, File homeFolder) {
        block10: {
            String basedir;
            this.runtimeType = 1;
            this.arubaProxyUrl = "http://192.168.46.106:8080/ArubaProxy/ProxyRequest";
            this.tsaData = new TSAData();
            this.serverAS = "https://app1.firma-remota.it/ArubaSignerService/webresources/signerservice";
            this.serverAS2 = "https://app2.firma-remota.it/ArubaSignerService/webresources/signerservice";
            this.userNameAS = "";
            this.passwordAS = "";
            this.userDomainAS = "";
            this.asUseCNS = "F";
            this.asMustUrl = null;
            this.p11On = "S";
            this.session = "NOSESSION";
            this.cacheCRL = "F";
            this.preferOCSP = "S";
            this.p11Override = "";
            this.ignoreAtr = "F";
            this.preferPdfCades = "S";
            this.feaActivated = "F";
            this.version = "4";
            this.crlOnMemory = "F";
            this.disableVerCertStatus = "F";
            this.crlProxy = "";
            this.crlProxyPort = "";
            this.pptUrl = "https://actalis.strongauth.it/ArubaIDFe/papertoken";
            this.netConf = null;
            this.lang = System.getProperty("user.language");
            this.scriptStatus = "0";
            this.ntlmSupport = "F";
            this.updaterBasicAuthUser = "";
            this.updaterBasicAuthPassword = "";
            this.arubaSignHome = null;
            this.userHome = System.getProperty("user.home");
            this.userDir = System.getProperty("user.dir");
            this.applicationUsername = "";
            this.applicationPassword = "";
            this.loggerLevelStatus = 0;
            this.timeZone = "UTC";
            this.useTimeZoneUTC = true;
            this.requestTsaUrl = "";
            this.remoteSignatureBasicAuthUser = "";
            this.remoteSignatureBasicAuthPassword = "";
            this.configFilePath = null;
            this.tslMode = "ATSL";
            this.useDSD = true;
            this.dsdUrl1 = "https://dsd.aruba.it";
            this.dsdUrl2 = "https://dsd.aruba.it";
            this.dsdUser = "asuser";
            this.dsdToken = "";
            this.runtimeType = RuntimeType;
            String base_dir = "";
            base_dir = Platform.isWindows() ? ((basedir = System.getProperty("it.arubapec.asbasedir")) != null && basedir.equals("appdata") ? System.getenv("APPDATA") + File.separator + ".arDigiSign" : this.userHome + File.separator + ".arDigiSign") : this.userHome + File.separator + ".arDigiSign";
            this.arubaSignHome = homeFolder != null && homeFolder.isDirectory() ? homeFolder : new File(base_dir);
            if (!this.arubaSignHome.exists()) {
                this.save();
            } else {
                String propertiesFile = null;
                try {
                    if (this.runtimeType == 1) {
                        propertiesFile = this.arubaSignHome.getAbsolutePath() + File.separator + "arDigiCore.ini";
                    } else if (this.runtimeType == 0) {
                        propertiesFile = this.arubaSignHome.getAbsolutePath() + File.separator + "arDigiCore_applet.ini";
                    } else if (this.runtimeType == 2) {
                        propertiesFile = this.arubaSignHome.getAbsolutePath() + File.separator + "arDigiCore_srv.ini";
                    } else {
                        throw new Exception("Errore tipo runtime non supportato");
                    }
                    this.initialize(propertiesFile, log);
                }
                catch (Exception ex) {
                    if (logger == null) break block10;
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public ConfigParameter(String propertiesFile) {
        this(propertiesFile, null);
    }

    public ConfigParameter(String propertiesFile, Logger log) {
        this.runtimeType = 1;
        this.arubaProxyUrl = "http://192.168.46.106:8080/ArubaProxy/ProxyRequest";
        this.tsaData = new TSAData();
        this.serverAS = "https://app1.firma-remota.it/ArubaSignerService/webresources/signerservice";
        this.serverAS2 = "https://app2.firma-remota.it/ArubaSignerService/webresources/signerservice";
        this.userNameAS = "";
        this.passwordAS = "";
        this.userDomainAS = "";
        this.asUseCNS = "F";
        this.asMustUrl = null;
        this.p11On = "S";
        this.session = "NOSESSION";
        this.cacheCRL = "F";
        this.preferOCSP = "S";
        this.p11Override = "";
        this.ignoreAtr = "F";
        this.preferPdfCades = "S";
        this.feaActivated = "F";
        this.version = "4";
        this.crlOnMemory = "F";
        this.disableVerCertStatus = "F";
        this.crlProxy = "";
        this.crlProxyPort = "";
        this.pptUrl = "https://actalis.strongauth.it/ArubaIDFe/papertoken";
        this.netConf = null;
        this.lang = System.getProperty("user.language");
        this.scriptStatus = "0";
        this.ntlmSupport = "F";
        this.updaterBasicAuthUser = "";
        this.updaterBasicAuthPassword = "";
        this.arubaSignHome = null;
        this.userHome = System.getProperty("user.home");
        this.userDir = System.getProperty("user.dir");
        this.applicationUsername = "";
        this.applicationPassword = "";
        this.loggerLevelStatus = 0;
        this.timeZone = "UTC";
        this.useTimeZoneUTC = true;
        this.requestTsaUrl = "";
        this.remoteSignatureBasicAuthUser = "";
        this.remoteSignatureBasicAuthPassword = "";
        this.configFilePath = null;
        this.tslMode = "ATSL";
        this.useDSD = true;
        this.dsdUrl1 = "https://dsd.aruba.it";
        this.dsdUrl2 = "https://dsd.aruba.it";
        this.dsdUser = "asuser";
        this.dsdToken = "";
        this.runtimeType = 1;
        this.initialize(propertiesFile, log);
    }

    public void reload() {
        this.initialize(this.configFilePath, logger);
    }

    private void initialize(String propertiesFile, Logger log) {
        block47: {
            String def_ignoreatr;
            this.configFilePath = propertiesFile;
            this.crlOnMemory = this.runtimeType != 2 ? "S" : "F";
            String def_tsa_url = System.getProperty("esecurity.default.tsaurl");
            if (!"".equals(def_tsa_url)) {
                this.tsaData.setTSAUrl(def_tsa_url);
            }
            if ((def_ignoreatr = System.getProperty("esecurity.default.ignoreatr")) == null || def_ignoreatr.equals("")) {
                def_ignoreatr = "F";
            } else {
                this.ignoreAtr = def_ignoreatr;
            }
            String def_preferpdfcades = System.getProperty("esecurity.default.preferpdfcades");
            if (def_preferpdfcades == null || def_preferpdfcades.equals("")) {
                def_preferpdfcades = "S";
            } else {
                this.preferPdfCades = def_preferpdfcades;
            }
            try {
                File objFile = new File(propertiesFile);
                if (objFile.exists()) {
                    String decrypt_value;
                    String dsdTk;
                    String decrypt_value2;
                    IniPreferences prefs = new IniPreferences(new Ini(objFile));
                    this.ntlmSupport = prefs.node("arDigiSign").get("ntlmsupoort", "F");
                    if (this.netConf == null) {
                        if (this.ntlmSupport.equals("S") || this.runtimeType == 0) {
                            if (this.ntlmSupport.equals("S")) {
                                System.setProperty("esecurity.urlutils.defaultprovider", "ApacheHttpClientProvider");
                                this.netConf = new NetworkConfig(log, true);
                                this.netConf.setProvidername("ApacheHttpClientProvider");
                            } else {
                                this.netConf = new NetworkConfig(log, true);
                            }
                        } else {
                            this.netConf = new NetworkConfig(log, false);
                        }
                    }
                    if (prefs.node("arDigiSign").get("ArFDTsaUrl", "").equals("")) {
                        this.tsaData.setTSAUrl("https://servizi.arubapec.it/tsa/ngrequest.php");
                    } else {
                        this.tsaData.setTSAUrl(prefs.node("arDigiSign").get("ArFDTsaUrl", ""));
                    }
                    this.tsaData.setTSAUser(prefs.node("arDigiSign").get("ArFDTsaUser", ""));
                    this.tsaData.setTSAPassword(prefs.node("arDigiSign").get("ArFDTsaPassword", ""));
                    if (this.tsaData.getTSAPassword() != null && !this.tsaData.getTSAPassword().equals("")) {
                        decrypt_value2 = SecretStore.DecryptByPassword((String)CRYPT_SALT, (String)USER_NAME, (String)this.tsaData.getTSAPassword());
                        if (decrypt_value2 != null && !decrypt_value2.equals("") && !decrypt_value2.equals("******AS350")) {
                            this.tsaData.setTSAPassword(decrypt_value2);
                        } else if (decrypt_value2 != null && !decrypt_value2.equals("") && decrypt_value2.equals("******AS350")) {
                            this.tsaData.setTSAPassword("");
                        }
                    }
                    this.tsaData.setTSAPolicy(prefs.node("arDigiSign").get("ArFDTsaPolicy", ""));
                    this.tsaData.setTSAAlternativeUrl(prefs.node("arDigiSign").get("TSAAlternativeUrl", ""));
                    this.tsaData.setTSAAlternativeUser(prefs.node("arDigiSign").get("TSAAlternativeUser", ""));
                    this.tsaData.setTSAAlternativePassword(prefs.node("arDigiSign").get("TSAAlternativePassword", ""));
                    if (this.tsaData.getTSAAlternativePassword() != null && !this.tsaData.getTSAAlternativePassword().equals("")) {
                        decrypt_value2 = SecretStore.DecryptByPassword((String)CRYPT_SALT, (String)USER_NAME, (String)this.tsaData.getTSAAlternativePassword());
                        if (decrypt_value2 != null && !decrypt_value2.equals("") && !decrypt_value2.equals("******AS350")) {
                            this.tsaData.setTSAAlternativePassword(decrypt_value2);
                        } else if (decrypt_value2 != null && !decrypt_value2.equals("") && decrypt_value2.equals("******AS350")) {
                            this.tsaData.setTSAAlternativePassword("");
                        }
                    }
                    String proxy = prefs.node("arDigiSign").get("ArFDProxyName", "");
                    String proxyHost = "";
                    String proxyType = "";
                    if (proxy != null && !proxy.isEmpty()) {
                        int typeIndex = proxy.indexOf(":");
                        int hostIndex = proxy.indexOf("//");
                        if (typeIndex != -1) {
                            proxyType = proxy.substring(0, typeIndex);
                        }
                        proxyHost = hostIndex != -1 ? proxy.substring(hostIndex + 2) : proxy;
                    }
                    this.netConf.setProxy(proxyHost);
                    this.netConf.setProxyType(proxyType);
                    this.netConf.setProxyPort(prefs.node("arDigiSign").get("ArFDProxyPort", ""));
                    this.netConf.setUserProxy(prefs.node("arDigiSign").get("ArFDProxyUser", ""));
                    String ArFDProxyPassword = prefs.node("arDigiSign").get("ArFDProxyPassword", "");
                    if (ArFDProxyPassword != null && !ArFDProxyPassword.equals("")) {
                        String decrypt_value3 = SecretStore.DecryptByPassword((String)CRYPT_SALT, (String)USER_NAME, (String)ArFDProxyPassword);
                        ArFDProxyPassword = decrypt_value3 != null && !decrypt_value3.equals("") ? decrypt_value3 : "";
                    }
                    this.netConf.setPasswordProxy(ArFDProxyPassword);
                    proxy = prefs.node("arDigiSign").get("ArFDSocks5Name", "");
                    proxyHost = "";
                    proxyType = "";
                    if (proxy != null && !proxy.isEmpty()) {
                        int typeIndex = proxy.indexOf(":");
                        int hostIndex = proxy.indexOf("//");
                        if (typeIndex != -1) {
                            proxyType = proxy.substring(0, typeIndex);
                        }
                        proxyHost = hostIndex != -1 ? proxy.substring(hostIndex + 2) : proxy;
                    }
                    this.netConf.setLdapProxy(proxyHost);
                    this.netConf.setLdapProxyType(proxyType);
                    this.netConf.setLdapProxyPort(prefs.node("arDigiSign").get("ArFDSocks5Port", ""));
                    this.netConf.setLdapUserProxy(prefs.node("arDigiSign").get("ArFDSocks5User", ""));
                    String ArFDSocks5Password = prefs.node("arDigiSign").get("ArFDSocks5Password", "");
                    if (ArFDSocks5Password != null && !ArFDSocks5Password.equals("")) {
                        String decrypt_value4 = SecretStore.DecryptByPassword((String)CRYPT_SALT, (String)USER_NAME, (String)ArFDSocks5Password);
                        ArFDSocks5Password = decrypt_value4 != null && !decrypt_value4.equals("") ? decrypt_value4 : "";
                    }
                    this.netConf.setLdapPasswordProxy(ArFDSocks5Password);
                    this.feaActivated = prefs.node("arDigiSign").get("FEAActivated", "").equals("") ? "F" : prefs.node("arDigiSign").get("FEAActivated", "");
                    this.cacheCRL = prefs.node("arDigiSign").get("cacheCRL", "").equals("") ? "F" : prefs.node("arDigiSign").get("cacheCRL", "");
                    this.preferOCSP = prefs.node("arDigiSign").get("preferOCSP", "").equals("") ? "F" : prefs.node("arDigiSign").get("preferOCSP", "");
                    this.asUseCNS = prefs.node("arDigiSign").get("ASUseCNS", "").equals("") ? "F" : prefs.node("arDigiSign").get("ASUseCNS", "");
                    this.p11Override = prefs.node("arDigiSign").get("p11override", "");
                    this.ignoreAtr = prefs.node("arDigiSign").get("ignoreatr", "").equals("") ? def_ignoreatr : prefs.node("arDigiSign").get("ignoreatr", "");
                    this.preferPdfCades = prefs.node("arDigiSign").get("preferpdfcades", "").equals("") ? def_preferpdfcades : prefs.node("arDigiSign").get("preferpdfcades", "");
                    this.netConf.setReadTimeOut(prefs.node("arDigiSign").get("readTimeOut", "").equals("") ? "14000" : prefs.node("arDigiSign").get("readTimeOut", ""));
                    this.netConf.setConnectionTimeOut(prefs.node("arDigiSign").get("connectionTimeOut", "").equals("") ? "4000" : prefs.node("arDigiSign").get("connectionTimeOut", ""));
                    this.netConf.setAutomaticProxyDiscovery(prefs.node("arDigiSign").get("autoProxy", "S").equals("S"));
                    this.crlProxy = prefs.node("arDigiSign").get("crlProxy", "");
                    this.crlProxyPort = prefs.node("arDigiSign").get("crlProxyPort", "");
                    this.lang = prefs.node("arDigiSign").get("lang", "");
                    this.scriptStatus = prefs.node("arDigiSign").get("script_status", "0");
                    if (this.lang.equals("")) {
                        this.lang = System.getProperty("user.language");
                    }
                    String ver = prefs.node("arDigiSign").get("version", "");
                    if (!prefs.node("arDigiSign").get("crlOnMemory", "").equals("")) {
                        this.crlOnMemory = prefs.node("arDigiSign").get("crlOnMemory", "");
                    }
                    if (!prefs.node("arDigiSign").get("ServerAS", "").equals("")) {
                        this.serverAS = prefs.node("arDigiSign").get("ServerAS", "");
                    }
                    this.userNameAS = prefs.node("arDigiSign").get("UserNameAS", "");
                    if (!prefs.node("arDigiSign").get("ServerAS2", "").equals("")) {
                        this.serverAS2 = prefs.node("arDigiSign").get("ServerAS2", "");
                    }
                    if (!prefs.node("arDigiSign").get("pptUrl", "").equals("")) {
                        this.pptUrl = prefs.node("arDigiSign").get("pptUrl", "");
                    }
                    this.userDomainAS = prefs.node("arDigiSign").get("UserDomainAS", System.getProperty("esecurity.default.rsdomain", "firma"));
                    this.p11On = !prefs.node("arDigiSign").get("p11on", "").equals("") ? prefs.node("arDigiSign").get("p11on", "") : (this.runtimeType != 2 ? "S" : "F");
                    String curLogLevel = prefs.node("arDigiSign").get("loggerLevel", "0");
                    if (curLogLevel.compareTo("0") == 0) {
                        this.loggerLevelStatus = 0;
                    } else if (curLogLevel.compareTo("1") == 0) {
                        this.loggerLevelStatus = 1;
                    } else if (curLogLevel.compareTo("2") == 0) {
                        this.loggerLevelStatus = 2;
                    }
                    this.timeZone = prefs.node("arDigiSign").get("timeZone", "UTC");
                    this.useTimeZoneUTC = true;
                    String useUTC = prefs.node("arDigiSign").get("useTimeZoneUTC", "1");
                    if (useUTC.equals("0")) {
                        this.useTimeZoneUTC = false;
                    }
                    this.tslMode = prefs.node("arDigiSign").get("tslMode", "ATSL");
                    this.useDSD = prefs.node("arDigiSign").getBoolean("UseDSD", true);
                    this.dsdUrl1 = prefs.node("arDigiSign").get("DSDUrl1", "https://dsd.aruba.it");
                    this.dsdUrl2 = prefs.node("arDigiSign").get("DSDUrl2", "https://dsd.aruba.it");
                    this.dsdUser = prefs.node("arDigiSign").get("DSDUser", "asuser");
                    if (this.dsdUser.isEmpty()) {
                        this.dsdUser = "asuser";
                    }
                    if ((dsdTk = prefs.node("arDigiSign").get("DSDPassword", "")) == null || dsdTk.equals("")) {
                        dsdTk = "ixpcDnrScLsmcMAXAQZOBnilyoPapmFi8eevjNLIYS8=";
                    }
                    dsdTk = (decrypt_value = SecretStore.DecryptByPassword((String)CRYPT_SALT, (String)this.dsdUser, (String)dsdTk)) != null && !decrypt_value.equals("") ? decrypt_value : "";
                    this.dsdToken = dsdTk;
                    this.setVersion(ver);
                } else {
                    if (this.netConf == null) {
                        this.netConf = this.runtimeType != 0 ? new NetworkConfig(log, false) : new NetworkConfig(log, true);
                    }
                    if (this.runtimeType != 2) {
                        this.p11On = "S";
                        this.userDomainAS = System.getProperty("esecurity.default.rsdomain", "firma");
                    } else {
                        this.p11On = "F";
                    }
                    if (this.runtimeType == 1) {
                        this.netConf.setAutomaticProxyDiscovery(true);
                    }
                }
            }
            catch (Exception ex) {
                if (logger == null) break block47;
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        this.netConf.setPreferBasic(true);
        Locale.setDefault(ConfigParameter.fromString(this.lang));
        HTTP.setDefaultConfig(this.netConf);
    }

    public static boolean exist(int RuntimeType, File homeFolder) {
        String basedir;
        String home = homeFolder != null && homeFolder.isDirectory() ? homeFolder.getAbsolutePath() : (Platform.isWindows() ? ((basedir = System.getProperty("it.arubapec.asbasedir")) != null && basedir.equals("appdata") ? System.getenv("APPDATA") + File.separator + ".arDigiSign" : System.getProperty("user.home") + File.separator + ".arDigiSign") : System.getProperty("user.home") + File.separator + ".arDigiSign");
        switch (RuntimeType) {
            case 1: {
                return new File(home + File.separator + "arDigiCore.ini").exists();
            }
            case 0: {
                return new File(home + File.separator + "arDigiCore_applet.ini").exists();
            }
            case 2: {
                return new File(home + File.separator + "arDigiCore_srv.ini").exists();
            }
        }
        return false;
    }

    public boolean isAutomaticProxyDiscovery() {
        return this.netConf.isAutomaticProxyDiscovery();
    }

    public void setAutomaticProxyDiscovery(boolean AutomaticProxyDiscovery) {
        this.netConf.setAutomaticProxyDiscovery(AutomaticProxyDiscovery);
    }

    public String getDisableVerCertStatus() {
        return this.disableVerCertStatus;
    }

    public void setDisableVerCertStatus(String disableVerCertStatus) {
        this.disableVerCertStatus = disableVerCertStatus;
    }

    public NetworkConfig getNetConf() {
        return this.netConf;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getEnforceMode() {
        return this.netConf.getEnforceMode();
    }

    public void setEnforceMode(String enforceMode) {
        this.netConf.setEnforceMode(enforceMode);
    }

    public String getConnectionTimeOut() {
        return this.netConf.getConnectionTimeOut();
    }

    public void setConnectionTimeOut(String connectionTimeOut) {
        this.netConf.setConnectionTimeOut(connectionTimeOut);
    }

    public String getReadTimeOut() {
        return this.netConf.getReadTimeOut();
    }

    public void setReadTimeOut(String readTimeOut) {
        this.netConf.setReadTimeOut(readTimeOut);
    }

    public String getPreferPdfCades() {
        return this.preferPdfCades;
    }

    public void setPreferPdfCades(String preferPdfCades) {
        this.preferPdfCades = preferPdfCades;
    }

    public String getFEAActivated() {
        return this.feaActivated;
    }

    public void setFEAActivated(String FEAActivated) {
        this.feaActivated = FEAActivated;
    }

    public String getIgnoreAtr() {
        return this.ignoreAtr;
    }

    public void setIgnoreAtr(String ignoreAtr) {
        this.ignoreAtr = ignoreAtr;
    }

    public String getP11Override() {
        return this.p11Override;
    }

    public void setP11Override(String p11Override) {
        this.p11Override = p11Override;
    }

    public String getAsMustUrl() {
        return this.asMustUrl;
    }

    public void setAsMustUrl(String asMustUrl) {
        this.asMustUrl = asMustUrl;
    }

    public String getCrlOnMemory() {
        return this.crlOnMemory;
    }

    public void setCrlOnMemory(String crlOnMemory) {
        this.crlOnMemory = crlOnMemory;
    }

    public static Locale fromString(String locale) {
        String[] parts = locale.split("_", -1);
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        if (parts.length == 2 || parts.length == 3 && parts[2].startsWith("#")) {
            return new Locale(parts[0], parts[1]);
        }
        return new Locale(parts[0], parts[1], parts[2]);
    }

    public boolean save() {
        if (this.configFilePath == null) {
            return false;
        }
        File configFile = new File(this.configFilePath);
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
            }
            catch (IOException ex) {
                if (logger != null) {
                    logger.error(ex.getMessage());
                }
                return false;
            }
        }
        try {
            Ini objIni = new Ini();
            Profile.Section objSec = objIni.add("arDigiSign");
            objSec.add((Object)"ArFDTsaUrl", (Object)this.tsaData.getTSAUrl());
            objSec.add((Object)"TSAAlternativeUrl", (Object)this.tsaData.getTSAAlternativeUrl());
            objSec.add((Object)"ArFDTsaUser", (Object)this.tsaData.getTSAUser());
            if (this.tsaData.getTSAPassword() != null && this.tsaData.getTSAPassword().trim().equals("")) {
                this.tsaData.setTSAPassword("******AS350");
            }
            objSec.add((Object)"ArFDTsaPassword", (Object)SecretStore.CryptByPassword((String)CRYPT_SALT, (String)USER_NAME, (String)this.tsaData.getTSAPassword()));
            if (this.tsaData.getTSAPassword() != null && this.tsaData.getTSAPassword().trim().equals("******AS350")) {
                this.tsaData.setTSAPassword("");
            }
            objSec.add((Object)"ArFDTsaPolicy", (Object)this.tsaData.getTSAPolicy());
            objSec.add((Object)"TSAAlternativeUser", (Object)this.tsaData.getTSAAlternativeUser());
            if (this.tsaData.getTSAAlternativePassword() != null && this.tsaData.getTSAAlternativePassword().trim().equals("")) {
                this.tsaData.setTSAAlternativePassword("******AS350");
            }
            objSec.add((Object)"TSAAlternativePassword", (Object)SecretStore.CryptByPassword((String)CRYPT_SALT, (String)USER_NAME, (String)this.tsaData.getTSAAlternativePassword()));
            if (this.tsaData.getTSAAlternativePassword() != null && this.tsaData.getTSAAlternativePassword().trim().equals("******AS350")) {
                this.tsaData.setTSAAlternativePassword("");
            }
            objSec.add((Object)"ArFDProxyName", (Object)(this.netConf.getProxyType() + "://" + this.netConf.getProxy()));
            objSec.add((Object)"ArFDProxyPort", (Object)this.netConf.getProxyPort());
            objSec.add((Object)"ArFDProxyUser", (Object)this.netConf.getUserProxy());
            objSec.add((Object)"ArFDProxyPassword", (Object)SecretStore.CryptByPassword((String)CRYPT_SALT, (String)USER_NAME, (String)this.netConf.getPasswordProxy()));
            objSec.add((Object)"ArFDSocks5Name", (Object)(this.netConf.getLdapProxyType() + "://" + this.netConf.getLdapProxy()));
            objSec.add((Object)"ArFDSocks5Port", (Object)this.netConf.getLdapProxyPort());
            objSec.add((Object)"ArFDSocks5User", (Object)this.netConf.getLdapUserProxy());
            objSec.add((Object)"ArFDSocks5Password", (Object)SecretStore.CryptByPassword((String)CRYPT_SALT, (String)USER_NAME, (String)this.netConf.getLdapPasswordProxy()));
            objSec.add((Object)"ServerAS", (Object)this.serverAS);
            objSec.add((Object)"ServerAS2", (Object)this.serverAS2);
            objSec.add((Object)"pptUrl", (Object)this.pptUrl);
            objSec.add((Object)"UserNameAS", (Object)this.userNameAS);
            objSec.add((Object)"UserDomainAS", (Object)this.userDomainAS);
            objSec.add((Object)"cacheCRL", (Object)this.cacheCRL);
            objSec.add((Object)"preferOCSP", (Object)this.preferOCSP);
            objSec.add((Object)"p11on", (Object)this.p11On);
            objSec.add((Object)"p11override", (Object)this.p11Override);
            objSec.add((Object)"ignoreatr", (Object)this.ignoreAtr);
            objSec.add((Object)"preferpdfcades", (Object)this.preferPdfCades);
            objSec.add((Object)"readTimeOut", (Object)this.netConf.getReadTimeOut());
            objSec.add((Object)"connectionTimeOut", (Object)this.netConf.getConnectionTimeOut());
            objSec.add((Object)"version", (Object)this.version);
            objSec.add((Object)"crlOnMemory", (Object)this.crlOnMemory);
            objSec.add((Object)"crlProxy", (Object)this.crlProxy);
            objSec.add((Object)"crlProxyPort", (Object)this.crlProxyPort);
            objSec.add((Object)"ASUseCNS", (Object)this.asUseCNS);
            objSec.add((Object)"lang", (Object)this.lang);
            objSec.add((Object)"script_status", (Object)this.scriptStatus);
            if (this.loggerLevelStatus == 0) {
                objSec.add((Object)"loggerLevel", (Object)"0");
            } else if (this.loggerLevelStatus == 1) {
                objSec.add((Object)"loggerLevel", (Object)"1");
            } else if (this.loggerLevelStatus == 2) {
                objSec.add((Object)"loggerLevel", (Object)"2");
            }
            if (this.netConf.isAutomaticProxyDiscovery()) {
                objSec.add((Object)"autoProxy", (Object)"S");
            } else {
                objSec.add((Object)"autoProxy", (Object)"F");
            }
            objSec.add((Object)"ntlmsupoort", (Object)this.ntlmSupport);
            objSec.add((Object)"timeZone", (Object)this.timeZone);
            if (this.useTimeZoneUTC) {
                objSec.add((Object)"useTimeZoneUTC", (Object)"1");
            } else {
                objSec.add((Object)"useTimeZoneUTC", (Object)"0");
            }
            objSec.add((Object)"tslMode", (Object)this.tslMode);
            objSec.add("UseDSD", (Object)this.useDSD);
            objSec.add((Object)"DSDUrl1", (Object)this.dsdUrl1);
            objSec.add((Object)"DSDUrl2", (Object)this.dsdUrl2);
            objSec.add((Object)"DSDUser", (Object)this.dsdUser);
            String criptToken = "";
            if (this.dsdToken != null && !this.dsdToken.isEmpty()) {
                criptToken = SecretStore.CryptByPassword((String)CRYPT_SALT, (String)this.dsdUser, (String)this.dsdToken);
            }
            objSec.add((Object)"DSDPassword", (Object)criptToken);
            objSec.add((Object)"FEAActivated", (Object)this.feaActivated);
            objIni.store((OutputStream)new FileOutputStream(configFile));
        }
        catch (Exception ex) {
            if (logger != null) {
                logger.error(ex.getMessage());
            }
            return false;
        }
        return true;
    }

    public String getP11On() {
        return this.p11On;
    }

    public void setP11On(String p11On) {
        this.p11On = p11On;
    }

    public String getCacheCRL() {
        return this.cacheCRL;
    }

    public void setCacheCRL(String cacheCRL) {
        this.cacheCRL = cacheCRL;
    }

    public String getPreferOCSP() {
        return this.preferOCSP;
    }

    public void setPreferOCSP(String preferOCSP) {
        this.preferOCSP = preferOCSP;
    }

    public String getServerAS() {
        return this.serverAS;
    }

    public void setServerAS(String ServerAS) {
        this.serverAS = ServerAS;
    }

    public String getServerAS2() {
        return this.serverAS2;
    }

    public void setServerAS2(String ServerAS2) {
        this.serverAS2 = ServerAS2;
    }

    public String getUserDomainAS() {
        return this.userDomainAS;
    }

    public void setUserDomainAS(String UserDomainAS) {
        this.userDomainAS = UserDomainAS;
    }

    public String getUserNameAS() {
        return this.userNameAS;
    }

    public void setUserNameAS(String UserNameAS) {
        this.userNameAS = UserNameAS;
    }

    public String getUserDir() {
        return this.userDir;
    }

    public String getUserHome() {
        return this.userHome;
    }

    public TSAData getTSAData() {
        return this.tsaData;
    }

    public void setTSAData(TSAData data) {
        this.tsaData = data;
    }

    public void setTSAPolicy(String TSAPolicy) {
        this.tsaData.setTSAPolicy(TSAPolicy);
    }

    public String getTSAPolicy() {
        return this.tsaData.getTSAPolicy();
    }

    public String getTSAPassword() {
        return this.tsaData.getTSAPassword();
    }

    public void setTSAPassword(String TSAPassword) {
        this.tsaData.setTSAPassword(TSAPassword);
    }

    public String getTSAAlternativePassword() {
        return this.tsaData.getTSAAlternativePassword();
    }

    public void setTSAAlternativePassword(String TSAAlternativePassword) {
        this.tsaData.setTSAAlternativePassword(TSAAlternativePassword);
    }

    public String getTSAUrl() {
        return this.tsaData.getTSAUrl();
    }

    public void setTSAUrl(String TSAUrl) {
        this.tsaData.setTSAUrl(TSAUrl);
    }

    public String getTSAAlternativeUrl() {
        return this.tsaData.getTSAAlternativeUrl();
    }

    public void setTSAAlternativeUrl(String TSAAlternativeUrl) {
        this.tsaData.setTSAAlternativeUrl(TSAAlternativeUrl);
    }

    public String getTSAUser() {
        return this.tsaData.getTSAUser();
    }

    public void setTSAUser(String TSAUser) {
        this.tsaData.setTSAUser(TSAUser);
    }

    public String getTSAAlternativeUser() {
        return this.tsaData.getTSAAlternativeUser();
    }

    public void setTSAAlternativeUser(String TSAAlternativeUser) {
        this.tsaData.setTSAAlternativeUser(TSAAlternativeUser);
    }

    public String getLdapPasswordProxy() {
        return this.netConf.getLdapPasswordProxy();
    }

    public void setLdapPasswordProxy(String socksPasswordProxy) {
        this.netConf.setLdapPasswordProxy(socksPasswordProxy);
    }

    public String getLdapProxy() {
        return this.netConf.getLdapProxy();
    }

    public void setLdapProxy(String socksProxy) {
        this.netConf.setLdapProxy(socksProxy);
    }

    public String getLdapProxyPort() {
        return this.netConf.getLdapProxyPort();
    }

    public void setLdapProxyPort(String socksProxyPort) {
        this.netConf.setLdapProxyPort(socksProxyPort);
    }

    public String getLdapUserProxy() {
        return this.netConf.getLdapUserProxy();
    }

    public void setLdapUserProxy(String socksUserProxy) {
        this.netConf.setLdapUserProxy(socksUserProxy);
    }

    public String getLdapProxyType() {
        return this.netConf.getLdapProxyType();
    }

    public void setLdapProxyType(String proxyType) {
        this.netConf.setLdapProxyType(proxyType);
    }

    public String getArubaProxyUrl() {
        return this.arubaProxyUrl;
    }

    public void setArubaProxyUrl(String ArubaProxyUrl) {
        this.arubaProxyUrl = ArubaProxyUrl;
    }

    public String getPasswordProxy() {
        return this.netConf.getPasswordProxy();
    }

    public void setPasswordProxy(String passwordProxy) {
        this.netConf.setPasswordProxy(passwordProxy);
    }

    public String getProxy() {
        return this.netConf.getProxy();
    }

    public void setProxy(String proxy) {
        this.netConf.setProxy(proxy);
    }

    public String getProxyPort() {
        return this.netConf.getProxyPort();
    }

    public void setProxyPort(String proxyPort) {
        this.netConf.setProxyPort(proxyPort);
    }

    public String getProxyType() {
        return this.netConf.getProxyType();
    }

    public void setProxyType(String proxyType) {
        this.netConf.setProxyType(proxyType);
    }

    public int getRuntimeType() {
        return this.runtimeType;
    }

    public String getUserProxy() {
        return this.netConf.getUserProxy();
    }

    public void setUserProxy(String userProxy) {
        this.netConf.setUserProxy(userProxy);
    }

    public String[] getProxyNoHosts() {
        return this.netConf.getProxynohosts();
    }

    public void setProxyNoHosts(String[] urlNoHost) {
        this.netConf.setProxynohosts(urlNoHost);
    }

    @Override
    public KeyStore.ProtectionParameter getProtectionParameter() {
        return null;
    }

    public String getPasswordAS() {
        return this.passwordAS;
    }

    public void setPasswordAS(String passwordAS) {
        this.passwordAS = passwordAS;
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public String getCrlProxy() {
        return this.crlProxy;
    }

    public void setCrlProxy(String crlProxy) {
        this.crlProxy = crlProxy;
    }

    public String getCrlProxyPort() {
        return this.crlProxyPort;
    }

    public void setCrlProxyPort(String crlProxyPort) {
        this.crlProxyPort = crlProxyPort;
    }

    public String getAsUseCNS() {
        return this.asUseCNS;
    }

    public void setAsUseCNS(String asUseCNS) {
        this.asUseCNS = asUseCNS;
    }

    public RemoteSignatureSession getRemoteSignatureSession() {
        return this.cnsSession;
    }

    public void setRemoteSignatureSession(RemoteSignatureSession cnssession) {
        this.cnsSession = cnssession;
    }

    public String getAsDelegatedUser() {
        return this.asDelegatedUser;
    }

    public void setAsDelegatedUser(String asDelegatedUser) {
        this.asDelegatedUser = asDelegatedUser;
    }

    public String getAsDelegatedPassword() {
        return this.asDelegatedPassword;
    }

    public void setAsDelegatedPassword(String asDelegatedPassword) {
        this.asDelegatedPassword = asDelegatedPassword;
    }

    public String getAsDelegatedDomain() {
        return this.asDelegatedDomain;
    }

    public void setAsDelegatedDomain(String asDelegatedDomain) {
        this.asDelegatedDomain = asDelegatedDomain;
    }

    public String getPptUrl() {
        return this.pptUrl;
    }

    public void setPptUrl(String pptUrl) {
        this.pptUrl = pptUrl;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getScriptStatus() {
        return this.scriptStatus;
    }

    public void setScriptStatus(String scriptStatus) {
        this.scriptStatus = scriptStatus;
    }

    public String getNtlmSupport() {
        return this.ntlmSupport;
    }

    public void setNtlmSupport(String ntlmSupport) {
        if (ntlmSupport.equals("S")) {
            System.setProperty("esecurity.urlutils.defaultprovider", "ApacheHttpClientProvider");
            this.netConf.setProvidername("ApacheHttpClientProvider");
        }
        this.ntlmSupport = ntlmSupport;
    }

    public File getArubaSignHome() {
        return this.arubaSignHome;
    }

    public String getUpdaterBasicAuthUser() {
        return this.updaterBasicAuthUser;
    }

    public void setUpdaterBasicAuthUser(String updaterBasicAuthUser) {
        this.updaterBasicAuthUser = updaterBasicAuthUser;
    }

    public String getUpdaterBasicAuthPassword() {
        return this.updaterBasicAuthPassword;
    }

    public void setUpdaterBasicAuthPassword(String updaterBasicAuthPassword) {
        this.updaterBasicAuthPassword = updaterBasicAuthPassword;
    }

    public String getApplicationUsername() {
        return this.applicationUsername;
    }

    public void setApplicationUsername(String applicationUsername) {
        this.applicationUsername = applicationUsername;
    }

    public String getApplicationPassword() {
        return this.applicationPassword;
    }

    public void setApplicationPassword(String applicationPassword) {
        this.applicationPassword = applicationPassword;
    }

    public int getLoggerLevelStatus() {
        return this.loggerLevelStatus;
    }

    public void setLoggerLevelStatus(int loggerLevelStatus) {
        this.loggerLevelStatus = loggerLevelStatus;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean isUseTimeZoneUTC() {
        return this.useTimeZoneUTC;
    }

    public void setUseTimeZoneUTC(boolean useTimeZoneUTC) {
        this.useTimeZoneUTC = useTimeZoneUTC;
    }

    public String getRequestTsaUrl() {
        return this.requestTsaUrl;
    }

    public void setRequestTsaUrl(String requestTsaUrl) {
        this.requestTsaUrl = requestTsaUrl;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public String getRemoteSignatureBasicAuthUser() {
        return this.remoteSignatureBasicAuthUser;
    }

    public void setRemoteSignatureBasicAuthUser(String remoteSignatureBasicAuthUser) {
        this.remoteSignatureBasicAuthUser = remoteSignatureBasicAuthUser;
    }

    public String getRemoteSignatureBasicAuthPassword() {
        return this.remoteSignatureBasicAuthPassword;
    }

    public void setRemoteSignatureBasicAuthPassword(String remoteSignatureBasicAuthPassword) {
        this.remoteSignatureBasicAuthPassword = remoteSignatureBasicAuthPassword;
    }

    public void setTSLMode(String mode) {
        this.tslMode = mode;
    }

    public String getTSLMode() {
        return this.tslMode;
    }

    public void setUseDSD(boolean useDSD) {
        this.useDSD = useDSD;
    }

    public boolean isUseDSD() {
        return this.useDSD;
    }

    public void setDSDUrl1(String dsdUrl1) {
        this.dsdUrl1 = dsdUrl1;
    }

    public String getDSDUrl1() {
        return this.dsdUrl1;
    }

    public void setDSDUrl2(String dsdUrl1) {
        this.dsdUrl1 = dsdUrl1;
    }

    public String getDSDUrl2() {
        return this.dsdUrl2;
    }

    public void setDSDUser(String user) {
        this.dsdUser = user;
    }

    public String getDSDUser() {
        return this.dsdUser;
    }

    public void setDSDPassword(String password) {
        this.dsdToken = password;
    }

    public String getDSDPassword() {
        return this.dsdToken;
    }

    public ConfigFile toConfigFile(String cert_db_path, String crlPath) {
        ConfigFile configFile = new ConfigFile(null);
        if (cert_db_path != null) {
            configFile.setElement("certdb.file", cert_db_path);
            configFile.setElement("certdb.pwd", "1234567890AAbbCCdd");
        }
        configFile.setElement("verify.revocation", "true");
        if (this.preferOCSP.equals("D")) {
            configFile.setElement("verify.mode", RevocationVerifyMode.CRLONLY.name());
        } else if (this.preferOCSP.equals("O")) {
            configFile.setElement("verify.mode", RevocationVerifyMode.OCSPONLY.name());
        } else if (this.preferOCSP.equals("S")) {
            configFile.setElement("verify.mode", RevocationVerifyMode.OCSPFIRST.name());
        } else {
            configFile.setElement("verify.mode", RevocationVerifyMode.CRLFIRST.name());
        }
        configFile.setBinElement("crl.cacheinmemory", this.cacheCRL.equals("S"));
        configFile.setElement("crl.dir", crlPath);
        configFile.setElement("crl.behavior", "LDAPFIRST");
        configFile.setElement("crl.ldap.timeout", "60000");
        configFile.setElement("crl.http.timeout", "60000");
        configFile.setElement("ocsp.timeout", "60000");
        configFile.setElement("usedatesign", "0");
        configFile.setElement("crl.update.period", "5");
        configFile.setElement("http.proxy", "false");
        if (this.netConf != null) {
            if (this.netConf.isAutomaticProxyDiscovery()) {
                configFile.setElement("http.proxy.auto", "true");
            } else if (this.netConf.getProxy() != null && !this.netConf.getProxy().isEmpty()) {
                configFile.setElement("http.proxy", "true");
                configFile.setElement("http.proxy.host", this.netConf.getProxy());
                configFile.setElement("http.proxy.type", this.netConf.getProxyType());
                configFile.setElement("http.proxy.port", this.netConf.getProxyPort());
                configFile.setElement("http.proxy.user", this.netConf.getUserProxy());
                configFile.setElement("http.proxy.pass", this.netConf.getPasswordProxy());
                String noProxyHosts = "";
                String[] noProxyHostsArray = this.netConf.getProxynohosts();
                if (noProxyHostsArray != null) {
                    noProxyHosts = "";
                    for (String noHost : noProxyHostsArray) {
                        noProxyHosts = noProxyHosts.isEmpty() ? noHost : noProxyHosts + "," + noHost;
                    }
                }
                configFile.setElement("http.proxy.noProxyHosts", noProxyHosts);
                configFile.setElement("http.proxy.workstation", "");
                configFile.setElement("http.proxy.domain", "");
                configFile.setElement("http.proxy.realm", "");
            }
        }
        if (this.crlProxy != null && !this.crlProxy.isEmpty()) {
            configFile.setElement("sogei.proxy", this.crlProxy);
            if (this.crlProxyPort != null && !this.crlProxyPort.isEmpty()) {
                configFile.setElement("sogei.proxy.port", this.crlProxyPort);
            }
        }
        configFile.setElement("ldap.proxy ", "false");
        if (this.netConf != null && this.netConf.getLdapProxy() != null && !this.netConf.getLdapProxy().isEmpty()) {
            configFile.setElement("ldap.proxy", "true");
            configFile.setElement("ldap.proxy.host", this.netConf.getLdapProxy());
            configFile.setElement("ldap.proxy.type", this.netConf.getLdapProxyType());
            configFile.setElement("ldap.proxy.port", this.netConf.getLdapProxyPort());
            configFile.setElement("ldap.proxy.user", this.netConf.getLdapUserProxy());
            configFile.setElement("ldap.proxy.pass", this.netConf.getLdapPasswordProxy());
        }
        configFile.setElement("log.config", "log4j.properties");
        configFile.setBinElement("isTimeZoneUTC", this.useTimeZoneUTC);
        configFile.setElement("timeZone", this.useTimeZoneUTC ? "UTC" : this.timeZone);
        configFile.setElement("language", this.lang);
        return configFile;
    }

    public void printLog() {
        if (logger == null) {
            return;
        }
        logger.info("--------------------------Config Parameter--------------------------------------");
        switch (this.runtimeType) {
            case 0: {
                logger.info("CONFIG_RUNTIMETYPE_APPLET");
                break;
            }
            case 1: {
                logger.info("CONFIG_RUNTIMETYPE_APP");
                break;
            }
            case 2: {
                logger.info("CONFIG_RUNTIMETYPE_SRV");
            }
        }
        logger.info("ArubaProxyUrl: " + this.arubaProxyUrl);
        logger.info("TSAUrl: " + this.tsaData.getTSAUrl());
        logger.info("TSAAlternativeUrl: " + this.tsaData.getTSAAlternativeUrl());
        logger.info("TSAPolicy: " + this.tsaData.getTSAPolicy());
        logger.info("ServerAS: " + this.serverAS);
        logger.info("ServerAS2: " + this.serverAS2);
        logger.info("ASUseCNS: " + this.asUseCNS);
        logger.info("ASMUSTURL: " + this.asMustUrl);
        logger.info("p11on: " + this.p11On);
        logger.info("Session: " + this.session);
        logger.info("CacheCRL: " + this.cacheCRL);
        logger.info("PreferOCSP: " + this.preferOCSP);
        logger.info("p11override: " + this.p11Override);
        logger.info("Ignoreatr: " + this.ignoreAtr);
        logger.info("PreferPdfCades: " + this.preferPdfCades);
        logger.info("Version: " + this.version);
        logger.info("CRLOnMemory: " + this.crlOnMemory);
        logger.info("DisableVerCertStatus: " + this.disableVerCertStatus);
        logger.info("CRLProxy: " + this.crlProxy);
        logger.info("CRLProxyPort: " + this.crlProxyPort);
        logger.info("pptUrl: " + this.pptUrl);
        logger.info("Proxy: " + this.netConf.getProxyType() + "://" + this.netConf.getProxy() + ":" + this.netConf.getProxyPort());
        logger.info("Proxy Ldap: " + this.netConf.getLdapProxyType() + "://" + this.netConf.getLdapProxy() + ":" + this.netConf.getLdapProxyPort());
        logger.info("Lang: " + this.lang);
        logger.info("ScriptStatus: " + this.scriptStatus);
        logger.info("NTLMSupport: " + this.ntlmSupport);
        logger.info("ArubaSignHome: " + this.arubaSignHome);
        logger.info("UserHome: " + this.userHome);
        logger.info("UserDir: " + this.userDir);
        logger.info("TimeZone: " + this.timeZone);
        logger.info("UsetimeZoneUTC: " + (this.useTimeZoneUTC ? "true" : "false"));
        logger.info("RequestTsaUrl: " + this.requestTsaUrl);
        logger.info("ConfigFilePath: " + this.configFilePath);
        logger.info("-----------------------------------------------------------------------------------");
    }
}

