/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.logger.utils;

import com.sun.jna.Platform;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.logging.LoggerConfig;
import it.actalis.ellips.capi.logging.LoggerLevel;
import it.arubapec.ca.utils.ConfigParameter;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationLogger {
    private static final int DEFAULT_LOG_MAXSIZE_MB = 100;
    private static boolean bIsInitialized = false;
    private static Logger logger = null;
    private static String defLogFolder = ".arDigiSign";
    private static String defLogFileName = "arDigiSign.log";
    private static String defLogName = "ArubaSign";
    private static boolean defLogDelete = true;
    private static boolean defUseLogSubFolder = true;

    public static Logger initLogger(String logFolderName, String logFileName, String loggerName, boolean deleteLogFolder, boolean useLogSubFolder) {
        if (logFolderName == null || logFolderName.isEmpty()) {
            logFolderName = defLogFolder;
        }
        if (logFileName == null || logFileName.isEmpty()) {
            logFileName = defLogFileName;
        }
        if (loggerName == null || loggerName.isEmpty()) {
            loggerName = defLogName;
        }
        try {
            String base_dir_as;
            String userhome = System.getProperty("user.home");
            String base_dir = "";
            base_dir = Platform.isWindows() ? ((base_dir_as = System.getProperty("it.arubapec.asbasedir")) != null && base_dir_as.equals("appdata") ? System.getenv("APPDATA") : userhome) : userhome;
            String logFilePath = "";
            if (base_dir != null) {
                String strLogDir = base_dir + File.separator + logFolderName;
                if (logFolderName.startsWith(base_dir)) {
                    strLogDir = logFolderName;
                }
                if (useLogSubFolder) {
                    strLogDir = strLogDir + File.separator + "log";
                }
                logFilePath = strLogDir + File.separator + logFileName;
                ApplicationLogger.initLogger(logFilePath, loggerName, deleteLogFolder);
            }
            if (logger != null) {
                logger.info("[ArubaSignCommon] log file for " + loggerName + ": " + logFilePath);
            } else {
                logger = LoggerFactory.getLogger(ApplicationLogger.class);
                logger.info("[ArubaSignCommon] instanced default logger");
            }
        }
        catch (RuntimeException e) {
            bIsInitialized = false;
            System.err.println(e.getMessage());
        }
        catch (Exception ex) {
            bIsInitialized = false;
            System.err.println(ex.getMessage());
        }
        return logger;
    }

    public static Logger initLogger(String logFolderName, String logFileName, String loggerName) {
        return ApplicationLogger.initLogger(logFolderName, logFileName, loggerName, defLogDelete, defUseLogSubFolder);
    }

    private static void initLogger(String logFilePath, String appName, boolean deleteLogFolder) throws IOException {
        ConfigParameter conf = new ConfigParameter(1);
        int levelStatus = conf.getLoggerLevelStatus();
        ApplicationLogger.manageLogFolder(new File(new File(logFilePath).getParent()), deleteLogFolder, levelStatus);
        try {
            LoggerConfig config = new LoggerConfig();
            config.setFileAppender(new File(logFilePath));
            config.setSpaceRolling(100L);
            String debug = System.getProperty("esecurity.logger.debug");
            boolean bSystemDebug = debug != null && debug.equals("true");
            boolean bConfDebug = levelStatus == 2;
            logger = bSystemDebug || bConfDebug ? EllipsLoggerFactory.createLogger((String)appName, (String)"%d [%t] [%p] %C{1}.%M(%F:%L) - %m%n", (LoggerLevel)LoggerLevel.DEBUG, (LoggerConfig)config) : EllipsLoggerFactory.createLogger((String)appName, (String)"%d [%t] [%p] %C{1}.%M(%F:%L) - %m%n", (LoggerLevel)LoggerLevel.INFO, (LoggerConfig)config);
            EllipsLoggerFactory.setMasterLogger((String)logger.getName());
            bIsInitialized = true;
        }
        catch (Exception ex) {
            bIsInitialized = false;
            System.err.println(ex.getMessage());
        }
    }

    private static void manageLogFolder(File logFolder, boolean deleteLogFolder, int levelStatus) {
        if (levelStatus == 0) {
            if (deleteLogFolder && logFolder.exists()) {
                String[] entries;
                for (String filePath : entries = logFolder.list()) {
                    File currentFile = new File(logFolder.getPath(), filePath);
                    currentFile.delete();
                }
                logFolder.delete();
            }
        } else if (!logFolder.exists()) {
            logFolder.mkdirs();
        }
    }

    public static void release() throws CapiException {
        EllipsLoggerFactory.removeLogger((EllipsLogger)((EllipsLogger)logger));
        logger = null;
        bIsInitialized = false;
    }

    public static boolean isInitialized() {
        return bIsInitialized;
    }
}

