/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.vol.volstream;

import java.io.IOException;
import java.io.InputStream;

public class B64EncoderInputStream
extends InputStream {
    public static final int[] EncodeLookUp = new int[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    int len = 0;
    int cnt = 0;
    int buf;
    int val;
    InputStream in = null;

    public B64EncoderInputStream(InputStream inStream) throws IOException {
        this.in = inStream;
    }

    @Override
    public int read() throws IOException {
        if (this.len < 6) {
            this.val = this.in.read();
            if (this.val < 0) {
                if (this.len <= 0) {
                    if ((this.cnt & 3) == 0) {
                        return this.val;
                    }
                    ++this.cnt;
                    return 61;
                }
            } else {
                this.buf |= this.val << 8 - this.len;
                this.len += 8;
            }
        }
        this.val = this.buf >> 10 & 0x3F;
        this.buf <<= 6;
        this.len -= 6;
        ++this.cnt;
        return EncodeLookUp[this.val];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int count = 0;
        for (int i = 0; i < length; ++i) {
            int dato = this.read();
            if (dato < 0) {
                if (count != 0) break;
                return -1;
            }
            b[offset + i] = dato > 127 ? (byte)(dato - 256) : (byte)dato;
            ++count;
        }
        return count;
    }

    @Override
    public int available() throws IOException {
        return this.in.available() + (this.len >= 6 ? 1 : 0);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long n) throws IOException {
        long dato;
        long count = 0L;
        for (long l = 0L; l < n && (dato = (long)this.read()) >= 0L; ++l) {
            ++count;
        }
        return count;
    }
}

