/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.vol.network;

import esecurity.validator.ValidatorConfig;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.ldap.LdapClient;
import it.actalis.ellips.capi.ldap.LdapEntry;
import it.actalis.ellips.capi.ldap.LdapException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.exception.NetworkException;
import it.actalis.vol.network.Helper;
import it.actalis.vol.utils.ConfigFile;
import it.actalis.vol.utils.Constants;
import org.slf4j.Logger;

public class LDAPhelper
implements Helper {
    private Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private int timeout = 0;
    private String ldapProxyHost = null;
    private String ldapProxyType = null;
    private String ldapProxyPort = null;
    private String ldapProxyUser = null;
    private String ldapProxyPass = null;
    private boolean useLdapProxy = false;
    private NetworkConfig networkConfig = null;
    String url = null;

    public LDAPhelper(ConfigFile conf) {
        this.useLdapProxy = Boolean.valueOf(conf.getElement("ldap.proxy", "false"));
        if (this.useLdapProxy) {
            this.logger.info("Use ldap proxy");
            this.ldapProxyHost = conf.getElement("ldap.proxy.host");
            this.ldapProxyPort = conf.getElement("ldap.proxy.port");
            this.ldapProxyUser = conf.getElement("ldap.proxy.user");
            this.ldapProxyPass = conf.getElement("ldap.proxy.pass");
            this.ldapProxyType = conf.getElement("ldap.proxy.type");
            this.timeout = conf.getIntElement("crl.ldap.timeout", 5000);
            if (this.ldapProxyHost == null) {
                this.logger.info("ldap.proxy.host == null use crl.ldap.proxy.host");
                this.ldapProxyHost = conf.getElement("crl.ldap.proxy.host");
                this.ldapProxyPort = conf.getElement("crl.ldap.proxy.port");
                this.ldapProxyUser = conf.getElement("crl.ldap.proxy.user");
                this.ldapProxyPass = conf.getElement("crl.ldap.proxy.pass");
                this.timeout = conf.getIntElement("crl.ldap.timeout", 5000);
            }
        }
    }

    public LDAPhelper(ValidatorConfig conf) {
        this.useLdapProxy = Boolean.valueOf(conf.getElement("ldap.proxy", "false"));
        if (this.useLdapProxy) {
            this.logger.info("Use ldap proxy");
            this.ldapProxyHost = conf.getElement("ldap.proxy.host");
            this.ldapProxyPort = conf.getElement("ldap.proxy.port");
            this.ldapProxyUser = conf.getElement("ldap.proxy.user");
            this.ldapProxyPass = conf.getElement("ldap.proxy.pass");
            this.ldapProxyType = conf.getElement("ldap.proxy.type");
            this.timeout = conf.getIntElement("crl.ldap.timeout", 5000);
            if (this.ldapProxyHost == null) {
                this.logger.info("ldap.proxy.host == null use crl.ldap.proxy.host");
                this.ldapProxyHost = conf.getElement("crl.ldap.proxy.host");
                this.ldapProxyPort = conf.getElement("crl.ldap.proxy.port");
                this.ldapProxyUser = conf.getElement("crl.ldap.proxy.user");
                this.ldapProxyPass = conf.getElement("crl.ldap.proxy.pass");
                this.timeout = conf.getIntElement("crl.ldap.timeout", 5000);
            }
            this.networkConfig = conf.getNetConfiguration();
        }
    }

    @Override
    public byte[] retrieveData() throws NetworkException {
        return this.retrieveData(this.url);
    }

    @Override
    public byte[] retrieveData(String url) throws NetworkException {
        try {
            String[] parsedurl = LdapClient.parseUrl((String)url);
            int port = 389;
            LdapClient cli = null;
            cli = this.useLdapProxy ? new LdapClient(parsedurl[0], port, "", this.timeout, this.networkConfig) : new LdapClient(parsedurl[0], port, "", this.timeout);
            LdapEntry entry = cli.getEntry(parsedurl[2]);
            byte[] result = entry.getBinAttribute(0, parsedurl[3]);
            return result;
        }
        catch (LdapException e) {
            throw new NetworkException(e);
        }
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    private LdapClient setLdapProxy(String urlAddress, int port, LdapClient client) throws LdapException {
        client = new LdapClient(urlAddress, port, "", 0, this.ldapProxyHost, Integer.parseInt(this.ldapProxyPort));
        return client;
    }
}

