/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util.ini;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.ini.IniSerializableObject;
import it.actalis.ellips.capi.util.ini.IniStringHashMap;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;

public class IniFile {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    HashMap<String, IniSerializableObject> table = new HashMap();

    public void load(byte[] buf, Class<? extends IniSerializableObject> IniSerializableClass) throws UnsupportedEncodingException, InstantiationException, IllegalAccessException {
        IniSerializableObject section;
        if (buf.length == 0) {
            return;
        }
        HashMap<String, String> childTable = new HashMap<String, String>();
        boolean subentry = false;
        String mainKey = null;
        String temp = null;
        int first = 0;
        int next = 0;
        String line = null;
        while ((next = this.readLine(buf, first)) != -1) {
            block15: {
                block16: {
                    block14: {
                        if (next != first) break block14;
                        if (buf[first] == 10) break block15;
                        line = "";
                        break block16;
                    }
                    line = new String(buf, first, next - first, "ISO8859_1");
                }
                if (line.endsWith("\\")) {
                    line = line.substring(0, line.length() - 1);
                    if (temp == null) {
                        temp = "";
                    }
                    temp = temp + line + '\r' + '\n';
                } else {
                    if (temp != null) {
                        line = temp + line;
                        temp = null;
                    }
                    if (line.length() != 0 && !line.startsWith("#") && !line.startsWith(";")) {
                        int index;
                        if (line.startsWith("[")) {
                            if (mainKey != null) {
                                section = IniSerializableClass.newInstance();
                                section.initAsStringHashMap(this.table, mainKey, childTable);
                                if (mainKey != section.getID()) {
                                    mainKey = section.getID();
                                }
                                this.table.put(mainKey, section);
                            }
                            mainKey = line.substring(1, line.length() - 1);
                            childTable = new HashMap();
                            subentry = true;
                        } else if (subentry && (index = line.indexOf("=")) != -1) {
                            String key = line.substring(0, index);
                            String value = null;
                            value = line.length() <= index + 1 ? "" : line.substring(index + 1, line.length());
                            childTable.put(key, value);
                        }
                    }
                }
            }
            first = next + 1;
        }
        if (mainKey != null) {
            section = IniSerializableClass.newInstance();
            section.initAsStringHashMap(this.table, mainKey, childTable);
            if (mainKey != section.getID()) {
                mainKey = section.getID();
            }
            this.table.put(mainKey, section);
        }
    }

    public void store(ByteArrayOutputStream os) throws IOException {
        os.reset();
        char[] c = new char[]{'\r', '\n'};
        String newLine = new String(c);
        for (Map.Entry<String, IniSerializableObject> entry : this.table.entrySet()) {
            this.printLine(os, "[" + entry.getKey() + "]");
            HashMap<String, String> map = entry.getValue().getAsStringHashMap();
            for (Map.Entry<String, String> sectionEntry : map.entrySet()) {
                String value = sectionEntry.getValue();
                if (value.indexOf(newLine) != -1) {
                    value = this.convertML(value);
                }
                String line = sectionEntry.getKey() + "=" + value;
                this.printLine(os, line);
            }
        }
        os.close();
    }

    public void setObject(String object, IniSerializableObject values) {
        this.table.put(object, values);
    }

    public void setProperty(String object, String key, String value) {
        if (this.table.containsKey(object)) {
            IniSerializableObject childTable = this.table.get(object);
            childTable.put(key, value);
            this.table.put(object, childTable);
        } else {
            IniStringHashMap childTable = new IniStringHashMap();
            childTable.put(key, value);
            this.table.put(object, childTable);
        }
    }

    public String[] getObjectList2() {
        if (this.table.size() <= 0) {
            return new String[0];
        }
        String[] res = new String[this.table.size()];
        int i = 0;
        for (Map.Entry<String, IniSerializableObject> entry : this.table.entrySet()) {
            res[i++] = entry.getKey();
        }
        return res;
    }

    public String[] getObjectList2(String property, String value) {
        if (this.table.size() <= 0) {
            return new String[0];
        }
        Vector<String> tmp = new Vector<String>();
        for (Map.Entry<String, IniSerializableObject> entry : this.table.entrySet()) {
            if (!value.equals(this.getProperty(entry.getKey(), property))) continue;
            tmp.addElement(entry.getKey());
        }
        String[] res = new String[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            res[i] = (String)tmp.elementAt(i);
        }
        return res;
    }

    public IniSerializableObject getObject(String object) {
        return this.table.get(object);
    }

    public String getProperty(String object, String key) {
        IniSerializableObject childTable = this.table.get(object);
        if (childTable == null) {
            return null;
        }
        return childTable.getIniPropertyStringValue(key);
    }

    public Enumeration getPropertyKeyList(String object) {
        Hashtable childTable = (Hashtable)((Object)this.table.get(object));
        if (childTable == null) {
            return null;
        }
        return childTable.keys();
    }

    public Enumeration getPropertyList(String object) {
        Hashtable childTable = (Hashtable)((Object)this.table.get(object));
        if (childTable == null) {
            return null;
        }
        return childTable.elements();
    }

    public String removeProperty(String object, String key) {
        IniSerializableObject childTable = this.table.get(object);
        if (childTable == null) {
            return null;
        }
        Object res = childTable.remove(key);
        if (res == null) {
            return null;
        }
        this.table.put(object, childTable);
        return res.toString();
    }

    public boolean removeObject(String object) {
        return this.table.remove(object) != null;
    }

    public boolean renameObject(String oldObject, String newObject) {
        IniSerializableObject childTable = this.table.get(oldObject);
        if (childTable == null) {
            return false;
        }
        this.table.put(newObject, childTable);
        return this.removeObject(oldObject);
    }

    public boolean containsObject(String object) {
        return this.table.containsKey(object);
    }

    public boolean containsProperty(String property, String value) {
        if (this.table.size() <= 0) {
            return false;
        }
        for (Map.Entry<String, IniSerializableObject> entry : this.table.entrySet()) {
            String val = entry.getValue().getIniPropertyStringValue(property);
            if (val == null || !value.equals(val)) continue;
            return true;
        }
        return false;
    }

    private String convertML(String s) {
        char[] src = s.toCharArray();
        char[] dst = new char[2 * src.length];
        int j = 0;
        for (int i = 0; i < src.length; ++i) {
            if (src[i] == '\r' && src[i + 1] == '\n') {
                dst[j] = 92;
                dst[++j] = src[i];
            } else {
                dst[j] = src[i];
            }
            ++j;
        }
        return new String(dst, 0, j);
    }

    private int readLine(byte[] data, int start) {
        for (int i = start; i < data.length; ++i) {
            if (data[i] != 13 && data[i] != 10) continue;
            return i;
        }
        return start >= data.length ? -1 : data.length;
    }

    private void printLine(ByteArrayOutputStream os, String str) throws IOException {
        byte[] data = null;
        try {
            data = Util.getBytes(str);
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        os.write(data, 0, data.length);
        os.write(13);
        os.write(10);
    }
}

