/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.SignatureAlgorithm;
import java.security.PrivateKey;
import java.security.SignatureException;

public class SignUtils {
    public static SignatureAlgorithm algoByKeyAndDigest(PrivateKey key, DigestAlgorithm algo) throws SignatureException {
        SignatureAlgorithm trovato = null;
        for (SignatureAlgorithm signAlgo : SignatureAlgorithm.values()) {
            if (!signAlgo.getSignatureAlgo().equalsIgnoreCase(key.getAlgorithm()) || signAlgo.getDigestAlgo() != algo) continue;
            trovato = signAlgo;
            break;
        }
        if (trovato == null) {
            new SignatureException("Invalid Digest Algorithm");
        }
        return trovato;
    }
}

