/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import it.actalis.ellips.capi.util.RFC4519InternalStyle;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;

public class RFC4519Utils {
    public static boolean compareDN(String dn, String dn2) {
        RDN[] uno = RFC4519InternalStyle.INSTANCE.fromString(dn);
        RDN[] due = RFC4519InternalStyle.INSTANCE.fromString(dn2);
        return RFC4519Utils.compareDN(uno, due);
    }

    public static boolean compareDN(RDN[] dn, RDN[] dn2) {
        if (dn == null || dn2 == null) {
            return false;
        }
        if (dn.length != dn2.length) {
            return false;
        }
        for (RDN firstRDN : dn) {
            if (RFC4519Utils.findMatch(firstRDN, dn2)) continue;
            return false;
        }
        return true;
    }

    private static boolean findMatch(RDN rdn, RDN[] dn) {
        for (RDN rdn2 : dn) {
            if (!RFC4519Utils.areEquals(rdn, rdn2)) continue;
            return true;
        }
        return false;
    }

    private static boolean areEquals(RDN rdn, RDN rdn2) {
        for (AttributeTypeAndValue atav : rdn.getTypesAndValues()) {
            if (RFC4519Utils.isInRDN(atav, rdn2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInRDN(AttributeTypeAndValue atav, RDN rdn) {
        for (AttributeTypeAndValue atav2 : rdn.getTypesAndValues()) {
            if (!atav.getType().equals((ASN1Primitive)atav2.getType())) continue;
            try {
                String firstValue = RFC4519Utils.asn1ToString(atav.getValue());
                String secondValue = RFC4519Utils.asn1ToString(atav2.getValue());
                if (!firstValue.equals(secondValue)) continue;
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static String asn1ToString(ASN1Encodable value) throws IOException {
        if (value instanceof ASN1String) {
            return ((ASN1String)value).getString();
        }
        return new String(value.toASN1Primitive().getEncoded()).trim();
    }
}

