/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsa;

import it.actalis.ellips.capi.core.CapiException;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.Arrays;

public class TimeStampAndCRL {
    private byte[] crl = null;
    private byte[] tst = null;

    public byte[] getCRL() {
        return Arrays.copyOf((byte[])this.crl, (int)this.crl.length);
    }

    public byte[] getTimeStampToken() {
        return Arrays.copyOf((byte[])this.tst, (int)this.tst.length);
    }

    public void setCRL(byte[] crl) {
        this.crl = Arrays.copyOf((byte[])crl, (int)crl.length);
    }

    public void setTimeStampToken(byte[] tst) {
        this.tst = Arrays.copyOf((byte[])tst, (int)tst.length);
    }

    public DERSequence getDERSequence() throws CapiException {
        if (this.tst == null) {
            throw new CapiException("No TimeStampToken in TimeStampandCRL", 50040);
        }
        try {
            ASN1EncodableVector tEv = new ASN1EncodableVector();
            ASN1Primitive asnObj = ASN1Primitive.fromByteArray((byte[])this.tst);
            tEv.add((ASN1Encodable)asnObj);
            if (this.crl != null) {
                asnObj = ASN1Primitive.fromByteArray((byte[])this.crl);
                tEv.add((ASN1Encodable)asnObj);
            }
            DERSequence seq = new DERSequence(tEv);
            return seq;
        }
        catch (IOException e) {
            throw new CapiException("IOException getting TimeStampToken", 50040);
        }
    }

    public byte[] getEncoded() throws CapiException {
        DERSequence seq = this.getDERSequence();
        if (seq == null) {
            throw new CapiException("No TimeStampToken in TimeStampandCRL", 50040);
        }
        try {
            return seq.getEncoded("DER");
        }
        catch (IOException e) {
            throw new CapiException("IOException getting TimeStampToken", 50040);
        }
    }
}

