/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisKeyStoreParameters;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class ActalisKeyStore
extends KeyStoreSpi {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    ActalisKeyStoreParameters parameter = null;
    CertificateFactory cf;
    Hashtable<String, X509Certificate> lstCert = new Hashtable();

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            if (this.parameter.getTk().isSessionOpen()) {
                return this.parameter.getTk().getPrivateKey(alias);
            }
            throw new UnrecoverableKeyException("Errore recupero chiave --> session not open");
        }
        catch (CapiException ex) {
            logger.error("Errore recupero chiave", (Throwable)ex);
            throw new UnrecoverableKeyException("Errore recupero chiave");
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] objRet = new Certificate[]{this.lstCert.get(alias)};
        return objRet;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Certificate c = this.lstCert.get(alias);
        return c;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Enumeration<String> engineAliases() {
        Enumeration<String> objReturn = null;
        objReturn = this.lstCert.keys();
        return objReturn;
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.lstCert.get(alias) != null;
    }

    @Override
    public int engineSize() {
        return this.lstCert.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        boolean blnReturn = false;
        try {
            if (this.parameter.getTk().isSessionOpen()) {
                blnReturn = this.parameter.getTk().getPrivateKey(alias) != null;
            }
        }
        catch (CapiException ex) {
            logger.error("Unable to retrieve key info", (Throwable)ex);
        }
        return blnReturn;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        boolean blnReturn = false;
        blnReturn = this.lstCert.get(alias) != null;
        return blnReturn;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        String strReturn = null;
        for (String alias : this.lstCert.keySet()) {
            Certificate c = this.lstCert.get(alias);
            if (!c.equals(cert)) continue;
            strReturn = alias;
            break;
        }
        return strReturn;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void engineLoad(KeyStore.LoadStoreParameter objConf) throws IOException, NoSuchAlgorithmException, CertificateException {
        boolean chiudiSessione = false;
        this.cf = CertificateFactory.getInstance("X.509");
        if (!(objConf instanceof ActalisKeyStoreParameters)) throw new NoSuchAlgorithmException("Invalid Parameters");
        this.parameter = (ActalisKeyStoreParameters)objConf;
        try {
            String[] aliases;
            if (!this.parameter.getTk().isSessionOpen()) {
                chiudiSessione = true;
                this.parameter.getTk().openPublicSession();
            }
            byte mask = 18;
            if (this.parameter.getTk().getClass().getName().endsWith("PKCS11Token") || this.parameter.getTk().getClass().getName().endsWith("SoftToken")) {
                mask = 4;
            }
            for (String alias : aliases = this.parameter.getTk().listObjects(null, mask)) {
                try {
                    String cert = this.parameter.getTk().getCert(alias);
                    ByteArrayInputStream bis = new ByteArrayInputStream(Base64.decode((String)cert));
                    X509Certificate objCert = (X509Certificate)this.cf.generateCertificate(bis);
                    bis.close();
                    this.lstCert.put(alias, objCert);
                }
                catch (Exception ex) {
                    logger.warn("Alias " + alias + " has not valid certificate!");
                }
            }
            if (!chiudiSessione) return;
            this.parameter.getTk().closeSession();
            return;
        }
        catch (CapiException ex) {
            logger.error("unable to initialize the token: " + ex.getMessage());
            throw new IOException(ex.getMessage());
        }
    }
}

