/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http;

import com.btr.proxy.search.ProxySearch;
import com.btr.proxy.util.PlatformUtil;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.HttpsClient;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.ProxyAutenticator;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;

public class HTTP {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private UrlClient client = null;
    public static NetworkConfig defaultConfig = new NetworkConfig(logger, false, "HTTPUrlConnectionProvider");
    private NetworkConfig config = null;
    private boolean onlyBasicAuthProxy = false;
    private String basicAuthUser = null;
    private String basicAuthPass = null;
    private String getContentCheck = null;
    private String postAccept = null;
    private String getAccept = null;
    private String requestType = null;
    private int postTimeout = 0;

    public HTTP() {
        this(defaultConfig);
    }

    public HTTP(NetworkConfig curConfig) {
        this.config = curConfig;
        this.client = new UrlClient(this.config, logger);
        if (this instanceof HttpsClient) {
            try {
                if (((HttpsClient)this).getCDB() != null) {
                    this.client.setTrustStore(((HttpsClient)this).getCDB().toTrustStore());
                }
            }
            catch (CertDBException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void setProxyAutenticator(ProxyAutenticator aut) {
        this.config.setProxyauthenticator(aut);
    }

    public void setProxyParams(boolean hasProxy, String proxyhost, int proxyport, String proxyrealm, String proxyuser, String proxypwd, String proxyuserdomain, String proxynonhosts) {
        this.config.setProxy(proxyhost);
        this.config.setProxyPort("" + proxyport);
        this.config.setUserProxy(proxyuser);
        this.config.setPasswordProxy(proxypwd);
        this.config.setProxynohosts(this.toHostArray(proxynonhosts));
    }

    public void setProxyAuthenticationOnlyBasic(boolean onlyBasic) {
        this.onlyBasicAuthProxy = onlyBasic;
    }

    public void setBasicAuthParams(String user, String pwd) {
        this.basicAuthUser = user;
        this.basicAuthPass = pwd;
    }

    public void setPostTimeOut(int timeout) {
        this.postTimeout = timeout;
    }

    public void setGetContentCheck(String getContentCheck) {
        this.getContentCheck = getContentCheck;
    }

    public void setPostAccept(String postAccept) {
        this.postAccept = postAccept;
    }

    public void setGetAccept(String getAccept) {
        this.getAccept = getAccept;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public byte[] doGet(String url, String saveToFileName) throws CapiException {
        return this.doGet(url, saveToFileName, true);
    }

    public byte[] doGet(String url, String saveToFileName, boolean canEscape) throws CapiException {
        URLCredentials cred = null;
        if (url == null) {
            throw new CapiException("Null URL", 1001);
        }
        if (!url.toUpperCase().startsWith("HTTP")) {
            throw new CapiException("Invalid URL", 1002);
        }
        try {
            URI uri = new URI(url);
            String escapedUri = uri.toString();
        }
        catch (Exception e) {
            throw new CapiException("Invalid URL", 1002);
        }
        logger.debug("doGet from URL: " + url);
        if (this.hasProxy() && this.isProxyHost(url)) {
            logger.debug("Passing through proxy: " + this.config.getProxy() + ":" + this.config.getProxyPort());
            if (this.config.getUserProxy() != null && this.config.getUserProxy().length() > 0) {
                logger.debug("proxyuser defined ... (" + this.config.getUserProxy() + ")");
                if (this.onlyBasicAuthProxy) {
                    logger.debug("onlyBasicAuthentProxy is TRUE ...");
                    this.config.setPreferBasic(true);
                }
            }
            String localHostName = null;
            try {
                InetAddress thisIp = InetAddress.getLocalHost();
                localHostName = thisIp.getHostName();
                logger.debug("Local host name: " + localHostName);
            }
            catch (Exception e) {
                throw new CapiException("Error getting Local Host name", 91000);
            }
        }
        if (this.basicAuthUser != null && this.basicAuthUser.length() > 0) {
            logger.debug("Basic authentication requested for user " + this.basicAuthUser);
            cred = new URLCredentials(this.basicAuthUser, this.basicAuthPass, null, null);
            logger.debug("Basic authentication activated.");
        }
        if (this.postTimeout != 0) {
            this.config.setConnectionTimeOut("" + this.postTimeout);
        }
        UrlReturn ret = null;
        RequestData pdata = null;
        if (this.getAccept != null) {
            pdata = new RequestData();
            pdata.setAcceptHeader(this.getAccept);
        }
        String contentType = "";
        int attempt = 0;
        for (attempt = 0; !(attempt >= 3 || (ret = this.client.downloadUrl(url, pdata, cred)) != null && ret.getStatus().equals("OK")); ++attempt) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (ret == null || !ret.getStatus().equals("OK")) {
            if (attempt == 3) {
                if (this.hasProxy() && this.isProxyHost(url)) {
                    throw new CapiException("Unaspected proxy error during HTTP GET", 91008);
                }
                throw new CapiException("File not found", 91004);
            }
            throw new CapiException("HTTP GET error: " + ret.getStatus(), 91007);
        }
        if (this.getContentCheck != null && !contentType.trim().endsWith(this.getContentCheck.trim())) {
            logger.debug("Content-type: " + contentType + " different from " + this.getContentCheck);
            throw new CapiException("HTTP ContentTypeMismatch", 91007);
        }
        logger.debug("Getting response body...");
        byte[] responseBody = ret.getData();
        logger.debug("Terminated doGet from URL: " + url);
        if (saveToFileName != null) {
            logger.debug("saving to:" + saveToFileName);
            Util.saveToFile(responseBody, saveToFileName);
        }
        return responseBody;
    }

    public byte[] doPost(String url, String contentType, InputStream postFileStream, String saveToFileName) throws CapiException {
        URLCredentials cred = null;
        RequestData rdata = new RequestData();
        if (!url.toUpperCase().startsWith("HTTP")) {
            throw new CapiException("Invalid URL", 1002);
        }
        try {
            if (postFileStream != null) {
                rdata.setPostdata(Streams.readAll((InputStream)postFileStream));
            }
            rdata.setContentType(contentType);
            logger.debug("doPOST to URL Http:" + url);
            if (this.hasProxy() && this.isProxyHost(url)) {
                logger.debug("Passing through proxy: " + this.config.getProxy() + ":" + this.config.getProxyPort());
                if (this.config.getUserProxy() != null && this.config.getUserProxy().length() > 0) {
                    logger.debug("proxyuser defined ...");
                    if (this.onlyBasicAuthProxy) {
                        logger.debug("onlyBasicAuthentProxy is TRUE ...");
                        this.config.setPreferBasic(true);
                    }
                }
                String localHostName = null;
                try {
                    InetAddress thisIp = InetAddress.getLocalHost();
                    localHostName = thisIp.getHostName();
                    logger.debug("Local host name: " + localHostName);
                }
                catch (Exception e) {
                    throw new CapiException("Error getting Local Host name", 91000);
                }
            }
            if (this.basicAuthUser != null && this.basicAuthUser.length() > 0) {
                logger.debug("Basic authentication requested for user " + this.basicAuthUser);
                cred = new URLCredentials(this.basicAuthUser, this.basicAuthPass, null, null);
                logger.debug("Basic authentication activated.");
            }
            if (this.postTimeout != 0) {
                this.config.setConnectionTimeOut("" + this.postTimeout);
            }
            if (this.postAccept != null) {
                rdata.setAcceptHeader(this.postAccept);
            }
            if (this.requestType != null) {
                rdata.setType(this.requestType);
            }
            UrlReturn ret = this.client.downloadUrl(url, rdata, cred);
            logger.debug("Response status code: " + ret.getStatus());
            logger.debug("Response status message: " + ret.getStatusMessage());
            byte[] responseBody = null;
            if (ret == null || !ret.getStatus().equals("OK")) {
                logger.debug("Unexpected failure: " + ret.getStatus());
                throw new CapiException("HTTP Post failure: " + ret.getStatus(), 91007);
            }
            responseBody = ret.getData();
            logger.debug("Terminated doPost to URL Http:" + url);
            if (saveToFileName != null) {
                logger.debug("saving to:" + saveToFileName);
                Util.saveToFile(responseBody, saveToFileName);
            }
            try {
                postFileStream.close();
            }
            catch (Exception e) {
                logger.debug("Failed closing postFileStream");
            }
            return responseBody;
        }
        catch (ConnectException e) {
            if (this.hasProxy() && this.isProxyHost(url)) {
                throw new CapiException("FailedConnect during HTTP POST through proxy", 91002);
            }
            throw new CapiException("FailedConnect during HTTP POST", 91002);
        }
        catch (SSLPeerUnverifiedException e) {
            throw new CapiException("Server not authenticated", 92001);
        }
        catch (SSLProtocolException e) {
            throw new CapiException("HTTPS SSL Protocol error", 92002);
        }
        catch (SSLHandshakeException e) {
            throw new CapiException("HTTPS Handshake error", 92000);
        }
        catch (SSLKeyException e) {
            throw new CapiException("HTTPS Key error", 92003);
        }
        catch (IOException e) {
            throw new CapiException("FailedIO during HTTP POST " + e.getMessage(), 91003);
        }
        catch (NullPointerException e) {
            throw new CapiException("HttpsClient socket not trusted", 91007);
        }
        catch (IllegalArgumentException e) {
            throw new CapiException("HTTP Post: invalid address", 91007);
        }
        catch (CapiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CapiException(e.getMessage(), 91007);
        }
    }

    public static String getSystemProxy(Proxy.Type type) {
        logger.debug("[getSystemProxy] begin ... ");
        Object foundproxy = null;
        try {
            ProxySearch ps = new ProxySearch();
            if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.WIN) {
                ps.addStrategy(ProxySearch.Strategy.IE);
                ps.addStrategy(ProxySearch.Strategy.FIREFOX);
                ps.addStrategy(ProxySearch.Strategy.JAVA);
                ps.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
            } else if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.LINUX) {
                ps.addStrategy(ProxySearch.Strategy.GNOME);
                ps.addStrategy(ProxySearch.Strategy.KDE);
                ps.addStrategy(ProxySearch.Strategy.FIREFOX);
                ps.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
            } else {
                ps.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
            }
            ProxySelector psel = ps.getProxySelector();
            List<Proxy> l = psel.select(new URL("http://www.yahoo.com/").toURI());
            if (l == null) {
                logger.debug("[getSystemProxy] No Proxy");
                foundproxy = null;
                return null;
            }
            for (Proxy proxy : l) {
                logger.debug("[getSystemProxy] proxy type : " + (Object)((Object)proxy.type()));
                if (proxy.type().equals((Object)Proxy.Type.DIRECT)) {
                    logger.debug("[getSystemProxy] DIRECT Proxy");
                    continue;
                }
                if (!proxy.type().equals((Object)type)) {
                    logger.debug("[getSystemProxy] No Proxy " + type.toString());
                    continue;
                }
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                if (addr == null) {
                    logger.debug("[getSystemProxy] No Proxy");
                    continue;
                }
                logger.debug("[getSystemProxy] proxy hostname : " + addr.getHostName());
                logger.debug("[getSystemProxy] proxy port : " + addr.getPort());
                return addr.getHostName() + ":" + addr.getPort();
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String[] toHostArray(String hosts) {
        if (hosts == null) {
            return new String[0];
        }
        try {
            StringTokenizer tokenH = new StringTokenizer(hosts, ";");
            String[] ret = new String[tokenH.countTokens()];
            int i = 0;
            while (tokenH.hasMoreTokens()) {
                ret[i] = tokenH.nextToken().trim();
                ++i;
            }
            return ret;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return new String[0];
        }
    }

    private String getHostString(String url) {
        try {
            URI u = new URI(url);
            String host = u.getHost();
            logger.debug("URL host: " + host);
            return host;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private int getHostPort(String url) {
        try {
            URI u = new URI(url);
            int port = u.getPort();
            if (port == -1) {
                port = url.toUpperCase().startsWith("HTTPS") ? 443 : 80;
            }
            logger.debug("host port: " + port);
            return port;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    private boolean isProxyHost(String url) {
        boolean ret = true;
        try {
            if (this.config.getProxynohosts() != null) {
                logger.debug("isProxyHost URL: " + url);
                URI u = new URI(url);
                String host = u.getHost();
                logger.debug("URL host:" + host);
                for (int i = 0; i < this.config.getProxynohosts().length; ++i) {
                    if (!host.equalsIgnoreCase(this.config.getProxynohosts()[i])) continue;
                    logger.debug("nonProxyHost:" + host);
                    return false;
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    public static void setDefaultConfig(NetworkConfig defaultConfig) {
        HTTP.defaultConfig = defaultConfig;
    }

    public boolean hasProxy() {
        if (this.config != null) {
            return this.config.getProxy() != null && !this.config.getProxy().isEmpty();
        }
        return !defaultConfig.getProxy().isEmpty();
    }

    public NetworkConfig getConfig() {
        if (this.config != null) {
            return this.config;
        }
        return defaultConfig;
    }
}

