/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.outputs;

import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileOutputHandler
extends OutputHandler {
    protected File file = null;

    public FileOutputHandler(File file, Long finalSize, boolean replace) throws FileNotFoundException, IOException {
        boolean isCreated;
        if (file == null) {
            throw new IllegalArgumentException("Please specify a non-null file!");
        }
        File fullPathFile = new File(file.getAbsolutePath());
        File parent = fullPathFile.getParentFile();
        if (!parent.exists() && !(isCreated = parent.mkdirs())) {
            throw new IOException("Unable to create the necessary directory structure for file " + file.getAbsolutePath() + ".");
        }
        if (parent.exists() && !parent.isDirectory()) {
            throw new IllegalArgumentException("Parent of " + file.getAbsolutePath() + " exists but it is not a " + "folder.");
        }
        if (!replace) {
            String fullFileName;
            String filePath = file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separator) + 1);
            String fileName = fullFileName = file.getName();
            String ext = "";
            int dotIndex = file.getName().indexOf(".");
            if (dotIndex != -1) {
                fileName = fullFileName.substring(0, dotIndex);
                ext = fullFileName.substring(dotIndex);
            }
            int iOccurrence = 1;
            File tmp = file;
            while (tmp.exists()) {
                tmp = dotIndex != -1 ? new File(filePath + fileName + "(" + iOccurrence + ")" + ext) : new File(filePath + fileName + "(" + iOccurrence + ")");
                ++iOccurrence;
            }
            file = tmp;
        }
        this.file = file;
        this.outputStream = new BufferedOutputStream(new FileOutputStream(this.file));
        this.initDataHandler(DataHandler.DATA_TYPE.FILE, file.getName(), finalSize);
    }

    public FileOutputHandler(File file, Long finalSize) throws FileNotFoundException, IOException {
        this(file, finalSize, false);
    }

    public FileOutputHandler(File file) throws FileNotFoundException, IOException {
        this(file, null);
    }

    public String getFullPath() {
        return this.file.getAbsolutePath();
    }
}

