/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.inputs;

import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.inputs.StreamInputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import org.slf4j.Logger;

public class URLInputHandler
extends StreamInputHandler {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private URL inputUrl = null;
    private NetworkConfig netConf = null;
    private URLCredentials credentials = null;
    private UrlClient client = null;

    public URLInputHandler(URL url, NetworkConfig config, URLCredentials creds) throws IOException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        if (url == null) {
            throw new IllegalArgumentException("Please specify a non-null URL!");
        }
        this.inputUrl = url;
        this.netConf = config != null ? config : new NetworkConfig();
        this.credentials = creds;
        this.client = new UrlClient(this.netConf, logger);
        InputStream remoteIs = this.client.getInputStream(this.inputUrl, this.credentials);
        String dataName = null;
        String path = this.inputUrl.getPath();
        String[] parts = path.split("/");
        if (parts != null) {
            dataName = parts[parts.length - 1];
        }
        Long contentLength = this.client.getContentLengthLong(url, this.credentials);
        this.initStreamInputHandler(remoteIs, dataName);
        this.type = DataHandler.DATA_TYPE.URL;
        this.setTotalSize(contentLength != null && contentLength >= 0L ? contentLength : null);
    }

    public URLInputHandler(URL url, NetworkConfig config) throws IOException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        this(url, config, null);
    }

    public URLInputHandler(URL url) throws IOException, MalformedURLException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        this(url, null);
    }
}

