/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core.qc;

import it.actalis.ellips.capi.core.qc.QcKnown;
import it.actalis.ellips.capi.core.qc.QcStatements;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;

public class QcEuLimitValue
extends QcKnown {
    private String curr;
    private double value;

    public QcEuLimitValue(ASN1Encodable info) {
        super(QcStatements.QcEuLimitValue, info);
        MonetaryValue limit = MonetaryValue.getInstance((Object)info);
        this.curr = limit.getCurrency().getAlphabetic();
        if (this.curr == null) {
            this.curr = "" + limit.getCurrency().getNumeric();
        }
        this.value = limit.getAmount().doubleValue() * Math.pow(10.0, limit.getExponent().doubleValue());
    }

    @Override
    public String getValue() {
        return this.curr + " " + String.format("%.2f", this.value);
    }
}

