/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends OutputStream {
    static final char[] BASE64_ENCODING_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private OutputStream out;
    private byte[] byteAcc = new byte[2];
    private int nbBytesWaiting;
    private boolean insertLineBreaks;
    private int lineLength;

    public Base64OutputStream(OutputStream out, boolean insertLineBreaks) {
        this.out = new BufferedOutputStream(out, 4096);
        this.insertLineBreaks = insertLineBreaks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(String s) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Base64OutputStream out64 = new Base64OutputStream(bout, false);
        try {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                out64.write(s.charAt(i));
            }
            out64.writePadding();
            String string = new String(bout.toByteArray());
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                out64.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void write(int i) throws IOException {
        if (this.nbBytesWaiting == 2) {
            this.out.write(BASE64_ENCODING_TABLE[(byte)((this.byteAcc[0] & 0xFC) >> 2)]);
            this.out.write(BASE64_ENCODING_TABLE[(byte)((this.byteAcc[0] & 3) << 4 | (this.byteAcc[1] & 0xF0) >> 4)]);
            this.out.write(BASE64_ENCODING_TABLE[(byte)((this.byteAcc[1] & 0xF) << 2 | (i & 0xC0) >> 6)]);
            this.out.write(BASE64_ENCODING_TABLE[(byte)(i & 0x3F)]);
            this.nbBytesWaiting = 0;
            if (this.insertLineBreaks && (this.lineLength += 4) >= 76) {
                this.out.write(13);
                this.out.write(10);
                this.lineLength = 0;
            }
        } else {
            this.byteAcc[this.nbBytesWaiting++] = (byte)i;
        }
    }

    public void writePadding() throws IOException {
        if (this.nbBytesWaiting == 0) {
            return;
        }
        if (this.nbBytesWaiting == 2) {
            this.out.write(BASE64_ENCODING_TABLE[(byte)((this.byteAcc[0] & 0xFC) >> 2)]);
            this.out.write(BASE64_ENCODING_TABLE[(byte)((this.byteAcc[0] & 3) << 4 | (this.byteAcc[1] & 0xF0) >> 4)]);
            this.out.write(BASE64_ENCODING_TABLE[(byte)((this.byteAcc[1] & 0xF) << 2)]);
            this.out.write(61);
        } else if (this.nbBytesWaiting == 1) {
            this.out.write(BASE64_ENCODING_TABLE[(byte)((this.byteAcc[0] & 0xFC) >> 2)]);
            this.out.write(BASE64_ENCODING_TABLE[(byte)((this.byteAcc[0] & 3) << 4)]);
            this.out.write(61);
            this.out.write(61);
        }
        this.nbBytesWaiting = 0;
    }

    @Override
    public void close() throws IOException {
        this.writePadding();
        this.out.close();
    }
}

