/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    private InputStream in;
    private int[] readBuffer = new int[3];
    private int readOffset;
    private int bytesLeft;
    private int[] decodeBuffer = new int[4];
    private static final int[] BASE64_DECODING_TABLE;

    public Base64InputStream(InputStream in) {
        super(in);
        this.in = new BufferedInputStream(in, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decode(String s) throws IOException {
        try (Base64InputStream in64 = new Base64InputStream(new ByteArrayInputStream(s.getBytes()));){
            int i;
            StringBuffer sb = new StringBuffer();
            while ((i = in64.read()) != -1) {
                sb.append((char)i);
            }
            String string = sb.toString();
            return string;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.bytesLeft == 0) {
            int nbRead = 0;
            while (nbRead < 4) {
                int read = this.in.read();
                if (read == -1) {
                    if (nbRead % 4 != 0) {
                        throw new IOException("InputStream did not end on a multiple of 4 bytes");
                    }
                    if (nbRead != 0) break;
                    return -1;
                }
                this.decodeBuffer[nbRead] = BASE64_DECODING_TABLE[read];
                if (this.decodeBuffer[nbRead] == -1 && read != 61) continue;
                ++nbRead;
            }
            this.readBuffer[this.bytesLeft++] = this.decodeBuffer[0] << 2 & 0xFC | this.decodeBuffer[1] >> 4 & 3;
            if (this.decodeBuffer[2] != -1) {
                this.readBuffer[this.bytesLeft++] = this.decodeBuffer[1] << 4 & 0xF0 | this.decodeBuffer[2] >> 2 & 0xF;
                if (this.decodeBuffer[3] != -1) {
                    this.readBuffer[this.bytesLeft++] = this.decodeBuffer[2] << 6 & 0xC0 | this.decodeBuffer[3] & 0x3F;
                }
            }
            this.readOffset = 0;
        }
        --this.bytesLeft;
        return this.readBuffer[this.readOffset++];
    }

    static {
        int c;
        BASE64_DECODING_TABLE = new int[256];
        for (c = 0; c < 256; c = (int)((char)(c + 1))) {
            Base64InputStream.BASE64_DECODING_TABLE[c] = -1;
        }
        int offset = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64InputStream.BASE64_DECODING_TABLE[c] = offset++;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64InputStream.BASE64_DECODING_TABLE[c] = offset++;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64InputStream.BASE64_DECODING_TABLE[c] = offset++;
        }
        Base64InputStream.BASE64_DECODING_TABLE[43] = 62;
        Base64InputStream.BASE64_DECODING_TABLE[47] = 63;
    }
}

