/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.certdb;

import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;

public class CertDBUtils {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static String getSubjectFromCert(Certificate cert) {
        return CertDBUtils.getSubjectFromCert(cert, true);
    }

    public static String getSubjectFromCert(Certificate cert, boolean verbose) {
        X500Principal p = cert.getInternalCert().getSubjectX500Principal();
        String s = p.toString();
        if (verbose) {
            logger.debug("Principal.toString: " + s);
        }
        String newRet = s.replaceAll(", ", ",");
        String nospace = newRet.replaceAll("\\+ ", "\\+");
        return nospace.replaceAll(" \\+", "\\+");
    }

    public static String getIssuerFromCert(Certificate cert) {
        X500Principal p = cert.getInternalCert().getIssuerX500Principal();
        String s = p.toString();
        String newRet = s.replaceAll(", ", ",");
        return newRet;
    }
}

