/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.certdb;

import esecurity.validator.constants.ValidationProfile;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBUtils;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.ini.IniSerializableObject;
import it.actalis.vol.utils.Constants;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class CertDBItem
implements Comparable,
IniSerializableObject {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final boolean VERBOSE = "true".equals(System.getProperty("capi.certdb.verbose", "true"));
    public static final int UNKNOWN = 0;
    public static final int END_ENTITY = 1;
    public static final int INTERMEDIATE_CA = 2;
    public static final int ROOT_CA = 4;
    public static final int ALL_CA = 6;
    public static final int ALL = 7;
    public static final int SUSPECT = 8;
    public static final int TRUSTED = 2;
    public static final int INHERIT = 1;
    public static final int UNTRUSTED = 0;
    public static final int ONLY_SIGN = 1;
    public static final int SIGN = 2;
    public static final int ONLY_CIPH = 4;
    public static final int CIPH = 8;
    public static final int GENERIC = 16;
    public static final int OTHER = 32;
    public static final int ONLY_OTHER = 64;
    public static final int ALL_USAGE_TYPE = 127;
    public static final int SOURCE_TYPE_SYSTEM = 0;
    public static final int SOURCE_TYPE_TSL = 1;
    public static final int SOURCE_TYPE_USER = 2;
    public static final int SOURCE_TYPE_UNKNOWN = 3;
    public static final int SOURCE_TYPE_CAISSUER = 4;
    public static final int SOURCE_TYPE_PRETSL_CAISSUER = 5;
    public static final int SOURCE_TYPE_SIGNER_CERTIFICATE = 6;
    private HashMap<String, Object> ht = new HashMap();
    private String sectionID = null;
    private CertDB parent = null;
    private byte[] cert = null;
    private String name = null;
    private String subject = null;
    private String issuer = null;
    private boolean storeTSLId = false;
    private String tslId = "";
    private int source = 3;
    private List<EllipsUsage> ellipsUsages = new ArrayList<EllipsUsage>();
    private boolean updateUsage = false;
    public static final String LBL_CERT = "cert";
    public static final String LBL_TYPE = "type";
    public static final String LBL_NAME_UTF = "name.utf";
    public static final String LBL_NAME = "name";
    public static final String LBL_SUBJ = "subj";
    public static final String LBL_ISS = "iss";
    public static final String LBL_USAGE = "usage";
    public static final String LBL_STATUS = "status";
    public static final String LBL_SOURCE = "source";
    public static final String LBL_ELLIPS_USAGES = "ellipsUsages";
    public static final String LBL_TRUST = "trust";
    public static final String LBL_TSLID = "tsl";
    public static final String LBL_REVOKED = "revoked";

    public CertDBItem() {
        this.ht = new HashMap();
    }

    public CertDBItem(String id, byte[] cert) throws CertDBException, CapiException {
        this.init(id, cert, 2, null);
    }

    public CertDBItem(String id, byte[] cert, List<EllipsUsage> ellipsUsages) throws CertDBException, CapiException {
        this.init(id, cert, 2, ellipsUsages);
    }

    private void init(String id, byte[] cert, int source, List<EllipsUsage> ellipsUsages) throws CapiException {
        if (VERBOSE) {
            logger.debug("Creating a new certDBItem");
        }
        this.sectionID = id;
        this.ht = new HashMap();
        this.source = source;
        this.ellipsUsages = new ArrayList<EllipsUsage>();
        Certificate c = new Certificate(cert, VERBOSE);
        try {
            this.cert = c.getInternalCert().getEncoded();
        }
        catch (CertificateEncodingException ex) {
            throw new CapiException("Certificate format unknown or not implemented", 30002, ex);
        }
        this.name = c.getName();
        this.subject = CertDBUtils.getSubjectFromCert(c, VERBOSE);
        this.issuer = CertDBUtils.getIssuerFromCert(c);
        int type = this.guessType(c);
        this.ht.put(LBL_TYPE, new Integer(type).toString());
        switch (type) {
            case 4: {
                this.ht.put(LBL_TRUST, new Integer(2).toString());
                break;
            }
            case 1: 
            case 2: {
                this.ht.put(LBL_TRUST, new Integer(1).toString());
                break;
            }
            default: {
                this.ht.put(LBL_TRUST, new Integer(0).toString());
            }
        }
        if (VERBOSE) {
            logger.debug("evaluating usage value ...");
        }
        int use = this.evalUsageType();
        this.ht.put(LBL_USAGE, Integer.toString(use));
        if (VERBOSE) {
            logger.debug("setting usage value to {}", (Object)use);
        }
        if (ellipsUsages != null) {
            this.ellipsUsages = ellipsUsages;
        } else if ((use & 3) == 0) {
            this.addEllipsUsage(EllipsUsage.FEA_SIGNATURE);
        }
        this.ht.put(LBL_STATUS, "");
        if (VERBOSE) {
            logger.debug("Created {} with type={} trust={}", new Object[]{this.name, this.getTypeAsString(), this.getTrustAsString()});
        }
    }

    public byte[] getCert(boolean der) {
        if (der) {
            return this.cert;
        }
        return Base64.encode((byte[])this.cert);
    }

    public Certificate getCertificate() throws CapiException {
        byte[] cert = this.getCert(false);
        return new Certificate(cert, VERBOSE);
    }

    public int compareTo(Object anotherObject) {
        return this.compareTo((CertDBItem)anotherObject);
    }

    public int compareTo(CertDBItem another) {
        String anotherName = another.getName();
        String thisName = this.getName();
        return thisName.compareTo(anotherName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws CertDBException {
        this.name = name;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubjectAndIssuer(Certificate cert) throws CertDBException {
        this.subject = CertDBUtils.getSubjectFromCert(cert, VERBOSE);
        this.issuer = CertDBUtils.getIssuerFromCert(cert);
    }

    public String getIssuer() {
        return this.issuer;
    }

    public int getType() throws CertDBException {
        String type = (String)this.ht.get(LBL_TYPE);
        if (type == null) {
            throw new CertDBException("Null type", 80000);
        }
        return Integer.parseInt(type);
    }

    public String getTypeAsString() throws CertDBException {
        int type = this.getType();
        switch (type) {
            case 1: {
                return "END_ENTITY";
            }
            case 2: {
                return "INTERMEDIATE_CA";
            }
            case 4: {
                return "ROOT_CA";
            }
            case 8: {
                return "SUSPECT";
            }
        }
        return "UNKNOWN";
    }

    public void setType(int type) throws CertDBException {
        switch (type) {
            case 0: {
                throw new CertDBException("Unknown type not allowed", 80012);
            }
            case 8: {
                throw new CertDBException("CA altered type not allowed", 80008);
            }
            default: {
                throw new CertDBException("Wrong type", 1002);
            }
            case 1: 
            case 2: 
            case 4: 
        }
        if (VERBOSE) {
            logger.debug("Change type to {}", (Object)type);
        }
        this.ht.put(LBL_TYPE, new Integer(type).toString());
    }

    public int guessType() throws CertDBException, CapiException {
        Certificate c = new Certificate(this.getCert(false), VERBOSE);
        return this.guessType(c);
    }

    private int guessType(Certificate c) throws CertDBException, CapiException {
        boolean selfsigned;
        boolean same_subj_iss;
        boolean ca;
        block19: {
            block18: {
                ca = false;
                same_subj_iss = false;
                selfsigned = false;
                if (c.getBasicConstraints()) break block18;
                if ((c.getKeyUsageBits() & 0x20) <= 0) break block19;
            }
            if (VERBOSE) {
                logger.debug("guessType: CA extensions found ");
            }
            ca = true;
        }
        if (c.getSubjectDN().equals(c.getIssuerDN())) {
            same_subj_iss = true;
            try {
                c.getInternalCert().verify(c.getInternalCert().getPublicKey());
                selfsigned = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ca) {
            if (same_subj_iss) {
                if (selfsigned) {
                    if (VERBOSE) {
                        logger.debug("guessType: cert with CA extensions and self signed, type=ROOT_CA");
                    }
                    return 4;
                }
                if (VERBOSE) {
                    logger.debug("guessType: cert with CA extensions and same subject&issuer NOT self signed, type=SUSPECT");
                }
                return 8;
            }
            if (VERBOSE) {
                logger.debug("guessType: cert with CA extensions and NOT self signed, type=INTERMEDIATE_CA");
            }
            return 2;
        }
        if (same_subj_iss) {
            if (selfsigned) {
                if (VERBOSE) {
                    logger.debug("guessType: cert without CA extensions and self signed, type=UNKNOWN");
                }
                return 0;
            }
            if (VERBOSE) {
                logger.debug("guessType: cert without CA extensions and same subject&issuer NOT self signed, type=UNKNOWN");
            }
            return 0;
        }
        if (VERBOSE) {
            logger.debug("guessType: cert without CA extensions and NOT self signed, type=END_ENTITY");
        }
        return 1;
    }

    public int getTrust() throws CertDBException {
        String t = (String)this.ht.get(LBL_TRUST);
        if (t == null) {
            throw new CertDBException("Null trust", 80000);
        }
        return Integer.parseInt(t);
    }

    public String getTrustAsString() throws CertDBException {
        int t = this.getTrust();
        switch (t) {
            case 2: {
                return "TRUSTED";
            }
            case 1: {
                return "INHERIT";
            }
            case 0: {
                return "UNTRUSTED";
            }
        }
        return "UNKNOWN";
    }

    public void setTrust(int trust) throws CertDBException {
        if (trust < 0 || trust > 2) {
            throw new CertDBException("Wrong trust value", 1002);
        }
        if (trust == 1) {
            boolean root = false;
            try {
                Certificate c = this.getCertificate();
                if (c.getSubjectDN().equals(c.getIssuerDN())) {
                    c.verify(Util.getBytes(c.getEncoded()));
                    root = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (root) {
                throw new CertDBException("Cannot set INHERIT trust to self-signed certs", 80009);
            }
        }
        if (VERBOSE) {
            logger.debug("Change trust to {}", (Object)trust);
        }
        this.ht.put(LBL_TRUST, new Integer(trust).toString());
    }

    public void setRevoked(boolean value) {
        if (value) {
            this.ht.put(LBL_REVOKED, "1");
        } else {
            this.ht.remove(LBL_REVOKED);
        }
    }

    public boolean isRevoked() {
        block3: {
            try {
                String rev = (String)this.ht.get(LBL_REVOKED);
                if (rev.equals("1")) {
                    return true;
                }
            }
            catch (Exception ignored) {
                if (!VERBOSE) break block3;
                logger.debug(ignored.getMessage(), (Throwable)ignored);
            }
        }
        return false;
    }

    public int getUsage() throws CertDBException {
        String usage;
        block5: {
            usage = (String)this.ht.get(LBL_USAGE);
            try {
                if (usage == null || usage.equals("")) {
                    if (VERBOSE) {
                        logger.debug("evaluating usage value ...");
                    }
                    int use = this.evalUsageType();
                    if (VERBOSE) {
                        logger.debug("setting usage value to {}", (Object)use);
                    }
                    usage = new Integer(use).toString();
                    this.updateUsage = true;
                }
                this.ht.put(LBL_USAGE, usage);
            }
            catch (Exception ignored) {
                if (!VERBOSE) break block5;
                logger.debug(ignored.getMessage(), (Throwable)ignored);
            }
        }
        return Integer.parseInt(usage);
    }

    public String getUsageAsString() throws CertDBException {
        int usage = this.getUsage();
        switch (usage) {
            case 1: {
                return "ONLY_SIGN";
            }
            case 2: {
                return "SIGN";
            }
            case 4: {
                return "ONLY_CIPH";
            }
            case 8: {
                return "CIPH";
            }
            case 16: {
                return "GENERIC";
            }
            case 64: {
                return "ONLY_OTHER";
            }
            case 32: {
                return "OTHER";
            }
        }
        return "USAGE UNKNOWN";
    }

    public String getSourceAsString() {
        switch (this.source) {
            case 0: {
                return "system";
            }
            case 1: {
                return "TSL";
            }
            case 3: {
                return "unknown";
            }
            case 2: {
                return "user";
            }
            case 4: {
                return "caIssuer";
            }
            case 5: {
                return "preCAIssuer";
            }
            case 6: {
                return "signerCertificate";
            }
        }
        return "";
    }

    public boolean updateKeyUsage() {
        return this.updateUsage;
    }

    void setID(String ID) {
        this.sectionID = ID;
    }

    @Override
    public String getID() {
        return this.sectionID;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int evalUsageType() throws CertDBException, CapiException {
        int i;
        String pdfSigning;
        String actalisOID;
        String emailProtID;
        String[] extku;
        boolean iscritExt;
        boolean iscrit;
        block39: {
            block45: {
                block44: {
                    block41: {
                        block40: {
                            boolean hasEmailProt;
                            int kubits;
                            Certificate c;
                            block42: {
                                block43: {
                                    c = new Certificate(this.getCert(false), VERBOSE);
                                    iscrit = c.isCritical(6);
                                    kubits = c.getKeyUsage();
                                    if (VERBOSE) {
                                        logger.debug("evalUsageType: iscritical = {} KeyUsageBits= {}", (Object)iscrit, (Object)kubits);
                                        logger.debug(" KeyUsageBits is {}", (Object)c.keyUsageToString(kubits));
                                    }
                                    iscritExt = c.isCritical(30);
                                    extku = c.getExtendedKeyUsage();
                                    if (logger.isDebugEnabled()) {
                                        if (VERBOSE) {
                                            logger.debug("critical = {} ExtendedKeyUsage ", (Object)iscritExt);
                                        }
                                        for (int i2 = 0; i2 < extku.length; ++i2) {
                                            if (!VERBOSE) continue;
                                            logger.debug("{}:{}", (Object)i2, (Object)extku[i2]);
                                        }
                                    }
                                    hasEmailProt = false;
                                    emailProtID = "1.3.6.1.5.5.7.3.4";
                                    actalisOID = "1.3.159.5.1";
                                    pdfSigning = "1.2.840.113583.1.1.5";
                                    if (VERBOSE) {
                                        logger.debug("searching emailProtectionID {}", (Object)emailProtID);
                                    }
                                    for (i = 0; i < extku.length; ++i) {
                                        if (!emailProtID.equals(extku[i])) continue;
                                        if (VERBOSE) {
                                            logger.debug("found emailProtectionID ");
                                        }
                                        hasEmailProt = true;
                                        break;
                                    }
                                    if (kubits == 0) break block41;
                                    if ((kubits & 2) <= 0) break block42;
                                    if (VERBOSE) {
                                        logger.debug("evalUsageType: nonRepudiation set");
                                    }
                                    if (kubits != 2 && kubits != 3) break block43;
                                    if (extku.length <= 0) {
                                        if (kubits != 2) return 2;
                                        if (!iscrit) return 2;
                                        return 1;
                                    }
                                    break block44;
                                }
                                if (VERBOSE) {
                                    logger.debug("nonRepudiation SHOULD NOT be combined");
                                }
                                if ((kubits & 0xC) > 0) {
                                    if (VERBOSE) {
                                        logger.debug("nonRepudiation SHOULD NOT be combined with cipher");
                                    }
                                    break block45;
                                } else if (extku.length > 0) {
                                    break block39;
                                } else {
                                    if (!iscrit) return 32;
                                    return 64;
                                }
                            }
                            if (c.isCNSAuthentication()) {
                                return 16;
                            }
                            if (kubits == 1) {
                                return 2;
                            }
                            if ((kubits & 0xD) > 0) {
                                if (VERBOSE) {
                                    logger.debug("evalUsageType: dataEncipherment|keyEncipherment |digitalSignature set");
                                }
                                if (kubits == 8 || kubits == 4 || kubits == 12 || kubits == 5) {
                                    if (extku.length > 0) {
                                        if (hasEmailProt) {
                                            if (!iscrit) return 8;
                                            return 4;
                                        }
                                        if (!iscritExt) return 32;
                                        return 64;
                                    }
                                    break block40;
                                } else {
                                    if ((kubits & 2) > 0) {
                                        if (VERBOSE) {
                                            logger.debug("nonRepudiation SHOULD NOT be combined");
                                        }
                                        if (extku.length <= 0) return 16;
                                        if (hasEmailProt) {
                                            return 16;
                                        }
                                        if (!iscritExt) return 32;
                                        return 64;
                                    }
                                    if (extku.length > 0) {
                                        if (hasEmailProt) {
                                            if (!iscrit) return 8;
                                            return 4;
                                        }
                                        if (!iscritExt) return 32;
                                        return 64;
                                    }
                                    if (!iscrit) return 8;
                                    return 4;
                                }
                            }
                            if ((kubits & 0xE) == 0) {
                                if (VERBOSE) {
                                    logger.debug("evalUsageType: no sign&cipher bits set");
                                }
                                if (extku.length > 0) {
                                    if (hasEmailProt) {
                                        if (!iscrit) return 32;
                                        return 64;
                                    }
                                    if (!iscritExt) return 32;
                                    return 64;
                                }
                                if (!iscrit) return 32;
                                return 64;
                            }
                        }
                        if (!VERBOSE) return 16;
                        logger.debug("evalUsageType: generic");
                        return 16;
                    }
                    if (extku.length <= 0) return 16;
                    i = 0;
                    while (i < extku.length) {
                        if (!(emailProtID.equals(extku[i]) || actalisOID.equals(extku[i]) || pdfSigning.equals(extku[i]))) {
                            if (!iscritExt) return 32;
                            return 64;
                        }
                        ++i;
                    }
                    return 16;
                }
                i = 0;
                while (i < extku.length) {
                    if (!(emailProtID.equals(extku[i]) || actalisOID.equals(extku[i]) || pdfSigning.equals(extku[i]))) {
                        if (!iscritExt) return 32;
                        return 64;
                    }
                    ++i;
                }
                return 2;
            }
            if (extku.length <= 0) return 16;
            i = 0;
            while (i < extku.length) {
                if (!(emailProtID.equals(extku[i]) || actalisOID.equals(extku[i]) || pdfSigning.equals(extku[i]))) {
                    if (!iscritExt) return 32;
                    return 64;
                }
                ++i;
            }
            return 16;
        }
        for (i = 0; i < extku.length; ++i) {
            if (emailProtID.equals(extku[i]) || actalisOID.equals(extku[i]) || pdfSigning.equals(extku[i])) continue;
            if (!iscritExt) return 32;
            return 64;
        }
        if (!iscrit) return 32;
        return 64;
    }

    public void setStatus(String status) {
        this.ht.put(LBL_STATUS, status);
    }

    public String getStatus() {
        return (String)this.ht.get(LBL_STATUS);
    }

    @Override
    public void initAsStringHashMap(HashMap<String, IniSerializableObject> mainTable, String sectionID, HashMap<String, String> map) {
        String strEllipsUsage = map.get(LBL_ELLIPS_USAGES);
        ArrayList<EllipsUsage> objArray = new ArrayList<EllipsUsage>();
        if (strEllipsUsage != null && !strEllipsUsage.equals("")) {
            int ellipsUsage = Integer.parseInt(strEllipsUsage);
            for (int iUsage = 0; iUsage < EllipsUsage.values().length; ++iUsage) {
                if (ellipsUsage - EllipsUsage.values()[iUsage].value >= 0) {
                    objArray.add(EllipsUsage.values()[iUsage]);
                    ellipsUsage -= EllipsUsage.values()[iUsage].value;
                }
                if (ellipsUsage == 0) break;
            }
            if (ellipsUsage != 0) {
                logger.error("ellips usages not valid for entry " + sectionID);
            }
        }
        try {
            this.source = Integer.parseInt(map.get(LBL_SOURCE));
        }
        catch (Exception e) {
            this.source = 3;
        }
        if (this.storeTSLId) {
            try {
                this.tslId = map.get(LBL_TSLID);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            this.init(sectionID, map.get(LBL_CERT).getBytes(), this.source, objArray);
        }
        catch (CapiException ex) {
            logger.error("Unable to initialize the entry " + sectionID + " " + ex.getMessage() + " code: " + ex.getErrorCode());
        }
        this.ht.put(LBL_STATUS, map.get(LBL_STATUS));
        String key = sectionID;
        try {
            Integer.parseInt(sectionID);
            int id = 0;
            key = CertDB.generateKeyByItem(this, id);
            if (id == 0) {
                while (mainTable.containsKey(key)) {
                    key = CertDB.generateKeyByItem(this, ++id);
                }
            }
        }
        catch (NumberFormatException id) {
        }
        catch (Exception ex) {
            logger.error("Impossibile inizializzare l'entry: " + ex.getMessage());
        }
        this.sectionID = key;
    }

    @Override
    public void put(String key, Object value) {
        this.ht.put(key, value.toString());
    }

    @Override
    public Object remove(String key) {
        return this.ht.remove(key);
    }

    @Override
    public HashMap<String, String> getAsStringHashMap() {
        HashMap<String, String> objReturn = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.ht.entrySet()) {
            if (entry.getValue() != null) {
                objReturn.put(entry.getKey(), entry.getValue().toString());
                continue;
            }
            objReturn.put(entry.getKey(), "");
        }
        objReturn.put(LBL_CERT, new String(Base64.encode((byte[])this.cert)));
        objReturn.put(LBL_SOURCE, "" + this.source);
        objReturn.put(LBL_ELLIPS_USAGES, this.getIniPropertyStringValue(LBL_ELLIPS_USAGES));
        if (this.storeTSLId) {
            objReturn.put(LBL_TSLID, this.tslId);
        }
        return objReturn;
    }

    @Override
    public String getIniPropertyStringValue(String property) {
        switch (property) {
            case "cert": {
                return new String(Base64.encode((byte[])this.cert));
            }
            case "name.utf": 
            case "name": {
                return this.name;
            }
            case "source": {
                return this.source + "";
            }
            case "ellipsUsages": {
                int somma = 0;
                for (EllipsUsage usage : this.ellipsUsages) {
                    somma += usage.value();
                }
                return somma + "";
            }
            case "tsl": {
                if (!this.storeTSLId) break;
                return this.tslId;
            }
        }
        Object value = this.ht.get(property);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public CertDB getParent() {
        return this.parent;
    }

    void setParent(CertDB parent) {
        this.parent = parent;
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public List<EllipsUsage> getEllipsUsages() {
        return this.ellipsUsages;
    }

    public void addEllipsUsage(EllipsUsage usage) {
        if (!this.ellipsUsages.contains((Object)usage)) {
            this.ellipsUsages.add(usage);
        }
    }

    public void addEllipsUsages(List<EllipsUsage> usages) {
        for (int i = 0; i < usages.size(); ++i) {
            this.addEllipsUsage(usages.get(i));
        }
    }

    public boolean hasEllipsUsage(EllipsUsage usage) {
        return this.ellipsUsages.contains((Object)usage);
    }

    public void resetEllipsUsage() {
        this.ellipsUsages.clear();
    }

    public boolean isEqualTo(CertDBItem item) throws CertDBException {
        if (item == null) {
            return false;
        }
        if (this.getEllipsUsages().size() != item.getEllipsUsages().size()) {
            return false;
        }
        for (EllipsUsage usage : this.getEllipsUsages()) {
            if (item.getEllipsUsages().contains((Object)usage)) continue;
            return false;
        }
        boolean ret = true;
        ret &= this.getSource() == item.getSource();
        ret &= this.getTrust() == item.getTrust();
        ret &= this.getUsage() == item.getUsage();
        ret &= this.getType() == item.getType();
        ret &= this.getID().equals(item.getID());
        ret &= this.getIssuer().equals(item.getIssuer());
        ret &= this.getName().equals(item.getName());
        ret &= this.getStatus().equals(item.getStatus());
        ret &= this.getSubject().equals(item.getSubject());
        if (this.storeTSLId) {
            ret &= this.getTslId().equals(item.getTslId());
        }
        return ret;
    }

    public static Comparator<CertDBItem> getCompByName() {
        Comparator<CertDBItem> comp = new Comparator<CertDBItem>(){

            @Override
            public int compare(CertDBItem s1, CertDBItem s2) {
                return s1.name.compareTo(s2.name);
            }
        };
        return comp;
    }

    public String getTslId() {
        return this.tslId;
    }

    public void setTslId(String tslId) {
        this.tslId = tslId;
    }

    public String toString() {
        String ret = "";
        ret = ret + String.format("  Name: %s\n", this.getName());
        ret = ret + String.format("  ID: %s\n", this.getID());
        ret = ret + String.format("  Subject: %s\n", this.getSubject());
        ret = ret + String.format("  Issuer: %s\n", this.getIssuer());
        ret = ret + String.format("  Status: %s\n", this.getStatus());
        try {
            ret = ret + String.format("  Type: %s\n", this.getTypeAsString());
        }
        catch (CertDBException certDBException) {
            // empty catch block
        }
        try {
            ret = ret + String.format("  Trust: %s\n", this.getTrustAsString());
        }
        catch (CertDBException certDBException) {
            // empty catch block
        }
        try {
            ret = ret + String.format("  Usage: %s\n", this.getUsageAsString());
        }
        catch (CertDBException certDBException) {
            // empty catch block
        }
        ret = ret + String.format("  Source: %s\n", this.getSourceAsString());
        ret = ret + String.format("  Ellips usage: %s\n", this.getEllipsUsages().toString());
        if (this.storeTSLId) {
            ret = ret + String.format("  TSL id: %s\n", this.getTslId());
        }
        return ret;
    }

    public boolean isAdmittedByProfile(ValidationProfile profile) {
        if (profile == null) {
            return false;
        }
        boolean admitted = false;
        switch (profile) {
            case QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE: {
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_SIGNATURE)) {
                    admitted = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_TIME_STAMP)) {
                    admitted = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_SIGNATURE_ONLY)) {
                    admitted = true;
                    break;
                }
                if (!this.hasEllipsUsage(EllipsUsage.SEAL_SIGNATURE)) break;
                admitted = true;
                break;
            }
            case CNS_ADVANCED_ELECTRONIC_SIGNATURE_PROFILE: {
                if (!this.hasEllipsUsage(EllipsUsage.CNS_AUTHENTICATION)) break;
                admitted = true;
                break;
            }
            case ADVANCED_ELECTRONIC_SIGNATURE_PROFILE: {
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_SIGNATURE)) {
                    admitted = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_TIME_STAMP)) {
                    admitted = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_SIGNATURE_ONLY)) {
                    admitted = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.SEAL_SIGNATURE)) {
                    admitted = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.FEA_SIGNATURE)) {
                    admitted = true;
                    break;
                }
                if (!this.hasEllipsUsage(EllipsUsage.CNS_AUTHENTICATION)) break;
                admitted = true;
                break;
            }
            case GRAPHOMETRIC_SIGNATURE_PROFILE: {
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_TIME_STAMP)) {
                    admitted = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_SIGNATURE)) {
                    admitted = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_SIGNATURE_ONLY)) {
                    admitted = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.SEAL_SIGNATURE)) {
                    admitted = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.GRAPHOMETRIC_SIGNATURE)) {
                    admitted = true;
                    break;
                }
                if (!this.hasEllipsUsage(EllipsUsage.NOTAR_GRAPHOMETRIC_SIGNATURE)) break;
                admitted = true;
            }
        }
        return admitted;
    }

    public static enum EllipsUsage {
        SEAL_SIGNATURE(100000000),
        QUALIFIED_SIGNATURE_ONLY(10000000),
        QUALIFIED_TIME_STAMP(1000000),
        QUALIFIED_SIGNATURE(100000),
        NOTAR_GRAPHOMETRIC_SIGNATURE(10000),
        GRAPHOMETRIC_SIGNATURE(1000),
        FEA_SIGNATURE(100),
        CNS_AUTHENTICATION(10),
        GENERIC_TRUSTED_ROOT(1);

        private final int value;

        private EllipsUsage(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

