/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.certdb;

import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class CertDBDiff {
    private ArrayList<CertDBItem> updatedPre = new ArrayList();
    private ArrayList<CertDBItem> updatedPost = new ArrayList();
    private ArrayList<CertDBItem> added = new ArrayList();
    private ArrayList<CertDBItem> removed = new ArrayList();

    public ArrayList<CertDBItem> getUpdatedPre() {
        return this.updatedPre;
    }

    public ArrayList<CertDBItem> getUpdatedPost() {
        return this.updatedPost;
    }

    public ArrayList<CertDBItem> getAdded() {
        return this.added;
    }

    public ArrayList<CertDBItem> getRemoved() {
        return this.removed;
    }

    public void reset() {
        this.updatedPre.clear();
        this.updatedPost.clear();
        this.added.clear();
        this.removed.clear();
    }

    public void copy(CertDBDiff other) {
        throw new UnsupportedOperationException();
    }

    public void addAdded(CertDBItem item) {
        this.added.add(item);
    }

    public void addRemove(CertDBItem item) {
        this.removed.add(item);
    }

    public void addUpdated(CertDBItem preItem, CertDBItem postItem) {
        this.updatedPre.add(preItem);
        this.updatedPost.add(postItem);
    }

    public boolean hasDiff() {
        return !this.added.isEmpty() || !this.removed.isEmpty() || !this.updatedPre.isEmpty() || !this.updatedPost.isEmpty();
    }

    public void toFile(File file) throws IOException, CertDBException {
        this.toFile(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFile(String filePath) throws IOException, CertDBException {
        if (!this.hasDiff()) {
            return;
        }
        File diffFile = new File(filePath);
        diffFile.delete();
        BufferedWriter diffBW = null;
        try {
            int i;
            diffBW = new BufferedWriter(new FileWriter(diffFile));
            diffBW.write("CDB DIFFERENCE\n\n");
            diffBW.write("--------------\n");
            diffBW.write(String.format("ADDED (%d)\n", this.added.size()));
            diffBW.write("--------------\n");
            Collections.sort(this.added, CertDBItem.getCompByName());
            for (i = 0; i < this.added.size(); ++i) {
                diffBW.write(String.format("added: %s", this.added.get(i).toString()));
                diffBW.write("- - - \n");
            }
            diffBW.write("\n--------------\n");
            diffBW.write(String.format("REMOVED (%d)\n", this.removed.size()));
            diffBW.write("--------------\n");
            Collections.sort(this.removed, CertDBItem.getCompByName());
            for (i = 0; i < this.removed.size(); ++i) {
                diffBW.write(String.format("removed: %s", this.removed.get(i).toString()));
                diffBW.write("- - - \n");
            }
            diffBW.write("\n--------------\n");
            diffBW.write(String.format("UPDATED (%d)\n", this.updatedPre.size()));
            diffBW.write("--------------\n");
            Collections.sort(this.updatedPre, CertDBItem.getCompByName());
            Collections.sort(this.updatedPost, CertDBItem.getCompByName());
            for (i = 0; i < this.updatedPre.size(); ++i) {
                diffBW.write(String.format("updated pre: %s", this.updatedPre.get(i).toString()));
                diffBW.write(String.format("updated post: %s", this.updatedPost.get(i).toString()));
                diffBW.write("- - - \n");
            }
        }
        finally {
            if (diffBW != null) {
                try {
                    diffBW.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

