/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.ocsp;

import esecurity.validator.x509status.ocsp.OCSPRequest;
import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;

public class HttpOCSPClient {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private OCSPRequest ocspRequest;
    private OCSPResponse ocspResponse;
    private BasicOCSPResp basicOCSPResponse;
    private UrlClient client = null;
    private CertDB certDB = null;

    public HttpOCSPClient(NetworkConfig config, Logger callerLogger, CertDB certDB) throws CapiException {
        this.client = new UrlClient(config, logger);
        if (callerLogger != null) {
            logger = callerLogger;
        }
        if (certDB == null) {
            throw new CapiException("Invalid Cert DB", 1001);
        }
        this.certDB = certDB;
    }

    public OCSPRequest createOCSPRequest(X509Certificate subj, X509Certificate issuer, boolean setNonce, boolean setAcceptBasic) throws OCSPException, CapiException, CertificateException {
        OCSPRequest fpOcspRequest = null;
        try {
            fpOcspRequest = new OCSPRequest(subj, issuer, setAcceptBasic, setNonce);
        }
        catch (Exception ex) {
            throw new CapiException("error generating ocsp request: " + ex.getMessage(), 31008, ex);
        }
        logger.debug("Unsigned request created");
        return fpOcspRequest;
    }

    private OCSPResponse parseOCSPResponse(String responderUrl, byte[] ocspResp) throws OCSPException {
        try {
            X509Certificate issuer = this.ocspRequest.getIssuerCert();
            OCSPResp ocspR = null;
            try {
                ocspR = new OCSPResp(ocspResp);
            }
            catch (Exception ex) {
                logger.debug("ASN1Object cannot be parsed or the response status is invalid");
                throw new OCSPException("OCSP response parsing error");
            }
            CertificateID reqCert = this.ocspRequest.getReqCert();
            BasicOCSPResp basicR = (BasicOCSPResp)ocspR.getResponseObject();
            if (basicR == null) {
                int responseStatus = ocspR.getStatus();
                logger.debug("responseStatus: " + responseStatus);
                String err = OCSPResponse.getResponseStatusName(responseStatus);
                throw new OCSPException("OCSP responder error: status " + err + " (" + responseStatus + ")");
            }
            int responseStatus = ocspR.getStatus();
            String statusName = OCSPResponse.getResponseStatusName(responseStatus);
            if (responseStatus != 0) {
                logger.debug("Not successful; got response status: " + statusName);
                throw new OCSPException("OCSP responder error: status " + statusName + " (" + responseStatus + ")");
            }
            this.ocspResponse = new OCSPResponse(ocspR, reqCert);
            logger.debug("Successful OCSP response: -------->");
            this.basicOCSPResponse = this.ocspResponse.getBasicOcspResponse();
            this.verifyOCSPResponse(issuer);
            SingleResp singleResponse = this.ocspResponse.getSingleResponse();
            if (singleResponse == null) {
                logger.debug("No response got for our request!");
                throw new OCSPException("OCSP singleResponse not present");
            }
            byte[] respondNonce = this.ocspResponse.getNonce();
            if (respondNonce != null) {
                byte[] requestNonce = this.ocspRequest.getNonce();
                if (requestNonce == null) {
                    logger.warn("why null nonce into the request?");
                    throw new CapiException("null nonce into the OCSP request", 31008);
                }
                if (!Arrays.areEqual((byte[])requestNonce, (byte[])respondNonce)) {
                    throw new CapiException("OCSP nonce values do not match!", 31008);
                }
            } else {
                boolean relaxed = true;
                if (relaxed) {
                    if (!responderUrl.toLowerCase().startsWith("https")) {
                        throw new CapiException("OCSP nonce is not present into the response. OCSP server could be vulnerable", 31008);
                    }
                    logger.warn("null nonce into the response, but OCSP on https (apply relaxed check)");
                } else {
                    throw new CapiException("OCSP nonce is not present into the response. OCSP server could be vulnerable", 31008);
                }
            }
            return this.ocspResponse;
        }
        catch (CertDBException cde) {
            logger.debug("CertDBException: " + cde.getMessage(), (Throwable)cde);
            throw new OCSPException("Error verifying cert in certDB: " + cde.getMessage());
        }
        catch (Exception ex) {
            logger.debug("Exception: " + ex.getMessage(), (Throwable)ex);
            throw new OCSPException(ex.getMessage());
        }
    }

    private X509Certificate getSignerOCSPResponse(BasicOCSPResp basicOCSPResponse, X509Certificate iss) throws OCSPException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException, Exception, OCSPException {
        logger.debug("getting signer cert from response ... ");
        X509CertificateHolder[] certs = basicOCSPResponse.getCerts();
        if (certs.length > 0) {
            logger.debug("Certs chain included; trying with issuer cert...");
            for (int i = 0; i <= certs.length; ++i) {
                try {
                    if (!basicOCSPResponse.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider(ProvUtils.bcProvider).build(certs[i]))) continue;
                    return new JcaX509CertificateConverter().setProvider(ProvUtils.bcProvider).getCertificate(certs[i]);
                }
                catch (Exception oe) {
                    logger.debug("Failed verifying basicOcspResponse with cert: " + certs[i].toString() + " " + oe.getMessage());
                }
            }
            throw new OCSPException("Failed basicOCSPResponse verify");
        }
        logger.debug("Certs not included; trying with issuer cert...");
        if (basicOCSPResponse.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider(ProvUtils.bcProvider).build(iss.getPublicKey()))) {
            return iss;
        }
        throw new OCSPException("Failed basicOCSPResponse verify with issuer certificate");
    }

    private boolean hasOCSPSigning(X509Certificate signerCert) throws Exception {
        logger.debug("searching id-kp-OCSPSigning ... ");
        List<String> extKeyUsageList = signerCert.getExtendedKeyUsage();
        if (extKeyUsageList == null) {
            return false;
        }
        if (extKeyUsageList.size() == 0) {
            return false;
        }
        String[] list = new String[extKeyUsageList.size()];
        for (int i = 0; i < extKeyUsageList.size(); ++i) {
            list[i] = extKeyUsageList.get(i);
            if (list[i].compareTo(KeyPurposeId.id_kp_OCSPSigning.getId()) != 0) continue;
            return true;
        }
        return false;
    }

    private void verifyOCSPResponse(X509Certificate iss) throws CertDBException, OCSPException, Exception {
        logger.debug("----init verifyOCSPResponse----");
        logger.debug("getting singleResponse...");
        SingleResp singleResponse = this.ocspResponse.getSingleResponse();
        logger.debug("done...");
        ASN1Primitive reqCertIDPrimitive = OCSPResponse.certificateIDToASN1Primitive(this.ocspRequest.getReqCert());
        ASN1Primitive respCertIDPrimitive = OCSPResponse.certificateIDToASN1Primitive(singleResponse.getCertID());
        if (!respCertIDPrimitive.equals(reqCertIDPrimitive)) {
            logger.debug("Request certificate doesn't match response certificate");
            throw new OCSPException("OCSP singleResponse no match request certificate");
        }
        logger.debug("getting signer certificate...");
        X509Certificate signerCert = null;
        try {
            signerCert = this.getSignerOCSPResponse(this.basicOCSPResponse, iss);
        }
        catch (NoSuchAlgorithmException e) {
            logger.debug("Failed during verifying BasicOcspResponse" + e.getMessage());
            throw new OCSPException("OCSP basicOcspResponse NoSuchAlgorithmException");
        }
        catch (InvalidKeyException e) {
            logger.debug("Failed during verifying BasicOcspResponse" + e.getMessage());
            throw new OCSPException("OCSP basicOcspResponse InvalidKeyException");
        }
        catch (SignatureException e) {
            logger.debug("Failed during verifying BasicOcspResponse" + e.getMessage());
            throw new OCSPException("OCSP basicOcspResponse SignatureException");
        }
        catch (OCSPException e) {
            logger.debug("Failed during verifying BasicOcspResponse" + e.getMessage());
            throw new OCSPException("OCSP basicOcspResponse OCSPException");
        }
        if (signerCert == null) {
            throw new OCSPException("OCSP singleResponse cert not inside");
        }
        logger.debug("...done");
        if (signerCert.equals(iss)) {
            logger.debug("Signature validated by the issuer cert");
            return;
        }
        logger.debug("Signature not validated by the issuer cert; checking authorization ...");
        boolean ocspSigning = this.hasOCSPSigning(signerCert);
        if (!signerCert.getIssuerDN().equals(iss.getSubjectDN())) {
            if (ocspSigning) {
                try {
                    CertDBItem[] certDBItemArray = this.certDB.onLineVerify(HTTP.defaultConfig, signerCert.getEncoded());
                }
                catch (CertDBException e) {
                    throw new OCSPException("OCSP responder certificate is not trusted");
                }
            } else {
                throw new OCSPException("OCSP responder certificate is not trusted");
            }
        }
    }

    public OCSPResponse sendOCSPRequest(String responderUrl, Certificate subjectCert, Certificate issuerCert) throws CapiException, OCSPException {
        X509Certificate X509SubjectCert = new Certificate(subjectCert.getEncoded().getBytes()).getInternalCert();
        X509Certificate X509IssuerCert = new Certificate(issuerCert.getEncoded().getBytes()).getInternalCert();
        return this.sendOCSPRequest(responderUrl, X509SubjectCert, X509IssuerCert);
    }

    public OCSPResponse sendOCSPRequest(String responderUrl, X509Certificate X509SubjectCert, X509Certificate X509IssuerCert) throws CapiException, OCSPException {
        this.ocspResponse = null;
        logger.debug("Creating encoded unsigned OCSP request");
        try {
            this.ocspRequest = this.createOCSPRequest(X509SubjectCert, X509IssuerCert, true, true);
        }
        catch (Exception e) {
            logger.debug("[sendOCSPRequest] OCSP Download error: " + e.getMessage());
            throw new OCSPException("Ocsp Request creation failed");
        }
        byte[] ocspRequestArray = this.ocspRequest.getEncodedOCSPReq();
        logger.debug("doPost request to " + responderUrl);
        String contentType = "application/ocsp-request";
        String accept = "application/ocsp-response";
        byte[] responseRaw = null;
        try {
            RequestData data = new RequestData();
            data.setPostdata(ocspRequestArray);
            data.setContentType(contentType);
            UrlReturn ret = this.client.downloadUrl(responderUrl, data, null);
            if (ret == null || !ret.getStatus().equals("OK")) {
                logger.error("Errore richiesta Ocsp Code {}", (Object)ret.getStatus_code());
                throw new CapiException("General exception", 31008);
            }
            responseRaw = ret.getData();
        }
        catch (SecurityException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            logger.debug("[sendOCSPRequest] SecurityException: " + e.getMessage());
            throw new CapiException("Security Exception", 31008);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            logger.debug("[sendOCSPRequest] Exception: " + e.getMessage());
            throw new CapiException("General exception", 31008);
        }
        logger.debug("doPost ? Done. ");
        logger.debug("Parse response: ");
        this.ocspResponse = this.parseOCSPResponse(responderUrl, responseRaw);
        if (this.ocspResponse == null) {
            logger.debug("[sendOCSPRequest] No singleResponse into OCSPresponse");
            throw new OCSPException("OCSP singleResponse not present");
        }
        return this.ocspResponse;
    }
}

