/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.utils;

import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.validator.bean.CertStatusValidation;
import esecurity.validator.bean.LevelValidation;
import esecurity.validator.bean.RefCRL;
import esecurity.validator.bean.VerifiedSerial;
import esecurity.validator.constants.StatusValidation;
import esecurity.validator.parser.utils.CRLUtils;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.util.TmpFileUtils;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;

public class LevelValidationUtils {
    public static LevelValidation validateLevel(TimeStampToken tsToken, X509Certificate signer, LinkedList<X509Certificate> certChain, LinkedList<BasicOCSPResp> ocsps, LinkedList<CRL> crls, Logger logger) {
        LevelValidation basicLevel;
        block9: {
            basicLevel = new LevelValidation();
            basicLevel.setSignerCertificate(signer);
            if (tsToken == null) {
                return basicLevel;
            }
            LinkedList<X509Certificate> forRefCrl = new LinkedList<X509Certificate>();
            try {
                Certificate tsaCert = tsToken.getTSACert();
                if (tsaCert == null) {
                    return basicLevel;
                }
                if (certChain != null) {
                    forRefCrl.addAll(certChain);
                }
                forRefCrl.add(tsaCert.getInternalCert());
                LinkedList<RefCRL> refsClrs = new LinkedList<RefCRL>();
                if (crls != null) {
                    for (CRL crl : crls) {
                        CRLUtils.addRefCrl(refsClrs, crl, forRefCrl);
                    }
                }
                return LevelValidationUtils.validateLevelByRefCRL(tsToken.getDate(), signer, tsaCert.getInternalCert(), certChain, ocsps, refsClrs, logger);
            }
            catch (ApiGeneralException ex) {
                if (logger != null) {
                    logger.error("Invalid timestamp: " + ex.getMessage());
                }
            }
            catch (CapiException ex) {
                if (logger == null) break block9;
                logger.error("Invalid timestamp: " + ex.getMessage());
            }
        }
        return basicLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LevelValidation validateLevelByRefCRL(Date timeStampDate, X509Certificate signer, X509Certificate tsaSigner, LinkedList<X509Certificate> certChain, LinkedList<BasicOCSPResp> ocsps, LinkedList<RefCRL> crls, Logger logger) {
        LevelValidation levelValidation;
        block33: {
            block32: {
                CertDBItem[] items;
                CertDBItem signerItem;
                CertDB embeddedCertDb;
                levelValidation = new LevelValidation();
                levelValidation.setSignerCertificate(signer);
                levelValidation.setChain(certChain);
                levelValidation.setOcsps(ocsps);
                levelValidation.setCrls(crls);
                levelValidation.setVerificationDate(timeStampDate);
                if (tsaSigner != null) {
                    levelValidation.setTsaCertificate(tsaSigner);
                    levelValidation.setLevel(SignatureLevel.T);
                }
                it.actalis.ellips.util.File tmpCDB = null;
                if (certChain != null) {
                    try {
                        tmpCDB = TmpFileUtils.createTempFile("tempCDB", "");
                        embeddedCertDb = CertDB.instanceFromList(certChain, tmpCDB.getAbsolutePath(), "12345678");
                        signerItem = embeddedCertDb.contains(signer.getEncoded());
                        if (signerItem != null) {
                            embeddedCertDb.delete(signerItem);
                        }
                        if ((items = embeddedCertDb.verify(signer.getEncoded())) != null && items.length > 0) {
                            levelValidation.setSignerChain(items);
                        }
                    }
                    catch (CapiException | IOException | NullPointerException | CertificateEncodingException ex) {
                        if (logger != null) {
                            logger.error("Error verifying signer certificate chain: " + ex.getMessage());
                        }
                    }
                    finally {
                        if (tmpCDB != null) {
                            ((File)tmpCDB).delete();
                        }
                    }
                }
                if (certChain != null) {
                    try {
                        tmpCDB = TmpFileUtils.createTempFile("tempCDB", "");
                        embeddedCertDb = CertDB.instanceFromList(certChain, tmpCDB.getAbsolutePath(), "12345678");
                        signerItem = embeddedCertDb.contains(tsaSigner.getEncoded());
                        if (signerItem != null) {
                            embeddedCertDb.delete(signerItem);
                        }
                        if ((items = embeddedCertDb.verify(tsaSigner.getEncoded())) != null && items.length > 0) {
                            levelValidation.setTsaChain(items);
                        }
                    }
                    catch (CapiException | IOException | NullPointerException | CertificateEncodingException ex) {
                        if (logger != null) {
                            logger.error("Error verifying TSA certificate chain: " + ex.getMessage());
                        }
                    }
                    finally {
                        if (tmpCDB != null) {
                            ((File)tmpCDB).delete();
                        }
                    }
                }
                try {
                    levelValidation.setSignerStatus(LevelValidationUtils.retrieveCertificateStatus(timeStampDate, signer, certChain, ocsps, crls));
                }
                catch (CapiException | IOException | NullPointerException | CertificateException | OCSPException | OperatorCreationException ex) {
                    if (logger == null) break block32;
                    logger.error("Error checking CRL/OCSP status for signer: " + ex.getMessage());
                }
            }
            try {
                levelValidation.setTsaSignerStatus(LevelValidationUtils.retrieveCertificateStatus(timeStampDate, tsaSigner, certChain, ocsps, crls));
            }
            catch (CapiException | IOException | NullPointerException | CertificateException | OCSPException | OperatorCreationException ex) {
                if (logger == null) break block33;
                logger.error("Error checking CRL/OCSP status for TSA: " + ex.getMessage());
            }
        }
        CertStatusValidation certVal = levelValidation.getSignerStatus();
        CertStatusValidation certTSAVal = levelValidation.getTsaSignerStatus();
        if (certVal != null && certTSAVal != null) {
            boolean bChainsAvailable;
            boolean bValidSignerStatusType = certVal.getValidationType() == StatusValidation.EMBEDDED_CRL || certVal.getValidationType() == StatusValidation.EMBEDDED_OCSP;
            boolean bValidTSAStatusType = certTSAVal.getValidationType() == StatusValidation.EMBEDDED_CRL || certTSAVal.getValidationType() == StatusValidation.EMBEDDED_OCSP;
            boolean bl = bChainsAvailable = levelValidation.getSignerChain() != null && levelValidation.getTsaChain() != null;
            if (bChainsAvailable) {
                if (!bValidSignerStatusType) {
                    logger.info("Formato non LT: non sono state trovate informazioni di revoca embedded per il signer {}", (Object)signer.getSubjectDN());
                }
                if (!bValidTSAStatusType) {
                    logger.info("Formato non LT non sono state trovate informazioni di revoca embedded per la TSA {}", (Object)tsaSigner.getSubjectDN());
                }
            }
            if (bValidSignerStatusType && bValidTSAStatusType && bChainsAvailable) {
                levelValidation.setLevel(SignatureLevel.LT);
            }
        }
        return levelValidation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CertStatusValidation retrieveCertificateStatus(Date timeStampDate, X509Certificate signer, LinkedList<X509Certificate> certChain, LinkedList<BasicOCSPResp> ocsps, LinkedList<RefCRL> crls) throws CertDBException, CapiException, CertificateEncodingException, CertificateException, OCSPException, IOException, OperatorCreationException {
        CertStatusValidation status = new CertStatusValidation();
        if (signer == null) {
            return status;
        }
        if (crls != null) {
            for (RefCRL crl : crls) {
                if (crl.getNextUpdate().before(timeStampDate)) continue;
                for (VerifiedSerial ser : crl.getVerifiedSerial()) {
                    if (!ser.getSerial().equals(signer.getSerialNumber().toString(16))) continue;
                    status.setValidationType(StatusValidation.EMBEDDED_CRL);
                    status.setCrl(crl);
                    if (ser.isRevoked() && ser.getRevocationDate().before(timeStampDate)) {
                        status.setReasonCode(ser.getReasonCode());
                        status.setRevocationDate(ser.getRevocationDate());
                        status.setRevoked(true);
                        break;
                    }
                    status.setRevoked(false);
                    break;
                }
                if (status.getValidationType() == StatusValidation.NONE) continue;
                break;
            }
        }
        if (status.getValidationType() != StatusValidation.NONE) {
            return status;
        }
        if (ocsps != null) {
            it.actalis.ellips.util.File tmpCDB = null;
            try {
                tmpCDB = TmpFileUtils.createTempFile("tempCDB", "");
                CertDB embeddedCertDb = CertDB.instanceFromList(certChain, tmpCDB.getAbsolutePath(), "12345678");
                for (BasicOCSPResp objResp : ocsps) {
                    X509CertificateHolder[] responseCertificates;
                    if (objResp.getProducedAt().before(timeStampDate) || !signer.getSerialNumber().equals(objResp.getResponses()[0].getCertID().getSerialNumber())) continue;
                    for (X509CertificateHolder responseCertificate : responseCertificates = objResp.getCerts()) {
                        CertDBItem[] items;
                        X509Certificate responseCert = new JcaX509CertificateConverter().setProvider(ProvUtils.bcProvider).getCertificate(responseCertificate);
                        CertDBItem signerItem = embeddedCertDb.contains(responseCert.getEncoded());
                        if (signerItem != null) {
                            embeddedCertDb.delete(signerItem);
                        }
                        if ((items = embeddedCertDb.verify(responseCert.getEncoded())) != null && items.length > 0 && objResp.getResponses()[0].getCertID().matchesIssuer(new X509CertificateHolder(items[0].getCertificate().getInternalCert().getEncoded()), new JcaDigestCalculatorProviderBuilder().build())) {
                            JcaContentVerifierProviderBuilder pb = new JcaContentVerifierProviderBuilder();
                            pb.setProvider(ProvUtils.bcProvider);
                            if (objResp.isSignatureValid(pb.build(responseCert.getPublicKey()))) {
                                status.setValidationType(StatusValidation.EMBEDDED_OCSP);
                                status.setOcsp(objResp);
                                RevokedStatus objStatus = (RevokedStatus)objResp.getResponses()[0].getCertStatus();
                                if (objStatus != null && objStatus.getRevocationTime().before(timeStampDate)) {
                                    status.setRevocationDate(objStatus.getRevocationTime());
                                    status.setReasonCode(objStatus.getRevocationReason());
                                    status.setRevoked(true);
                                    break;
                                }
                                status.setRevoked(false);
                                break;
                            }
                        }
                        if (status.getValidationType() != StatusValidation.NONE) break;
                    }
                    if (status.getValidationType() == StatusValidation.NONE) continue;
                    break;
                }
            }
            finally {
                if (tmpCDB != null) {
                    ((File)tmpCDB).delete();
                }
            }
        }
        return status;
    }

    public static CertStatusValidation retrieveCertificateStatus(X509Certificate signer, LevelValidation lvlValidation) throws CertDBException, CapiException, CertificateEncodingException, CertificateException, OCSPException, IOException, OperatorCreationException {
        return LevelValidationUtils.retrieveCertificateStatus(lvlValidation.getVerificationDate(), signer, lvlValidation.getChain(), lvlValidation.getOcsps(), lvlValidation.getCrls());
    }
}

