/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.utils;

import esecurity.validator.ValidationDate;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.bean.ValidatedSigner;
import esecurity.validator.constants.SignatureFormat;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.LanguagesCode;
import it.actalis.ellips.capi.core.msg.MessageFactory;
import it.actalis.ellips.capi.core.msg.ReportMessageEnum;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.exception.VolException;
import it.actalis.vol.utils.Constants;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import org.slf4j.Logger;

public class HTMLMessageUtils {
    public static String SUCCESS_BASE64 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAJKSURBVHjapFNNaBNREJ63b1+ymzbbJqJoEtCWHAIiVow1oCIigtCDqAfFVjwLJnjw4tGTiMfGiwdz9ODPpWcPHrQgBUGlHqINSEyr0fxs/vbnvX3OJtgaqCJk2N3hDTPfm++bWSKlhFFMgRFN9T+nrxOQHgDT8YBecPQEHzKcLFyAUES5yG2vYrVgmQb+0YHPzEMwTwxepwegG+zq2WtHnx4/v/8JUWHGj/8XBY43j0XVhVOXDjzSNQNiexPxY+eSz1mQzNLl5h2gKgFCCUEaisqIlNi6T2mzeJLOn7iQKoSNCOuYXYwJ0MZZZL307YsySJLxaCx4d+qQ8Uy48uAQ5wll/sjcvoKmh5hZbwL3bGi1avBq6f0Ds8rv+SLO7Z7WL6cy8YVAUAPG1pPFlZ83uQ0vQhFyZeZMrBAM6qxZN7E9BdyuDR9fl/O1r05WRRHJjccTdiisY60Ori3AV9astjdK7+oPk7PRW2HDCNkWB0oJcORTXKnmGxWeZcFBl3Q6AxkhvAhVvTFuu+BYDjCNju9IBE4qQJnVsVAPDlavB2tva4vmhsipbGvEdNe0WOo2nDVJ3DTVvUnXQRDbAdcRfS88F2wELa+2860fMkfZoHATYCoNDvL90Gt5q5icpprY6XKOwnIQuFFOj8P3TzzfbUCWqluj/ROgf8CxfXY68Ma14DCOZg9ejIIBNMqwaLchp6jDuzEE0A/4A5VQwW5ecgsSUkCqW4M8AubINuv2G0DdZoVLCHIb17SI2t1XlMFa/83IqL/zLwEGAFLLD6jFbLX/AAAAAElFTkSuQmCC";
    public static String WARNING_BASE64 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACgUlEQVR42pWST0gUURzHv29n/7S7rpuhlroW/kFdobQ8qBgdxItWB6NDkVAdukREWdShEr3YHyiicwQlJRJJEP2hOoVmapq1qbEuaWq7Cu6s6+7OjLuz7zU7I1aYZXP5vWHm++Hzvu8R/OURJ15YGZWZJXePsNo/ZLUPYc9jS0ykQ0yWKKen2+1bG8T/AoS+tLf4J4UmeVFEaqaueX3Z8ZY1AxZGbm+e9y2OJttDFqoAeB+N2NMNRWm7mqbXBOAHb7YHJkMHHPnzYDEJYwNMsdA/yKi7deifgOCnqzu9I+E3jnyeuH0S5KiEApsE9wBYdpGlKrO+rWdVwMLHZl2El/pEPliWlRfAjYdALCbiTG0QnveA2Wbqs9qNFVkHn7A/Avjes0fH+4N3nBVz0FEB1zoAWQGcqwtCDkvoeUZQXLnh8JZjb++tAPi7T9v8EwG3ycRvSncEwaR5NN8NKR2EcGmvABbX4duoEYJg86bnpBXmnugP/waYfXnkytd+//mSqilQYQosGsHlTgPMBuBkjWIcJ6CyDl3PzXCWp7XmN7ouLANmnzbkTrrmhrMcnnW2pO8AUwKUoMtDYOKAsgxOMSCqBT/DYdxtlnJKHMV5p96Nq4CJttrO6aGx+m2VXk0nUREjGJll6rooRa8aJABMJhjoNsJRkPrIefHzfuLt2F3teuV5XVrpJWYrU7NY6rixnVPn9X3QwgokARLDBIO9RuYsz64mrtaSD8Kct7Rwx6KyHy3JmFZNnFDVRBfVa2GasNBg7mEOJmvyIBlqyuOn3ZGUFVeK/TqJOjU7srRFICPTwBPf/ZokvSV5I8D9PJPlMFH7VN/p0poSDRKniIYCMz8A9QcpP1oZxJMAAAAASUVORK5CYII=";
    public static String ERROR_BASE64 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAKdSURBVHjajFNLaxRBEK5+zYyzm4eZJG58kOxBQjwoIgSM+BN8blSMejIHFbx4VCNEvOViBFG8iCAeJGfN3UNEiQrRg5foaQMu2WSz2d3Z6Z5uq2fyxoMNtVNbX1fN91XVgDEGtlr17MCNnbEt2MTOGAc8s34AShqvq9d73X0oe3ou6HTqVf2EcgIEcaM0ZNvIvd6h4M58355cqShHGYemxagtEMdmV9DjvMofzhSyrhIHB9snfZ/e1rEBrQ1ks+Quxh75Iqb5o61Xg27+Qivj2lxiaczv73qbP5K9oJshgIqBeQ6EEYefs9WbnJps/7GWCcoV6FACFQyI8GD+S+XN0pK+n0igRB9Qy1UwGunifxWGIFwG/QPOM2YlRCHI1RisHh3hJZBAiOkiYPykQKkEhVjKqZ4cOW7wEpIC2VBAGQF7XTdMkkwshoFi0bxfWWUjiC+nDBgUyxVeMEpOBR16yDbnX0djcqnM3q3U2QhjULF0eQoZoBQWyjVxhunwc1tG9cUmnUCKAjD8XVoV3ytNPsyYaaTRtSmgFqRq4H/OYGOxEa+V3Rjj+mmlajTQUS6qKZA1ucMUdJoo/8Nvu7U1J5FgG9Wi1VgO6g9XmhpU2rMN+taPbO+Jzuw18dMiyYiQsknLPCngx3K8XdUf/MH2x7CZvK3Cmhvi6zpI7fEi93lE+cukgFHxtVJMMJluSzaON00MZHCmJ9erNNEaVj/V14GRD0kPmo57JWLeQoSEmiDQGGjhTRvhDWvXK2jhz4QYw/VCKQwkdX9J4V5CCZ/SKRAyQz33HDCxgDuGD2cahLiMHGq4VSXiOOc5dz4qxCgTv/HuKXTnNr6Fr5nd6FG7gidQzkXC6Thi5SS2KWgfSDUGnD9H/1u6lgb+CjAAEaBRdKFbm0EAAAAASUVORK5CYII=";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String retrieveHtmlSummary(ValidatedSigner validatedSigner, String img_ok, String img_ko, String img_warn, LanguagesCode language, Logger logger) throws CapiException {
        if (img_ok == null || img_ok.isEmpty()) {
            img_ok = SUCCESS_BASE64;
        }
        if (img_ko == null || img_ko.isEmpty()) {
            img_ko = ERROR_BASE64;
        }
        if (img_warn == null || img_warn.isEmpty()) {
            img_warn = WARNING_BASE64;
        }
        if (language == null) {
            language = LanguagesCode.EN;
        }
        MessageFactory msgFactory = null;
        try {
            msgFactory = new MessageFactory(language, "reportDictionary");
        }
        catch (VolException ex) {
            if (logger != null) {
                logger.error(ex.getMessage());
            }
            return "";
        }
        String html = HTMLMessageUtils.addTitle(validatedSigner, msgFactory);
        html = html + "<table>";
        try {
            html = html + HTMLMessageUtils.addSignatureInfo(validatedSigner, msgFactory, img_ok, img_ko, img_warn);
            html = html + HTMLMessageUtils.addCertificateInfo(validatedSigner.getCert(), msgFactory, validatedSigner.getVerificationDate(), img_ok, img_ko, img_warn);
        }
        catch (CapiException capiException) {
        }
        finally {
            html = html + "</table>";
        }
        return html;
    }

    private static String addTitle(ValidatedSigner validatedSigner, MessageFactory msgFactory) {
        String strReturn = "<b>";
        if (!validatedSigner.getFormat().equals((Object)SignatureFormat.TST)) {
            strReturn = strReturn + msgFactory.getMessage(ReportMessageEnum.R0043_SIGNATURE_TITLE, new Object[0]);
        } else {
            strReturn = strReturn + msgFactory.getMessage(ReportMessageEnum.R0044_TIMESTAMP_TITLE, new Object[0]);
            strReturn = strReturn + "</b>";
            if (validatedSigner.getSignatureDate() != null) {
                SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
                df.setTimeZone(Constants.DEFAULT_TIMEZONE);
                strReturn = strReturn + String.format("<p>%s: %s</p>", msgFactory.getMessage(ReportMessageEnum.R0045_TIMESTAMP_DATE, new Object[0]), df.format(validatedSigner.getSignatureDate()));
            }
        }
        strReturn = strReturn + "</b>";
        return strReturn;
    }

    private static String addSignatureInfo(ValidatedSigner validatedSigner, MessageFactory msgFactory, String img_ok, String img_ko, String img_warn) {
        boolean hasRFC5652_SignedAttrDER = !validatedSigner.hasMessage(ValidatorMessageEnum.WS0013_NO_RFC5652_SIGNEDATTRIBUTES);
        String strReturn = "";
        String selImage = "";
        String displayedMessage = "";
        if (validatedSigner.getFormat().equals((Object)SignatureFormat.TST)) {
            if (validatedSigner.isValid() && !validatedSigner.hasBeanWarnings()) {
                selImage = img_ok;
                displayedMessage = msgFactory.getMessage(ReportMessageEnum.R0046_TIMESTAMP_VALID, new Object[0]);
            } else if (validatedSigner.hasBeanWarnings()) {
                selImage = img_warn;
                displayedMessage = msgFactory.getMessage(ReportMessageEnum.R0046_TIMESTAMP_VALID, new Object[0]);
            } else if (!validatedSigner.isValid() && validatedSigner.getCert() != null) {
                selImage = img_ko;
                displayedMessage = msgFactory.getMessage(ReportMessageEnum.R0047_TIMESTAMP_NOT_VALID, new Object[0]);
            } else {
                selImage = img_ko;
                displayedMessage = msgFactory.getMessage(ReportMessageEnum.R0048_TIMESTAMP_WITHOUT_CERTIFICATE, new Object[0]);
            }
        } else if (validatedSigner.isValid() && !validatedSigner.hasBeanWarnings()) {
            displayedMessage = msgFactory.getMessage(ReportMessageEnum.R0049_SIGNATURE_VALID, new Object[0]);
            selImage = !hasRFC5652_SignedAttrDER ? img_warn : img_ok;
        } else if (validatedSigner.hasBeanWarnings()) {
            selImage = img_warn;
            displayedMessage = msgFactory.getMessage(ReportMessageEnum.R0049_SIGNATURE_VALID, new Object[0]);
        } else if (!validatedSigner.isValid() && validatedSigner.getCert() != null) {
            selImage = img_ko;
            displayedMessage = msgFactory.getMessage(ReportMessageEnum.R0050_SIGNATURE_NOT_VALID, new Object[0]);
        } else {
            selImage = img_ko;
            displayedMessage = msgFactory.getMessage(ReportMessageEnum.R0051_SIGNATURE_WITHOUT_CERTIFICATE, new Object[0]);
        }
        strReturn = strReturn + String.format("<tr><td><img src=%s></img></td><td><b>%s</b></td></tr>", selImage, displayedMessage);
        LinkedList<ValidatorMessage> lstMessages = validatedSigner.getMessages();
        for (int iMsg = 0; iMsg < lstMessages.size(); ++iMsg) {
            strReturn = strReturn + HTMLMessageUtils.addStepMessage(lstMessages.get(iMsg), displayedMessage, 0);
        }
        return strReturn;
    }

    private static String addCertificateInfo(ValidatedCertificate validatedCertificate, MessageFactory msgFactory, ValidationDate verificationDate, String img_ok, String img_ko, String img_warn) throws CapiException {
        if (validatedCertificate == null) {
            return "";
        }
        String strReturn = "";
        String selImage = "";
        String displayedMessage = "";
        if (validatedCertificate.isValid() && !validatedCertificate.hasBeanWarnings()) {
            selImage = img_ok;
            displayedMessage = msgFactory.getMessage(ReportMessageEnum.R0052_CERTIFICATE_VALID, new Object[0]);
        } else if (validatedCertificate.hasBeanWarnings()) {
            selImage = img_warn;
            displayedMessage = msgFactory.getMessage(ReportMessageEnum.R0053_CERTIFICATE_VALID_WITH_WARNS, new Object[0]);
        } else {
            selImage = img_ko;
            displayedMessage = msgFactory.getMessage(ReportMessageEnum.R0054_CERTIFICATE_NOT_VALID, new Object[0]);
        }
        strReturn = strReturn + String.format("<tr><td><img src=%s></img></td><td><b>%s<b></td></tr>", selImage, displayedMessage);
        LinkedList<ValidatorMessage> lstNotes = validatedCertificate.getMessages();
        for (int iNote = 0; iNote < lstNotes.size(); ++iNote) {
            strReturn = strReturn + HTMLMessageUtils.addStepMessage(lstNotes.get(iNote), displayedMessage, 0);
        }
        return strReturn;
    }

    private static String addStepMessage(ValidatorMessage msg, String msgTitle, int level) {
        String boldStart = "";
        String boldEnd = "";
        if (level == 0) {
            boldStart = "<b>";
            boldEnd = "</b>";
        }
        String strReturn = String.format("<tr><td></td><td></td></tr>", new Object[0]);
        if (!msg.getMessage().equalsIgnoreCase(msgTitle)) {
            strReturn = strReturn + String.format("<tr><td></td><td>%s%s%s</td></tr>", boldStart, msg.getMessage(), boldEnd);
        }
        LinkedList<ValidatorMessage> lstNotes = msg.getNotes();
        for (int iNote = 0; iNote < lstNotes.size(); ++iNote) {
            ValidatorMessage note = lstNotes.get(iNote);
            strReturn = strReturn + "<tr><td></td><td>";
            strReturn = strReturn + note;
            strReturn = strReturn + "</td></tr>";
            for (int iSub = 0; iSub < note.getNotes().size(); ++iSub) {
                strReturn = strReturn + HTMLMessageUtils.addStepMessage(note.getNotes().get(iSub), msgTitle, level + 1);
            }
        }
        return strReturn;
    }
}

