/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.core.x509.StepX509AIACheck;
import esecurity.validator.steps.core.x509.StepX509DPCM189KeyLengthCompliance;
import esecurity.validator.steps.core.x509.StepX509ExtensionsCheck;
import esecurity.validator.steps.core.x509.StepX509IssuerIdentityCheck;
import esecurity.validator.steps.core.x509.StepX509SubjectDNCheck;
import esecurity.validator.steps.core.x509.StepX509VersionCompliance;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;

public class StepX509DPCM189Compliance
extends SingleValidationSubStepImpl {
    public StepX509DPCM189Compliance() {
        super(ValidationType.CERTIFICATE);
        this.subSteps.add(new StepX509DPCM189KeyLengthCompliance());
        this.subSteps.add(new StepX509VersionCompliance());
        this.subSteps.add(new StepX509IssuerIdentityCheck());
        this.subSteps.add(new StepX509SubjectDNCheck());
        this.subSteps.add(new StepX509AIACheck());
        this.subSteps.add(new StepX509ExtensionsCheck());
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        MessageLevel level = StepsUtils.retrieveWorstLevel(subMessage);
        Date notBefore = param.getSignerCertificate().getCert().getInternalCert().getNotBefore();
        if (notBefore.after(Constants.DPCM_AGID_189_2017_DEADLINE) && notBefore.before(Constants.DPCM_AGID_121_2019)) {
            if (level == MessageLevel.ERROR) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.EC0022_NOAGID189, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]);
            }
            if (level == MessageLevel.WARNING) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.WC0014_CERT_NOT_COMPLIANT_AGID189, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]);
            }
        }
        return null;
    }
}

