/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.tst;

import esecurity.validator.bean.SignerInfoData;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.pkcs.SignedData;

public class TimeStampStepSignatureRFCSignedDataCheck
extends SingleValidationSubStepImpl {
    public TimeStampStepSignatureRFCSignedDataCheck() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param != null && param.getSignature() != null && param.getSignature().getSignerInfoData() != null) {
            SignerInfoData data = param.getSignature().getSignerInfoData();
            if (data.getSignerInfo().getAuthenticatedAttributes() != null) {
                ASN1Set sAttrs = data.getSignerInfo().getAuthenticatedAttributes();
                boolean hasSignedAttrs = false;
                for (int i = 0; i < sAttrs.size(); ++i) {
                    String id = "";
                    id = sAttrs.getObjectAt(i) instanceof DERSequence ? ((DERSequence)sAttrs.getObjectAt(i)).getObjectAt(0).toString() : ((DLSequence)sAttrs.getObjectAt(i)).getObjectAt(0).toString();
                    if (!id.equals(CMSAttributes.messageDigest.getId()) && !id.equals(CMSAttributes.signingTime.getId()) && !id.equals(CMSAttributes.contentType.getId()) && !id.equals(SignedData.id_aa_signingCertificate.getId()) && !id.equals(SignedData.id_aa_signingCertificateV2.getId())) continue;
                    hasSignedAttrs = true;
                }
                if (!hasSignedAttrs) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0026_TIMESTAMP_NOSIGNEDATTRS, new Object[0]);
                }
            } else {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0026_TIMESTAMP_NOSIGNEDATTRS, new Object[0]);
            }
        }
        return null;
    }
}

