/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.tst;

import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Utils;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.tsp.Accuracy;

public class TimeStampStepSignatureDetailsInfo
extends MultipleValidationSubStepImpl {
    public TimeStampStepSignatureDetailsInfo() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        LinkedList<ValidatorMessage> msgs = new LinkedList<ValidatorMessage>();
        if (param != null && param.getSignature() != null && param.getSignature().getTstSpecific() != null) {
            TimeStampToken tstToken = null;
            try {
                tstToken = new TimeStampToken(param.getSignature().getSignatureInfo());
            }
            catch (CapiException ex) {
                return msgs;
            }
            msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0007_MARK_DATE, param.getSignature().getSignatureDate()));
            if (tstToken.getPolicyId() != null) {
                msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0008_MARK_POLICY_ID, tstToken.getPolicyId()));
            }
            if (tstToken.getSerialNumber() != null) {
                msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0009_MARK_SERIAL_NUMBER, tstToken.getSerialNumber().toString(16)));
            }
            try {
                if (tstToken.getSigningCertificateV2HashAlg() != null) {
                    msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0010_MARK_HASH_ALGORITHM, Utils.oidToHashAlgName(tstToken.getSigningCertificateV2HashAlg())));
                }
            }
            catch (CapiException ex) {
                // empty catch block
            }
            if (!tstToken.isEIDASCompliance()) {
                msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0010_TIMESTAMP_NOEIDASCOMPLIANCE, new Object[0]));
                msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0011_TIMESTAMP_VALIDITY, new Object[0]));
            } else {
                msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0011_MARK_EIDAS_COMPLIANCE, new Object[0]));
                try {
                    Accuracy accuracy = tstToken.getAccuracy();
                    if (accuracy != null) {
                        ASN1Integer sec = accuracy.getSeconds();
                        BigInteger msec = sec.getValue();
                        msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0012_MARK_ACCURACY, String.format("%d", msec.intValue() * 1000)));
                    }
                }
                catch (ApiGeneralException apiGeneralException) {
                    // empty catch block
                }
            }
        }
        return msgs;
    }
}

