/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.tst;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.core.tst.TimeStampStepSignatureDPCM45DigestAlgoCheck;
import esecurity.validator.steps.core.tst.TimeStampStepSignatureSignedDataCheck;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;

public class TimeStampStepSignatureDPCM45Compliance
extends SingleValidationSubStepImpl {
    public TimeStampStepSignatureDPCM45Compliance() {
        super(ValidationType.SIGNATURE);
        this.subSteps.add(new TimeStampStepSignatureDPCM45DigestAlgoCheck());
        this.subSteps.add(new TimeStampStepSignatureSignedDataCheck());
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        MessageLevel level;
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        format.setTimeZone(param.getTimeZone());
        Date validationDate = param.getCalculatedValidationDate().getDate();
        if (validationDate.after(Constants.DPCM_CNIPA_45_2009) && validationDate.before(Constants.DPCM_AGID_121_2019) && (level = StepsUtils.retrieveWorstLevel(subMessage)) != MessageLevel.INFO) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.WS0009_TIMESTAMP_NOCNIPAVALID, new Object[0]);
        }
        return null;
    }
}

