/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationSignatureFormats;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.annotations.StepOrder;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

@StepOrder(order=100)
@StepContext(formats={ValidationSignatureFormats.CADES, ValidationSignatureFormats.PADES, ValidationSignatureFormats.XADES})
public class StepValidationProfile
extends SingleValidationSubStepImpl {
    public StepValidationProfile() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param.getProfile() != ValidationProfile.ALL_PROFILES && param.getProfile() != ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE) {
            String profileName = param.getConfig().getMessageFactory().getMessage(ValidatorMessageEnum.IA0005_VALIDATION_PROFILE_ALL, new Object[0]);
            if (param.getProfile() == ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE) {
                profileName = param.getConfig().getMessageFactory().getMessage(ValidatorMessageEnum.IA0001_VALIDATION_PROFILE_QUALIFIED, new Object[0]);
            } else if (param.getProfile() == ValidationProfile.CNS_ADVANCED_ELECTRONIC_SIGNATURE_PROFILE) {
                profileName = param.getConfig().getMessageFactory().getMessage(ValidatorMessageEnum.IA0002_VALIDATION_PROFILE_CNS, new Object[0]);
            } else if (param.getProfile() == ValidationProfile.ADVANCED_ELECTRONIC_SIGNATURE_PROFILE) {
                profileName = param.getConfig().getMessageFactory().getMessage(ValidatorMessageEnum.IA0003_VALIDATION_PROFILE_FEA, new Object[0]);
            } else if (param.getProfile() == ValidationProfile.GRAPHOMETRIC_SIGNATURE_PROFILE) {
                profileName = param.getConfig().getMessageFactory().getMessage(ValidatorMessageEnum.IA0004_VALIDATION_PROFILE_GRAPHOMETRIC, new Object[0]);
            }
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0014_VALIDATION_PROFILE, profileName);
        }
        return null;
    }
}

