/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser.utils;

import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.validator.bean.RefCertificate;
import esecurity.validator.bean.ReferenceDoc;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.bean.TstSpecific;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.constants.SignatureFormat;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import org.slf4j.Logger;

public class TSTUtils {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static SignatureInformation tstToVol(TransientDocument doc, byte[] tst, InputHandler marked_doc, String marked_doc_id, DateFormat df) throws ApiGeneralException {
        SignatureInformation signer = new SignatureInformation();
        try {
            signer.setFormat(SignatureFormat.TST);
            signer.setSignatureInfo(tst);
            signer.setContainerFormat(ContainerFormat.SELF);
            if (marked_doc_id != null && !marked_doc_id.isEmpty()) {
                signer.addRefDoc(new ReferenceDoc(marked_doc_id, true));
            }
            TimeStampToken tstToken = new TimeStampToken(tst);
            boolean blnDocCorrect = false;
            try {
                blnDocCorrect = tstToken.compare(marked_doc.getInputAsNewStream());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tstToken.getTSACert() != null) {
                String id = Utils.calculateDigest(new ByteArrayInputStream(tstToken.getTSACert().getDerEncoded()), Constants.SHA256);
                signer.setRefsCertId(id);
                RefCertificate refCert = new RefCertificate();
                refCert.setId(id);
                refCert.setContent(tstToken.getTSACert().getDerEncoded());
                refCert.setCapiCertificate(tstToken.getTSACert());
                signer.setSignatureDate(df.format(tstToken.getDate()));
                Certificate ellipsCert = refCert.getCapiCertificate();
                signer.setSignerName(ellipsCert.getName());
                doc.addCert(refCert);
                boolean blnDocValid = false;
                try {
                    blnDocValid = tstToken.verifySignature();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (blnDocCorrect && blnDocValid) {
                    signer.setCorrupted(false);
                } else {
                    signer.setCorrupted(true);
                }
            } else {
                signer.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
            }
            TstSpecific tstSpecific = new TstSpecific();
            tstSpecific.setRelatedToDoc(blnDocCorrect);
            signer.setTstSpecific(tstSpecific);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (CapiException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return signer;
    }
}

